// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};
quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Which european regulation for data security guides the learning experience?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>Principles should guide the learning experience according to the European Union’s General Data Protection Regulation (GDPR).`;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>Principles should guide the learning experience according to the European Union’s General Data Protection Regulation (GDPR).`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`General Data Protection Regulation (GDPR)`;
quizQuestions[0][0].answers[1]=`Specific Data Protection Regulation (SDPR)`;
quizQuestions[0][0].answers[2]=`European Data Protection (EDP)`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Name three data security best practices`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>It is important to use both internal and external firewalls, to have a well-defined policy, and to demand data backup for several reasons. These measures can help to protect sensitive data and systems from unauthorized access, tampering, or other security threats.`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>It is important to use both internal and external firewalls, to have a well-defined policy, and to demand data backup for several reasons. These measures can help to protect sensitive data and systems from unauthorized access, tampering, or other security threats.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Implement unique passwords;
 Use encryption for all sensitive data;
 Regularly back up data`;
quizQuestions[0][1].answers[1]=`Use both internal and external firewalls;
 Have a well-defined policy;
 Demand data backup`;
quizQuestions[0][1].answers[2]=`Implement access controls to restrict access;
 Regularly monitor and audit networks and systems;
 Ensure that all software and systems are kept up to date`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`What is the main goal of a storyboard in a learning experience?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>The main goal of a storyboard is to visually plan out a video narrative, including the sequences, the compositions of each, and any audio that may be included.`;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>The main goal of a storyboard is to visually plan out a video narrative, including the sequences, the compositions of each, and any audio that may be included.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`A storyboard serves as a stand-alone piece of content`;
quizQuestions[0][2].answers[1]=`To serve as the final, polished version of the learning experience`;
quizQuestions[0][2].answers[2]=`Creating a story or context that engages the learners aligned with the pedagogical approach`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`What is a storyboard?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>A storyboard is a document that outlines the content of an online course, dividing it into individual slides or screens. This allows course creators to plan out their material in a structured and organized way, and to make changes and revisions before production begins. The storyboard can also help them to communicate their vision to the rest of the team, including the instructors and designers.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>A storyboard is a document that outlines the content of an online course, dividing it into individual slides or screens. This allows course creators to plan out their material in a structured and organized way, and to make changes and revisions before production begins. The storyboard can also help them to communicate their vision to the rest of the team, including the instructors and designers.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`A storyboard is a document that breaks down the online course material slide by slide or screen by screen`;
quizQuestions[0][3].answers[1]=`A storyboard is a finished, polished version of the material course`;
quizQuestions[0][3].answers[2]=`A storyboard is a tool for organizing data or information`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`What is the main goal of a storyboard in general?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct. </b><br>A storyboard outlines the structure and presentation of an outcome, providing stakeholders with a preview of what the course will look like. This allows these individuals to see how the final outcome will be organized and delivered, and to offer feedback and suggestions before production begins. `;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>A storyboard outlines the structure and presentation of an outcome, providing stakeholders with a preview of what the course will look like. This allows these individuals to see how the final outcome will be organized and delivered, and to offer feedback and suggestions before production begins. `;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`A storyboard's objective is to withhold the structure and presentation 
of the course from the stakeholders and experts in the field`;
quizQuestions[0][4].answers[1]=`A storyboard's objective is to provide the stakeholders and experts in the field with a sneak peek into the structure and presentation of the course`;
quizQuestions[0][4].answers[2]=`The main goal of a storyboard is to provide a final presentation of the contents of a course`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`What types of storyboard exist?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>There are two main categories of storyboards: written eLearning storyboards and graphic eLearning storyboards.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>There are two main categories of storyboards: written eLearning storyboards and graphic eLearning storyboards.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Interactive, animated, and verbal storyboards`;
quizQuestions[0][5].answers[1]=`Traditional and modern storyboards`;
quizQuestions[0][5].answers[2]=`Written eLearning storyboards and graphic eLearning storyboards`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`What is a written storyboard?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>The written eLearning storyboard is a document that outlines the content of an online course, dividing it into individual slides or screens. 
This allows course creators to plan out their material in a structured and organized way, and to make changes and revisions before production begins.`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>The written eLearning storyboard is a document that outlines the content of an online course, dividing it into individual slides or screens. 
This allows course creators to plan out their material in a structured and organized way, and to make changes and revisions before production begins.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`The written eLearning storyboard is a document that lists the course material, slide by slide or screen by screen`;
quizQuestions[0][6].answers[1]=`A written storyboard is a finished version of a piece of content`;
quizQuestions[0][6].answers[2]=`A written storyboard is a tool for organising data and planning`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`What is the main advantage of using a written storyboard?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>The main advantage of using a written storyboard is that it allows to plan out their material in a structured and organized way. A written storyboard can include a detailed outline, dividing it into individual slides or screens.`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>The main advantage of using a written storyboard is that it allows to plan out their material in a structured and organized way. A written storyboard can include a detailed outline, dividing it into individual slides or screens.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Written storyboards are quick to create`;
quizQuestions[0][7].answers[1]=`Written storyboards assist the ID in focusing on the course material rather than the course's audiovisual aesthetic`;
quizQuestions[0][7].answers[2]=`Written storyboards allow to have a complete perspective of the materials`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`What is a visual storyboard?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>The visual eLearning storyboard is a type of storyboard that focuses on both the design and the content of the content. This type of storyboard combines elements of a written storyboard, which outlines the course material and structure, with a visual prototype, which shows how the content will look and feel.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>The visual eLearning storyboard is a type of storyboard that focuses on both the design and the content of the content. This type of storyboard combines elements of a written storyboard, which outlines the course material and structure, with a visual prototype, which shows how the content will look and feel.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`A tool to increase a presentation's visual aesthetic value`;
quizQuestions[0][8].answers[1]=`A tool for creating animations or special effects`;
quizQuestions[0][8].answers[2]=`The visual eLearning storyboard concentrates on both the course design and its content. A visual eLearning storyboard combines a written storyboard and a visual prototype`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`What are the two most common strategies for determining learning goals?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>Action mapping is a method of identifying the specific actions or behaviors that learners need to be able to perform in order to achieve the desired learning outcomes. This involves identifying the key performance indicators that will be used to measure success, and designing the course content and activities to support the development of these skills. Conventional course-building involves starting with the desired learning outcomes and working backwards to design the course content and activities.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>Action mapping is a method of identifying the specific actions or behaviors that learners need to be able to perform in order to achieve the desired learning outcomes. This involves identifying the key performance indicators that will be used to measure success, and designing the course content and activities to support the development of these skills. Conventional course-building involves starting with the desired learning outcomes and working backwards to design the course content and activities.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Action mapping and conventional course-building`;
quizQuestions[0][9].answers[1]=`Sketching and benchmarking`;
quizQuestions[0][9].answers[2]=`Brainstorming and factor analysis`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`What is an action map?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>The action map specifies the specific actions or behaviors that the audience must take in order to accomplish a certain goal. This can include things like completing a task, making a decision, or achieving a certain level of proficiency.`;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>The action map specifies the specific actions or behaviors that the audience must take in order to accomplish a certain goal. This can include things like completing a task, making a decision, or achieving a certain level of proficiency.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`A tool for idea generation`;
quizQuestions[0][10].answers[1]=`The action map specifies the steps that the audience must take to accomplish a certain goal`;
quizQuestions[0][10].answers[2]=`A visual presentation of a specific outcome`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`What elements does a storyboard comprise? `;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>Text, images, audio, animations, and programming notes are all important elements for a storyboard because they help to plan and visualize the content and structure.`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>Text, images, audio, animations, and programming notes are all important elements for a storyboard because they help to plan and visualize the content and structure.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Polished visuals or animations, detailed scripts, and complex or specialized effects or technology`;
quizQuestions[0][11].answers[1]=`Final audio recordings and music`;
quizQuestions[0][11].answers[2]=`Text, images, audio, animations, programming notes`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`What is the name of the text that appears on each slide for the audience?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>The correct answer was On-screen-text (OST).`;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>The correct answer was On-screen-text (OST).`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`On-screen-text (OST)`;
quizQuestions[0][12].answers[1]=`Screen Text`;
quizQuestions[0][12].answers[2]=`Screen verbal content`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Name some concerns the ID should have when using voiceover`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>The transcript and name of the audio file for each slide should be included;
 It is important to include the transcript and name of the audio file for each slide when using voiceover because it helps to ensure that the 
audio is properly aligned with the visual elements of the slide.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>The transcript and name of the audio file for each slide should be included;
 It is important to include the transcript and name of the audio file for each slide when using voiceover because it helps to ensure that the 
audio is properly aligned with the visual elements of the slide.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Attention to tone of voice`;
quizQuestions[0][13].answers[1]=`The transcript and name of the audio file for each slide should be included`;
quizQuestions[0][13].answers[2]=`Correct diction`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Which domains fall under user experience design (UX)`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>Interaction design, interface design, visual design, content management, usability, and information architecture are important for UX design because they help to create user-friendly and engaging digital experiences.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>Interaction design, interface design, visual design, content management, usability, and information architecture are important for UX design because they help to create user-friendly and engaging digital experiences.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Software development, network engineering, and digital marketing`;
quizQuestions[0][14].answers[1]=`Data analysis and cybersecurity`;
quizQuestions[0][14].answers[2]=`Interaction design, interface design, visual design, content management, usability, and information architecture`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`How do users interact with a product?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>The user interface (UI) is the part of a product or service that allows users to interact with it. This can include things like buttons, menus, and other controls that allow users to input commands and data, as well as the visual and audio elements that provide feedback and guidance to users.`;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>The user interface (UI) is the part of a product or service that allows users to interact with it. This can include things like buttons, menus, and other controls that allow users to input commands and data, as well as the visual and audio elements that provide feedback and guidance to users.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Through its user interface (UI)`;
quizQuestions[0][15].answers[1]=`With a keyboard and mouse`;
quizQuestions[0][15].answers[2]=`With a remote control`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`What does UX cover?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>UX covers the complete interaction users have with a product. This includes not only the user interface (UI), which is the part of a product that allows users to interact with it, but also the other elements that contribute to the user experience.`;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>UX covers the complete interaction users have with a product. This includes not only the user interface (UI), which is the part of a product that allows users to interact with it, but also the other elements that contribute to the user experience.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`The aesthetics of a product`;
quizQuestions[0][16].answers[1]=`The complete interaction users have with a product`;
quizQuestions[0][16].answers[2]=`Data gathering and analysis`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`What are some heuristics to be considered when producing eLearning content?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>Visibility of system status, match between system and the real world, and user control and freedom are all important for eLearning because they help to create user-friendly and effective learning experiences.`;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>Visibility of system status, match between system and the real world, and user control and freedom are all important for eLearning because they help to create user-friendly and effective learning experiences.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Easy to digest content;
 interactivity`;
quizQuestions[0][17].answers[1]=`Appealing aesthetics and complex animation`;
quizQuestions[0][17].answers[2]=`Visibility of system status;
 Match between system and the real world;
 User control and freedom`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`How should error messages be displayed?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>Error messages should always be expressed using plain language (no codes), precisely indicate the problem, and constructively suggest a solution.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>Error messages should always be expressed using plain language (no codes), precisely indicate the problem, and constructively suggest a solution.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`In plain language (no codes), precisely indicate the problem, and constructively suggest a solution`;
quizQuestions[0][18].answers[1]=`Using detailed code`;
quizQuestions[0][18].answers[2]=`With a loud audio noise`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`How to enhance user mistake feedback?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b><br>Offering a clearly marked exit to leave an unwanted state, and 
supporting undo and redo, can help to create user-friendly and engaging 
learning experiences.`;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b><br>Offering a clearly marked exit to leave an unwanted state, and 
supporting undo and redo, can help to create user-friendly and engaging 
learning experiences.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`With constant inflow of information about the mistake`;
quizQuestions[0][19].answers[1]=`Offer a clearly marked exit to leave the unwanted state and support undo and redo`;
quizQuestions[0][19].answers[2]=`With detailed technical instructions about the error`;
quizQuestions[0][19].key=2;

