// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};
quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Which statement best describe instructional solution?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional solutions are developed with the concerns of instructional problems and learning needs, to-be-taught knowledge and skills, pre-existing learning environments, and learner personas. It provides the structure of the instruction that creates learning experiences for learners to achieve learning objectives. Instructional solutions will be developed into instructional blueprints with various design considerations so that instructional developers could develop instructional products.`;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional solutions are developed with the concerns of instructional problems and learning needs, to-be-taught knowledge and skills, pre-existing learning environments, and learner personas. It provides the structure of the instruction that creates learning experiences for learners to achieve learning objectives. Instructional solutions will be developed into instructional blueprints with various design considerations so that instructional developers could develop instructional products.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Instructional solution is developed with the only focus on to-be-taught knowledge and skills`;
quizQuestions[0][0].answers[1]=`Instructional solution provides the general structure of instruction that create learning experience for learners to achieve learning objectives `;
quizQuestions[0][0].answers[2]=`Instructional solution should be as detailed as possible at the beginning so that they can be used for developing instructional products`;
quizQuestions[0][0].key=2;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`What should be included in the intended learning outcomes?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>Learning objectives should indicate the measurable cognitive behaviors on to-be-learned knowledge and skills, and the context of applying the knowledge and skills.`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>Learning objectives should indicate the measurable cognitive behaviors on to-be-learned knowledge and skills, and the context of applying the knowledge and skills.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Expected measurable cognitive behaviors,  description of the to-be-learned knowledge and skills, and the application context`;
quizQuestions[0][1].answers[1]=`Knowledge and skill students should mastered after the completion of instruction`;
quizQuestions[0][1].answers[2]=`Expected performance of a specific learning task`;
quizQuestions[0][1].key=1;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`What are the six hierarchical levels of thinking in Bloom's taxonomy of educational objectives?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>The six hierarchical levels of thinking in Bloom's taxonomy of educational objectives are: Remember, Understand, Apply, Analyze, Evaluate and Create.`;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>The six hierarchical levels of thinking in Bloom's taxonomy of educational objectives are: Remember, Understand, Apply, Analyze, Evaluate and Create.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Remember, Understand, Apply, Analyze, Evaluate and Create`;
quizQuestions[0][2].answers[1]=`Remember, Understand, Apply, Analyze, Combine and Create`;
quizQuestions[0][2].answers[2]=`Remember, Apply, Understand, Compare, Analyze, and Create`;
quizQuestions[0][2].key=1;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`How can the analysis of learner persona help in instructional design?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>Learner persona can be used to identify the learning needs and imply the instructional support needed in user-centered instruction.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>Learner persona can be used to identify the learning needs and imply the instructional support needed in user-centered instruction.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Learner personas identify the key issues underlying the instructional problem`;
quizQuestions[0][3].answers[1]=`Learner personas inform the needs of learners which implies the instructional support that learners need`;
quizQuestions[0][3].answers[2]=`Learner personas indicate learners' learning preferences which determines how the instruction should be designed to match their preference`;
quizQuestions[0][3].key=2;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Which statement about developing user-centered instruction is incorrect?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct.</b><br>Instructional designers utilize learner personas to identify needed instructional support. If there is no information about learners, instructional designers should still take learner perspectives to design the instruction based on learning objectives.`;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional designers utilize learner personas to identify needed instructional support. If there is no information about learners, instructional designers should still take learner perspectives to design the instruction based on learning objectives.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Instructional designers design the instruction only based on how it matches learners' learning preferences`;
quizQuestions[0][4].answers[1]=`Instructional designers should utilize learner personas to consider the needed instructional support `;
quizQuestions[0][4].answers[2]=`Instructional designers can not design instruction if there is no available learner persona information`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Which statement about learning environments is incorrect?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional designers should consider the existing learning environment, available resources and the learning objectives to develop the desired learning environments.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional designers should consider the existing learning environment, available resources and the learning objectives to develop the desired learning environments.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`A learning environment consists of physical settings, cognitive environment, and psychological environment`;
quizQuestions[0][5].answers[1]=`Instructional designers design and develop any kind of learning environment as long as it serves instructional purpose`;
quizQuestions[0][5].answers[2]=`Compared to the physical setting and cognitive environment, psychological environments are more related to learner personas`;
quizQuestions[0][5].key=2;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Which statement regarding the development of instructional solutions is incorrect?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>The development of instruction solution is a process constantly involve iterative analysis of the instructional context.`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>The development of instruction solution is a process constantly involve iterative analysis of the instructional context.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Generating instructional solutions is a linear process of selecting instructional methods and assessment methods based on learning objectives`;
quizQuestions[0][6].answers[1]=`Generating instructional solutions involve the iterative analysis of instructional contexts that informs the decision-making on the selection of learning modes, instructional methods, and assessment methods`;
quizQuestions[0][6].answers[2]=`Generating instructional solutions always start after an analysis of the instructional context so that instructional designers develop user-centered, problem-centered, and context-centered instructional solutions`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`If you need to design a training in e-learning mode, how would it affect your decision on other components of instructional solution?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>There are some types of learning objectives that can not be achieved with e-learning, for example, mastering specific football techniques and playing a football game with others.`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>There are some types of learning objectives that can not be achieved with e-learning, for example, mastering specific football techniques and playing a football game with others.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`The instructional methods should be adapted to the e-learning environment with digital learning materials and digital learning tools`;
quizQuestions[0][7].answers[1]=`The learning objectives do not need to change because any type of learning can be convert into the e-learning format`;
quizQuestions[0][7].answers[2]=`The assessment is more likely to be designed to test the declarative and conceptual understanding of the knowledge instead of specific motor skills`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Which is the most suitable learning mode for learning to design architecture blueprints?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>Learning to design architecture blueprints requires a great amount of independent learning of factual knowledge about architecture blueprints which is better to be learned with e-Learning. It also involves design thinking and communication with stakeholders, which is better to be learned in persons in project-based learning.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>Learning to design architecture blueprints requires a great amount of independent learning of factual knowledge about architecture blueprints which is better to be learned with e-Learning. It also involves design thinking and communication with stakeholders, which is better to be learned in persons in project-based learning.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Blended learning`;
quizQuestions[0][8].answers[1]=`Mobile learning`;
quizQuestions[0][8].answers[2]=`Face-to-face learning`;
quizQuestions[0][8].key=1;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Which is a correct statement regarding the instructional methods?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>The selection of instructional methods is based on the type of target learning and the available resources.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>The selection of instructional methods is based on the type of target learning and the available resources.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`We select and adapt instructional methods only based on instructors' competence of using the instructional methods and the available technology`;
quizQuestions[0][9].answers[1]=`We select, adapt, and integrate the instructional methods based on it's effectiveness in supporting target learning, but the selection is also constrained by the available technology resources, and physical setting`;
quizQuestions[0][9].answers[2]=`Instructional designers select different instructional methods based on learning objectives and create a new learning environment so that the instructional methods can be implemented`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Which is not the function of technology in supporting instructional methods?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>Some types of learning can not be accessed with e-Learning, such as drilling perceptual-motor skills. Face-to-face learning also has different psychological arousal that does not appear in e-Learning, which might hinder the target learning.`;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>Some types of learning can not be accessed with e-Learning, such as drilling perceptual-motor skills. Face-to-face learning also has different psychological arousal that does not appear in e-Learning, which might hinder the target learning.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Technology can assist in providing richer learning experiences and improving learning motivation during the learning process`;
quizQuestions[0][10].answers[1]=`Technology can assist in providing the social interactions that support the target learning`;
quizQuestions[0][10].answers[2]=`Technology can convert all instructional functions provided in face-to-face learning into e-Learning`;
quizQuestions[0][10].key=3;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`What are the functions of assessment in instruction and learning?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>Assessment can be used to identify the learning progress and learning outcomes, which can inform instructional adjustment and learners' self-regulated learning.`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>Assessment can be used to identify the learning progress and learning outcomes, which can inform instructional adjustment and learners' self-regulated learning.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Assessment can be used for informing and regulating the learning and teaching process`;
quizQuestions[0][11].answers[1]=`Assessment can be used for identifying and measuring the learning outcomes`;
quizQuestions[0][11].answers[2]=`Assessment can be used for measuring learning outcomes and regulating the learning process`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Why do instructional designers use formative assessment?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional designers usually use formative assessment as part of the learning and teaching activities to provide informative feedback for learners and teachers to regulate the learning process. But not every instruction must include the formative assessment.`;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional designers usually use formative assessment as part of the learning and teaching activities to provide informative feedback for learners and teachers to regulate the learning process. But not every instruction must include the formative assessment.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Formative assessment is integrated as part of learning activities that could assist students in understanding the course contents and regulating the learning process`;
quizQuestions[0][12].answers[1]=`Using formative assessment means no need to use the summative assessment because students' learning outcomes are measured during the learning process`;
quizQuestions[0][12].answers[2]=`Formative assessment can capture the learning process and track students' learning progress. Every instructional design should involve the formative assessment`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`What are the important components of instructional solution?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>The important components of instructional solution include learning objectives, learning mode, instructional methods, and assessment method.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>The important components of instructional solution include learning objectives, learning mode, instructional methods, and assessment method.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`The instructional strategies improving motivation, instructional methods, and assessment tools`;
quizQuestions[0][13].answers[1]=`Learning modes and instructional methods for the learning objectives`;
quizQuestions[0][13].answers[2]=`Learning objectives, learning mode, instructional methods, and assessment tools`;
quizQuestions[0][13].key=3;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`How do instructional designers develop cultural-sensitive instruction?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional designers develop learning materials and activities based on learners' social-cultural habits and develop a culture-sensitive learning community for learners from various learning backgrounds.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional designers develop learning materials and activities based on learners' social-cultural habits and develop a culture-sensitive learning community for learners from various learning backgrounds.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Instructional designers design learning materials and learning activities according to learners' social-cultural habits`;
quizQuestions[0][14].answers[1]=`Instructional designers should design community-based instruction that allows learners to interact with people from various backgrounds`;
quizQuestions[0][14].answers[2]=`Instructional designers develop learning materials and activities based on learners' social-cultural habits and develop a culture-sensitive learning community for learners from various learning backgrounds`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`How do instructional designers align assessment with learning objectives?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>Sometimes the assessment focus on the holistic task performed which is difficult to include every cognitive behavior and learning content stated in the learning objectives.`;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>Sometimes the assessment focus on the holistic task performed which is difficult to include every cognitive behavior and learning content stated in the learning objectives.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Assessment should require learners to demonstrate every cognitive behaviors as stated in the learning objectives`;
quizQuestions[0][15].answers[1]=`Assessment criteria should be set up based on how well learners could perform learning tasks as stated in the learning objectives`;
quizQuestions[0][15].answers[2]=`Assessment should involve every target knowledge and skills stated in learning objectives in the assessment items `;
quizQuestions[0][15].key=2;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`What is constructive alignment?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>Constructive alignment is a dynamic alignment among learning objectives, instructional methods and assessment.`;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>Constructive alignment is a dynamic alignment among learning objectives, instructional methods and assessment.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`The alignment between learning modes, instructional methods, and assessment`;
quizQuestions[0][16].answers[1]=`The alignment between learning objectives, instructional methods and assessment`;
quizQuestions[0][16].answers[2]=`The alignment between learning objectives, learning modes, and instructional methods`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Which one is not the role of instructional solutions in designing and developing the learning objects?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional solution does not provide the detailed description of the learning objects.`;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional solution does not provide the detailed description of the learning objects.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Instructional solutions provide detailed information on how the learning objects should develop in every learning path, module, and activity`;
quizQuestions[0][17].answers[1]=`Instructional solutions indicate the methods and delivery of the instruction, which provide the boundary to the development of learning objects that could be resided, used, and reused in the given instructional context`;
quizQuestions[0][17].answers[2]=`Instructional solutions indicate essential instructional methods and assessment in terms of learning content and learning activities, which state the purposes of the learning objects`;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`What are the learning objects?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>Learning objects refer to the learning content materials, learning activity affordance, and assessment tools based on a single learning objective.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>Learning objects refer to the learning content materials, learning activity affordance, and assessment tools based on a single learning objective.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Learning objects refer to the learning materials that present the main information of the target knowledge and skills  `;
quizQuestions[0][18].answers[1]=`Learning objects refer to the learning content materials, learning activity affordance, and assessment tools based on a single learning objective`;
quizQuestions[0][18].answers[2]=`Learning objects refer to the learning materials that learners need for performing specific learning tasks`;
quizQuestions[0][18].key=2;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`What instructional methods usually involve collaborative learning?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b><br>Problem-based learning and inquiry-based learning engage learners in a specific project work which involve multiple perspectives for conceptualization, group discussion and collaboration for problem-solving or inquiring.`;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b><br>Problem-based learning and inquiry-based learning engage learners in a specific project work which involve multiple perspectives for conceptualization, group discussion and collaboration for problem-solving or inquiring.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Lectures and project-based learning`;
quizQuestions[0][19].answers[1]=`Microlearning and simulation-based learning`;
quizQuestions[0][19].answers[2]=`Problem-based learning and inquiry-based learning`;
quizQuestions[0][19].key=3;

