// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};
quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Porque é que o Instructional Design requer conhecimento interdisciplinar?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A conceção de instruções envolve uma interação rica num ambiente de aprendizagem e processos de conceção sistemáticos que exigem conhecimentos interdisciplinares. Mas os Instructional Designers não têm de ser especialistas em todas estas disciplinas. A colaboração interdisciplinar é uma estratégia importante para o ID.`;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A conceção de instruções envolve uma interação rica num ambiente de aprendizagem e processos de conceção sistemáticos que exigem conhecimentos interdisciplinares. Mas os Instructional Designers não têm de ser especialistas em todas estas disciplinas. A colaboração interdisciplinar é uma estratégia importante para o ID.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`As diferentes fases do Instructional Design requerem conhecimento e competências em várias disciplinas (por exemplo, ciências da educação, design, gestão ou comunicação), que interagem entre si e mutualmente afetam a qualidade dos resultados do projeto`;
quizQuestions[0][0].answers[1]=`A conceção de um ambiente de aprendizagem complexo, repleto de interação, exige que os Instructional Designers sejam especialistas em várias disciplinas (por exemplo, ciências da educação, design, gestão e comunicação).`;
quizQuestions[0][0].answers[2]=`Ambas as opções estão corretas.`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Quais são as principais perspetivas sobre a formação?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As principais perspetivas de aprendizagem habitualmente utilizadas no ID incluem o comportamentalismo, o cognitivismo, o construtivismo e a teoria da aprendizagem sociocultural.`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>As principais perspetivas de aprendizagem habitualmente utilizadas no ID incluem o comportamentalismo, o cognitivismo, o construtivismo e a teoria da aprendizagem sociocultural.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Comportamentalismo, cognitivismo, construtivismo cognitivo, construtivismo social`;
quizQuestions[0][1].answers[1]=`Comportamentalismo, cognitivismo, construtivismo e teoria da aprendizagem sociocultural`;
quizQuestions[0][1].answers[2]=`Comportamentalismo, cognitivismo, construtivismo e conectivismo.`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Quais são os elementos fundamentais que diferenciam as várias perspetivas sobre a formação? `;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As diferentes perspetivas sobre a aprendizagem variam devido à diferente definição de conhecimento e à explicação de como a aprendizagem ocorre.`;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>As diferentes perspetivas sobre a aprendizagem variam devido à diferente definição de conhecimento e à explicação de como a aprendizagem ocorre.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`As diferentes perspetivas sobre a formação diferem pois definem de modo diferente a natureza do conhecimento`;
quizQuestions[0][2].answers[1]=`As diferentes perspetivas sobre a aprendizagem diferem porque explicam como a aprendizagem acontece de forma diferente.`;
quizQuestions[0][2].answers[2]=`As diferentes perspetivas sobre a aprendizagem definem a natureza do conhecimento e a forma como a aprendizagem se processa de forma diferente.`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Qual das seguintes frases está incorreta?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A aprendizagem pode ser explicada através de várias perspetivas. No entanto, quando se considera o poder explicativo e as práticas mais eficazes para apoiar um tipo específico de aprendizagem, os Instructional Designers devem ser capazes de identificar qual a perspetiva que fornece melhores diretrizes para a criação de formação com recursos e tempo limitados.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A aprendizagem pode ser explicada através de várias perspetivas. No entanto, quando se considera o poder explicativo e as práticas mais eficazes para apoiar um tipo específico de aprendizagem, os Instructional Designers devem ser capazes de identificar qual a perspetiva que fornece melhores diretrizes para a criação de formação com recursos e tempo limitados.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Por norma os Instructional Designers têm diferentes perspetivas sobre a aprendizagem para analisar o objetivo formativo. No entanto, os Instructional Designers escolhem as perspetivas mais adequadas relativamente à sua capacidade explanativa de aprender a guiar o Instructional Design.`;
quizQuestions[0][3].answers[1]=`Um fenómeno de aprendizagem só pode ser explicado por uma perspetiva específica da aprendizagem. Os Instructional Designers devem escolher a perspetiva correta para analisar a aprendizagem-alvo.`;
quizQuestions[0][3].answers[2]=`Os Instructional Designers utilizam as perspetivas de aprendizagem para analisar aspetos importantes da aprendizagem-alvo e definir os valores de aprendizagem. Com base nos valores e objetivos de aprendizagem, examinam a adequação das práticas instrucionais.`;
quizQuestions[0][3].key=2;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Qual das opções descreve corretamente a orientação das teorias de aprendizagem para práticas de Instructional Design?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As teorias de aprendizagem socioculturais dão ênfase a práticas autênticas para apoiar a aprendizagem mal estruturada. Mas não exclui as práticas deliberadas e a elaboração de informação. Em vez disso, estas duas práticas são normalmente utilizadas para modelação e treino de desempenho de peritos.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>As teorias de aprendizagem socioculturais dão ênfase a práticas autênticas para apoiar a aprendizagem mal estruturada. Mas não exclui as práticas deliberadas e a elaboração de informação. Em vez disso, estas duas práticas são normalmente utilizadas para modelação e treino de desempenho de peritos.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`O cognitivismo indica que a aprendizagem é o desenvolvimento de uma estrutura mental para processamento de informação. A formação deve elaborar a informação de modo a otimizar a memorização e fornecer estratégias (meta-)cognitivas para processamento de informação.`;
quizQuestions[0][4].answers[1]=`A aprendizagem sociocultural dá ênfase às oportunidades de participação ativa na comunidade de práticas e no desenvolvimento da identidade. A formação exclui completamente a elaboração de informação e as práticas deliberadas e enfatiza o envolvimento da interação social.`;
quizQuestions[0][4].answers[2]=`O construtivismo dá ênfase a um ambiente de aprendizagem que apoia a construção de sentido e de conhecimentos por parte dos alunos. A instrução fornece apoios (elaboração e interação social) para ligar o conhecimento prévio e atividades ricas para investigação e resolução de problemas.`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Qual das opções indica a relação mais adequada entre a autorregulação dos formandos e a regulação externa?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Num contexto de ensino, os formandos participam numa aprendizagem autorregulada, planeando, implementando, monitorizando, regulando e refletindo sobre o seu processo de aprendizagem e os seus resultados. A regulação externa (práticas de ensino) desempenha um papel importante na aprendizagem autorregulada dos formandos. Os formandos com menor capacidade de aprendizagem autorregulada precisam de mais regulação externa. Mas a regulação externa pode centrar-se em garantir que a aprendizagem visada se realize e/ou em apoiar a aprendizagem autorregulada dos formandos para atingir os objetivos de aprendizagem.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>Num contexto de ensino, os formandos participam numa aprendizagem autorregulada, planeando, implementando, monitorizando, regulando e refletindo sobre o seu processo de aprendizagem e os seus resultados. A regulação externa (práticas de ensino) desempenha um papel importante na aprendizagem autorregulada dos formandos. Os formandos com menor capacidade de aprendizagem autorregulada precisam de mais regulação externa. Mas a regulação externa pode centrar-se em garantir que a aprendizagem visada se realize e/ou em apoiar a aprendizagem autorregulada dos formandos para atingir os objetivos de aprendizagem.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`A regulação externa (por exemplo, práticas formativas) deve ser utilizada apenas para apoiar a aprendizagem autorregulada dos formandos, pois é esta que determina como decorrerá a aprendizagem no verdadeiro ambiente formativo.`;
quizQuestions[0][5].answers[1]=`Um contexto de ensino envolve sempre uma aprendizagem autorregulada e uma regulação externa (ou seja, práticas de ensino). A regulação externa deve equilibrar o apoio à autorregulação eficaz dos formandos e o apoio à facilitação da aprendizagem-alvo.`;
quizQuestions[0][5].answers[2]=`A regulação externa (ou seja, as práticas de ensino) só pode monitorizar e regular o processo de aprendizagem dos formandos durante as atividades de ensino. Os formandos só se envolvem numa aprendizagem autorregulada quando estudam sozinhos.`;
quizQuestions[0][5].key=2;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Quais são as cinco componentes básicas da formação de acordo com os primeiros princípios da formação?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os cinco princípios da instrução são que a aprendizagem é melhorada se a instrução (1) for centrada no problema, (2) ativar os conhecimentos prévios do formando ou preparar os conhecimentos prévios do formando relacionados com a aprendizagem-alvo, (3) demonstrar e modelar a aprendizagem-alvo, (4) proporcionar oportunidades para praticar a aplicação dos novos conhecimentos aprendidos, e (5) proporcionar um contexto para o formando integrar a nova aprendizagem com os conhecimentos prévios para criar uma nova compreensão.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>Os cinco princípios da instrução são que a aprendizagem é melhorada se a instrução (1) for centrada no problema, (2) ativar os conhecimentos prévios do formando ou preparar os conhecimentos prévios do formando relacionados com a aprendizagem-alvo, (3) demonstrar e modelar a aprendizagem-alvo, (4) proporcionar oportunidades para praticar a aplicação dos novos conhecimentos aprendidos, e (5) proporcionar um contexto para o formando integrar a nova aprendizagem com os conhecimentos prévios para criar uma nova compreensão.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`(1) Informação centrada no conhecimento
(2) Informação para ativação de conhecimentos prévios
(3) Demonstração da aplicação do conhecimento
(4) Exercícios e práticas
(5) Avaliação e tarefas de resolução de problemas`;
quizQuestions[0][6].answers[1]=`(1) Avaliação centrada no problema
(2) Informação para ativação de conhecimentos prévios
(3) Demonstração de novas aprendizagens
(4) Exercícios e práticas
(5) Avaliação sumativa para reprodução de conhecimentos`;
quizQuestions[0][6].answers[2]=`(1) Tarefas de aprendizagem centradas no problema
(2) Informação para ativação de conhecimentos prévios ou desenvolvimento de estruturas de esquemas
(3) Demonstrações de novas aprendizagens
(4) Práticas de aplicação da aprendizagem
(5) Avaliação e tarefas de reflexão e produção criativa`;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Qual das seguintes ideias sobre teorias do Instructional Design está incorreta?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As teorias de ID descrevem sistematicamente a forma como os métodos de formação devem ser utilizados para criar um ambiente de aprendizagem favorável. No entanto, os Instructional Designers utilizam as teorias instrucionais de forma flexível e situacional, dependendo das necessidades de aprendizagem e do contexto de aprendizagem.`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>As teorias de ID descrevem sistematicamente a forma como os métodos de formação devem ser utilizados para criar um ambiente de aprendizagem favorável. No entanto, os Instructional Designers utilizam as teorias instrucionais de forma flexível e situacional, dependendo das necessidades de aprendizagem e do contexto de aprendizagem.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`As teorias de Instructional Design são prescritivas e teorias orientadas para o design que sistemicamente descrevem como é que os Instructional Designers devem conceber as práticas formativas e o ambiente de aprendizagem para apoiar o objeto de aprendizagem. Os Instructional Designers devem seguir estritamente as teorias selecionadas.`;
quizQuestions[0][7].answers[1]=`As teorias de Instructional Design fornecem uma orientação sobre os métodos pedagógicos mais adequados para abordar um tipo específico de aprendizagem num contexto específico. As teorias de Instructional Design são situacionais, componenciais e probabilísticas. O Instructional Designer utiliza diferentes teorias instrucionais consoante o contexto de conceção instrucional.`;
quizQuestions[0][7].answers[2]=`As teorias de Instructional Design abordam o quadro geral da instrução que inclui, mas não se limita a, eventos de instrução, configuração do ambiente de aprendizagem, conceção de materiais e atividades de aprendizagem, conceção de informação de apoio e integração tecnológica.`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Qual das seguintes ideias sobre a aplicação de teorias do Instructional Design está incorreta?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A aprendizagem cognitiva não é eficaz para aprender um conjunto restrito e específico de competências motoras ou de desempenho. Porque este tipo de aprendizagem não exige uma interação e uma comunicação ricas com um membro da comunidade, o que pode ser aprendido mais eficazmente com a aprendizagem de domínio.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A aprendizagem cognitiva não é eficaz para aprender um conjunto restrito e específico de competências motoras ou de desempenho. Porque este tipo de aprendizagem não exige uma interação e uma comunicação ricas com um membro da comunidade, o que pode ser aprendido mais eficazmente com a aprendizagem de domínio.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Teorias da carga cognitiva podem ser aplicadas ao design de uma tarefa de formação, materiais formativos multimédia, informação de suporte, prática e exercícios para aprendizagem introdutória. `;
quizQuestions[0][8].answers[1]=`A aprendizagem cognitiva é adequada a qualquer tipo de aprendizagem em qualquer contexto, uma vez que fornece uma orientação para o desenvolvimento de um ambiente de aprendizagem autêntico que auxilia a reflexão ativa do conhecimento e a articulação com interações ricas.`;
quizQuestions[0][8].answers[2]=`Na aprendizagem de domínio, os formadores utilizam diferentes métodos de instrução para diferentes tipos de aprendizagem e permitem que os alunos aprendam ao seu próprio ritmo para dominar o que foi ensinado na instrução.`;
quizQuestions[0][8].key=2;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Qual das seguintes ideias sobre os paradigmas do Instructional Design está incorreta?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os Instructional Designers utilizam o paradigma da conceção sistemática e o paradigma da conceção situacional de forma interativa durante o processo de ID. Enquanto o paradigma da conceção sistemática fornece o quadro geral, o paradigma da conceção situacional efetua ajustamentos com base na análise iterativa dos problemas.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>Os Instructional Designers utilizam o paradigma da conceção sistemática e o paradigma da conceção situacional de forma interativa durante o processo de ID. Enquanto o paradigma da conceção sistemática fornece o quadro geral, o paradigma da conceção situacional efetua ajustamentos com base na análise iterativa dos problemas.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Os Instructional Designers escolhem um dos paradigmas para desenvolver formação escolhendo entre seguir procedimentos pela teoria ou desenvolver formação baseando-se numa análise detalhada da situação. `;
quizQuestions[0][9].answers[1]=`Os Instructional Designers utilizam indistintamente os paradigmas de conceção sistemática e situacional para definir todo o quadro de formação e preencher os pormenores de conceção das práticas instrucionais.`;
quizQuestions[0][9].answers[2]=`Os Instructional Designers utilizam indistintamente os paradigmas de conceção sistemática e situacional para estabelecer o processo de desenvolvimento de instruções e adaptar de forma ágil o quadro e as práticas de conceção com base nos progressos do desenvolvimento.`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Em que consiste o contexto do Instructional Design?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O contexto do ID consiste em problemas pedagógicos e necessidades de aprendizagem, informações sobre a personalidade do formando e ambientes de aprendizagem.`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>O contexto do ID consiste em problemas pedagógicos e necessidades de aprendizagem, informações sobre a personalidade do formando e ambientes de aprendizagem.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Requisitos do cliente, alvo e potenciais formandos e características da sala de aula`;
quizQuestions[0][10].answers[1]=`Problemas de instrução e necessidades de aprendizagem, alunos-alvo/potenciais e ambiente de aprendizagem`;
quizQuestions[0][10].answers[2]=`Objetivos de aprendizagem, ambiente de aprendizagem e tecnologia disponível.`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`O que é uma solução formativa?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A solução instrucional é um documento desenvolvido com base nas teorias de ID, que consiste no modo de aprendizagem, nos objetivos de aprendizagem, nos métodos de instrução e na avaliação, que podem ser desenvolvidos num plano para o desenvolvimento do objeto de aprendizagem.`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A solução instrucional é um documento desenvolvido com base nas teorias de ID, que consiste no modo de aprendizagem, nos objetivos de aprendizagem, nos métodos de instrução e na avaliação, que podem ser desenvolvidos num plano para o desenvolvimento do objeto de aprendizagem.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Um manual baseado em teorias de Instructional Design para desenvolvimento de objetos de aprendizagem que servem para apresentar o conteúdo formativo, as atividades de aprendizagem, os materiais de apoio e a avaliação.`;
quizQuestions[0][11].answers[1]=`Um quadro baseado em teorias de Instructional Design, que fornece a estrutura do processo pedagógico, a divisão do conteúdo de aprendizagem e as ferramentas de avaliação, que podem ser utilizadas para desenvolver o modelo para o desenvolvimento de objetos de aprendizagem.`;
quizQuestions[0][11].answers[2]=`Um documento desenvolvido com base em teorias de Instructional Design, que consiste no modo de aprendizagem, nos objetivos de aprendizagem, nos métodos de instrução e na avaliação, que pode ser desenvolvido num plano para o desenvolvimento do objeto de aprendizagem.`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`O que é um objeto de aprendizagem?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os objetos de aprendizagem referem-se aos materiais de conteúdo de aprendizagem, aos recursos da atividade de aprendizagem e à avaliação baseada num objetivo de aprendizagem.`;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>Os objetos de aprendizagem referem-se aos materiais de conteúdo de aprendizagem, aos recursos da atividade de aprendizagem e à avaliação baseada num objetivo de aprendizagem.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Os objetos de aprendizagem referem-se aos materiais de formação que apresentam a informação essencial ao alvo de aprendizagem.`;
quizQuestions[0][12].answers[1]=`Os objetos de aprendizagem referem-se aos materiais de conteúdo de aprendizagem, aos recursos da atividade de aprendizagem e à avaliação baseada num objetivo de aprendizagem.`;
quizQuestions[0][12].answers[2]=`Os objetos de aprendizagem referem-se aos recursos que ajudam na aprendizagem quando os alunos têm dificuldades de aprendizagem.`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Quais são as principais fases do desenvolvimento da formação?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As etapas básicas envolvidas em todos os modelos de desenvolvimento pedagógico (DI) são a análise, a design, o desenvolvimento, a implementação e a avaliação. Estes modelos variam na sua ênfase em etapas específicas, nas práticas de cada etapa e nas sequências destas etapas.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>As etapas básicas envolvidas em todos os modelos de desenvolvimento pedagógico (DI) são a análise, a design, o desenvolvimento, a implementação e a avaliação. Estes modelos variam na sua ênfase em etapas específicas, nas práticas de cada etapa e nas sequências destas etapas.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Análise, design, desenvolvimento, implementação e avaliação`;
quizQuestions[0][13].answers[1]=`Análise, design, implementação, avaliação e reformulação.`;
quizQuestions[0][13].answers[2]=`Análise, design, desenvolvimento e implementação.`;
quizQuestions[0][13].key=1;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Qual das seguintes ideias sobre modelos de Instructional Design está incorreta?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O modelo ADDIE é um modelo abrangente de ID. É utilizado tanto de forma linear como iterativa.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>O modelo ADDIE é um modelo abrangente de ID. É utilizado tanto de forma linear como iterativa.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`O modelo ADDIE é uma abordagem sistemática e linear de instructional design que segue estritamente o procedimento que passa pela análise, design, desenvolvimento, implementação e avaliação.`;
quizQuestions[0][14].answers[1]=`A utilização do modelo SAM exige um ambiente de trabalho flexível e recursos de equipa para dar feedbacks atempados sobre o design e os protótipos.`;
quizQuestions[0][14].answers[2]=`A utilização do modelo SAM requer um ambiente de trabalho flexível e recursos de equipa para dar feedback atempado sobre o design e os protótipos.`;
quizQuestions[0][14].key=1;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Qual a opção que melhor descreve o papel da avaliação num projeto de Instructional Design?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A fase de avaliação está interligada com cada etapa da formação. Mas a adoção ou não da avaliação formativa varia de projeto para projeto.`;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A fase de avaliação está interligada com cada etapa da formação. Mas a adoção ou não da avaliação formativa varia de projeto para projeto.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`A avaliação tem o papel importante de identificar a efetividade da formação desenvolvida. É normalmente conduzida após a implementação da instrução.`;
quizQuestions[0][15].answers[1]=`A avaliação desempenha um papel importante em cada fase do Instructional Design. As práticas de avaliação centram-se tanto na qualidade do processo de conceção como na qualidade dos resultados das fases de análise, design, desenvolvimento e implementação.`;
quizQuestions[0][15].answers[2]=`A avaliação desempenha um papel importante na identificação da eficácia da instrução desenvolvida. O instrumento de avaliação é concebido e desenvolvido como um instrumento de avaliação da aprendizagem.`;
quizQuestions[0][15].key=2;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`Quais são as considerações prioritárias ao escolher modelos de ID?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A seleção dos modelos de ID depende do tipo de instrução e dos recursos e tempo disponíveis.`;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A seleção dos modelos de ID depende do tipo de instrução e dos recursos e tempo disponíveis.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Os Instructional Designers selecionam modelos de ID baseando-se nos problemas de aprendizagem e na sua experiência ao utilizar estes modelos. `;
quizQuestions[0][16].answers[1]=`Os Instructional Designers selecionam os modelos de ID com base nos problemas instrucionais, no tempo disponível, no orçamento, no apoio à gestão e nos recursos (por exemplo, tecnologia).`;
quizQuestions[0][16].answers[2]=`Os Instructional Designers selecionam os modelos de ID com base nos problemas instrucionais e nos requisitos e satisfação do cliente.`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Quais são os princípios de design que devem ser considerados ao configurar e desenvolver formação funcional?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O desenvolvimento de instruções funcionais não depende da conformidade com o modelo de desenvolvimento instrucional (ID). Os Instructional Designers utilizam o modelo de ID de forma heurística para conceber instruções centradas no problema e centradas no utilizador. Os IDs também têm em conta as necessidades de diversidade funcional, alinhamento da conceção, princípios de conceção e comunicação durante o processo de conceção.`;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>O desenvolvimento de instruções funcionais não depende da conformidade com o modelo de desenvolvimento instrucional (ID). Os Instructional Designers utilizam o modelo de ID de forma heurística para conceber instruções centradas no problema e centradas no utilizador. Os IDs também têm em conta as necessidades de diversidade funcional, alinhamento da conceção, princípios de conceção e comunicação durante o processo de conceção.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Necessidade de diversidade funcional, procedimentos de conformidade do desenvolvimento teórico, princípios de design, comunicação e utilização de tecnologia.`;
quizQuestions[0][17].answers[1]=`Problema e contexto, necessidades da diversidade funcional, conformidade com os procedimentos de desenvolvimento teórico, princípios de design, comunicação e utilização da tecnologia.`;
quizQuestions[0][17].answers[2]=`Problema e contexto, necessidades da diversidade funcional, alinhamento do design, princípios de conceção e comunicação.`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`Qual é o papel da tecnologia num projeto de Instructional Design?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A tecnologia é integrada em diferentes atividades de aprendizagem para servir a função de instrução e é utilizada para apoiar a gestão, a comunicação, a design e o desenvolvimento de objetos de aprendizagem, a implementação da instrução e a avaliação do projeto.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta. </b><br>A tecnologia é integrada em diferentes atividades de aprendizagem para servir a função de instrução e é utilizada para apoiar a gestão, a comunicação, a design e o desenvolvimento de objetos de aprendizagem, a implementação da instrução e a avaliação do projeto.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`A tecnologia é utilizada para apoiar a aprendizagem e a instrução, o que é considerado durante a criação da solução de formação para satisfazer as necessidades do cliente`;
quizQuestions[0][18].answers[1]=`A tecnologia é integrada em diferentes atividades de aprendizagem para servir a função de instrução e é utilizada para apoiar a gestão, a comunicação, o design e o desenvolvimento de objetos de aprendizagem, a implementação da instrução e a avaliação de projetos.`;
quizQuestions[0][18].answers[2]=`A tecnologia é utilizada para o design e o desenvolvimento de objetos de aprendizagem no projeto de Instructional Design.`;
quizQuestions[0][18].key=2;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Porque é que os Instructional Designers devem estar envolvidos em aprendizagem ao longo da vida no campo do Instructional Design?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b>`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta. </b>`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Para obter certificados de nível superior e obter uma promoção e um salário mais elevado.`;
quizQuestions[0][19].answers[1]=`Para se manterem atualizados com os conhecimentos e as competências na matéria, uma vez que os domínios do Instructional Design continuam a desenvolver-se juntamente com o desenvolvimento das ciências da aprendizagem.`;
quizQuestions[0][19].answers[2]=`Ambas as opções estão corretas.`;
quizQuestions[0][19].key=3;

