// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minuuttiaToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minuuttiaToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a monivalintakysymykset?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "Lähetä", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Aloita",
    button_prev: "Edellinen",
    button_next: "Seuraava",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Lähetä",
    button_review: "Arvostelu",
    button_try_again: "Yritä uudelleen",
    button_finish: "Lähetä arvosana",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Tervetuloa arviointitoimintaan!</b></h2>
        <p>Tämä arviointitoiminta koostuu seuraavista osista<b><span class="quiz-total"></span> monivalintakysymykset</b> johon sinun on vastattava valitsemalla oikea vaihtoehto. Arviointitehtävän suorittaminen hyväksytysti edellyttää, että saat vähintään seuraavan arvosanan<b>${minimumGrade}%</b>.</p>
        <p>Sinulla on <b><span class="quiz-attempts"></span> yritystä</b> suorittamaan tämä tehtävä. Sinulla on<b>${minuuttiaToComplete} minuuttia</b> jokaisessa yrityksessä suorittaa tietokilpailu. Sinun on klikattava "Lähetä arvosana" -painiketta tallentaaksesi sijoituksesi koulutusalustalle.</p>
        <p style="text-align: right"><b>Onnea matkaan!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</h2>
            <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
            <p>Yritä uudelleen.</p>
            <br><br>
            <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">ONNITTELUT!</h2>
            <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
            <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
            <p>Klikkaamalla "Lähetä arvosana" -painiketta aktiviteetti estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, klikkaa "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan).</p>
            <br><br>
            <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Yritä uudelleen.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Sinulta on loppunut yritykset tehdä tämä arviointitehtävä.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Klikkaamalla "Lähetä arvosana" -painiketta aktiviteetti estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, klikkaa "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan).</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Arvosanasi tallennettiin alustalle ja kohde merkittiin suoritetuksi.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>

        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>

        <p>Paras arvosanasi tähän mennessä oli <span class="quiz-best-grade"></span>%. Klikkaamalla "Lähetä arvosana" -painiketta toiminta estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, käytä "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan). Palaa alustalle napsauttamalla X-painiketta.</p>

        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Paras arvosanasi tähän mennessä oli <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Lähetä arvosana" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Yritä uudelleen" button (your best rating will be recorded).</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Arvosanasi kirjattiin alustalle ja tehtävä merkittiin suoritetuksi.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Mikä on prototyyppaus?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Prototyyppaus on prosessi, jossa luodaan kokeellisia näytteitä opetuksellisesta tuotteestasi, joita testaavat oppijat ja antavat palautetta tulevia tuotteita varten.  `;
quizQuestions[0][0].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Prototyyppaus on prosessi, jossa luodaan kokeellisia näytteitä opetuksellisesta tuotteestasi, joita testaavat oppijat ja antavat palautetta tulevia tuotteita varten.  `;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Prototyyppaus on prosessi, jossa lanseerataan uusi tuote uudelle markkinalle.`;
quizQuestions[0][0].answers[1]=`Prototyyppaus on prosessi, jossa testataan tuotetta uudella tai aiemmin kokeilemattomalla markkinalla.`;
quizQuestions[0][0].answers[2]=`Prototyyppaus on prosessi, jossa luodaan mallikappaleita tuotteen jalostamiseksi.  `;
quizQuestions[0][0].key=3;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Mikä on käyttäjäkokemus?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Vaihtoehto 1 viittaa käyttöliittymään, ja vaihtoehto 3 periaatteeseen 2 Käyttäjäkokemuksen hunajakenno-kehyksestä.  `;
quizQuestions[0][1].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Vaihtoehto 1 viittaa käyttöliittymään, ja vaihtoehto 3 periaatteeseen 2 Käyttäjäkokemuksen hunajakenno-kehyksestä.  `;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Käyttäjäkokemus viittaa tuotteen tai järjestelmän esittelyyn.`;
quizQuestions[0][1].answers[1]=`Käyttäjäkokemus viittaa siihen, kuinka käyttäjät vuorovaikuttavat ja kokevat tuotteen, järjestelmän tai palvelun.`;
quizQuestions[0][1].answers[2]=`Käyttäjäkokemus kertoo siitä, kuinka helppoa on asiakkaiden käyttää tuotetta.  `;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Mikä on käyttöliittymä?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käyttöliittymä, tunnettu myös nimellä UI, on tuotteen tai järjestelmän visuaalinen esitys.  `;
quizQuestions[0][2].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käyttöliittymä, tunnettu myös nimellä UI, on tuotteen tai järjestelmän visuaalinen esitys.  `;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Se viittaa tuotteen tai järjestelmän esittelyyn.`;
quizQuestions[0][2].answers[1]=`Se viittaa siihen, miten käyttäjät kokevat tuotteen tai järjestelmän.`;
quizQuestions[0][2].answers[2]=`Se viittaa siihen, miten käyttäjät vuorovaikuttavat ja kokevat tuotteen, järjestelmän tai palvelun.  `;
quizQuestions[0][2].key=1;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Mikä on käyttöliittymäsuunnittelun päämäärä?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käyttöliittymäsuunnittelun tavoitteena on luoda helppokäyttöinen, tehokas ja miellyttävä käyttöliittymä.  `;
quizQuestions[0][3].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käyttöliittymäsuunnittelun tavoitteena on luoda helppokäyttöinen, tehokas ja miellyttävä käyttöliittymä.  `;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Käyttöliittymäsuunnittelun päämäärä on välittää tuotteen tai järjestelmän edut potentiaalisille käyttäjille.`;
quizQuestions[0][3].answers[1]=`Käyttöliittymäsuunnittelun tavoitteena on luoda tuotteen mallikappaleen havainnekuvaa.`;
quizQuestions[0][3].answers[2]=`Käyttöliittymäsuunnittelun tavoitteena on luoda käyttöliittymä, joka on helppokäyttöinen, tehokas ja miellyttävä.  `;
quizQuestions[0][3].key=3;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Kuinka monta periaatetta on käyttäjäkokemuksen hunajakennokehysmallissa?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käyttäjäkokemuksen hunajakenno-kehyksen seitsemän vaihetta ovat: käytettävyys, hyödyllisyys, haluttavuus, löydettävyys, saavutettavuus, luotettavuus ja arvo.  `;
quizQuestions[0][4].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käyttäjäkokemuksen hunajakenno-kehyksen seitsemän vaihetta ovat: käytettävyys, hyödyllisyys, haluttavuus, löydettävyys, saavutettavuus, luotettavuus ja arvo.  `;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Kuusi.`;
quizQuestions[0][4].answers[1]=`Seitsemän.`;
quizQuestions[0][4].answers[2]=`Viisi.  `;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Mitä tarkoittaa "Käytettävä," joka on käyttäjäkokemuksen hunajakennokehyksen ensimmäinen vaihe?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Vaihtoehto 1 on periaate 3, "Haluttava," ja vaihtoehto 2 on periaate 6, "Luotettava," Käyttäjäkokemuksen hunajakenno-kehyksestä.  `;
quizQuestions[0][5].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Vaihtoehto 1 on periaate 3, "Haluttava," ja vaihtoehto 2 on periaate 6, "Luotettava," Käyttäjäkokemuksen hunajakenno-kehyksestä.  `;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Järjestelmän estetiikan pitäisi olla houkutteleva ja helppo kääntää.`;
quizQuestions[0][5].answers[1]=`Sen tulisi olla läpinäkyvä ja turvallinen käyttää.`;
quizQuestions[0][5].answers[2]=`Sen pitäisi tuntua tutulta ja olla helppokäyttöinen.  `;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Mitä "Esteetön" periaate käyttäjäkokemuksen hunajakennokehyksessä tarkoittaa?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Vaihtoehto 1 on periaate 6, "Luotettava," ja vaihtoehto 3 on periaate 4, "Löydettävissä," Käyttäjäkokemuksen hunajakenno-kehyksestä.  `;
quizQuestions[0][6].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Vaihtoehto 1 on periaate 6, "Luotettava," ja vaihtoehto 3 on periaate 4, "Löydettävissä," Käyttäjäkokemuksen hunajakenno-kehyksestä.  `;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Sen pitäisi tuntua tutulta ja olla helppokäyttöinen.`;
quizQuestions[0][6].answers[1]=`Sovelluksen pitäisi olla saavutettavissa myös vammaisille.`;
quizQuestions[0][6].answers[2]=`Tiedon pitäisi olla helposti löydettävissä ja yksinkertainen navigoida.  `;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Jos kaikki 7 periaatetta käyttäjäkokemuksen hunajakennokehyksessä toteutuvat, mitä loppukäyttäjä kokee?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käyttäjäkokemuksen hunajakenno-kehys on luotu ohjaamaan käyttöliittymäsuunnittelua, ja nämä seitsemän periaatetta ovat keskeisiä tehokkaan käyttöliittymän ja oppimiskokemuksen suunnittelussa.  `;
quizQuestions[0][7].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käyttäjäkokemuksen hunajakenno-kehys on luotu ohjaamaan käyttöliittymäsuunnittelua, ja nämä seitsemän periaatetta ovat keskeisiä tehokkaan käyttöliittymän ja oppimiskokemuksen suunnittelussa.  `;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Löytää arvoa ja luottamusta sovellukseen.`;
quizQuestions[0][7].answers[1]=`Olla esimerkkituote myynnissä.`;
quizQuestions[0][7].answers[2]=`Tuotteen tulisi olla edullinen käyttää.  `;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Kuinka monta vaihetta on käyttäjäkokemuksen suunnitteluprosessissa?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käyttäjäkokemuksen suunnitteluprosessin viisi vaihetta ovat: empatia, määrittely, ideointi, prototyyppaus ja testaus.  `;
quizQuestions[0][8].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käyttäjäkokemuksen suunnitteluprosessin viisi vaihetta ovat: empatia, määrittely, ideointi, prototyyppaus ja testaus.  `;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`8`;
quizQuestions[0][8].answers[1]=`7`;
quizQuestions[0][8].answers[2]=`5`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Mitä "Myötäelää" vaihe käyttäjäkokemuksen suunnitteluprosessissa käsittää?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Empatia on ensimmäinen vaihe, jossa tulee ymmärtää tuotteesi käyttäjien haasteet, eli asettua heidän asemaansa.  `;
quizQuestions[0][9].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Empatia on ensimmäinen vaihe, jossa tulee ymmärtää tuotteesi käyttäjien haasteet, eli asettua heidän asemaansa.  `;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Kehittämään useita ratkaisuehdotuksia erityiseen ongelmaan, joka oppijat usein kohtaavat.`;
quizQuestions[0][9].answers[1]=`Kerää oppijoilta palautetta paremman tuotteen luomiseksi, joka vastaa täysin heidän tarpeitaan ja odotuksiaan.`;
quizQuestions[0][9].answers[2]=`Ymmärrä tuotteesi käyttäjien haasteet ja asetu heidän asemaansa ymmärtääksesi, miltä heistä tuntuu tuotetta käytettäessä.  `;
quizQuestions[0][9].key=3;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Mitä määrittelyvaihe käsittää?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Toinen vaihe, "Määrittely," käsittää haasteiden priorisoinnin ja niiden taustojen tutkimisen.  `;
quizQuestions[0][10].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Toinen vaihe, "Määrittely," käsittää haasteiden priorisoinnin ja niiden taustojen tutkimisen.  `;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Tässä vaiheessa ongelmat lajitellaan tärkeysjärjestykseen, jotka on tunnistettu 'Myötäelää'-vaiheessa, ja tehdään tutkimusta ymmärtääksemme miksi nämä haasteet ovat tärkeitä.`;
quizQuestions[0][10].answers[1]=`Vaihe sisältää tuotteen osa-alueiden määrittämisen, jotka täytyy suunnitella uudestaan käyttäjien aikaisemman palautteen perusteella.`;
quizQuestions[0][10].answers[2]=`Määrittelyvaiheessa valitaan paras idea yleisen ongelman ratkaisemiseksi, jonka oppijat usein kohtaavat.  `;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Kuinka usein käyttäjätutkimus ja testaus tulisi suorittaa tuotteelle?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käyttäjätutkimus ja testaus ovat olennainen osa UX-suunnittelijan työtä ja ne tulisi tehdä säännöllisesti tuotteen tehokkuuden ylläpitämiseksi.  `;
quizQuestions[0][11].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käyttäjätutkimus ja testaus ovat olennainen osa UX-suunnittelijan työtä ja ne tulisi tehdä säännöllisesti tuotteen tehokkuuden ylläpitämiseksi.  `;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Viisi kertaa.`;
quizQuestions[0][11].answers[1]=`Niin usein kuin mahdollista.`;
quizQuestions[0][11].answers[2]=`Kerran.  `;
quizQuestions[0][11].key=2;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Mitä "Ideoi" vaihe käsittää?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Tämän prosessin toistaminen säännöllisesti varmistaa tuotteen tehokkuuden ja toimivuuden.  `;
quizQuestions[0][12].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Tämän prosessin toistaminen säännöllisesti varmistaa tuotteen tehokkuuden ja toimivuuden.  `;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Lajittele identifioidut ongelmat niiden tärkeysasteen mukaan.`;
quizQuestions[0][12].answers[1]=`Sisältää mahdollisimman monien ideoiden generoinnin.`;
quizQuestions[0][12].answers[2]=`Asetu käyttäjän asemaan.  `;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Miksi UX-suunnittelijat testaavat tuotteitaan?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>UX-suunnittelijat tekevät testauksia, koska se mahdollistaa tuotteen tai palvelun parantamisen ja suunnitteluvaiheessa tehdyt muutokset pystytään arvioimaan.  `;
quizQuestions[0][13].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>UX-suunnittelijat tekevät testauksia, koska se mahdollistaa tuotteen tai palvelun parantamisen ja suunnitteluvaiheessa tehdyt muutokset pystytään arvioimaan.  `;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Tämä vaihe tarkoittaa, että suunnittelijat voivat paremmin tunnistaa tulevat tuotteet, jotka he voivat suunnitella täydentämään testattavaa tuotetta.`;
quizQuestions[0][13].answers[1]=`Tämä varmistaa, että suunnittelijat ymmärtävät, mitkä muutokset tuotteeseen tulee tehdä.`;
quizQuestions[0][13].answers[2]=`Tämä mahdollistaa sen, että he voivat nähdä, toimivatko tekemänsä muutokset tuotteessa oikein.  `;
quizQuestions[0][13].key=3;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Miksi interaktiivisuus on niin tärkeää?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Interaktiivisuus lisää oppijoiden sitoutumista kurssiin, ja erilaisten interaktiivisten elementtien käyttö pitää sisällön mielenkiintoisena.  `;
quizQuestions[0][14].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Interaktiivisuus lisää oppijoiden sitoutumista kurssiin, ja erilaisten interaktiivisten elementtien käyttö pitää sisällön mielenkiintoisena.  `;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Se antaa kehittäjille mahdollisuuden asettua käyttäjän kenkiin.`;
quizQuestions[0][14].answers[1]=`Se helpottaa oppijoiden vuorovaikutusta sisällön kanssa.`;
quizQuestions[0][14].answers[2]=`Mahdollistaa muutosten tekemisen prototyyppiin.  `;
quizQuestions[0][14].key=2;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Mikä on pelipohjaisen oppimisen taso?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Pelipohjainen oppiminen on neljäs taso interaktiivisuudessa.  `;
quizQuestions[0][15].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Pelipohjainen oppiminen on neljäs taso interaktiivisuudessa.  `;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`4`;
quizQuestions[0][15].answers[1]=`3`;
quizQuestions[0][15].answers[2]=`7`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`Seuraavat ovat video-, ääni- ja kuvankäsittelyohjelmistot.`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Adobe Premiere, Final Cut Pro, Adobe Photoshop ja GIMP ovat video- ja kuvankäsittelyohjelmia.  `;
quizQuestions[0][16].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Adobe Premiere, Final Cut Pro, Adobe Photoshop ja GIMP ovat video- ja kuvankäsittelyohjelmia.  `;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Zoom, Skype ja Instagram.`;
quizQuestions[0][16].answers[1]=`Adobe Premiere, Final Cut Pro, Adobe Photoshop ja GIMP -editing.`;
quizQuestions[0][16].answers[2]=`Twitter, Microsoft Office, Microsoft Excel.  `;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Suunnitteluprosessissa on monta vaihetta, ja ensimmäinen vaihe on?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Käsikirjoitus on erinomainen työkalu mediaproduktion suunnittelussa, auttaen luomaan videon ruutu kerrallaan.  `;
quizQuestions[0][17].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Käsikirjoitus on erinomainen työkalu mediaproduktion suunnittelussa, auttaen luomaan videon ruutu kerrallaan.  `;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Käsikirjoitus.`;
quizQuestions[0][17].answers[1]=`Muokkaaminen.`;
quizQuestions[0][17].answers[2]=`Käsikirjoituksen laatiminen.  `;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`Mikä on skenaariopohjainen oppiminen?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Skenaariopohjainen oppiminen aktivoi oppijat esittämällä heille ratkaistavia ongelmia, ja kehittää heidän päätöksentekotaitojaan.  `;
quizQuestions[0][18].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Skenaariopohjainen oppiminen aktivoi oppijat esittämällä heille ratkaistavia ongelmia, ja kehittää heidän päätöksentekotaitojaan.  `;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Skenaariopohjainen oppiminen on tilanne, jossa oppija saa tiedon opettajalta passiivisella tavalla.`;
quizQuestions[0][18].answers[1]=`Skenaariopohjaisessa oppimisessa roolit vaihtuvat ja oppija opettaa opettajaa.`;
quizQuestions[0][18].answers[2]=`Skenaariopohjainen oppiminen tarkoittaa sitä, että oppijat osallistuvat aktiivisesti oppimiseen ratkaisemalla heille esitettyjä skenaarioita ja ongelmia.  `;
quizQuestions[0][18].key=3;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Skenaariopohjaisen oppimisen suunnittelun ensimmäinen vaihe pitäisi olla?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Vaihtoehto 1 on kolmas askel skenaarion luomisessa, ja vaihtoehto 2 on viides askel.`;
quizQuestions[0][19].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Vaihtoehto 1 on kolmas askel skenaarion luomisessa, ja vaihtoehto 2 on viides askel.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Valitse tilanne skenaariollesi.`;
quizQuestions[0][19].answers[1]=`Skenaariosi suunnittelu.`;
quizQuestions[0][19].answers[2]=`Tunnista kohdeyleisösi ja ymmärrä heidän tarpeensa.`;
quizQuestions[0][19].key=3;

