/* 
 * Custom JS interactions
 */

function customFunctions() {
    paginationUpdate();
    paginationCompletion();
    autoPopup();
    autoDialogue();
    dialogueQuestion();
    simpleQuestion();
    clearExtraScreen();
}

var topics = [];
var topicPage = 1;

function pagination() {
    var size = courseIndex.length;
    
    for ( var p = 0; p < size; p++ ) {
        if ( topics[courseIndex[p].topic] === undefined ) {
            topics[courseIndex[p].topic] = 1;
            if ( isNaN(courseStatus.topics[courseIndex[p].topic])  ) {
                courseStatus.topics[courseIndex[p].topic] = 0;
            }
        } else {
            topics[courseIndex[p].topic]++;
        }
    }
    zork('This course has ' + topics.length + ' topics!' );
}

pagination();

function paginationUpdate() {
    var topicCurrent = courseIndex[slideActive].topic;
    topicPage = 0;
    
    for ( var t = 0; t <= slideActive; t++ ) {
        if ( courseIndex[t].topic === topicCurrent ) {
            topicPage++;
        } 
    }
    if ( isNaN(courseStatus.topics[topicCurrent])  ) {
        topicPage = 0;
    }
    if ( courseStatus.topics[topicCurrent] <= topicPage ) {
        courseStatus.topics[topicCurrent] = topicPage;
    }
    courseStatus.topics[topicCurrent] = topicPage;
    $('#current-pagination').html(topicPage);
    $('#total-pagination').html(topics[topicCurrent]);
    zork('You are in page ' + topicPage + ' of ' + topics[topicCurrent] + '.');
    
    var t = topicCurrent + 1;
    $('.map-unit').removeClass('active');
    $('.map-unit[data-id="'+t+'"]').addClass('active');
    $('.map-unit-pin.active').removeClass('active');
    $('.map-unit-pin[data-id="'+t+'"]').addClass('active');
    
}
function paginationCompletion() {
    var completed = 0;
    var inProgress = 0;
    var granularTotal = 0;
    var granularProgress = 0;
    var total = topics.length;
    
    for ( var m = 0; m < total; m++ ) {
        var max = topics[m];
        var current = courseStatus.topics[m];   
        var unitPercent = Math.round( current * 100 / max );
        granularTotal += max;
        granularProgress += current;
        if ( current < max ) {
            inProgress++;
        } else {
            completed++;
        }
        if ( $('#evolution-bar-'+m ).length <= 0 ) {
            $('#progress-bars-box').append('<div id="evolution-title-'+m+'" class="evolution-title">'+topicsIndex[m]+'</div><div id="evolution-bar-'+m+'" class="evolution-bar"><div class="progress"></div></div><div id="evolution-bar-percent-'+m+'" class="evolution-bar-percent"></div>');
        }
        $('#evolution-bar-'+m+' .progress').css('width', unitPercent + '%');
        $('#evolution-bar-percent-'+m).html( unitPercent + '%');
    }
    var percent = Math.round(granularProgress * 100 / granularTotal);
    $('#pie-chart').attr('data-percent', percent);
    $('.progress-data-completed').html( completed);
    $('.progress-data-in-progress').html( inProgress);
    $('.progress-data-total').html( total);
}

function toolListToggle( id ) {
    $('.tool').removeClass('active');
    $( '.tool-link' ).removeClass('active');
    $( '.tool-link' ).each( function(){
        var format = $( this ).attr( 'src' ).split('.').pop();
        $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
    });
    if ( !$( '#tool-' + id ).hasClass('active') ) {
//        $( '#tool-' + id ).fadeIn();
        $( '#tool-' + id ).addClass('active');
        $( '#tool-link-' + id ).addClass('active');
        
        var format = $( '#tool-link-' + id ).attr( 'src' ).split('.').pop();
        $( '#tool-link-' + id ).attr( 'src', $( '#tool-link-' + id ).data( 'src' ) + 'select.' + format );
    }
}

function simpleQuestion() {
    $('.mbcp-simple-question-button').on( 'click', function() {
        if ( $(this).hasClass('selectable') ) {
            $('.mbcp-simple-question-button').removeClass('selected');
            $(this).addClass('selected');
            $('.mbcp-simple-question-validate').show();
        }
    });
    $('.mbcp-simple-question-validate').on( 'click', function() {
        $('.mbcp-simple-question-button').removeClass('selectable');
        $('.mbcp-simple-question-button').addClass('solved');
        $('.mbcp-simple-question-validate').hide();
        $('.mbcp-simple-question-intruction-2').hide();
        finish();
        if ( $('.mbcp-simple-question-button.right.selected' ).length > 0 ) {
            $('.mbcp-simple-question-feedback-correct').fadeIn();
        } else {    
            $('.mbcp-simple-question-feedback-incorrect').fadeIn();
        }
    });
}

function dialogueQuestion() {
    $('.mbcp-dialogue-question').on( 'click', function() {
        if ( $(this).hasClass('selectable') ) {
            $('.mbcp-dialogue-question').removeClass('selected');
            $(this).addClass('selected');
            $('.mbcp-dialogue-question-validate').show();
        }
    });
    $('.mbcp-dialogue-question-validate').on( 'click', function() {
        $('.mbcp-dialogue-question').removeClass('selectable');
        $('.mbcp-dialogue-question').addClass('solved');
        $('.mbcp-dialogue-question-validate').hide();
        $('.mbcp-dialogue-question-intruction').hide();
        finish();
        if ( $('.mbcp-dialogue-question.right.selected' ).length > 0 ) {
            $('.mbcp-dialogue-question-feedback-correct').show();
        } else {
            
            $('.mbcp-dialogue-question-feedback-incorrect').show();
        }
    });
}

function glossaryUpdate() {
    $('.gallery-link').addClass('dead');
    var size = glossary.length;
    for ( var g = 0; g < size; g++ ) {
        var key = glossary[g][0][0].toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '');   
        $('#gallery-link-'+key).removeClass('dead');
    }
}


function glossarySearch() {
    var search = $('#glossary-input').val().toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '');
    var letter = search[0];
    glossaryGoTo( letter );
    letter.toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '');
    var size = glossary.length;
    
    var searchSize = search.length;
    
    for ( var g = 0; g < size; g++ ) {
        var key = glossary[g][0].toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '');
        if ( glossary[g][0][0] === letter ) {
            key = key.slice(0, searchSize);
            zork('Comparing ' + key + ' to ' + search + '.');
            if ( key === search ) {
                glossaryGoToItem( g );
            }
        }
    }
}

function glossaryGoToItem( id ) {
    var definition = '';
    $('.gallery-item').removeClass('active');
    definition += '<h3>' + glossary[id][0] + '</h3>';
    definition += '<p>' + glossary[id][1] + '</p>';
    $('.gallery-item-' + id).addClass('active');
    zork('Going to item ' + id + ', ' + glossary[id][0] + '.');
    $('#glossary-results').fadeIn();
    $('#glossary-definition').html( definition );
}

function glossaryGoTo( id ) {
    var letter = id[0].toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '');
    var list = '';
    var size = glossary.length;
    $('.gallery-link').removeClass('active');
    $('#gallery-link-' + letter).addClass('active');
    for ( var g = 0; g < size; g++ ) {
        var key = glossary[g][0][0].toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '');
        if ( key === letter ) {
            zork('Adding glossary item ' + g + '!');
            list += '<a class="gallery-item gallery-item-' + g + '" href="#" onclick="glossaryGoToItem('+g+'); return false;">'+glossary[g][0]+'</a>';
        }
    }
    $('#glossary-definition').html( '' );
    $('#glossary-list').html( list );
    $('#glossary-results').fadeIn();
    
}

function mapClicked() {
    $('.map-unit').hover( function() {
        var id = $(this).data('id');
        $('.map-unit-pin[data-id="'+id+'"]').addClass('temp');
    }, function(){
        $('.map-unit-pin.temp').removeClass('temp');
    });
}

function clearExtraScreen() {
    $( '#slide-menu' ).removeClass( 'active' );
    $( '.tool' ).removeClass( 'active' );
    $( '.player-controls' ).removeClass( 'selected' );
    $('.extra-screen').removeClass( 'active' );
    $('#extra-screen-barrier').fadeOut();
    $( '.tool-link' ).removeClass('active');
    $( '.tool-link' ).each( function(){
        var format = $( this ).attr( 'src' ).split('.').pop();
        $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
    });
}

function showExtraScreen( id ) {
    $( '#slide-menu' ).removeClass( 'active' );
    $( '.tool' ).removeClass( 'active' );
    $( '.player-controls' ).removeClass( 'selected' );
    if ( !$( '#' + id ).hasClass( 'active' ) ) {
        $('#player-controls-'+ id).addClass('selected');
        $('.extra-screen').removeClass( 'active' );
        $( '#' + id ).addClass( 'active' );
        $('#extra-screen-barrier').fadeIn();
    } else {
        $('.extra-screen').removeClass( 'active' );
        $('#extra-screen-barrier').fadeOut();
    }
}

function autoPopup() {
    zork('Activating auto popups!');
    $('.autopopup-close').on('click', function() {
        $('.autopopup').fadeOut();
    });
    
    $('.autopopup-button').each( function() {
        $(this).on('click', function() {
            var id = $( this ).data('target');
            zork('You clicked on popup button #' + id);
            $('.autopopup-' + id ).fadeIn();
            $( this ).attr('src', $( this ).data('clicked') );
            $( this ).addClass('clicked');
            checkAllPopups();
        });
    });
    $('.automicropopup-button').each( function() {
        $(this).on('mouseover', function() {
            var id = $( this ).data('target');
            zork('You hovered on micro popup button #' + id);
            $('.automicropopup-' + id ).show();
            $( this ).attr('src', $( this ).data('clicked') );
            $( this ).addClass('clicked');
            checkAllPopups();
        });
        $(this).on('click', function() {
            var id = $( this ).data('target');
            zork('You clicked on micro popup button #' + id);
            if(  $('.automicropopup-' + id ).hasClass('show') ) {
                $('.automicropopup-' + id ).hide();
                $('.automicropopup-' + id ).removeClass('show');
            } else {
                $('.automicropopup-' + id ).show();
                $('.automicropopup-' + id ).addClass('show');
            }
        });
        
        $(this).on('mouseleave', function() {
            var id = $( this ).data('target');
            zork('You hovered off micro popup button #' + id);
            if( !$('.automicropopup-' + id ).hasClass('show') ) {
                $('.automicropopup-' + id ).hide();
            }
        });
    });
}

function checkAllPopups() {
    var numberOfPopups = $('.mandatory-interaction').length;
    var numberOfClickedPopups = $('.mandatory-interaction.clicked').length;
    
    if ( numberOfPopups === numberOfClickedPopups ) {
        finish();
    }
}

function autoDialogue() {
    zork('Activating auto dialogues!');
    $('.mbcp-dialogue-button').each( function() {
        $(this).on('click', function() {
            $('.mbcp-instruction').fadeOut();
            var id = parseIfInteger($( this ).data('number'));
            var idNext = id + 1;
            zork('You clicked on dialogue button #' + id);
            if( !$(this).hasClass('locked') ) {
                $('.mbcp-dialogue').fadeOut();
                $('.mbcp-dialogue-button.active').removeClass('active');
                $('.mbcp-dialogue-'+ id).fadeIn();
                $('.mbcp-dialogue-button-'+ id).addClass('active');
                zork('Checking to see if button ' + idNext + ' is available!');
                if ( $('.mbcp-dialogue-button-'+ idNext).length > 0 ) {
                    $('.mbcp-dialogue-button-'+ idNext).removeClass('locked');
                } else {
                    zork('Success!');
                    finish();
                }
            }
        });
    });
}

$(document).ready(function() {
   // glossaryUpdate();
    paginationCompletion();
    mapClicked();
//    $('.custom-scrollbar').customScrollbar();
});

