// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};
var quizQuestions = {};



quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Para que são utilizados os Sistemas de Gestão da Aprendizagem (LMS)?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os LMSs são utilizados para ministrar, monitorizar e elaborar relatórios sobre cursos de e-learning. Isto significa que os LMSs fornecem uma plataforma para disponibilizar cursos de e-learning aos formandos, e para acompanhar e gerir o seu progresso e desempenho.`;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os LMSs são utilizados para ministrar, monitorizar e elaborar relatórios sobre cursos de e-learning. Isto significa que os LMSs fornecem uma plataforma para disponibilizar cursos de e-learning aos formandos, e para acompanhar e gerir o seu progresso e desempenho.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Disponibilização, monitorização e elaboração de relatórios sobre cursos de e-learning`;
quizQuestions[0][0].answers[1]=`Criação de conteúdos e autoria`;
quizQuestions[0][0].answers[2]=`Apoio e aconselhamento aos formandos`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`O que é que um LMS oferece?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Um LMS fornece a base e a estrutura de um curso de e-learning, fornecendo uma plataforma para organizar, fornecer e acompanhar o conteúdo e as atividades de aprendizagem.`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Um LMS fornece a base e a estrutura de um curso de e-learning, fornecendo uma plataforma para organizar, fornecer e acompanhar o conteúdo e as atividades de aprendizagem.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Modelos para apresentações de cursos`;
quizQuestions[0][1].answers[1]=`A base e a estrutura de um curso de e-learning`;
quizQuestions[0][1].answers[2]=`Ferramentas para conceber uma experiência de aprendizagem`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Que elementos deve oferecer um LMS para proporcionar uma formação de alta qualidade e cativante?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Um LMS pode fornecer formação de alta qualidade e envolvente através de elementos de gamificação, calendários e percursos de aprendizagem. Estes elementos podem tornar a experiência de aprendizagem mais envolvente e divertida, e podem motivar os formandos a concluir tarefas e a atingir objetivos.`;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Um LMS pode fornecer formação de alta qualidade e envolvente através de elementos de gamificação, calendários e percursos de aprendizagem. Estes elementos podem tornar a experiência de aprendizagem mais envolvente e divertida, e podem motivar os formandos a concluir tarefas e a atingir objetivos.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Manuais extensos em PDF`;
quizQuestions[0][2].answers[1]=`Vídeos detalhados sobre como utilizar o LMS`;
quizQuestions[0][2].answers[2]=`Elementos de gamificação, calendários e percursos de aprendizagem`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Que funcionalidade dos LMS é essencial na sociedade atual?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A compatibilidade com dispositivos móveis é crucial para a funcionalidade do LMS, pois permite que os formandos acedam e utilizem o LMS nos seus dispositivos móveis, como smartphones e tablets. Isto é importante porque muitos formandos utilizam dispositivos móveis como principal ou único meio de acesso à Internet.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A compatibilidade com dispositivos móveis é crucial para a funcionalidade do LMS, pois permite que os formandos acedam e utilizem o LMS nos seus dispositivos móveis, como smartphones e tablets. Isto é importante porque muitos formandos utilizam dispositivos móveis como principal ou único meio de acesso à Internet.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Compatibilidade com dispositivos móveis`;
quizQuestions[0][3].answers[1]=`Capacidade de criar conteúdos dentro do LMS`;
quizQuestions[0][3].answers[2]=`Transmissão em direto`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Que característica é crucial para monitorizar o desempenho da aprendizagem?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma funcionalidade robusta de criação de relatórios é uma característica crucial para monitorizar o desempenho da aprendizagem, porque fornece dados detalhados e abrangentes sobre o progresso e o desempenho dos formandos.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma funcionalidade robusta de criação de relatórios é uma característica crucial para monitorizar o desempenho da aprendizagem, porque fornece dados detalhados e abrangentes sobre o progresso e o desempenho dos formandos.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Sistema de mensagens síncronas`;
quizQuestions[0][4].answers[1]=`Funcionalidade de relatório robusta`;
quizQuestions[0][4].answers[2]=`Capacidade de gravar sessões`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Qual é o primeiro passo que o ID deve dar durante a configuração?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Durante a configuração O primeiro passo para um ID é fazer uma lista de verificação para garantir que todas as necessidades e requisitos definidos para o projeto são implementados. Isto significa criar uma lista de todos os elementos e características chave que o projeto deve incluir e verificar cada item à medida que é implementado.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Durante a configuração O primeiro passo para um ID é fazer uma lista de verificação para garantir que todas as necessidades e requisitos definidos para o projeto são implementados. Isto significa criar uma lista de todos os elementos e características chave que o projeto deve incluir e verificar cada item à medida que é implementado.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Criação de conteúdos`;
quizQuestions[0][5].answers[1]=`Certifique-se de que os visuais estão finalizados e polidos`;
quizQuestions[0][5].answers[2]=`Faça uma lista de verificação para garantir que todas as necessidades e requisitos definidos para o projeto são implementados`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Quando é que um LMS com opção de etiqueta branca é essencial?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Se o curso tiver de refletir a marca da empresa, a opção de etiqueta branca é essencial.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Se o curso tiver de refletir a marca da empresa, a opção de etiqueta branca é essencial.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Se o curso tiver de refletir a marca da empresa `;
quizQuestions[0][6].answers[1]=`Se o ID necessitar de mais opções`;
quizQuestions[0][6].answers[2]=`Se os formandos quiserem personalizar o seu ambiente`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Qual é a norma mais recente para avaliar um ambiente de e-learning?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A norma mais recente para avaliar um ambiente de e-learning é a Experience API (xAPI).`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A norma mais recente para avaliar um ambiente de e-learning é a Experience API (xAPI).`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`SCORM`;
quizQuestions[0][7].answers[1]=`xAPI `;
quizQuestions[0][7].answers[2]=`AICC`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Qual é a melhor prática para envolver os formandos na experiência de e-learning?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>É importante que os formandos tenham a oportunidade de criar conteúdos originais, pois isso permite-lhes demonstrar os seus conhecimentos e competências.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>É importante que os formandos tenham a oportunidade de criar conteúdos originais, pois isso permite-lhes demonstrar os seus conhecimentos e competências.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Para oferecer uma grande quantidade de conteúdos de aprendizagem`;
quizQuestions[0][8].answers[1]=`Para criar uma experiência de aprendizagem consistente e de tamanho único`;
quizQuestions[0][8].answers[2]=`Os formandos devem ter a oportunidade de criar conteúdos originais`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Qual é a melhor forma de apresentar a informação?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Ao apresentar o conteúdo aos formandos, é importante contextualizar a informação, porque contextualizar a informação significa fornecer antecedentes, exemplos e aplicações do mundo real que ajudem os formandos a compreender o significado e a relevância do conteúdo.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Ao apresentar o conteúdo aos formandos, é importante contextualizar a informação, porque contextualizar a informação significa fornecer antecedentes, exemplos e aplicações do mundo real que ajudem os formandos a compreender o significado e a relevância do conteúdo.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`A informação deve ser contextualizada`;
quizQuestions[0][9].answers[1]=`Detalhe de forma direta e abundante`;
quizQuestions[0][9].answers[2]=`Em modo verbal`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`O que é essencial para definir uma estratégia de migração de dados?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Ao definir uma estratégia de migração de dados, é essencial definir quais os cursos, dados e ativos pedagógicos que devem ser transferidos para o novo sistema, uma vez que esta informação determinará o âmbito e a complexidade do processo de migração.`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Ao definir uma estratégia de migração de dados, é essencial definir quais os cursos, dados e ativos pedagógicos que devem ser transferidos para o novo sistema, uma vez que esta informação determinará o âmbito e a complexidade do processo de migração.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Assegure-se de que o processo é rápido e eficaz`;
quizQuestions[0][10].answers[1]=`Que cursos, dados e ativos de ensino devem ser transferidos para o novo sistema`;
quizQuestions[0][10].answers[2]=`Não perder o controlo das questões de segurança`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Qual é o passo final antes de concluir o processo de implementação do LMS?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O passo final antes de concluir o processo de implementação do LMS é testar o novo LMS com um conjunto selecionado de utilizadores, porque isso permitirá identificar e resolver quaisquer problemas ou bugs antes de o sistema ser utilizado por todos os utilizadores.`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O passo final antes de concluir o processo de implementação do LMS é testar o novo LMS com um conjunto selecionado de utilizadores, porque isso permitirá identificar e resolver quaisquer problemas ou bugs antes de o sistema ser utilizado por todos os utilizadores.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Certifique-se de que todo o conteúdo é carregado corretamente`;
quizQuestions[0][11].answers[1]=`Certifique-se de que os visuais estão bem definidos e polidos`;
quizQuestions[0][11].answers[2]=`Teste o novo LMS com um conjunto selecionado de utilizadores`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Qual é o primeiro passo a dar após a conclusão do processo de implementação do LMS?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>É importante rever como correu o processo de implementação do LMS para todos os envolvidos, porque pode ajudar a identificar quaisquer problemas ou desafios que tenham surgido durante o processo de implementação.`;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>É importante rever como correu o processo de implementação do LMS para todos os envolvidos, porque pode ajudar a identificar quaisquer problemas ou desafios que tenham surgido durante o processo de implementação.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Análise da forma como decorreu o processo de implementação do LMS para todos os envolvidos`;
quizQuestions[0][12].answers[1]=`Certifique-se de que todo o conteúdo é carregado corretamente`;
quizQuestions[0][12].answers[2]=`Teste todas as funcionalidades do LMS`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Qual é o elemento essencial do controlo de qualidade?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Supervisionar a implementação das soluções do ID e realizar testes de validação são elementos essenciais de uma verificação de qualidade porque ajudam a garantir que os materiais instrucionais estão a ser implementados corretamente e são eficazes para atingir os objetivos de aprendizagem pretendidos.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Supervisionar a implementação das soluções do ID e realizar testes de validação são elementos essenciais de uma verificação de qualidade porque ajudam a garantir que os materiais instrucionais estão a ser implementados corretamente e são eficazes para atingir os objetivos de aprendizagem pretendidos.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Verificar a disposição e a formatação dos materiais`;
quizQuestions[0][13].answers[1]=`Supervisionar a implementação de soluções de ID e efetuar testes de validação`;
quizQuestions[0][13].answers[2]=`Verificar se todas as imagens e elementos visuais são de alta resolução`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`O que é que o ID deve ter sempre em conta ao conceber os materiais de aprendizagem?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O ID deve ter sempre em conta os antecedentes dos formandos quando concebe os materiais de aprendizagem.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O ID deve ter sempre em conta os antecedentes dos formandos quando concebe os materiais de aprendizagem.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Detalhe e exaustividade dos conteúdos`;
quizQuestions[0][14].answers[1]=`O fator "uau" dos visuais`;
quizQuestions[0][14].answers[2]=`Os fundos dos formandos`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Como é que o ID pode aumentar a velocidade de aprendizagem?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O ID pode aumentar a velocidade de aprendizagem através da utilização de pequenas unidades, uma vez que a divisão do conteúdo em unidades pequenas e manejáveis pode facilitar o processamento e a compreensão da informação por parte dos formandos, o que, por sua vez, pode ajudar a acelerar o processo de aprendizagem.`;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O ID pode aumentar a velocidade de aprendizagem através da utilização de pequenas unidades, uma vez que a divisão do conteúdo em unidades pequenas e manejáveis pode facilitar o processamento e a compreensão da informação por parte dos formandos, o que, por sua vez, pode ajudar a acelerar o processo de aprendizagem.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Utilizar unidades mais curtas`;
quizQuestions[0][15].answers[1]=`Utilizar mais recursos visuais`;
quizQuestions[0][15].answers[2]=`Gerar conteúdos extra`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`O que é essencial para que um formando atinja a proficiência?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A prática é fundamental para qualquer tipo de aprendizagem.`;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A prática é fundamental para qualquer tipo de aprendizagem.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Para se sentir à vontade com o LMS`;
quizQuestions[0][16].answers[1]=`Prática`;
quizQuestions[0][16].answers[2]=`Tomada de notas`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Qual é a melhor prática para apresentar novas informações aos formandos?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Contextualizar novas informações significa fornecer aos formandos os antecedentes e o contexto necessários para compreenderem a informação e verem como esta se relaciona com os seus conhecimentos e experiências existentes.`;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Contextualizar novas informações significa fornecer aos formandos os antecedentes e o contexto necessários para compreenderem a informação e verem como esta se relaciona com os seus conhecimentos e experiências existentes.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Com conteúdos longos e pormenorizados`;
quizQuestions[0][17].answers[1]=`Através da design de visuais impressionantes`;
quizQuestions[0][17].answers[2]=`A informação deve ser contextualizada`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`O que é que a experiência de aprendizagem deve promover?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma experiência de aprendizagem deve promover uma comunidade de aprendentes. Criar um sentido de comunidade entre os formandos pode trazer muitos benefícios tanto para os formandos como para a própria experiência de aprendizagem.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma experiência de aprendizagem deve promover uma comunidade de aprendentes. Criar um sentido de comunidade entre os formandos pode trazer muitos benefícios tanto para os formandos como para a própria experiência de aprendizagem.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Uma comunidade de formandos`;
quizQuestions[0][18].answers[1]=`A rede do ID`;
quizQuestions[0][18].answers[2]=`Trabalho árduo e competitividade`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`O que é que uma comunidade de formandos pode proporcionar à experiência de aprendizagem?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma comunidade de alunos pode proporcionar um ambiente de apoio e colaboração onde os formandos podem partilhar os seus conhecimentos e experiências, fazer perguntas e dar feedback uns aos outros.`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma comunidade de alunos pode proporcionar um ambiente de apoio e colaboração onde os formandos podem partilhar os seus conhecimentos e experiências, fazer perguntas e dar feedback uns aos outros.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Possibilidades de networking`;
quizQuestions[0][19].answers[1]=`Um ambiente de apoio e colaboração`;
quizQuestions[0][19].answers[2]=`Sentido de competição`;
quizQuestions[0][19].key=2;





