// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};


quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`What are Learning Management Systems (LMS) used for?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>LMSs are used for delivering, monitoring, and reporting on eLearning courses. This means that LMSs provide a platform for making eLearning courses available to learners, and for tracking and managing their progress and performance.`;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>LMSs are used for delivering, monitoring, and reporting on eLearning courses. This means that LMSs provide a platform for making eLearning courses available to learners, and for tracking and managing their progress and performance.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Delivering, monitoring, and reporting on eLearning courses`;
quizQuestions[0][0].answers[1]=`Content creation and authoring`;
quizQuestions[0][0].answers[2]=`Student support and counseling`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`What does an LMS provide?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>An LMS provides the foundation and structure of an e-learning course by providing a platform for organizing, delivering, and tracking the learning content and activities.`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>An LMS provides the foundation and structure of an e-learning course by providing a platform for organizing, delivering, and tracking the learning content and activities.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Templates for course presentations`;
quizQuestions[0][1].answers[1]=`The foundation and structure of an e-learning course`;
quizQuestions[0][1].answers[2]=`Tools to design a learning experience`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`What elements should a LMS offer to deliver high-quality and engaging training?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>An LMS can deliver high-quality and engaging training through gamification elements, calendars, and learning paths. These elements can make the learning experience more engaging and fun, and can motivate learners to complete tasks and achieve goals.`;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>An LMS can deliver high-quality and engaging training through gamification elements, calendars, and learning paths. These elements can make the learning experience more engaging and fun, and can motivate learners to complete tasks and achieve goals.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Extensive PDF manuals`;
quizQuestions[0][2].answers[1]=`Detailed videos on how to operate the LMS`;
quizQuestions[0][2].answers[2]=`Gamification elements, calendars, and learning paths`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`What LMS functionality is essential in today's society?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>Compatibility with mobile devices is crucial for the LMS functionality because it allows learners to access and use the LMS on their mobile devices, such as smartphones and tablets. This is important because many learners use mobile devices as their primary or only means of accessing the internet.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>Compatibility with mobile devices is crucial for the LMS functionality because it allows learners to access and use the LMS on their mobile devices, such as smartphones and tablets. This is important because many learners use mobile devices as their primary or only means of accessing the internet.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Compatibility with mobile devices`;
quizQuestions[0][3].answers[1]=`Ability to create content inside the LMS`;
quizQuestions[0][3].answers[2]=`Live-streaming`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`What feature is crucial for monitoring the learning performance?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct. </b><br>A robust reporting feature is a crucial feature for monitoring the learning performance because it provides detailed and comprehensive data on learners' progress and performance.`;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>A robust reporting feature is a crucial feature for monitoring the learning performance because it provides detailed and comprehensive data on learners' progress and performance.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Synchronous messaging system`;
quizQuestions[0][4].answers[1]=`Robust reporting feature`;
quizQuestions[0][4].answers[2]=`Ability to record sessions`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`What is the first step the ID must do during setup?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>During setup The first step for an instructional designer is to make a checklist to ensure that all the needs and requirements defined for the project are implemented. This means creating a list of all the key elements and features that the project should include, and checking off each item as it is implemented.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>During setup The first step for an instructional designer is to make a checklist to ensure that all the needs and requirements defined for the project are implemented. This means creating a list of all the key elements and features that the project should include, and checking off each item as it is implemented.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Content creation`;
quizQuestions[0][5].answers[1]=`Make sure the visuals are finalised and polished`;
quizQuestions[0][5].answers[2]=`Make a checklist to ensure that all the needs and requirements defined for the project are implemented`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`When is a LMS with white-labelling option essential?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>If the course needs to reflect the firm's branding the white-labelling option is essential.
`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>If the course needs to reflect the firm's branding the white-labelling option is essential.
`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`If the course needs to reflect the firm's branding `;
quizQuestions[0][6].answers[1]=`If the ID requires more options`;
quizQuestions[0][6].answers[2]=`If the students wish to customise their environment`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`What is the most recent norm to evaluate an elearning environment?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>The most recent norm to evaluate an elearning environment is Experience API (xAPI).`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>The most recent norm to evaluate an elearning environment is Experience API (xAPI).`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`SCORM`;
quizQuestions[0][7].answers[1]=`Experience API xAPI `;
quizQuestions[0][7].answers[2]=`AICC`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`What is the best practice to engage learners with the elearning experience?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>It is important for students to have the opportunity to create original content because it allows them to demonstrate their knowledge and skills.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>It is important for students to have the opportunity to create original content because it allows them to demonstrate their knowledge and skills.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`To offer large quantity of learning content`;
quizQuestions[0][8].answers[1]=`To create a consistent one-size-fits-all learning experience`;
quizQuestions[0][8].answers[2]=`Students should have the opportunity to create original content`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`What is the best way to present information?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>When presenting content to students, it is important to contextualize the information because contextualizing information means providing background, examples, and real-world applications that help students to understand the significance and relevance of the content.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>When presenting content to students, it is important to contextualize the information because contextualizing information means providing background, examples, and real-world applications that help students to understand the significance and relevance of the content.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Information should be contextualised`;
quizQuestions[0][9].answers[1]=`Directly and we abundant detail`;
quizQuestions[0][9].answers[2]=`In verbal mode`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`What is essential when defining a data migration strategy?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>When defining a data migration strategy, it is essential to define which courses, data, and instructional assets should be transferred to the new system because this information will determine the scope and complexity of the migration process.`;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>When defining a data migration strategy, it is essential to define which courses, data, and instructional assets should be transferred to the new system because this information will determine the scope and complexity of the migration process.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Ensure the process is quick and effective`;
quizQuestions[0][10].answers[1]=`Which courses, data, and instructional assets should be transferred to the new system`;
quizQuestions[0][10].answers[2]=`Not to lose track of security issues`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`What is the final step before completing the LMS deployment process?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>The final step before completing the LMS deployment process is to test the new LMS with a selected set of users because this will allow us to identify and resolve any issues or bugs before the system is used by all users.`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>The final step before completing the LMS deployment process is to test the new LMS with a selected set of users because this will allow us to identify and resolve any issues or bugs before the system is used by all users.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Make sure all the content is uploaded correctly`;
quizQuestions[0][11].answers[1]=`Make sure the visuals are well defined and polished`;
quizQuestions[0][11].answers[2]=`Test the new LMS with a selected set of users`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`What is the first step after completing the LMS deployment process?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>Reviewing how the LMS implementation process went for everyone involved is important because it can help identify any issues or challenges that arose during the implementation process.`;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>Reviewing how the LMS implementation process went for everyone involved is important because it can help identify any issues or challenges that arose during the implementation process.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Review of how the LMS implementation procedure went for everyone involved`;
quizQuestions[0][12].answers[1]=`Make sure all the content is uploaded correctly`;
quizQuestions[0][12].answers[2]=`Testing all the  features of the LMS`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`What is the essential element of quality check?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>Supervising the implementation of instructional designer solutions and performing validation tests are essential elements of a quality check because they help ensure that the instructional materials are being implemented correctly and are effective for achieving the intended learning objectives.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>Supervising the implementation of instructional designer solutions and performing validation tests are essential elements of a quality check because they help ensure that the instructional materials are being implemented correctly and are effective for achieving the intended learning objectives.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Checking the layout and formatting of the materials`;
quizQuestions[0][13].answers[1]=`Supervising the implementation of ID solutions and performing validation tests`;
quizQuestions[0][13].answers[2]=`Checking that all images and visuals are high-resolution`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`What should the ID always consider when designing learning materials?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>The ID should always consider the backgrounds of the students when designing learning materials.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>The ID should always consider the backgrounds of the students when designing learning materials.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Detail and thoroughness of content`;
quizQuestions[0][14].answers[1]=`The wow factor of the visuals`;
quizQuestions[0][14].answers[2]=`The backgrounds of the students`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`How can the ID increase learning speed?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>The ID can increase learning speed by using small units because dividing content into small, manageable units can make it easier for learners to process and understand the information, which can in turn help to accelerate the learning process.`;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>The ID can increase learning speed by using small units because dividing content into small, manageable units can make it easier for learners to process and understand the information, which can in turn help to accelerate the learning process.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Using shorter units`;
quizQuestions[0][15].answers[1]=`Using more visuals`;
quizQuestions[0][15].answers[2]=`Generate extra content`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`What is essential for a student to achieve proficiency?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>Practice is fundamental for any kind of learning.`;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>Practice is fundamental for any kind of learning.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`To be at ease with the LMS`;
quizQuestions[0][16].answers[1]=`Practice`;
quizQuestions[0][16].answers[2]=`Note-taking`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`What is the best practice to present new information to students?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>Contextualizing new information means providing learners with the necessary background and context to understand the information and see how it relates to their existing knowledge and experiences.`;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>Contextualizing new information means providing learners with the necessary background and context to understand the information and see how it relates to their existing knowledge and experiences.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`With long and detailed content`;
quizQuestions[0][17].answers[1]=`Through the design of impressive visuals`;
quizQuestions[0][17].answers[2]=`Information should be contextualised`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`What should the learning experience promote?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>A learning experience should promote a community of learners. Creating a sense of community among learners can have many benefits for both the learners and the learning experience itself.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>A learning experience should promote a community of learners. Creating a sense of community among learners can have many benefits for both the learners and the learning experience itself.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`A community of learners`;
quizQuestions[0][18].answers[1]=`The network of the ID`;
quizQuestions[0][18].answers[2]=`Hard work and competitiveness`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`What can a community of learners provide for the learning experience?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b><br>A community of learners can provide a supportive and collaborative environment where learners can share their knowledge and experiences, ask questions, and provide feedback to each other.`;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b><br>A community of learners can provide a supportive and collaborative environment where learners can share their knowledge and experiences, ask questions, and provide feedback to each other.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Possibilities for network`;
quizQuestions[0][19].answers[1]=`A supportive and collaborative environment`;
quizQuestions[0][19].answers[2]=`A sense of competition`;
quizQuestions[0][19].key=2;

