// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};



quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Quais são as três competências que um Gestor de Projetos deve ter?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A opção 1 e a opção 2 referem-se às competências em matéria de perspetiva e não às competências em matéria de pessoas.`;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A opção 1 e a opção 2 referem-se às competências em matéria de perspetiva e não às competências em matéria de pessoas.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Governação, estruturas e processos`;
quizQuestions[0][0].answers[1]=`Liderança, trabalho de equipa e negociação`;
quizQuestions[0][0].answers[2]=`Conformidade, normas e regulamentos`;
quizQuestions[0][0].key=2;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Qual é a inspiração para a nossa Metodologia de Gestão de Projetos? `;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>PM² (pronuncia-se "P-M ao quadrado") é uma metodologia de gestão de projetos desenvolvida e aprovada pela Comissão Europeia (CE).`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>PM² (pronuncia-se "P-M ao quadrado") é uma metodologia de gestão de projetos desenvolvida e aprovada pela Comissão Europeia (CE).`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Agile`;
quizQuestions[0][1].answers[1]=`Gestão de projetos Lean`;
quizQuestions[0][1].answers[2]=`Metodologia PM²`;
quizQuestions[0][1].key=3;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Quais são as principais fases do ciclo de vida de um projeto?   `;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O ciclo de vida de um projeto tem sempre 4 fases. O ciclo de vida do projeto começa com o pedido de início do projeto e termina quando as atividades da fase de encerramento estão concluídas e o cliente efetua a aceitação final.`;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O ciclo de vida de um projeto tem sempre 4 fases. O ciclo de vida do projeto começa com o pedido de início do projeto e termina quando as atividades da fase de encerramento estão concluídas e o cliente efetua a aceitação final.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Planeamento, execução e encerramento`;
quizQuestions[0][2].answers[1]=`Iniciar, executar, encerrar, monitorizar e controlar`;
quizQuestions[0][2].answers[2]=`Executar, Iniciar, Monitorizar e Controlar`;
quizQuestions[0][2].key=2;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`O Ciclo de Vida do Projeto consiste em que atividades? `;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O foco de um projeto passa das atividades de iniciação e planeamento no início para as atividades de execução, monitorização e controlo no meio e para as atividades de aceitação, transição e encerramento no final.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O foco de um projeto passa das atividades de iniciação e planeamento no início para as atividades de execução, monitorização e controlo no meio e para as atividades de aceitação, transição e encerramento no final.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Criar o Pedido de Iniciação do Projeto, desenvolver o Plano de Trabalho, coordenar o projeto, documentar as lições aprendidas para projetos futuros e executar todos os processos de gestão`;
quizQuestions[0][3].answers[1]=`Produzir os resultados do projeto, iniciar a reunião de revisão final do projeto e gerir a execução do projeto`;
quizQuestions[0][3].answers[2]=`Realizar a reunião de lançamento do planeamento, coordenar o projeto e os recursos`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`O âmbito do projeto tem de ser fechado logo no início do projeto? `;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>É fundamental que o âmbito do projeto seja fechado logo no início do projeto. Desta forma, pode evitar trabalhar em resultados que não estão devidamente definidos ou planeados, porque isso pode resultar na entrega de resultados de má qualidade. Este é um erro comum e dispendioso.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>É fundamental que o âmbito do projeto seja fechado logo no início do projeto. Desta forma, pode evitar trabalhar em resultados que não estão devidamente definidos ou planeados, porque isso pode resultar na entrega de resultados de má qualidade. Este é um erro comum e dispendioso.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Sim, o(s) cliente(s) precisa(m) de saber o que quer o mais rapidamente possível`;
quizQuestions[0][4].answers[1]=`Não, pode esperar até à fase de encerramento do projeto`;
quizQuestions[0][4].answers[2]=`Sim, de modo a evitar derrapagens orçamentais`;
quizQuestions[0][4].key=3;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Qual das afirmações é verdadeira?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma Carta de Projeto tem de apresentar necessidades e características de alto nível, onde o cliente as revê e aprova (ou não) para que o projeto possa passar formalmente para a fase de planeamento.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma Carta de Projeto tem de apresentar necessidades e características de alto nível, onde o cliente as revê e aprova (ou não) para que o projeto possa passar formalmente para a fase de planeamento.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`A Carta do Projeto não precisa de ser re-submetida se o âmbito do projeto tiver sido alterado e/ou atualizado`;
quizQuestions[0][5].answers[1]=`Uma Carta de Projeto deve apresentar requisitos detalhados, ignorando necessidades e características de alto nível`;
quizQuestions[0][5].answers[2]=`Uma Carta de Projeto deve ser breve, evitando apresentar requisitos detalhados e tendo em consideração todos os contributos do cliente`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Como Gestor de Projetos ID, como pode utilizar um Registo de Decisões? `;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Pode utilizar um Registo de Decisões sempre que houver uma decisão tomada no projeto. Inclua qualquer decisão que tenha impacto no projeto, porque é uma forma de comunicar com o cliente e uma forma de este apoiar a decisão.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Pode utilizar um Registo de Decisões sempre que houver uma decisão tomada no projeto. Inclua qualquer decisão que tenha impacto no projeto, porque é uma forma de comunicar com o cliente e uma forma de este apoiar a decisão.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Só pode utilizar um Registo de Decisões se houver reuniões agendadas sobre o projeto`;
quizQuestions[0][6].answers[1]=`Pode usar um Registo de Decisões sempre que houver uma decisão tomada no projeto. Inclua qualquer decisão que tenha impacto no projeto`;
quizQuestions[0][6].answers[2]=`Pode utilizar um Registo de Decisões sempre que houver uma decisão que não precise de ser partilhada com as partes interessadas`;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Quais são algumas das vantagens de uma boa abordagem de Gestão do Tempo?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma boa abordagem de gestão do tempo pode levar a uma maior eficiência e produtividade, menos stress e mais sucesso no desenvolvimento de projetos.`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma boa abordagem de gestão do tempo pode levar a uma maior eficiência e produtividade, menos stress e mais sucesso no desenvolvimento de projetos.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Alívio do stress e, consequentemente, maior capacidade para atingir os objetivos`;
quizQuestions[0][7].answers[1]=`Um mau fluxo de trabalho e, consequentemente, uma má qualidade do trabalho`;
quizQuestions[0][7].answers[2]=`Maior capacidade de atingir os objetivos e consequente perda de controlo`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Enquanto Gestor de Projetos de ID, como pode utilizar o seu tempo de forma mais eficaz?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Um Gestor de Projetos pode aproveitar ao máximo o seu tempo estabelecendo objetivos que sejam alcançáveis, dando prioridade às tarefas com base no tempo e na urgência. Além disso, defina restrições de tempo para completar as tarefas, pois isso ajuda o PM a ser mais focado e eficiente, planeando e fazendo pausas entre as tarefas.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Um Gestor de Projetos pode aproveitar ao máximo o seu tempo estabelecendo objetivos que sejam alcançáveis, dando prioridade às tarefas com base no tempo e na urgência. Além disso, defina restrições de tempo para completar as tarefas, pois isso ajuda o PM a ser mais focado e eficiente, planeando e fazendo pausas entre as tarefas.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Ao definir corretamente os objetivos, um limite de tempo para realizar uma tarefa, estabelecer prioridades, planear com antecedência e fazer uma pausa entre tarefas`;
quizQuestions[0][8].answers[1]=`Por não delegar tarefas e estar ansioso com os prazos`;
quizQuestions[0][8].answers[2]=`Ao completar as tarefas à última da hora`;
quizQuestions[0][8].key=1;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`O que é que considera serem exemplos de ferramentas de gestão do tempo?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A calendarização do projeto e os gráficos de Gantt são duas das ferramentas que pode utilizar na gestão do tempo, identificando as dependências entre as tarefas e dando ao PM uma representação visual do projeto.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A calendarização do projeto e os gráficos de Gantt são duas das ferramentas que pode utilizar na gestão do tempo, identificando as dependências entre as tarefas e dando ao PM uma representação visual do projeto.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Registo de pedidos de informação e de decisões do projeto`;
quizQuestions[0][9].answers[1]=`Projeto - Relatório final e registo de riscos`;
quizQuestions[0][9].answers[2]=`Planeamento de projetos e gráficos de Gantt `;
quizQuestions[0][9].key=3;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Qual é a diferença entre o Planeamento de Projetos e a Programação de Projetos?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O Planeamento do Projeto refere-se à Fase de Planeamento, que envolve a seleção das políticas adequadas, metodologias e procedimentos do projeto.
O Planeamento do Projeto refere-se à Fase de Execução, em que o PM precisa de converter os planos, o âmbito e o custo numa linha de tempo operacional do projeto`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O Planeamento do Projeto refere-se à Fase de Planeamento, que envolve a seleção das políticas adequadas, metodologias e procedimentos do projeto.
O Planeamento do Projeto refere-se à Fase de Execução, em que o PM precisa de converter os planos, o âmbito e o custo numa linha de tempo operacional do projeto`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`O planeamento do projeto envolve a seleção das políticas adequadas, das metodologias e dos procedimentos necessários para entregar o projeto a tempo.
A calendarização do projeto converte os planos, o âmbito e o custo num calendário operacional do projeto`;
quizQuestions[0][10].answers[1]=`O planeamento do projeto converte os planos, o âmbito e o custo num calendário operacional do projeto.
A calendarização do projeto envolve a seleção das políticas adequadas, das metodologias e dos procedimentos necessários para entregar o projeto a tempo`;
quizQuestions[0][10].answers[2]=`O planeamento do projeto converte os planos, o âmbito e o custo numa linha de tempo operacional do projeto.
A calendarização do projeto envolve a seleção dos riscos adequados, das metodologias de projeto e dos procedimentos necessários para entregar o projeto após o tempo estimado`;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Indique algumas das recompensas que pode dar aos membros da sua equipa pelo cumprimento de objetivos e metas:`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As pessoas são motivadas de formas diferentes, por isso há várias maneiras de dar o reconhecimento que os membros da sua equipa merecem. Pode fazê-lo recorrendo a recompensas informais e/ou formais, como sextas-feiras de roupa casual ou outras atividades divertidas (recompensas informais) ou bónus especiais (recompensas formais).`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>As pessoas são motivadas de formas diferentes, por isso há várias maneiras de dar o reconhecimento que os membros da sua equipa merecem. Pode fazê-lo recorrendo a recompensas informais e/ou formais, como sextas-feiras de roupa casual ou outras atividades divertidas (recompensas informais) ou bónus especiais (recompensas formais).`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Não precisam de reconhecimento ou recompensas, estão apenas a fazer o seu trabalho`;
quizQuestions[0][11].answers[1]=`Comprar algo muito especial e pessoal para o membro da sua equipa`;
quizQuestions[0][11].answers[2]=`Sextas-feiras de roupa informal, bónus especiais e outros`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Quais são as técnicas que pode utilizar na Gestão de Custos?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Para atingir os objetivos do projeto, juntamente com as suas estimativas detalhadas de esforço/custo, o seu calendário e a duração do projeto resultante e os requisitos de recursos têm de estar alinhados. `;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Para atingir os objetivos do projeto, juntamente com as suas estimativas detalhadas de esforço/custo, o seu calendário e a duração do projeto resultante e os requisitos de recursos têm de estar alinhados. `;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Estimativa de custos, atas de reuniões e planeamento de recursos`;
quizQuestions[0][12].answers[1]=`Estimativa de custos, orçamentação de custos, controlo de custos e planeamento de recursos`;
quizQuestions[0][12].answers[2]=`Estimativa de custos, orçamentação de custos, diagrama de Gantt`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Durante a Gestão de Custos, quando é que é possível estabelecer orçamentos, normas e um sistema de monitorização?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A orçamentação de custos só é possível quando o orçamento é aprovado pelo cliente, no início do projeto.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A orçamentação de custos só é possível quando o orçamento é aprovado pelo cliente, no início do projeto.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Este processo é possível quando o orçamento é aprovado pelos membros da equipa, no início do projeto`;
quizQuestions[0][13].answers[1]=`Este processo só é possível quando o orçamento é aprovado pelo cliente, no início do projeto`;
quizQuestions[0][13].answers[2]=`Este processo só é possível quando o orçamento é aprovado pelo cliente, no encerramento do projeto`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Quais são os passos da Gestão de Recursos Humanos? `;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A Gestão de Recursos Humanos (GRH) consiste na prática de recrutamento, contratação, colocação e gestão dos colaboradores de uma organização, reportando-a ao coordenador da unidade.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A Gestão de Recursos Humanos (GRH) consiste na prática de recrutamento, contratação, colocação e gestão dos colaboradores de uma organização, reportando-a ao coordenador da unidade.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Recrutamento, recompensa, crítica`;
quizQuestions[0][14].answers[1]=`Recrutamento, Recompensa, Formação e Planeamento`;
quizQuestions[0][14].answers[2]=`Construir a equipa, Recompensa, Formação, Valor, Planeamento e Coaching`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Enquanto gestor de projetos de ID, como pode apoiar a estratégia da empresa para a retenção de colaboradores?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Enquanto gestor de projeto, deve apoiar sempre a sua equipa. Arranje tempo para uma reunião de equipa, bem como para conversas individuais, para que possa saber qual a melhor forma de os ajudar.`;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Enquanto gestor de projeto, deve apoiar sempre a sua equipa. Arranje tempo para uma reunião de equipa, bem como para conversas individuais, para que possa saber qual a melhor forma de os ajudar.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Apoie os membros da sua equipa ao longo de todo o processo! Seja o seu melhor motivador e dê prioridade ao equilíbrio entre a vida profissional e pessoal`;
quizQuestions[0][15].answers[1]=`Não investir na flexibilidade de horários dos membros da sua equipa`;
quizQuestions[0][15].answers[2]=`Dê prioridade às suas próprias necessidades`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`Durante a Gestão da Comunicação, como é que pode melhorar a comunicação intercultural?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Terá diferentes abordagens para chegar a diferentes pessoas. Tenha em consideração as diferenças culturais e individuais quando selecionar o seu estilo de comunicação e também os meios para as alcançar. O PM precisa de manter a etiqueta em todos os momentos, respeitando a cultura e/ou a diferença de comunicação entre eles.`;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Terá diferentes abordagens para chegar a diferentes pessoas. Tenha em consideração as diferenças culturais e individuais quando selecionar o seu estilo de comunicação e também os meios para as alcançar. O PM precisa de manter a etiqueta em todos os momentos, respeitando a cultura e/ou a diferença de comunicação entre eles.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Utilizando calão, falando mais depressa e comportando-se de forma pouco profissional`;
quizQuestions[0][16].answers[1]=`Manter as coisas simples, criar um acordo de comunicação entre a equipa e usar muito sentido de humor inapropriado`;
quizQuestions[0][16].answers[2]=`Mantenha a etiqueta, pratique a escuta ativa e tenha em conta a diferença de gerações`;
quizQuestions[0][16].key=3;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Porque é que é essencial ter uma comunicação escrita, especialmente com o cliente?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Para garantir que todas as decisões são aprovadas no âmbito do Projeto, o PM precisa de ter provas das mesmas. `;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Para garantir que todas as decisões são aprovadas no âmbito do Projeto, o PM precisa de ter provas das mesmas. `;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`A comunicação com o cliente deve ser escrita, para que possa ter provas/registos escritos, em caso de necessidade ou divergências no projeto`;
quizQuestions[0][17].answers[1]=`A comunicação com o cliente não precisa de ser escrita, porque existe um acordo tácito entre o Gestor de Projeto e o Cliente`;
quizQuestions[0][17].answers[2]=`A comunicação com o cliente deve ser escrita, porque o Gestor de Projeto vai enviar-lhe e-mails`;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`Quais são as possíveis estratégias de resposta aos riscos?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Mitigar, Evitar, Reduzir e Transferir um risco, são as estratégias de resposta ao risco. Estas estratégias são referidas no Passo 3 - Desenvolvimento da Resposta ao Risco, na Descrição do Processo de Gestão do Risco.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Mitigar, Evitar, Reduzir e Transferir um risco, são as estratégias de resposta ao risco. Estas estratégias são referidas no Passo 3 - Desenvolvimento da Resposta ao Risco, na Descrição do Processo de Gestão do Risco.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=` Evitar, reduzir e transferir um risco`;
quizQuestions[0][18].answers[1]=`Mitigar, Evitar, Reduzir e Transferir um risco`;
quizQuestions[0][18].answers[2]=`Crie, evite, reduza e transfira um risco`;
quizQuestions[0][18].key=2;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Enquanto Gestor de Projetos de ID, deve considerar os impactos ambientais do projeto?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A poupança de recursos traduz-se numa poupança de dinheiro e, mais importante ainda, na preservação dos recursos para as gerações futuras. O gestor de projetos de ID tem de pensar em termos ecológicos, criando um plano para minimizar os impactos ambientais do projeto.`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A poupança de recursos traduz-se numa poupança de dinheiro e, mais importante ainda, na preservação dos recursos para as gerações futuras. O gestor de projetos de ID tem de pensar em termos ecológicos, criando um plano para minimizar os impactos ambientais do projeto.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Como gestor de projetos de ID, não preciso de me preocupar com isso`;
quizQuestions[0][19].answers[1]=`Como gestor de projetos de ID, só me interessa o lucro`;
quizQuestions[0][19].answers[2]=`Como gestor de projetos de ID, tenho de pensar verdadeiramente verde para a eficácia e eficiência do projeto, promovendo a sustentabilidade para as gerações futuras`;
quizQuestions[0][19].key=3;




