/* 
 *      Functions of interactive content! Here you can fiddle with:
 *	    Clickable items
 *	    Selectable items
 *	    Visited items
 *	    
 *	    Layers
 *		
 *              
 *	    Shortcuts
 *              exit( this )		//Exits course
 *              menu( this )		//Open/close menu
 *              sound( this )		//Toggle audio on/off
 *              home( this )		//Goes to home slide
 *              next( this )		//Goes to next slide
 *              previous( this )		//Goes to previous slide
 *              goTo( this, X )		//Goes to X slide
 *              finish( this )		//Finishes slide
 *              grade( this )		//Grades course and sets complete
 *          
 */

/*Clickable and locked items*/

function contentHover() {
    if ( userMobile === false ) {
        
        $( '.button-hover' ).on( 'click',
	    function(){
                $(this).on('clicked', function() {
                    var format = $( this ).attr( 'src' ).split('.').pop();
                    $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
                });
//		if( !$( this ).hasClass('clicked') ){
//                    $( '.button-hover' ).removeClass('clicked');
//		    $( this ).addClass('clicked');
//                    $(this).on('clicked', function() {
//                        var format = $( this ).attr( 'src' ).split('.').pop();
//                        $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
//                    });
//                    
////                    $( '.button-hover' ).each( function() {
////                        if ( !$( this ).hasClass('clicked') ) {
////                            var format = $( this ).attr( 'src' ).split('.').pop();
////                            $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
////                        } else {
////                            
////                            var format = $( this ).attr( 'src' ).split('.').pop();
////                            $( this ).attr( 'src', $( this ).data( 'src' ) + 'hover.' + format );
////                        }
////                    });
//		} else {
//                    $( this ).removeClass('clicked');
//                    $( '.button-hover' ).each( function() {
//                        if ( !$( this ).hasClass('clicked') ) {
//                            var format = $( this ).attr( 'src' ).split('.').pop();
//                            $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
//                        }
//                    });
//                }
	    }
	);
	$( '.button-hover' ).hover( //Hover img elements can have a Hover state
	    function(){
		if( !$( this ).hasClass('button-locked') && !$( this ).hasClass('active') ){
		    var format = $( this ).attr( 'src' ).split('.').pop();
		    $( this ).attr( 'src', $( this ).data( 'src' ) + 'hover.' + format );
		}
	    }, function(){
		if( !$( this ).hasClass('clicked') && !$( this ).hasClass('active') ){
		    var format = $( this ).attr( 'src' ).split('.').pop();
		    $( this ).attr( 'src', $( this ).data( 'src' ) + 'normal.' + format );
		}
	    }
	);
    }
}

function contentSelect() {
    $( '.button-select' ).click( //Selected elements can be selected
	function(){
	    if( $( this ).hasClass('button-select') ){
		if( $( this ).hasClass('selected') ){
		    $( this ).removeClass('selected');
		} else {
		    $( this ).addClass('selected');
		}
	    }
	}	
    );
}

/* Common functions */
function parseIfInteger( data ) {
    if ( isNaN( data ) ) {
	return data;
    } else {
	var dataParsed = parseInt( data );
	return dataParsed;
    }
}

function convertMS( milliseconds ) {    
    var day, hour, minute, seconds;
    seconds = Math.floor(milliseconds / 1000);
    minute = Math.floor(seconds / 60);
    seconds = seconds % 60;
    hour = Math.floor(minute / 60);
    minute = minute % 60;
    day = Math.floor(hour / 24);
    hour = hour % 24;
    
    return {
        day: day,
        hour: hour,
        minute: minute,
        seconds: seconds
    };
}

function convertMSseconds( milliseconds ) {
    var clock = convertMS( milliseconds );
    
    return clock.seconds;
}

function convertMSminute( milliseconds ) {
    var clock = convertMS( milliseconds );
    
    var seconds = clock.seconds;
    if ( seconds <= 9 ) {
        seconds = '0' + seconds;
    }
    var minute = clock.minute;
    if ( minute <= 9 && minute > 0 ) {
        minute = '0' + minute;
    } else if ( minute === 0 ) {
        minute = '00';
    }
    
    var time = ( minute + ':' + seconds );
    
    return time;
}
function convertMShour( milliseconds ) {
    var clock = convertMS( milliseconds );
    
//    var seconds = clock.seconds;
//    var minute = clock.minute;
    var hour = clock.hour;
    
    var seconds = clock.seconds;
    if ( seconds <= 9 ) {
        seconds = '0' + seconds;
    }
    var minute = clock.minute;
    if ( minute <= 9 && minute > 0 ) {
        minute = '0' + minute;
    } else if ( minute === 0 ) {
        minute = '00';
    }
    var time = ( hour + ':' + minute + ':' + seconds );
    
    return time;
}

function convertMSday( milliseconds ) {
    var clock = convertMS( milliseconds );
    
    var seconds = clock.seconds;
    var minute = clock.minute;
    var hour = clock.hour;
    var day = clock.day;
    
    var time = ( day + ':' + hour + ':' + minute + ':' + seconds );
    
    return time;
}

function convertMSToSeconds( milliseconds ) {
    var time = milliseconds / 1000;
    
    return time;
}

function shuffle( array ) {
    var currentIndex = array.length, temporaryValue, randomIndex;

    // While there remain elements to shuffle...
    while ( 0 !== currentIndex ) {

	// Pick a remaining element...
	randomIndex = Math.floor(Math.random() * currentIndex);
	currentIndex -= 1;

	// And swap it with the current element.
	temporaryValue = array[currentIndex];
	array[currentIndex] = array[randomIndex];
	array[randomIndex] = temporaryValue;
    }

    return array;
}

function mobileAddMobileClass( element ) {
    if ( userMobile ) {
	$( element ).addClass( 'mobile' );
    }
}

function stringIncludes( string, needle ) {
    var size = string.length;
    var includes = false;
    
    for ( i = 0; i < size; i ++ ) {
	if ( string === needle) {
	    includes = true;
	}
    }
    
    return includes;
}

/* Layers */

function layerVisibility( target ){
    if ( $( '#layer-' + target ).css( 'display' ) === 'block' || $( '#layer-' + target ).css( 'display' ) === 'flex'  ) {
	return true;
    } else {
	return false;
    }
}

function layerCurrent() {
    var visibleLayer;
    
    var size = $( '.layer' ).length;
    for ( i = 0; i < size; i++) {
	if ( layerVisibility( i ) ) {
	    visibleLayer = i;
	} 
    }
    
    return visibleLayer;
}
function layerTotal() {
    return $( '.layer' ).length;
}

function layerLast() {
    var lastLayer = $( '.layer' ).length - 1;
    if ( layerCurrent() === lastLayer ) {
	return true;
    } else {
	return false;
    }
}

function layerAfterFirst() {
    if ( layerCurrent() === 1 ) {
	return true;
    } else {
	return false;
    }
}
function layerBeforeLast() {
    var beforeLastLayer = $( '.layer' ).length - 2;
    if ( layerCurrent() === beforeLastLayer ) {
	return true;
    } else {
	return false;
    }
}

function layerInTheMiddle() {
    if ( layerLast() === false && layerFirst() === false ) {
	return true;
    } else {
	return false;
    }
}

function layerFirst() {
    if ( layerCurrent() === 0 ) {
	return true;
    } else {
	return false;
    }
}

function layerUp() {
    var current = layerCurrent();
    var next = current + 1;
    if ( $( '#layer-' + next  ).length > 0 ) {
	layerGoTo( next );
    } else {
	zork( 'You reached the last layer!' );
    }
}

function layerDown() {
    var current = layerCurrent();
    var previous = current + -1;
    if ( $( '#layer-' + previous  ).length > 0 ) {
	layerGoTo( previous );
    } else {
	zork('You reached the first layer!' );
    }
}

function layerGoTo( target ) {
    if ( typeof target === 'number' ) {
	if ( layerCurrent() !== target ) {
//	    $( '.layer:not(.layer-sticky)' ).fadeOut( 500 );
//	    $( '#layer-' + target ).fadeIn( 500 );
	    $( '.layer:not(.layer-sticky)' ).hide();
	    $( '#layer-' + target ).show();
	    zork( 'Going to layer ' + target + '.' );
	} else if ( layerCurrent() === target ) {
	    zork( 'You are already there!' );
	}
    } else if ( typeof target === 'string' ) {
	zork('Hiding all layers except sticky ones!');
//	$( '.layer:not(.layer-sticky)' ).fadeOut( 500 );
	$( '.layer:not(.layer-sticky)' ).hide();
	
	zork('Showing intended layer...');
	if ( target === 'first' ) {
//	    $( '.layer-first' ).fadeIn( 500 );
	    $( '.layer-first' ).show();
	} else if ( target === 'last' ) {
//	    $( '.layer-last' ).fadeIn( 500 );
	    $( '.layer-last' ).show();
	} else {
//	    $( '#layer-' + target ).fadeIn( 500 );
	    $( '#layer-' + target ).show();
	}	
    }
}

function layerClose( target ) {
//    $( '#layer-' + target ).fadeOut( 500 );
    $( '#layer-' + target ).hide();
}

function popItUp( id, url, windowName ) {
       courseStatus.pop[id] = 1;
       newwindow=window.open( url, windowName,'height=640,width=480');
       if (window.focus) {newwindow.focus()}
       return false;
     }

/* Shortcuts */

//Player
function exit( caller ) {   //Exits course, use exit(this)
    if( !$( caller ).hasClass('button-locked') ){
	playerControlsExit();
	return false;
    }
}
function reload( caller ) {   //Exits course, use exit(this)
    if( !$( caller ).hasClass('button-locked') ){
	courseReload();
	return false;
    }
}

function menu( caller ) { //Toggles menu
    if( !$( caller ).hasClass('button-locked') ){
	playerControlsToggleMenu();
	return false;
    }
}

function sound( caller ) { //Toggles audio
    if( !$( caller ).hasClass('button-locked') ){
	playerControlsToggleAudio();
	return false;
    }
}
function music( caller ) { //Toggles audio
    if( !$( caller ).hasClass('button-locked') ){
	playerControlsToggleMusic();
	return false;
    }
}

function home( caller ) { //Goes home
    if( !$( caller ).hasClass('button-locked') ){
	playerControlsHome();
	return false;
    }
}

function next( caller ) { //Goes to next slide
    if( !$( caller ).hasClass('button-locked') ){
	slideNext();
	return false;
    }
}

function previous( caller ) { //Goes to previous slide
    if( !$( caller ).hasClass('button-locked') ){
	slidePrevious();
	return false;
    }
}

function goTo( target, caller ) { //Goes to slide
    if( !$( caller ).hasClass('button-locked') ){
	slideGoTo( target );
	return false;
    }
}

function finish( caller ) { //Finishes slide
    if( !$( caller ).hasClass('button-locked') ){
	slideComplete();
	return false;
    }
}

//Layers
function up( caller ) {
    if( !$( caller ).hasClass('button-locked') ){
	layerUp();
	return false;
    }
}
function down( caller ) {
    if( !$( caller ).hasClass('button-locked') ){
	layerDown();
	return false;
    }
}
function layer( target, caller ) {
    if( !$( caller ).hasClass('button-locked') ){
	layerGoTo( target );
	return false;
    }
}

function randomNumber( number ) {
    return Math.ceil(Math.random() * number);
}

// Stuff
var kkeys = [], konami = "38,38,40,40,37,39,37,39,66,65";
$(document).keydown(function(e) {
	kkeys.push( e.keyCode );
	if ( kkeys.toString().indexOf( konami ) >= 0 ) {
		kkeys.length = 0;
		$('.slide-current').append('<img src="" id="poof" style="position: absolute;z-index: 20000;width: 15%; top: 60%; left: 16%; opacity: 0.75;">');
		$('#poof').attr('src', '');
		setTimeout( function() {
		    $('#poof').attr('src','images/character/happy/poof.gif');
		}, 100);
		playerSFXPlay( 'damage-poof' );
		setTimeout( function() {
		    $('#poof').remove();
		}, 1500);
	}
});