// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`What is prototyping?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>Prototyping is the process of creating mock-up samples of your product that will be tested and used by learners who will give feedback that will then be implemented for future products.`;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>Prototyping is the process of creating mock-up samples of your product that will be tested and used by learners who will give feedback that will then be implemented for future products.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Prototyping is the process of launching a new product in a new market`;
quizQuestions[0][0].answers[1]=`Prototyping is the process of testing a product in a new or previously untested market`;
quizQuestions[0][0].answers[2]=`Prototyping is the process of creating mock-up samples in order to refine a product`;
quizQuestions[0][0].key=3;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`What is User Experience?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>Option 1 refers to User Interface and option 3 refers to principle 2 of the User Experience Honeycomb framework.`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>Option 1 refers to User Interface and option 3 refers to principle 2 of the User Experience Honeycomb framework.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`User experience refers to the presentation of a product or system`;
quizQuestions[0][1].answers[1]=`User experience refers to the way that users interact and experience a product, system or service`;
quizQuestions[0][1].answers[2]=`User experience is about how easy it is for customers to use a product`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`What is User Interface?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>User interface is also known as UI and refers to the presentation of a product or system. `;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>User interface is also known as UI and refers to the presentation of a product or system. `;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`It refers to the presentation of a product or system
`;
quizQuestions[0][2].answers[1]=`It refers to the way a product or system is perceived by its users`;
quizQuestions[0][2].answers[2]=`It refers to the way that users interact with and experience a product, system or service`;
quizQuestions[0][2].key=1;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`What is the goal of User Interface design?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>The goal of User Interface design is to produce a User Interface that makes it easy, efficient, and enjoyable to use.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>The goal of User Interface design is to produce a User Interface that makes it easy, efficient, and enjoyable to use.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`The goal of User Interface design is to communicate the product or system's benefits to potential users`;
quizQuestions[0][3].answers[1]=`The goal of User Interface design is to create a mock up of a product sample`;
quizQuestions[0][3].answers[2]=`The goal of User Interface design is to produce a User Interface that is easy, efficient, and enjoyable to use`;
quizQuestions[0][3].key=3;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`How many principles are in the User Experience Honeycomb Framework?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct. </b><br>The 7 steps in the User Experience Honeycomb framework are Usable, Useful, Desirable, Findable, Accessible, Credible, and Valuable.`;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>The 7 steps in the User Experience Honeycomb framework are Usable, Useful, Desirable, Findable, Accessible, Credible, and Valuable.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`6`;
quizQuestions[0][4].answers[1]=`7`;
quizQuestions[0][4].answers[2]=`5`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`The first step of the User Experience Honeycomb Experience- 'Usable' means: `;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>Option 1 is Principle 3: Desirable- from the User Experience Honeycomb framework. Option 2 is Principle 6: Credible.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>Option 1 is Principle 3: Desirable- from the User Experience Honeycomb framework. Option 2 is Principle 6: Credible.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`The aesthetics of the system should be attractive and easy to translate`;
quizQuestions[0][5].answers[1]=`It should be transparent and secure to use
`;
quizQuestions[0][5].answers[2]=`It should feel familiar and it should be easy to use`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`The 'Accessible' principle of the User Experience Honeycomb Experience means:`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>Option 1 is Principle 6: Credible. Option 3 is Principle 4: Findable.
`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>Option 1 is Principle 6: Credible. Option 3 is Principle 4: Findable.
`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`It should feel familiar and it should be easy to use`;
quizQuestions[0][6].answers[1]=`An application should be accessible to those with disabilities`;
quizQuestions[0][6].answers[2]=`Information needs to be findable and simple to navigate`;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`If all the 7 principles of the User experience Honeycomb framework the end user will:`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>The User Experience Honeycomb framework was created to guide user interface design. The 7 principles must be kept in mind when designing an effective user interface and is fundamental to ensuring effective learning experience for learners.`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>The User Experience Honeycomb framework was created to guide user interface design. The 7 principles must be kept in mind when designing an effective user interface and is fundamental to ensuring effective learning experience for learners.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Find value and trust in the application`;
quizQuestions[0][7].answers[1]=`Have a sample product to sell`;
quizQuestions[0][7].answers[2]=`Have a product that is inexpensive to use`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`How many steps are there in the User Experience Design process?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>The 5 steps of the User Experience Design Process are: Empathise, Define, Ideate, Prototype, and Test.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>The 5 steps of the User Experience Design Process are: Empathise, Define, Ideate, Prototype, and Test.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`8`;
quizQuestions[0][8].answers[1]=`7`;
quizQuestions[0][8].answers[2]=`5`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`What does the 'Empathise' stage in the User Experience design process involve? `;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>Empathise is the first stage of the User Experience design process where you have to undertake and realise the challenges the users of your product face. This means putting yourself into the shoes of the users to understand how they feel when using the product.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>Empathise is the first stage of the User Experience design process where you have to undertake and realise the challenges the users of your product face. This means putting yourself into the shoes of the users to understand how they feel when using the product.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Coming up with multiple ideas on how to solve a specific problem that learners have a tendency to encounter frequently`;
quizQuestions[0][9].answers[1]=`Getting feedback from learners to make a better product that will fully meet their needs and expectations`;
quizQuestions[0][9].answers[2]=`Understanding the challenge of the users of your product and putting yourself in the shoes of the users to understand how they feel when using the product`;
quizQuestions[0][9].key=3;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`What does the Define step involve? 
`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>The second step in the User Experience Design process is 'Define'. This involves sorting the issues identified in the first step by their levels of importance and carrying out research to understand why these challenges are important.`;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>The second step in the User Experience Design process is 'Define'. This involves sorting the issues identified in the first step by their levels of importance and carrying out research to understand why these challenges are important.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`This step involves sorting the issues identified in the Empathise stage by their levels of importance and carrying out research to understand why these challenges faced are important`;
quizQuestions[0][10].answers[1]=`It involves defining the elements of the product that need to be re-designed to better meet the needs of users based on their previous feedback`;
quizQuestions[0][10].answers[2]=`The define step is about selecting the best idea to solve a common problem learners frequently have`;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`How often should you do user research and testing on a product?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>User research and testing is a fundamental part of the UX designer’s job and a core part of the overall UX design process. To ensure that a product remains efficient and effective, User research and testing should be done as regularly as possible.`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>User research and testing is a fundamental part of the UX designer’s job and a core part of the overall UX design process. To ensure that a product remains efficient and effective, User research and testing should be done as regularly as possible.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Five times `;
quizQuestions[0][11].answers[1]=`As often as possible`;
quizQuestions[0][11].answers[2]=`Once `;
quizQuestions[0][11].key=2;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`What does the step ‘Ideate’ involve?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>To ensure that the product remains efficient and effective, ensure to repeat this process as regularly as possible.`;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>To ensure that the product remains efficient and effective, ensure to repeat this process as regularly as possible.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Sorting the issues identified into levels of importance `;
quizQuestions[0][12].answers[1]=`This involves the generation of as many ideas as possible`;
quizQuestions[0][12].answers[2]=`Putting yourself in the shoes of the user`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Why do UX designers test their product? `;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>Testing is a fundamental part of the UX designer’s job and a core part of the overall UX design process. UX designers test because it allows them to improve upon the original product or site design and to see if the changes they made during the ‘design’ phase stand up to scrutiny.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>Testing is a fundamental part of the UX designer’s job and a core part of the overall UX design process. UX designers test because it allows them to improve upon the original product or site design and to see if the changes they made during the ‘design’ phase stand up to scrutiny.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`This step means that designers can better identify future products that they can design to complement the one being tested`;
quizQuestions[0][13].answers[1]=`This ensures that they can see what changes need to be made to their product`;
quizQuestions[0][13].answers[2]=`This allows them to see if the changes they have made on a product work and function properly`;
quizQuestions[0][13].key=3;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Why is interactivity so important?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>Interactivity is one way that you can make it easier for learners to engage very well with your course. When building the interactive elements for your course, including a variety of different levels will keep the content fresh and interesting for learners.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>Interactivity is one way that you can make it easier for learners to engage very well with your course. When building the interactive elements for your course, including a variety of different levels will keep the content fresh and interesting for learners.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`It allows developers to put themselves in the shoes of the user`;
quizQuestions[0][14].answers[1]=`It makes it easier for learners to engage with your content`;
quizQuestions[0][14].answers[2]=`It allows you to make changes to a prototype`;
quizQuestions[0][14].key=2;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`What level is game based learning?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>Game-based learning is level 4 of interactivity. `;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>Game-based learning is level 4 of interactivity. `;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`4`;
quizQuestions[0][15].answers[1]=`3`;
quizQuestions[0][15].answers[2]=`7`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`The following are video, audio and image-editing software`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>Adobe Premiere, Final Cut Pro, Adobe Photoshop and GIMP are all video and image editing tools. `;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>Adobe Premiere, Final Cut Pro, Adobe Photoshop and GIMP are all video and image editing tools. `;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Zoom, Skype and Instagram`;
quizQuestions[0][16].answers[1]=`Adobe Premiere, Final Cut Pro,
Adobe Photoshop and GIMP editing
`;
quizQuestions[0][16].answers[2]=`Twitter, Microsoft Office, Microsoft Excel`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`There are many steps involved in planning any media that you create. The first step is 
`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>Storyboarding is a useful thing to do in the planning stage of media production. It helps creators plan and visualise a video frame by frame.`;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>Storyboarding is a useful thing to do in the planning stage of media production. It helps creators plan and visualise a video frame by frame.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Storyboarding`;
quizQuestions[0][17].answers[1]=`Editing`;
quizQuestions[0][17].answers[2]=`Writing a script`;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`What is Scenario Based Learning?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>Scenario Based Learning allows learners to engage in active learning by presenting learners with problems that need to be solved.  It facilitates learners to hone their decision-making skills.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>Scenario Based Learning allows learners to engage in active learning by presenting learners with problems that need to be solved.  It facilitates learners to hone their decision-making skills.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Scenario Based Learning is when the learner is given information from an instructor, and they take in information in a passive way`;
quizQuestions[0][18].answers[1]=`Scenario Based Learning is when roles are reversed and the instructor is taught by the learner`;
quizQuestions[0][18].answers[2]=`Scenario Based Learning  involves learners engaging in active learning by presenting learners with scenarios and problems that need to be solved`;
quizQuestions[0][18].key=3;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`The first step in designing a scenario for SBL should be:
`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b><br>Option 1 is actually the third step that should be taken when building a scenario. Option 2 is the fifth step.`;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b><br>Option 1 is actually the third step that should be taken when building a scenario. Option 2 is the fifth step.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Choosing a situation for your scenario`;
quizQuestions[0][19].answers[1]=`Designing your scenario`;
quizQuestions[0][19].answers[2]=`Identifying your target audience and understanding their needs`;
quizQuestions[0][19].key=3;

