// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minuuttiaToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minuuttiaToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a monivalintakysymykset?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "Lähetä", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Aloita",
    button_prev: "Edellinen",
    button_next: "Seuraava",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Lähetä",
    button_review: "Arvostelu",
    button_try_again: "Yritä uudelleen",
    button_finish: "Lähetä arvosana",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Tervetuloa arviointitoimintaan!</b></h2>
        <p>Tämä arviointitoiminta koostuu seuraavista osista<b><span class="quiz-total"></span> monivalintakysymykset</b> johon sinun on vastattava valitsemalla oikea vaihtoehto. Arviointitehtävän suorittaminen hyväksytysti edellyttää, että saat vähintään seuraavan arvosanan<b>${minimumGrade}%</b>.</p>
        <p>Sinulla on <b><span class="quiz-attempts"></span> yritystä</b> suorittamaan tämä tehtävä. Sinulla on<b>${minuuttiaToComplete} minuuttia</b> jokaisessa yrityksessä suorittaa tietokilpailu. Sinun on klikattava "Lähetä arvosana" -painiketta tallentaaksesi sijoituksesi koulutusalustalle.</p>
        <p style="text-align: right"><b>Onnea matkaan!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</h2>
            <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
            <p>Yritä uudelleen.</p>
            <br><br>
            <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">ONNITTELUT!</h2>
            <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
            <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
            <p>Klikkaamalla "Lähetä arvosana" -painiketta aktiviteetti estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, klikkaa "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan).</p>
            <br><br>
            <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Yritä uudelleen.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Sinulta on loppunut yritykset tehdä tämä arviointitehtävä.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Klikkaamalla "Lähetä arvosana" -painiketta aktiviteetti estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, klikkaa "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan).</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Arvosanasi tallennettiin alustalle ja kohde merkittiin suoritetuksi.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>

        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>

        <p>Paras arvosanasi tähän mennessä oli <span class="quiz-best-grade"></span>%. Klikkaamalla "Lähetä arvosana" -painiketta toiminta estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, käytä "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan). Palaa alustalle napsauttamalla X-painiketta.</p>

        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Paras arvosanasi tähän mennessä oli <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Lähetä arvosana" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Yritä uudelleen" button (your best rating will be recorded).</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Arvosanasi kirjattiin alustalle ja tehtävä merkittiin suoritetuksi.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Mikä eurooppalainen tietoturvaa koskeva asetus ohjaa oppimiskokemusta?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Kyllä! Vastasit oikein.</b><br>Periaatteiden tulisi ohjata oppimiskokemusta EU:n yleisen tietosuoja-asetuksen (GDPR) mukaisesti.`;
quizQuestions[0][0].feedback_wrong=`<b>Vastasit väärin.</b><br>Periaatteiden tulisi ohjata oppimiskokemusta EU:n yleisen tietosuoja-asetuksen (GDPR) mukaisesti.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Yleinen tietosuoja-asetus (GDPR)`;
quizQuestions[0][0].answers[1]=`Erityinen tietosuojasäädös (SDPR)`;
quizQuestions[0][0].answers[2]=`Euroopplainen tietoturva-asetus (EDP)`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Nimeä kolme tietoturvan parasta käytäntöä`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Kyllä! Vastasit oikein.</b><br>On tärkeää käyttää palomuuria sekä sisäisten että ulkoisten verkkojen välillä, laatia hyvin määrittellyn datapolitiikan ja vaatia varmuuskopiointia useista syistä. Nämä toimenpiteet voivat auttaa suojaamaan arkaluontoisia tietoja ja järjestelmiä luvattomalta pääsyltä, manipuloinnilta tai muilta turvallisuusuhkilta.`;
quizQuestions[0][1].feedback_wrong=`<b>Vastasit väärin.</b><br>On tärkeää käyttää palomuuria sekä sisäisten että ulkoisten verkkojen välillä, laatia hyvin määrittellyn datapolitiikan ja vaatia varmuuskopiointia useista syistä. Nämä toimenpiteet voivat auttaa suojaamaan arkaluontoisia tietoja ja järjestelmiä luvattomalta pääsyltä, manipuloinnilta tai muilta turvallisuusuhkilta.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Käytä yksilöllisiä salasanoja;
 käytä salausta kaikille arkaluonteisille tiedoille;
 varmuuskopioi tiedot säännöllisesti`;
quizQuestions[0][1].answers[1]=`Käytä palomuuria sekä sisäisten että ulkoisten verkkojen välillä;
 Laadi hyvin määritelty datapolitiikka;
 Vaadi tietojen varmuuskopiointia`;
quizQuestions[0][1].answers[2]=`Hallinnoi käyttöoikeuksia rajoittaaksesi pääsyä;
 tarkkaile ja tarkista säännöllisesti verkkoja ja järjestelmiä;
 varmista, että kaikki ohjelmistot ja järjestelmät pidetään ajan tasalla`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Mikä on käsikirjoituksen päätavoite oppimiskokemuksessa?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Käsikirjoituksen päätavoitteena on suunnitella visuaalisesti videon kerronta, mukaan lukien jaksot, kunkin koostumukset ja mahdollisesti sisältyvä ääni.`;
quizQuestions[0][2].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Käsikirjoituksen päätavoitteena on suunnitella visuaalisesti videon kerronta, mukaan lukien jaksot, kunkin koostumukset ja mahdollisesti sisältyvä ääni.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Kuvakäsikirjoitus toimii itsenäisenä sisältökappaleena`;
quizQuestions[0][2].answers[1]=`Toimimaan oppimiskokemuksen lopullisena, hiottuna versiona`;
quizQuestions[0][2].answers[2]=`Luoda tarina tai konteksti, joka sitouttaa oppijat pedagogisen lähestymistavan mukaisesti`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Mikä on käsikirjoitus?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Käsikirjoitus on asiakirja, joka määrittelee verkkokurssin sisällön, jakaen sen yksittäisiin dioihin tai näyttöihin. Tämä mahdollistaa kurssin luojien suunnitella materiaalinsa järjestelmällisesti ja organisoidusti sekä tehdä muutoksia ja tarkistuksia ennen tuotannon alkua. Käsikirjoitus voi myös auttaa heitä kommunikoimaan visionaan muulle tiimille, mukaan lukien ohjaajat ja suunnittelijat.`;
quizQuestions[0][3].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Käsikirjoitus on asiakirja, joka määrittelee verkkokurssin sisällön, jakaen sen yksittäisiin dioihin tai näyttöihin. Tämä mahdollistaa kurssin luojien suunnitella materiaalinsa järjestelmällisesti ja organisoidusti sekä tehdä muutoksia ja tarkistuksia ennen tuotannon alkua. Käsikirjoitus voi myös auttaa heitä kommunikoimaan visionaan muulle tiimille, mukaan lukien ohjaajat ja suunnittelijat.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Kuvakäsikirjoitus on asiakirja, joka jäsentelee verkkokurssin materiaalin dia diaalta tai näyttö näytöltä`;
quizQuestions[0][3].answers[1]=`Kuvakäsikirjoitus on aineiston kurssin valmis, hiottu versio`;
quizQuestions[0][3].answers[2]=`Kuvakäsikirjoitus on työkalu tiedon tai tiedon järjestämiseen`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Mikä on käsikirjoituksen päätavoite yleisesti?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Käsikirjoitus hahmottaa lopputuloksen rakenteen ja esityksen, antaen sidosryhmille esikatselun siitä, miltä kurssi tulee näyttämään. Tämä mahdollistaa näiden henkilöiden nähdä, kuinka lopputulos tullaan järjestämään ja toimittamaan, sekä tarjota palautetta ja ehdotuksia ennen tuotannon alkamista.`;
quizQuestions[0][4].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Käsikirjoitus hahmottaa lopputuloksen rakenteen ja esityksen, antaen sidosryhmille esikatselun siitä, miltä kurssi tulee näyttämään. Tämä mahdollistaa näiden henkilöiden nähdä, kuinka lopputulos tullaan järjestämään ja toimittamaan, sekä tarjota palautetta ja ehdotuksia ennen tuotannon alkamista.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`"Kuvakäsikirjoituksen tavoitteena on pitää kurssin rakenne ja esitys piilossa sidosryhmiltä ja alueen asiantuntijoilta"`;
quizQuestions[0][4].answers[1]=`Kuvakäsikirjoituksen tavoitteena on tarjota sidosryhmille ja alalla oleville asiantuntijoille kurkistus kurssin rakenteeseen ja esitystapaan`;
quizQuestions[0][4].answers[2]=`Kuvakäsikirjoituksen päämääränä on tarjota lopullinen esitys kurssin sisällöstä`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Mitä erityyppisiä käsikirjoituksia on olemassa?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>On kaksi pääluokkaa käsikirjoituksia: kirjalliset verkko-oppimisen käsikirjoitukset ja kuvalliset verkko-oppimisen käsikirjoitukset.`;
quizQuestions[0][5].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>On kaksi pääluokkaa käsikirjoituksia: kirjalliset verkko-oppimisen käsikirjoitukset ja kuvalliset verkko-oppimisen käsikirjoitukset.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Interaktiiviset, animoidut ja verbiset kuvakäsikirjoitukset`;
quizQuestions[0][5].answers[1]=`Perinteiset ja modernit kuvakäsikirjoitukset`;
quizQuestions[0][5].answers[2]=`Kirjalliset verkko-oppimisen kuvakäsikirjoitukset ja graafiset verkko-oppimisen kuvakäsikirjoitukset`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Mikä on kirjallinen käsikirjoitus?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Kirjallinen verkko-oppimisen käsikirjoitus on asiakirja, joka määrittelee verkkokurssin sisällön, jakaen sen yksittäisiin dioihin tai näyttöihin. Tämä mahdollistaa kurssin luojien suunnitella materiaalinsa järjestelmällisesti ja organisoidusti sekä tehdä muutoksia ja tarkistuksia ennen tuotannon alkua.`;
quizQuestions[0][6].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Kirjallinen verkko-oppimisen käsikirjoitus on asiakirja, joka määrittelee verkkokurssin sisällön, jakaen sen yksittäisiin dioihin tai näyttöihin. Tämä mahdollistaa kurssin luojien suunnitella materiaalinsa järjestelmällisesti ja organisoidusti sekä tehdä muutoksia ja tarkistuksia ennen tuotannon alkua.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Kirjallinen verkko-oppimisen kuvakäsikirjoitus on asiakirja, joka luettelee kurssimateriaalin dia diaalta tai näyttö näytöltä`;
quizQuestions[0][6].answers[1]=`Käsikirjoitus on sisällön valmis versio`;
quizQuestions[0][6].answers[2]=`Kirjallinen kuvakäsikirjoitus on työkalu tiedon järjestämiseen ja suunnitteluun`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Mikä on kirjallisen käsikirjoituksen käytön pääetu?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Kirjallisen käsikirjoituksen käyttämisen pääetu on, että se mahdollistaa materiaalin suunnittelun järjestelmällisesti ja organisoidusti. Kirjallinen käsikirjoitus voi sisältää yksityiskohtaisen hahmotelman, joka jakaa sen yksittäisiin dioihin tai näyttöihin.`;
quizQuestions[0][7].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Kirjallisen käsikirjoituksen käyttämisen pääetu on, että se mahdollistaa materiaalin suunnittelun järjestelmällisesti ja organisoidusti. Kirjallinen käsikirjoitus voi sisältää yksityiskohtaisen hahmotelman, joka jakaa sen yksittäisiin dioihin tai näyttöihin.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Kirjalliset kuvakäsikirjoitukset ovat nopeita luoda`;
quizQuestions[0][7].answers[1]=`Käsikirjoitukset auttavat oppimismuotoilijaa keskittymään kurssimateriaaliin eikä kurssin audiovisuaaliseen estetiikkaan`;
quizQuestions[0][7].answers[2]=`Kirjalliset kuvakäsikirjoitukset antavat mahdollisuuden saada täydellisen näkökulman materiaaleihin`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Mikä on kuvakäsikirjoitus?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Visuaalinen verkko-oppimisen käsikirjoitus on käsikirjoitustyyppi, joka keskittyy sekä suunnitteluun että sisällön sisältöön. Tämän tyyppinen käsikirjoitus yhdistää kirjallisen käsikirjoituksen elementtejä, jotka hahmottavat kurssimateriaalin ja rakenteen, visuaaliseen prototyyppiin, joka näyttää, miltä sisältö näyttää ja tuntuu.`;
quizQuestions[0][8].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Visuaalinen verkko-oppimisen käsikirjoitus on käsikirjoitustyyppi, joka keskittyy sekä suunnitteluun että sisällön sisältöön. Tämän tyyppinen käsikirjoitus yhdistää kirjallisen käsikirjoituksen elementtejä, jotka hahmottavat kurssimateriaalin ja rakenteen, visuaaliseen prototyyppiin, joka näyttää, miltä sisältö näyttää ja tuntuu.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Työkalu esityksen visuaalisen estetiikan arvon lisäämiseen`;
quizQuestions[0][8].answers[1]=`Työkalu animaatioiden tai erikoistehosteiden luomiseen`;
quizQuestions[0][8].answers[2]=`Visuaalinen verkko-oppimisen kuvakäsikirjoitus keskittyy sekä kurssin suunnitteluun että sen sisältöön. Visuaalinen verkko-oppimisen kuvakäsikirjoitus yhdistää kirjallisen kuvakäsikirjoituksen ja visuaalisen prototyypin`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Mitkä ovat kaksi yleisintä strategiaa oppimistavoitteiden määrittämiseksi?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Toiminnan kartoitus (action mapping) on menetelmä, jossa tunnistetaan erityiset toimet tai käyttäytymiset, jotka oppijoiden on pystyttävä suorittamaan saavuttaakseen halutut oppimistavoitteet. Tämä sisältää keskeisten suorituskykymittareiden tunnistamisen, joita käytetään menestyksen mittaamiseen, ja kurssin sisällön ja aktiviteettien suunnittelun näiden taitojen kehittämisen tukemiseksi. Perinteinen kurssin rakentaminen alkaa halutuista oppimistavoitteista ja työskentelee taaksepäin suunnitellakseen kurssin sisällön ja aktiviteetit.`;
quizQuestions[0][9].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Toiminnan kartoitus (action mapping) on menetelmä, jossa tunnistetaan erityiset toimet tai käyttäytymiset, jotka oppijoiden on pystyttävä suorittamaan saavuttaakseen halutut oppimistavoitteet. Tämä sisältää keskeisten suorituskykymittareiden tunnistamisen, joita käytetään menestyksen mittaamiseen, ja kurssin sisällön ja aktiviteettien suunnittelun näiden taitojen kehittämisen tukemiseksi. Perinteinen kurssin rakentaminen alkaa halutuista oppimistavoitteista ja työskentelee taaksepäin suunnitellakseen kurssin sisällön ja aktiviteetit.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Toiminnan kartoitus (action mapping) ja perinteinen kurssin rakentaminen`;
quizQuestions[0][9].answers[1]=`Luonnostelu ja vertailukohtien asettaminen`;
quizQuestions[0][9].answers[2]=`Aivoriihi ja tekijäanalyysi`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Mikä on toiminnan kartoitus?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Toiminnan kartoitus (action mapping) on menetelmä, jolla tunnistetaan erityiset toimet tai käyttäytymiset, joita oppijoiden on kyettävä suorittamaan saavuttaakseen halutut oppimistavoitteet. Tämä sisältää avainkäyttäytymistä osoittavien indikaattorien tunnistamisen, jotka käytetään menestyksen mittaamiseen, ja kurssin sisällön ja aktiviteettien suunnittelun näiden taitojen kehittämisen tukemiseksi. Perinteinen kurssinrakentaminen aloitetaan halutuista oppimistavoitteista ja suunnitellaan taaksepäin kurssin sisältö ja aktiviteetit.`;
quizQuestions[0][10].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Toiminnan kartoitus (action mapping) on menetelmä, jolla tunnistetaan erityiset toimet tai käyttäytymiset, joita oppijoiden on kyettävä suorittamaan saavuttaakseen halutut oppimistavoitteet. Tämä sisältää avainkäyttäytymistä osoittavien indikaattorien tunnistamisen, jotka käytetään menestyksen mittaamiseen, ja kurssin sisällön ja aktiviteettien suunnittelun näiden taitojen kehittämisen tukemiseksi. Perinteinen kurssinrakentaminen aloitetaan halutuista oppimistavoitteista ja suunnitellaan taaksepäin kurssin sisältö ja aktiviteetit.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Työkalu ideoiden generointiin`;
quizQuestions[0][10].answers[1]=`Toiminnan kartoitus määrittää ne askeleet, jotka yleisön on otettava tietyntavoitteen saavuttamiseksi`;
quizQuestions[0][10].answers[2]=`Visuaalinen esitys tietystä lopputuloksesta`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Mitä elementtejä käsikirjoitus sisältää?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Teksti, kuvat, ääni, animaatiot ja ohjelmointimerkinnät ovat kaikki tärkeitä osia kuvakäsikirjoitukselle, koska ne auttavat suunnittelemaan ja visualisoimaan sisällön ja rakenteen.`;
quizQuestions[0][11].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Teksti, kuvat, ääni, animaatiot ja ohjelmointimerkinnät ovat kaikki tärkeitä osia kuvakäsikirjoitukselle, koska ne auttavat suunnittelemaan ja visualisoimaan sisällön ja rakenteen.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Hiottuja visuaaleja tai animaatioita, yksityiskohtaisia käsikirjoituksia, ja monimutkaisia tai erikoistuneita vaikutuksia tai teknologiaa`;
quizQuestions[0][11].answers[1]=`Lopulliset äänitykset ja musiikki`;
quizQuestions[0][11].answers[2]=`Teksti, kuvat, ääni, animaatiot, ohjelmointimuistiinpanot`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Mikä on tekstin nimi, joka näkyy jokaisella kalvolla yleisölle?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Oikea vastaus oli teksti näytöllä (OST).`;
quizQuestions[0][12].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Oikea vastaus oli teksti näytöllä (OST).`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Teksti näytöllä (OST)`;
quizQuestions[0][12].answers[1]=`Teksti näytöllä`;
quizQuestions[0][12].answers[2]=`Näytön sanallinen sisältö`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Nimeä joitakin huolenaiheita, joita oppimismuotoilijalla tulisi olla käyttäessään voice-overia`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Jokaisen dian äänitiedoston tekstitys ja nimi tulisi sisällyttää;
 on tärkeää sisällyttää jokaisen dian äänitiedoston tekstitys ja nimi käytettäessä voice-over -äänitystä, koska se auttaa varmistamaan, että ääni on oikein yhteensovitettu dian visuaalisten elementtien kanssa.`;
quizQuestions[0][13].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Jokaisen dian äänitiedoston tekstitys ja nimi tulisi sisällyttää;
 on tärkeää sisällyttää jokaisen dian äänitiedoston tekstitys ja nimi käytettäessä voice-over -äänitystä, koska se auttaa varmistamaan, että ääni on oikein yhteensovitettu dian visuaalisten elementtien kanssa.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Huomiota äänensävyn`;
quizQuestions[0][13].answers[1]=`Jokaisen dian äänitiedoston transkripti ja nimi tulisi sisällyttää`;
quizQuestions[0][13].answers[2]=`Oikea dikti`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Mitkä alueet kuuluvat käyttökokemuksen suunnitteluun (UX)?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Vuorovaikutussuunnittelu, käyttöliittymäsuunnittelu, visuaalinen suunnittelu, sisällön hallinta, käytettävyys ja informaatioarkkitehtuuri ovat tärkeitä UX-suunnittelussa, koska ne auttavat luomaan käyttäjäystävällisiä ja sitouttavia digitaalisia kokemuksia.`;
quizQuestions[0][14].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Vuorovaikutussuunnittelu, käyttöliittymäsuunnittelu, visuaalinen suunnittelu, sisällön hallinta, käytettävyys ja informaatioarkkitehtuuri ovat tärkeitä UX-suunnittelussa, koska ne auttavat luomaan käyttäjäystävällisiä ja sitouttavia digitaalisia kokemuksia.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Ohjelmistokehitys, verkkoinsinöörintyö ja digitaalinen markkinointi`;
quizQuestions[0][14].answers[1]=`Tietoanalyysi ja kyberturvallisuus`;
quizQuestions[0][14].answers[2]=`Vuorovaikutussuunnittelu, käyttöliittymäsuunnittelu, visuaalinen suunnittelu, sisällönhallinta, käytettävyys ja informaatioarkkitehtuuri`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Miten käyttäjät vuorovaikuttavat tuotteen kanssa?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Käyttöliittymä (UI) on tuotteen tai palvelun osa, joka mahdollistaa käyttäjien kanssaan vuorovaikutuksen. Tämä voi sisältää esimerkiksi painikkeita, valikkoja ja muita ohjaimia, jotka sallivat käyttäjien syöttää komentoja ja tietoa, sekä visuaalisia ja äänellisiä elementtejä, jotka antavat palautetta ja ohjeita käyttäjille.`;
quizQuestions[0][15].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Käyttöliittymä (UI) on tuotteen tai palvelun osa, joka mahdollistaa käyttäjien kanssaan vuorovaikutuksen. Tämä voi sisältää esimerkiksi painikkeita, valikkoja ja muita ohjaimia, jotka sallivat käyttäjien syöttää komentoja ja tietoa, sekä visuaalisia ja äänellisiä elementtejä, jotka antavat palautetta ja ohjeita käyttäjille.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Käyttöliittymän (UI) kautta`;
quizQuestions[0][15].answers[1]=`Näppäimistön ja hiiren avulla`;
quizQuestions[0][15].answers[2]=`Kaukosäätimellä`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`Mitä UX kattaa?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>UX kattaa käyttäjän täydellisen vuorovaikutuksen tuotteen kanssa. Tämä sisältää paitsi käyttöliittymän (UI), joka on tuotteen osa, joka mahdollistaa käyttäjien kanssaan vuorovaikutuksen, myös muut elementit, jotka vaikuttavat käyttäjäkokemukseen.`;
quizQuestions[0][16].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>UX kattaa käyttäjän täydellisen vuorovaikutuksen tuotteen kanssa. Tämä sisältää paitsi käyttöliittymän (UI), joka on tuotteen osa, joka mahdollistaa käyttäjien kanssaan vuorovaikutuksen, myös muut elementit, jotka vaikuttavat käyttäjäkokemukseen.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Tuotteen esteettisyys`;
quizQuestions[0][16].answers[1]=`Täydellinen vuorovaikutus, joka käyttäjillä on tuotteen kanssa`;
quizQuestions[0][16].answers[2]=`Tietojen keruu ja analysointi`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Mitkä ovat joitakin euristisia näkökohtia, jotka tulisi ottaa huomioon tuotettaessa verkko-oppimismateriaalia?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Järjestelmän tilan näkyvyys, yhtenevyys järjestelmän ja todellisen maailman välillä sekä käyttäjän ohjaus ja vapaus ovat kaikki tärkeitä verkko-oppimisessa, koska ne auttavat luomaan käyttäjäystävällisiä ja tehokkaita oppimiskokemuksia.`;
quizQuestions[0][17].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Järjestelmän tilan näkyvyys, yhtenevyys järjestelmän ja todellisen maailman välillä sekä käyttäjän ohjaus ja vapaus ovat kaikki tärkeitä verkko-oppimisessa, koska ne auttavat luomaan käyttäjäystävällisiä ja tehokkaita oppimiskokemuksia.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Helppo sulattaa sisältö;
 interaktiivisuus`;
quizQuestions[0][17].answers[1]=`Houkutteleva estetiikka ja monimutkainen animaatio`;
quizQuestions[0][17].answers[2]=`Järjestelmän tilan näkyvyys;
 Yhteensopivuus järjestelmän ja todellisen maailman välillä;
 Käyttäjän kontrolli ja vapaus`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`Miten virheilmoitukset tulisi näyttää?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Virheviestit tulisi aina ilmaista selkokielellä (ei koodeja), ne tulisi tarkasti ilmaista ongelman, ja ehdottaa rakentavasti ratkaisua.`;
quizQuestions[0][18].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Virheviestit tulisi aina ilmaista selkokielellä (ei koodeja), ne tulisi tarkasti ilmaista ongelman, ja ehdottaa rakentavasti ratkaisua.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Selkeällä kielellä (ei koodeja), tarkasti ilmaise ongelman ja ehdota konstruktiivisesti ratkaisua`;
quizQuestions[0][18].answers[1]=`Yksityiskohtaisen koodin käyttö`;
quizQuestions[0][18].answers[2]=`Kovan äänimelun kanssa`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Miten parantaa käyttäjän virhepalautetta?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Oikein! Vastauksesi on oikein.</b><br>Selvästi merkityn "exit"-vaihtoehdon tarjoaminen poistumiseen ei-toivotusta tilasta sekä undo- ja redo-toimintojen tukeminen, voivat auttaa luomaan käyttäjäystävällisiä ja sitouttavia oppimiskokemuksia.`;
quizQuestions[0][19].feedback_wrong=`<b>Vastauksesi on väärin.</b><br>Selvästi merkityn "exit"-vaihtoehdon tarjoaminen poistumiseen ei-toivotusta tilasta sekä undo- ja redo-toimintojen tukeminen, voivat auttaa luomaan käyttäjäystävällisiä ja sitouttavia oppimiskokemuksia.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Jatkuvalla virheestä saadun tiedon tulvalla`;
quizQuestions[0][19].answers[1]=`Tarjoa selvästi merkitty "exit" poistumiseen ei-toivotusta tilasta ja tue perumista ja uusintaa`;
quizQuestions[0][19].answers[2]=`Yksityiskohtaiset tekniset ohjeet virheestä`;
quizQuestions[0][19].key=2;

