// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};
quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Que afirmação descreve melhor a solução de ensino?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As soluções de instrução são desenvolvidas tendo em conta os problemas de instrução e as necessidades de aprendizagem, os conhecimentos e competências a ensinar, os ambientes de aprendizagem pré-existentes e as personas dos formandos. Fornece a estrutura da instrução que cria experiências de aprendizagem para que os formandos atinjam os objetivos de aprendizagem. As soluções de instrução serão desenvolvidas em planos de instrução com várias considerações de design para que os programadores de instrução possam desenvolver produtos de instrução.`;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>As soluções de instrução são desenvolvidas tendo em conta os problemas de instrução e as necessidades de aprendizagem, os conhecimentos e competências a ensinar, os ambientes de aprendizagem pré-existentes e as personas dos formandos. Fornece a estrutura da instrução que cria experiências de aprendizagem para que os formandos atinjam os objetivos de aprendizagem. As soluções de instrução serão desenvolvidas em planos de instrução com várias considerações de design para que os programadores de instrução possam desenvolver produtos de instrução.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`A solução pedagógica é desenvolvida tendo em conta apenas os conhecimentos e as competências a ensinar.`;
quizQuestions[0][0].answers[1]=`A solução de instrução fornece a estrutura geral de instrução que cria uma experiência de aprendizagem para que os formandos atinjam os objetivos de aprendizagem `;
quizQuestions[0][0].answers[2]=`A solução pedagógica deve ser tão pormenorizada quanto possível no início, de modo a poder ser utilizada para desenvolver produtos pedagógicos`;
quizQuestions[0][0].key=2;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`O que deve ser incluído nos resultados de aprendizagem pretendidos?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os objetivos de aprendizagem devem indicar os comportamentos cognitivos mensuráveis sobre os conhecimentos e as competências a serem aprendidos, bem como o contexto de aplicação dos conhecimentos e das competências.`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os objetivos de aprendizagem devem indicar os comportamentos cognitivos mensuráveis sobre os conhecimentos e as competências a serem aprendidos, bem como o contexto de aplicação dos conhecimentos e das competências.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Comportamentos cognitivos mensuráveis esperados, descrição dos conhecimentos e competências a serem aprendidos e contexto de aplicação.`;
quizQuestions[0][1].answers[1]=`Os conhecimentos e competências que os formandos devem dominar após a conclusão da formação`;
quizQuestions[0][1].answers[2]=`Desempenho esperado de uma tarefa de aprendizagem específica`;
quizQuestions[0][1].key=1;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Quais são os seis níveis hierárquicos de pensamento na taxonomia de Bloom dos objetivos educacionais?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os seis níveis hierárquicos de pensamento na taxonomia de Bloom dos objetivos educativos são: Recordar, Compreender, Aplicar, Analisar, Avaliar e Criar.`;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os seis níveis hierárquicos de pensamento na taxonomia de Bloom dos objetivos educativos são: Recordar, Compreender, Aplicar, Analisar, Avaliar e Criar.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Recordar, Compreender, Aplicar, Analisar, Avaliar e Criar.`;
quizQuestions[0][2].answers[1]=`Recordar, Compreender, Aplicar, Analisar, Combinar e Criar`;
quizQuestions[0][2].answers[2]=`Recordar, Aplicar, Compreender, Comparar, Analisar e Criar`;
quizQuestions[0][2].key=1;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Como é que a análise da persona do formando pode ajudar no ID?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A persona do formando pode ser utilizada para identificar as necessidades de aprendizagem e implicar o apoio pedagógico necessário numa instrução centrada no utilizador.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A persona do formando pode ser utilizada para identificar as necessidades de aprendizagem e implicar o apoio pedagógico necessário numa instrução centrada no utilizador.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`As personas dos formandos identificam as questões-chave subjacentes ao problema de instrução`;
quizQuestions[0][3].answers[1]=`As personas dos alunos informam as necessidades dos formandos, o que implica o apoio pedagógico de que os formandos necessitam`;
quizQuestions[0][3].answers[2]=`As personas dos formandos indicam as preferências de aprendizagem dos formandos, o que determina a forma como a instrução deve ser concebida para corresponder às suas preferências`;
quizQuestions[0][3].key=2;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Que afirmação sobre o desenvolvimento de uma instrução centrada no utilizador está incorreta?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os IDs utilizam as personas dos formandos para identificar o apoio pedagógico necessário. Se não houver informações sobre os formandos, os conceptores de instruções devem, ainda assim, ter em conta as perspetivas dos formandos para conceber a instrução com base nos objetivos de aprendizagem.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os IDs utilizam as personas dos formandos para identificar o apoio pedagógico necessário. Se não houver informações sobre os formandos, os conceptores de instruções devem, ainda assim, ter em conta as perspetivas dos formandos para conceber a instrução com base nos objetivos de aprendizagem.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Os IDs concebem a instrução apenas com base na forma como esta corresponde às preferências de aprendizagem dos formandos`;
quizQuestions[0][4].answers[1]=`Os designers instrucionais devem utilizar personas do formando para considerar o apoio instrucional necessário`;
quizQuestions[0][4].answers[2]=`Os designers instrucionais não podem conceber instruções se não houver informação disponível sobre a pessoa do formando`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Que afirmação sobre os ambientes de aprendizagem está incorreta?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os IDs devem ter em conta o ambiente de aprendizagem existente, os recursos disponíveis e os objetivos de aprendizagem para desenvolver os ambientes de aprendizagem desejados.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os IDs devem ter em conta o ambiente de aprendizagem existente, os recursos disponíveis e os objetivos de aprendizagem para desenvolver os ambientes de aprendizagem desejados.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Um ambiente de aprendizagem consiste em ambientes físicos, cognitivos e psicológicos`;
quizQuestions[0][5].answers[1]=`Os IDs concebem e desenvolvem qualquer tipo de ambiente de aprendizagem, desde que sirva os objetivos instrucionais`;
quizQuestions[0][5].answers[2]=`Em comparação com o ambiente físico e o ambiente cognitivo, os ambientes psicológicos estão mais relacionados com as personas dos formandos`;
quizQuestions[0][5].key=2;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Que afirmação relativa ao desenvolvimento de soluções de ensino está incorreta?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O desenvolvimento de soluções de instrução é um processo que envolve constantemente uma análise iterativa do contexto de instrução.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O desenvolvimento de soluções de instrução é um processo que envolve constantemente uma análise iterativa do contexto de instrução.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`A criação de soluções pedagógicas é um processo linear de seleção de métodos pedagógicos e de métodos de avaliação com base nos objetivos de aprendizagem`;
quizQuestions[0][6].answers[1]=`A criação de soluções pedagógicas envolve a análise iterativa de contextos pedagógicos que informam a tomada de decisões sobre a seleção de modos de aprendizagem, métodos pedagógicos e métodos de avaliação`;
quizQuestions[0][6].answers[2]=`A criação de soluções de ensino começa sempre após uma análise do contexto de ensino, de modo a que os conceptores de ensino desenvolvam soluções de ensino centradas no utilizador, no problema e no contexto`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Se precisar de conceber uma formação em modo de e-learning, como é que isso afetaria a sua decisão sobre outros componentes da solução pedagógica?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Existem alguns tipos de objetivos de aprendizagem que não podem ser alcançados com o e-learning, por exemplo, dominar técnicas específicas de futebol e jogar um jogo de futebol com outras pessoas.`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Existem alguns tipos de objetivos de aprendizagem que não podem ser alcançados com o e-learning, por exemplo, dominar técnicas específicas de futebol e jogar um jogo de futebol com outras pessoas.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Os métodos de ensino devem ser adaptados ao ambiente de e-learning com materiais de aprendizagem digitais e ferramentas de aprendizagem digitais`;
quizQuestions[0][7].answers[1]=`Os objetivos de aprendizagem não precisam de mudar porque qualquer tipo de aprendizagem pode ser convertido no formato de e-learning`;
quizQuestions[0][7].answers[2]=`É mais provável que a avaliação seja concebida para testar a compreensão declarativa e conceptual dos conhecimentos do que as competências motoras específicas.`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Qual é o modo de aprendizagem mais adequado para aprender a desenhar projetos de arquitetura?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Aprender a desenhar projetos de arquitetura requer uma grande quantidade de aprendizagem independente de conhecimentos factuais sobre projetos de arquitetura, que é melhor aprender com o e-Learning. Também envolve o pensamento de conceção e a comunicação com as partes interessadas, que é melhor aprender com pessoas no âmbito da aprendizagem baseada em projetos.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Aprender a desenhar projetos de arquitetura requer uma grande quantidade de aprendizagem independente de conhecimentos factuais sobre projetos de arquitetura, que é melhor aprender com o e-Learning. Também envolve o pensamento de conceção e a comunicação com as partes interessadas, que é melhor aprender com pessoas no âmbito da aprendizagem baseada em projetos.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Aprendizagem combinada`;
quizQuestions[0][8].answers[1]=`Aprendizagem móvel`;
quizQuestions[0][8].answers[2]=`Aprendizagem presencial`;
quizQuestions[0][8].key=1;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Qual é a afirmação correta relativamente aos métodos de ensino?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A seleção dos métodos de ensino baseia-se no tipo de aprendizagem visada e nos recursos disponíveis.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A seleção dos métodos de ensino baseia-se no tipo de aprendizagem visada e nos recursos disponíveis.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Selecionamos e adaptamos os métodos de ensino apenas com base na competência dos formadores para utilizar os métodos de ensino e a tecnologia disponível`;
quizQuestions[0][9].answers[1]=`Selecionamos, adaptamos e integramos os métodos de ensino com base na sua eficácia no apoio à aprendizagem alvo, mas a seleção é também limitada pelos recursos tecnológicos disponíveis e pelo ambiente físico`;
quizQuestions[0][9].answers[2]=`Os IDs selecionam diferentes métodos de instrução com base nos objetivos de aprendizagem e criam um novo ambiente de aprendizagem para que os métodos de instrução possam ser implementados`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Qual não é a função da tecnologia no apoio aos métodos de ensino?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Alguns tipos de aprendizagem não podem ser acedidos através do e-Learning, como o treino de competências preceptivo-motoras. A aprendizagem presencial também tem uma excitação psicológica diferente que não aparece no e-Learning, o que pode dificultar a aprendizagem pretendida.`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Alguns tipos de aprendizagem não podem ser acedidos através do e-Learning, como o treino de competências preceptivo-motoras. A aprendizagem presencial também tem uma excitação psicológica diferente que não aparece no e-Learning, o que pode dificultar a aprendizagem pretendida.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`A tecnologia pode ajudar a proporcionar experiências de aprendizagem mais ricas e a melhorar a motivação durante o processo de aprendizagem`;
quizQuestions[0][10].answers[1]=`A tecnologia pode ajudar a proporcionar as interações sociais que apoiam a aprendizagem-alvo`;
quizQuestions[0][10].answers[2]=`A tecnologia pode converter em e-Learning todas as funções de instrução fornecidas na aprendizagem presencial`;
quizQuestions[0][10].key=3;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Quais são as funções da avaliação na instrução e na aprendizagem?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A avaliação pode ser utilizada para identificar o progresso e os resultados da aprendizagem, o que pode servir de base ao ajustamento da instrução e à aprendizagem autorregulada dos formandos.`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A avaliação pode ser utilizada para identificar o progresso e os resultados da aprendizagem, o que pode servir de base ao ajustamento da instrução e à aprendizagem autorregulada dos formandos.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`A avaliação pode ser utilizada para informar e regular o processo de ensino e aprendizagem`;
quizQuestions[0][11].answers[1]=`A avaliação pode ser utilizada para identificar e medir os resultados da aprendizagem`;
quizQuestions[0][11].answers[2]=`A avaliação pode ser utilizada para medir os resultados da aprendizagem e regular o processo de aprendizagem`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Porque é que os Instructional Designers utilizam a avaliação formativa?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os IDs utilizam geralmente a avaliação formativa como parte das atividades de ensino e aprendizagem para fornecer feedback informativo aos alunos e professores, de modo a regular o processo de aprendizagem. Mas nem todas as instruções devem incluir a avaliação formativa.`;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os IDs utilizam geralmente a avaliação formativa como parte das atividades de ensino e aprendizagem para fornecer feedback informativo aos alunos e professores, de modo a regular o processo de aprendizagem. Mas nem todas as instruções devem incluir a avaliação formativa.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`A avaliação formativa é integrada como parte das atividades de aprendizagem que podem ajudar os alunos a compreender os conteúdos do curso e a regular o processo de aprendizagem`;
quizQuestions[0][12].answers[1]=`A utilização da avaliação formativa dispensa a avaliação sumativa, uma vez que os resultados da aprendizagem dos alunos são medidos durante o processo de aprendizagem`;
quizQuestions[0][12].answers[2]=`A avaliação formativa pode captar o processo de aprendizagem e acompanhar o progresso da aprendizagem dos formandos. Cada ID deve envolver a avaliação formativa`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Quais são os componentes importantes da solução pedagógica?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os componentes importantes da solução pedagógica incluem objetivos de aprendizagem, modo de aprendizagem, métodos de instrução e método de avaliação.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os componentes importantes da solução pedagógica incluem objetivos de aprendizagem, modo de aprendizagem, métodos de instrução e método de avaliação.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`As estratégias de ensino melhoram a motivação, os métodos de ensino e as ferramentas de avaliação`;
quizQuestions[0][13].answers[1]=`Modos de aprendizagem e métodos de ensino para os objetivos de aprendizagem`;
quizQuestions[0][13].answers[2]=`Objetivos de aprendizagem, modo de aprendizagem, métodos de ensino e ferramentas de avaliação`;
quizQuestions[0][13].key=3;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Como é que os IDs desenvolvem um processo de formação sensível à cultura?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os IDs desenvolvem materiais e atividades de aprendizagem com base nos hábitos socioculturais dos formandos e criam uma comunidade de aprendizagem sensível à cultura para formandos de vários contextos de aprendizagem.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os IDs desenvolvem materiais e atividades de aprendizagem com base nos hábitos socioculturais dos formandos e criam uma comunidade de aprendizagem sensível à cultura para formandos de vários contextos de aprendizagem.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Os IDs concebem materiais de aprendizagem e atividades de aprendizagem de acordo com os hábitos socioculturais dos formandos`;
quizQuestions[0][14].answers[1]=`Os IDs devem conceber instruções baseadas na comunidade que permitam aos formandos interagir com pessoas de diferentes origens`;
quizQuestions[0][14].answers[2]=`Os IDs desenvolvem materiais e atividades de aprendizagem com base nos hábitos socioculturais dos formandos e criam uma comunidade de aprendizagem sensível à cultura para formandos de vários contextos de aprendizagem`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Como é que os IDs alinham a avaliação com os objetivos de aprendizagem?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Por vezes, a avaliação centra-se na tarefa holística realizada, o que é difícil de incluir todos os comportamentos cognitivos e conteúdos de aprendizagem indicados nos objetivos de aprendizagem.`;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Por vezes, a avaliação centra-se na tarefa holística realizada, o que é difícil de incluir todos os comportamentos cognitivos e conteúdos de aprendizagem indicados nos objetivos de aprendizagem.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`A avaliação deve exigir que os formandos demonstrem todos os comportamentos cognitivos indicados nos objetivos de aprendizagem`;
quizQuestions[0][15].answers[1]=`Os critérios de avaliação devem ser definidos com base na capacidade de os formandos realizarem as tarefas de aprendizagem indicadas nos objetivos de aprendizagem`;
quizQuestions[0][15].answers[2]=`A avaliação deve incluir nos elementos de avaliação todos os conhecimentos e competências visados nos objetivos de aprendizagem `;
quizQuestions[0][15].key=2;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`O que é o alinhamento construtivo?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O alinhamento construtivo é um alinhamento dinâmico entre os objetivos de aprendizagem, os métodos de ensino e a avaliação.`;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O alinhamento construtivo é um alinhamento dinâmico entre os objetivos de aprendizagem, os métodos de ensino e a avaliação.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`O alinhamento entre os modos de aprendizagem, os métodos de ensino e a avaliação`;
quizQuestions[0][16].answers[1]=`O alinhamento entre os objetivos de aprendizagem, os métodos de ensino e a avaliação`;
quizQuestions[0][16].answers[2]=`O alinhamento entre os objetivos de aprendizagem, os modos de aprendizagem e os métodos de ensino`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Qual não é o papel das soluções pedagógicas na conceção e desenvolvimento dos objetos de aprendizagem?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O alinhamento construtivo é um alinhamento dinâmico entre os objetivos de aprendizagem, os métodos de ensino e a avaliação.`;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O alinhamento construtivo é um alinhamento dinâmico entre os objetivos de aprendizagem, os métodos de ensino e a avaliação.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`As soluções de ensino fornecem informações detalhadas sobre a forma como os objetos de aprendizagem se devem desenvolver em cada percurso, módulo e atividade de aprendizagem`;
quizQuestions[0][17].answers[1]=`As soluções pedagógicas indicam os métodos e a forma como a instrução é ministrada, o que constitui o limite para o desenvolvimento de objetos de aprendizagem que podem ser resididos, utilizados e reutilizados num determinado contexto pedagógico`;
quizQuestions[0][17].answers[2]=`As soluções pedagógicas indicam os métodos pedagógicos essenciais e a avaliação em termos de conteúdos e atividades de aprendizagem, que definem as finalidades dos objetos de aprendizagem`;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`O que são os objetos de aprendizagem?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os objetos de aprendizagem referem-se aos materiais de conteúdo de aprendizagem, aos recursos da atividade de aprendizagem e às ferramentas de avaliação baseadas num único objetivo de aprendizagem.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os objetos de aprendizagem referem-se aos materiais de conteúdo de aprendizagem, aos recursos da atividade de aprendizagem e às ferramentas de avaliação baseadas num único objetivo de aprendizagem.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Os objetos de aprendizagem referem-se aos materiais de aprendizagem que apresentam a informação principal dos conhecimentos e competências alvo  `;
quizQuestions[0][18].answers[1]=`Os objetos de aprendizagem referem-se aos materiais de conteúdo de aprendizagem, aos recursos da atividade de aprendizagem e às ferramentas de avaliação baseadas num único objetivo de aprendizagem`;
quizQuestions[0][18].answers[2]=`Os objetos de aprendizagem referem-se aos materiais de aprendizagem de que os formandos necessitam para realizar tarefas de aprendizagem específicas`;
quizQuestions[0][18].key=2;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Que métodos de ensino envolvem normalmente a aprendizagem colaborativa?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A aprendizagem baseada em problemas e a aprendizagem baseada em inquéritos envolvem os aprendentes num projeto de trabalho específico que envolve múltiplas perspetivas de conceptualização, discussão em grupo e colaboração para a resolução de problemas ou inquéritos.`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A aprendizagem baseada em problemas e a aprendizagem baseada em inquéritos envolvem os aprendentes num projeto de trabalho específico que envolve múltiplas perspetivas de conceptualização, discussão em grupo e colaboração para a resolução de problemas ou inquéritos.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Palestras e aprendizagem baseada em projetos`;
quizQuestions[0][19].answers[1]=`Microaprendizagem e aprendizagem baseada na simulação`;
quizQuestions[0][19].answers[2]=`Aprendizagem baseada em problemas e aprendizagem baseada em inquéritos`;
quizQuestions[0][19].key=3;

