// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Why does instructional design require interdisciplinary expertise?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional design involves rich interaction within a learning environment and systematic design processes that require interdisciplinary knowledge. But instructional designers don't have to be experts in all these disciplines. Interdiscilinary collaboration is an important strategy for instructional design.`;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional design involves rich interaction within a learning environment and systematic design processes that require interdisciplinary knowledge. But instructional designers don't have to be experts in all these disciplines. Interdiscilinary collaboration is an important strategy for instructional design.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Different phases of instructional design require expertise and skills from multiple disciplines (e.g., learning science, design, management, and communication), which interactively and mutually decide the quality of the project results`;
quizQuestions[0][0].answers[1]=`Designing a complex learning environment fulfilled with interaction requires that instructional designers must be experts in multiple disciplinaries (e.g., learning science, design, management, and communication)`;
quizQuestions[0][0].answers[2]=`Both answers are correct`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`What are the main perspectives on learning?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>The main perspectives on learning that are commonly used for instructional design include behaviorism, cognitivism, constructivism, and sociocultural learning theory.`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>The main perspectives on learning that are commonly used for instructional design include behaviorism, cognitivism, constructivism, and sociocultural learning theory.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Behaviorism, cognitivism, cognitive constructivism, social constructivism`;
quizQuestions[0][1].answers[1]=`Behaviorism, cognitivism, constructivism, and sociocultural learning theory`;
quizQuestions[0][1].answers[2]=`Behaviorism, cognitivism, constructivism, and connectivism`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`What are the fundamental elements that differentiate the various perspectives on learning?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>Different perspectives on learning varies due to the different definition of knowledge and explanation of how learning happen.`;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>Different perspectives on learning varies due to the different definition of knowledge and explanation of how learning happen.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Different perspectives on learning differ because they define the nature of knowledge differently`;
quizQuestions[0][2].answers[1]=`Different perspectives on learning differ because they explain how learning happen differently `;
quizQuestions[0][2].answers[2]=`Different perspectives on learning define the nature of knowledge and how learning happen differently`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Which statement is incorrect?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>Learning can be explained through various perspectives. However, when considering the explanatory power and the most effective practices to support a specific type of learning, instructional designers should be able to identify which perspective provides better guidelines for instructional design within limited resources and time.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>Learning can be explained through various perspectives. However, when considering the explanatory power and the most effective practices to support a specific type of learning, instructional designers should be able to identify which perspective provides better guidelines for instructional design within limited resources and time.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Instructional designers usually hold divergent perspectives on learning to analyze the target learning. But instructional designers choose the most suitable perspectives regarding its explanatory power to learning to guide instructional design`;
quizQuestions[0][3].answers[1]=`One learning phenomenon can only be explained by one specific perspective on learning. Instructional designers should choose the correct perspective to analyze the target learning`;
quizQuestions[0][3].answers[2]=`Instructional designers utilize the perspectives on learning to analyze important aspects of the target learning and define the learning values. Based on the learning value and goals, instructional designers examine the appropriateness of instructional practices`;
quizQuestions[0][3].key=2;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Which statement correctly describes the guidance of learning theories for instructional design practices?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct. </b><br>Sociocultural learning theories emphasize authentic practices for supporting ill-structured learning. But it does not exclude deliberate practices and information elaboration. Instead, these two practices are commonly used for expert performance modeling and coaching.`;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>Sociocultural learning theories emphasize authentic practices for supporting ill-structured learning. But it does not exclude deliberate practices and information elaboration. Instead, these two practices are commonly used for expert performance modeling and coaching.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Cognitivism claims that learning is the development of a mental structure for information processing. Instructions should elaborate information for optimal memory and provide (meta-)cognitive strategies for information processing`;
quizQuestions[0][4].answers[1]=`Sociocultural learning emphasizes the opportunities for active participation in the community of practices and identity development. Instruction completely excludes information elaboration and deliberate practices and emphasizes the engagement of social interaction`;
quizQuestions[0][4].answers[2]=`Constructivism emphasizes a learning environment that supports learners' sense-making and knowledge construction. Instruction provides scaffolding (elaboration and social interaction) to connect the prior knowledge and rich activities for inquiry and problem-solving`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Which statement indicates the most appropriate relations between learners' self-regulation and external regulation?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>In an instructional setting, learners engage in self-regulated learning by plan, implement, monitor, regulate, and reflect on their learning process and outcomes. External regulation (instructional practices) play important roles in  learners' self-regulated learning. For learner with lower self-regulated learning ability, they need more external regulation. But the external regulation regulation can focus on ensuring the target learning happen and/or supporting learners' self-regulated learning to achieve the learning goals.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>In an instructional setting, learners engage in self-regulated learning by plan, implement, monitor, regulate, and reflect on their learning process and outcomes. External regulation (instructional practices) play important roles in  learners' self-regulated learning. For learner with lower self-regulated learning ability, they need more external regulation. But the external regulation regulation can focus on ensuring the target learning happen and/or supporting learners' self-regulated learning to achieve the learning goals.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`External regulation (i.e., instructional practices) should only be used to support learners' self-regulated learning, because learners' self-regulated learning determines how learning happen in actual instructional settings`;
quizQuestions[0][5].answers[1]=`An instructional setting always involves self-regulated learning and external regulation (i.e., instructional practices). External regulation should balance the support for learners' effective self-regulation and the support for facilitating the target learning`;
quizQuestions[0][5].answers[2]=`External regulation (i.e., instructional practices) can only monitor and regulate learners' learning process during instructional activities. Learners only engage in self-regulated learning when they study alone`;
quizQuestions[0][5].key=2;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`What are the five basic instructional component according to the first principles of instruction?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>The five principles of instructions is that learning is best improved if the instruction (1) is problem-centered, (2) actives learner's prior knowledge or prepares learner prerequisite knowledge related to the target learning, (3) demonstrates and models the target learning, (4) provide opportunities to practice the application of new learnt knowledge, and (5) provide context for learner to integrate new learning with prior knowledge to create new understanding.`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>The five principles of instructions is that learning is best improved if the instruction (1) is problem-centered, (2) actives learner's prior knowledge or prepares learner prerequisite knowledge related to the target learning, (3) demonstrates and models the target learning, (4) provide opportunities to practice the application of new learnt knowledge, and (5) provide context for learner to integrate new learning with prior knowledge to create new understanding.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`(1) Knowledge-centered information, 
(2) Supportive information for prior knowledge activation
(3) Demonstration of knowledge application
(4) Drill and practice 
(5) Assessment and task for problem-solving`;
quizQuestions[0][6].answers[1]=`(1) Problem-centered assessment
(2) Information for prior knowledge activation
(3) Demonstration of new learning
(4) Drill and practices
(5) Summative assessment for knowledge reproduction`;
quizQuestions[0][6].answers[2]=`(1) Problem-centered learning tasks
(2) Information for prior knowledge activation or schema structure development
(3) Demonstrations of new learning
(4) Learning application practices
(5) Assessment and tasks for reflection and creative production`;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Which statement regarding instructional design theories is incorrect?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional design theories systematically describe how instructional methods should be used to create a supportive learning environment. However, instructional designers utilize the instructional theories flexibly and situationally depending on the learning needs and learning context.`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional design theories systematically describe how instructional methods should be used to create a supportive learning environment. However, instructional designers utilize the instructional theories flexibly and situationally depending on the learning needs and learning context.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Instructional design theories are prescriptive and design-oriented theories that systematically describe how instructional designers should design the instructional practices and learning environment to support the target learning. Instructional designers should strictly follow the selected instructional design theories`;
quizQuestions[0][7].answers[1]=`Instructional design theories provide a guideline on what instructional methods are the most suitable to address a specific type of learning under a specific context. Instructional design theories are situational, componential, and probabilistic. Instructional designer use different instructional theories depending on the instructional design context`;
quizQuestions[0][7].answers[2]=`Instructional-design theories address the general framework of instruction which include but not limits to instructional events, learning environment setting, learning materials and activities design, supportive information design, and technology integration`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Which statement regarding the application of instructional design theories is incorrect?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>Cognitive apprenticeship is not effective for learning a specific narrow set of performance or motor skills. Because this type of learning does not require rich interaction and communication with a community member, which can be learned more effectively with mastery learning.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>Cognitive apprenticeship is not effective for learning a specific narrow set of performance or motor skills. Because this type of learning does not require rich interaction and communication with a community member, which can be learned more effectively with mastery learning.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Cognitive load theories can be applied to the design of learning task, multimedia learning materials, supportive information, practices and exercise for introductory learning`;
quizQuestions[0][8].answers[1]=`Cognitive apprenticeship is suitable for any type of learning in any setting since it provides a guideline for developing an authentic learning environment that assists active knowledge reflection and articulation with rich interactions`;
quizQuestions[0][8].answers[2]=`In mastery learning, teachers use different instruction methods for different type of learning and allow learners learn in their own pace to master what has been taught in the instruction  `;
quizQuestions[0][8].key=2;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Which statement regarding instructional design paradigms is incorrect?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional designers use the systematic design paradigm and situational design paradigm interactively during the instructional design process. While the systematic design paradigm provides the general framework, the situational design paradigm makes adjustment based on the iterative analysis of problems.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional designers use the systematic design paradigm and situational design paradigm interactively during the instructional design process. While the systematic design paradigm provides the general framework, the situational design paradigm makes adjustment based on the iterative analysis of problems.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Instructional designers choose one of the paradigms to develop instruction by either following theory-driven procedures or developing instruction based on a detailed analysis of the situation`;
quizQuestions[0][9].answers[1]=`Instructional designers use the systematic and situational design paradigms interchangeably to set up the whole instruction framework and fill in the design details for instructional practices`;
quizQuestions[0][9].answers[2]=`Instructional designers use the systematic and situational design paradigms interchangeably to set up the instruction development process and agilely adapt the framework and design practices based on the progress of development`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`What does the instructional design context consist of?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional design context consists of instructional problems and learning needs, information of learner persona, and learning environments.`;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional design context consists of instructional problems and learning needs, information of learner persona, and learning environments.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Client's requirement, target/potential learners, and classroom settings`;
quizQuestions[0][10].answers[1]=`Instructional problems and learning needs, target/potential learners, and learning environment`;
quizQuestions[0][10].answers[2]=`Learning objectives, learning environment, and available technology`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`What is an instructional solution?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>Instructional solution is a document developed based on instructional-design theories, consisting of learning mode, learning objectives, instructional methods, and assessment, which can be developed into a blueprint for the learning object development`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>Instructional solution is a document developed based on instructional-design theories, consisting of learning mode, learning objectives, instructional methods, and assessment, which can be developed into a blueprint for the learning object development`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`A manual based on instructional-design theories for developing the learning objects that serve for the presentation of learning content, the learning activities, the scaffolding, and assessment`;
quizQuestions[0][11].answers[1]=`A framework based on instructional-design theories, providing the structure of the instructional process, division of learning content, and the assessment tools, which can be used to develop the template for learning object development`;
quizQuestions[0][11].answers[2]=`A document developed based on instructional-design theories, consisting of learning mode, learning objectives, instructional methods, and assessment, which can be developed into a blueprint for the learning object development`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`What is learning object?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>Learning objects refer to the learning content materials, learning activity affordance, and the assessment based on a learning objective`;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>Learning objects refer to the learning content materials, learning activity affordance, and the assessment based on a learning objective`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Learning objects refer to the learning materials that present the essential information of the target learning`;
quizQuestions[0][12].answers[1]=`Learning objects refer to the learning content materials, learning activity affordance, and the assessment based on a learning objective`;
quizQuestions[0][12].answers[2]=`Learning objects refer to the resources that assist in the learning when students encounter learning difficulties`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`What are the main phase of instructional development?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>The basic steps involved in every instructional development (ID) models are analysis, design, develop, implement and evaluate. They vary in their emphasis on specific steps, the practices in each step, and the sequences of these steps.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>The basic steps involved in every instructional development (ID) models are analysis, design, develop, implement and evaluate. They vary in their emphasis on specific steps, the practices in each step, and the sequences of these steps.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Analyze, design, develop, implement and evaluate`;
quizQuestions[0][13].answers[1]=`Analyze, design, implement, evaluate, and redesign`;
quizQuestions[0][13].answers[2]=`Analyze, design, develop and implement`;
quizQuestions[0][13].key=1;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Which statement regarding ID models is incorrect?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>ADDIE model is a comprehensive instructional design model. It is used both linearly or iteratively accordingly.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>ADDIE model is a comprehensive instructional design model. It is used both linearly or iteratively accordingly.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`ADDIE model is a systematic and linear instructional design approach that strictly follows the procedure starting from analysis, design, development, and implementation, to evaluation`;
quizQuestions[0][14].answers[1]=`Using SAM model require the flexible working environment and team resources to give in-time feedbacks on the design and prototypes`;
quizQuestions[0][14].answers[2]=`Using the SAM model requires a flexible working environment and team resources to give in-time feedback on the design and prototypes`;
quizQuestions[0][14].key=1;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Which statement best describes the role of evaluation in an instructional design project?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>The evaluation phase interweaves with each step of instruction. But whether adopting the formative evaluation varies from project to project.`;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>The evaluation phase interweaves with each step of instruction. But whether adopting the formative evaluation varies from project to project.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Evaluation plays an important role in identifying the effectiveness of the developed instruction. It is usually conducted after the implementation of instruction`;
quizQuestions[0][15].answers[1]=`Evaluation plays an important role in each phase of instructional design. The evaluation practices focus on both the quality of the design process and the quality of the outcomes from analyze, design, develop and implement phases`;
quizQuestions[0][15].answers[2]=`Evaluation plays an important role in identifying the effectiveness of the developed instruction. The evaluation tool is designed and developed as an assessment tool for learning `;
quizQuestions[0][15].key=2;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`What are the prioritized considerations for choosing ID models?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>The selection of ID models depend on the type of instruction and the available resources and time.`;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>The selection of ID models depend on the type of instruction and the available resources and time.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Instructional designers select ID models based on the instructional problems and their expertise in using these models`;
quizQuestions[0][16].answers[1]=`Instructional designers select ID models based on the instructional problems,  available time, money, management support, and resources (e.g., technology)`;
quizQuestions[0][16].answers[2]=`Instructional designers select ID models based on the instructional problems and the client's requirements and satisfaction`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`What are the design principles that should be considered to design and develop functional instruction?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>Developing functional instructions does not rely on the compliance of the instructional development (ID) model. Instructional designers utilize the ID model heuristically to design problem-centered and user-centered instruction. Instructional designers also consider the needs of functional diversity, design alignment, design principles, and communication during the design process.`;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>Developing functional instructions does not rely on the compliance of the instructional development (ID) model. Instructional designers utilize the ID model heuristically to design problem-centered and user-centered instruction. Instructional designers also consider the needs of functional diversity, design alignment, design principles, and communication during the design process.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Needs of functional diversity, compliance of theoretical development procedures, design principles, communication, and usage of technology`;
quizQuestions[0][17].answers[1]=`Problem and context, needs of functional diversity, compliance of theoretical development procedures, design principles, communication, and usage of technology`;
quizQuestions[0][17].answers[2]=`Problem and context, needs of functional diversity, design alignment, design principles, and communication`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`What is the role of technology in instructional design project?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>Technology is integrated in different learning activities to serve instructional function and used to support the management, communication, design, and development of learning objects, implementation of instruction, and project evaluation.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>Technology is integrated in different learning activities to serve instructional function and used to support the management, communication, design, and development of learning objects, implementation of instruction, and project evaluation.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Technology is used to supporting the learning and instruction, which is considered during the generation of instructional solution to meet client's requirement`;
quizQuestions[0][18].answers[1]=`Technology is integrated in different learning activities to serve instructional function and used to support the management, communication, design, and development of learning objects, implementation of instruction, and project evaluation`;
quizQuestions[0][18].answers[2]=`Technology is used for the design and development of learning objects in the instructional design project`;
quizQuestions[0][18].key=2;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Why should instructional designers engage in life-long learning in the instructional design field?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b>`;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b>`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`To gain higher-level certificates and get a promotion and a higher salary`;
quizQuestions[0][19].answers[1]=`To keep updated with the field knowledge and skills since instructional design fields keep developing along with learning science development`;
quizQuestions[0][19].answers[2]=`Both answers are correct`;
quizQuestions[0][19].key=3;

