// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};
quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Quantos tipos de avaliação de ID existem?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Existem 3 tipos de avaliação de ID: Formativa, sumativa e confirmativa. `;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Existem 3 tipos de avaliação de ID: Formativa, sumativa e confirmativa. `;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`3`;
quizQuestions[0][0].answers[1]=`6`;
quizQuestions[0][0].answers[2]=`2`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Quem está envolvido na avaliação formativa do design? `;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Tanto os IDs como os formandos estão envolvidos no processo, juntamente com especialistas na matéria e formadores.`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Tanto os IDs como os formandos estão envolvidos no processo, juntamente com especialistas na matéria e formadores.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Instructional designers e grupos de especialistas`;
quizQuestions[0][1].answers[1]=`Instructional designers, especialistas no assunto, formandos e formadores`;
quizQuestions[0][1].answers[2]=`Formandos e estudantes`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Quando é efetuada a avaliação formativa do design? `;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A avaliação sumativa é efetuada no final do processo e a avaliação confirmativa é realizada de forma contínua.`;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A avaliação sumativa é efetuada no final do processo e a avaliação confirmativa é realizada de forma contínua.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`É efetuada antes do processo de design`;
quizQuestions[0][2].answers[1]=`É efetuada durante o processo de design`;
quizQuestions[0][2].answers[2]=`É efetuada após o processo de design`;
quizQuestions[0][2].key=2;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Qual é o objetivo da avaliação sumativa do design?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A avaliação sumativa é efetuada no final do processo de design para determinar se o produto de instrução atinge os resultados pretendidos.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A avaliação sumativa é efetuada no final do processo de design para determinar se o produto de instrução atinge os resultados pretendidos.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Para avaliar a formação e/ou os materiais didáticos no início do processo de design`;
quizQuestions[0][3].answers[1]=`Avaliar a formação e/ou os materiais de formação ao longo do processo de design`;
quizQuestions[0][3].answers[2]=`Para avaliar a formação e/ou os materiais didáticos depois de 
de terem sido finalizados`;
quizQuestions[0][3].key=3;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Quem efetua a avaliação sumativa do design? `;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O objetivo de uma avaliação sumativa é avaliar a formação e/ou os materiais pedagógicos depois de terem sido finalizados.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O objetivo de uma avaliação sumativa é avaliar a formação e/ou os materiais pedagógicos depois de terem sido finalizados.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Avaliadores externos`;
quizQuestions[0][4].answers[1]=`Formandos`;
quizQuestions[0][4].answers[2]=`Instructional designers`;
quizQuestions[0][4].key=1;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Quando é efetuada a avaliação sumativa do design?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os avaliadores externos para os decisores conduzem ou participam frequentemente na avaliação sumativa.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os avaliadores externos para os decisores conduzem ou participam frequentemente na avaliação sumativa.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Antes`;
quizQuestions[0][5].answers[1]=`De forma contínua`;
quizQuestions[0][5].answers[2]=`Depois `;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Por que razão é efetuada a avaliação confirmativa?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A avaliação confirmativa vai além do âmbito da avaliação formativa e sumativa e analisa se o efeito a longo prazo da instrução é o que o ID esperava alcançar.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A avaliação confirmativa vai além do âmbito da avaliação formativa e sumativa e analisa se o efeito a longo prazo da instrução é o que o ID esperava alcançar.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Fornecer feedback para informar o processo de design`;
quizQuestions[0][6].answers[1]=`Avaliar os materiais de formação depois de terem sido finalizados`;
quizQuestions[0][6].answers[2]=`Para determinar o efeito duradouro da formação`;
quizQuestions[0][6].key=3;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Quando deve ser efetuada a avaliação confirmativa?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A avaliação confirmativa deve ser efetuada de forma contínua.`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A avaliação confirmativa deve ser efetuada de forma contínua.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`A avaliação confirmativa deve ser efetuada regularmente`;
quizQuestions[0][7].answers[1]=`A avaliação confirmativa deve ser efetuada no final do processo de design`;
quizQuestions[0][7].answers[2]=`A avaliação confirmativa deve ser efetuada durante o processo de design`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Qual é a melhor forma de assegurar que a garantia de qualidade é cumprida?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A melhor forma de garantir a qualidade do sua formação é através da implementação de normas de garantia de qualidade que devem ser cumpridas desde o início do processo de ID. Isto significa que a qualidade dos materiais produzidos é considerada desde o início, garantindo que são do mais alto nível.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A melhor forma de garantir a qualidade do sua formação é através da implementação de normas de garantia de qualidade que devem ser cumpridas desde o início do processo de ID. Isto significa que a qualidade dos materiais produzidos é considerada desde o início, garantindo que são do mais alto nível.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Deixando-a acontecer naturalmente ao longo do processo de ID`;
quizQuestions[0][8].answers[1]=`Implementando-a desde o início do processo de ID`;
quizQuestions[0][8].answers[2]=`Implementando-a no final do processo de ID`;
quizQuestions[0][8].key=1;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Quantos critérios existem para testar o conteúdo do Instructional Design?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Existem 3 critérios de garantia de qualidade: Eficácia, Eficiência e Envolvimento.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Existem 3 critérios de garantia de qualidade: Eficácia, Eficiência e Envolvimento.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`3`;
quizQuestions[0][9].answers[1]=`5`;
quizQuestions[0][9].answers[2]=`2`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`O que significa eficácia nos 3 Es da garantia de qualidade?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Eficácia significa que os objetivos e os resultados desejados foram atingidos.  Pode ser contabilizada ao longo de todo o processo de design através de testes-piloto e avaliação contínua.`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Eficácia significa que os objetivos e os resultados desejados foram atingidos.  Pode ser contabilizada ao longo de todo o processo de design através de testes-piloto e avaliação contínua.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Isto significa que os objetivos e os resultados desejados foram atingidos`;
quizQuestions[0][10].answers[1]=`Isto significa que as conceções foram criadas dentro dos limites de tempo, orçamento e outras restrições`;
quizQuestions[0][10].answers[2]=`Isto significa que os formandos se envolveram no processo de ID`;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Como é que a eficiência é medida na garantia de qualidade?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A eficiência mede-se em termos de criação de projetos com tempo, orçamento e outras restrições.
Pode ser contabilizada ao longo de todo o processo através de testes contínuos ao longo das fases de conceção e desenvolvimento, calendarizando a participação dos formandos.`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A eficiência mede-se em termos de criação de projetos com tempo, orçamento e outras restrições.
Pode ser contabilizada ao longo de todo o processo através de testes contínuos ao longo das fases de conceção e desenvolvimento, calendarizando a participação dos formandos.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`A eficiência é medida em termos do nível de qualidade dos resultados do curso/conteúdo`;
quizQuestions[0][11].answers[1]=`A eficiência é medida em termos da rapidez com que o processo de ID é concluído`;
quizQuestions[0][11].answers[2]=`A eficiência é medida em termos de conceções criadas dentro do tempo, do orçamento e de outras restrições`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Como é que o compromisso pode ser testado na garantia de qualidade?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>É importante garantir que os formandos tenham a oportunidade de contribuir e de se envolverem numa aprendizagem ativa ao longo de cada etapa de teste do conteúdo de ID.`;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>É importante garantir que os formandos tenham a oportunidade de contribuir e de se envolverem numa aprendizagem ativa ao longo de cada etapa de teste do conteúdo de ID.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Pode ser testada através da contagem do tempo de participação dos formandos`;
quizQuestions[0][12].answers[1]=`Pode ser testada assegurando que existem oportunidades para a contribuição do formando, a aprendizagem ativa e o envolvimento do formando ao longo de cada etapa do processo`;
quizQuestions[0][12].answers[2]=`Pode ser testado durante a fase de pilotos`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`O que são indicadores-chave de desempenho?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os Indicadores Chave de Desempenho ou KPIs, como são frequentemente designados, são medidas quantificáveis que são utilizadas para avaliar o desempenho de um determinado objetivo ao longo do tempo.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os Indicadores Chave de Desempenho ou KPIs, como são frequentemente designados, são medidas quantificáveis que são utilizadas para avaliar o desempenho de um determinado objetivo ao longo do tempo.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`São medidas quantificáveis que são utilizadas para avaliar o desempenho de um determinado objetivo ao longo do tempo`;
quizQuestions[0][13].answers[1]=`São objetivos específicos, mensuráveis, realizáveis, realistas e oportunos`;
quizQuestions[0][13].answers[2]=`Permitem objetivos limitados no tempo`;
quizQuestions[0][13].key=1;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`O que é a validação externa?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A validação externa é uma ferramenta importante na avaliação do processo de cID. Esta fase implica obter a opinião de um Instructional Designer externo ao project para testar os materiais que concebeu.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A validação externa é uma ferramenta importante na avaliação do processo de cID. Esta fase implica obter a opinião de um Instructional Designer externo ao project para testar os materiais que concebeu.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Ajuda a fornecer feedback para informar o processo de pilotagem`;
quizQuestions[0][14].answers[1]=`É o processo de ter um ID externo a testar os materiais que concebeu`;
quizQuestions[0][14].answers[2]=`É o processo de ter alguém dentro da empresa a testar os materiais que concebeu`;
quizQuestions[0][14].key=2;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Porque é que o teste-piloto de material educativo é útil?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os testes-piloto podem ajudar a identificar precocemente as falhas do seu material didático. Testar o seu material didático é uma ótima maneira de ter uma nova visão do material antes de o apresentar ao grupo mais vasto de formandos. `;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os testes-piloto podem ajudar a identificar precocemente as falhas do seu material didático. Testar o seu material didático é uma ótima maneira de ter uma nova visão do material antes de o apresentar ao grupo mais vasto de formandos. `;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Ajuda os instrutores de ID a debater ideias para materiais de aprendizagem educativos`;
quizQuestions[0][15].answers[1]=`É útil fazer alterações depois de o material educativo ter sido utilizado por um grupo alargado de formandos`;
quizQuestions[0][15].answers[2]=`A pilotagem de material educativo permite-lhe destacar quaisquer potenciais falhas ou problemas nos seus materiais antes de serem apresentados a um grupo mais vasto de formandos`;
quizQuestions[0][15].key=3;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`O que é um grupo-piloto? `;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Um grupo-piloto é um grupo de indivíduos que testa o material antes de este ser divulgado ao público-alvo geral. É importante que o grupo piloto tenha dados demográficos semelhantes aos do público-alvo pretendido.`;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Um grupo-piloto é um grupo de indivíduos que testa o material antes de este ser divulgado ao público-alvo geral. É importante que o grupo piloto tenha dados demográficos semelhantes aos do público-alvo pretendido.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`É um grupo de pessoas que criam o conceito dos seus materiais`;
quizQuestions[0][16].answers[1]=`É um grupo de indivíduos que testa o material antes de este ser divulgado ao público-alvo geral`;
quizQuestions[0][16].answers[2]=`É um grupo de indivíduos que são o alvo dos seus materiais`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Quantas etapas tem um teste-piloto?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma etapa piloto tem 5 passos: Planeamento, Preparação, Teste, Avaliação e Implementação.`;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma etapa piloto tem 5 passos: Planeamento, Preparação, Teste, Avaliação e Implementação.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`6`;
quizQuestions[0][17].answers[1]=`5`;
quizQuestions[0][17].answers[2]=`7`;
quizQuestions[0][17].key=2;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`O terceiro passo num teste-piloto é?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Depois de concluída a fase de preparação, pode começar a testar. O teste é realizado por um grupo selecionado de utilizadores finais que testam os materiais como o público-alvo o faria.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Depois de concluída a fase de preparação, pode começar a testar. O teste é realizado por um grupo selecionado de utilizadores finais que testam os materiais como o público-alvo o faria.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Testes`;
quizQuestions[0][18].answers[1]=`Avaliação`;
quizQuestions[0][18].answers[2]=`Implementação`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`O que faz parte de um plano de avaliação?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Uma vez concluído o teste, os utilizadores finais avaliam os materiais. Criam um relatório e enviam quaisquer problemas aos designers, que os corrigem para preparar os materiais para a implementação.`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Uma vez concluído o teste, os utilizadores finais avaliam os materiais. Criam um relatório e enviam quaisquer problemas aos designers, que os corrigem para preparar os materiais para a implementação.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Contém informações da fase de piloto`;
quizQuestions[0][19].answers[1]=`Contém uma visão geral dos objetivos do material, os dados recolhidos para a caracterização da formação e uma lista dos instrumentos de avaliação utilizados`;
quizQuestions[0][19].answers[2]=`Contém uma visão geral do brainstorming inicial de ideias para os materiais`;
quizQuestions[0][19].key=2;

