// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};
var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`O que é a prototipagem?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A prototipagem é o processo de criação de amostras do seu produto que serão testadas e utilizadas pelos formandos, que darão feedback que será depois implementado em produtos futuros.`;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A prototipagem é o processo de criação de amostras do seu produto que serão testadas e utilizadas pelos formandos, que darão feedback que será depois implementado em produtos futuros.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`A prototipagem é o processo de lançamento de um novo produto num novo mercado`;
quizQuestions[0][0].answers[1]=`Prototipagem é o processo de testar um produto num mercado novo ou previamente não testado`;
quizQuestions[0][0].answers[2]=`A prototipagem é o processo de criação de amostras de maquetas para aperfeiçoar um produto`;
quizQuestions[0][0].key=3;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`O que é a experiência do utilizador?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A opção 1 refere-se à interface do utilizador e a opção 3 refere-se ao princípio 2 da estrutura Honeycomb da experiência do utilizador.`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A opção 1 refere-se à interface do utilizador e a opção 3 refere-se ao princípio 2 da estrutura Honeycomb da experiência do utilizador.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`A experiência do utilizador refere-se à apresentação de um produto ou sistema`;
quizQuestions[0][1].answers[1]=`A experiência do utilizador refere-se à forma como os utilizadores interagem e experimentam um produto, sistema ou serviço`;
quizQuestions[0][1].answers[2]=`A experiência do utilizador diz respeito à facilidade com que os clientes utilizam um produto`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`O que é a interface do utilizador?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A interface do utilizador é também conhecida como IU e refere-se à apresentação de um produto ou sistema. `;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A interface do utilizador é também conhecida como IU e refere-se à apresentação de um produto ou sistema. `;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Refere-se à apresentação de um produto ou sistema`;
quizQuestions[0][2].answers[1]=`Refere-se à forma como um produto ou sistema é percebido pelos seus utilizadores`;
quizQuestions[0][2].answers[2]=`Refere-se à forma como os utilizadores interagem e experimentam um produto, sistema ou serviço`;
quizQuestions[0][2].key=1;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Qual é o objetivo do design da interface do utilizador?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O objetivo da design da interface de utilizador é produzir uma interface de utilizador que torne a sua utilização fácil, eficiente e agradável.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O objetivo da design da interface de utilizador é produzir uma interface de utilizador que torne a sua utilização fácil, eficiente e agradável.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`O objetivo da conceção da interface do utilizador é comunicar os benefícios do produto ou sistema aos potenciais utilizadores`;
quizQuestions[0][3].answers[1]=`O objetivo do design da interface do utilizador é criar uma maquete de uma amostra do produto`;
quizQuestions[0][3].answers[2]=`O objetivo da design da interface de utilizador é produzir uma interface de utilizador que seja fácil, eficiente e agradável de utilizar`;
quizQuestions[0][3].key=3;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Quantos princípios existem na Estrutura Honeycomb da Experiência do Utilizador?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os 7 passos da estrutura Honeycomb da Experiência do Utilizador são: Utilizável, Útil, Desejável, Localizável, Acessível, Credível e Valioso.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os 7 passos da estrutura Honeycomb da Experiência do Utilizador são: Utilizável, Útil, Desejável, Localizável, Acessível, Credível e Valioso.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`6`;
quizQuestions[0][4].answers[1]=`7`;
quizQuestions[0][4].answers[2]=`5`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`O primeiro passo da Experiência do Utilizador em favo de mel - "Utilizável" significa: `;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A opção 1 é o Princípio 3: Desejável - da estrutura Honeycomb da Experiência do Utilizador. A opção 2 é o Princípio 6: Credível.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A opção 1 é o Princípio 3: Desejável - da estrutura Honeycomb da Experiência do Utilizador. A opção 2 é o Princípio 6: Credível.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`A estética do sistema deve ser atrativa e fácil de traduzir`;
quizQuestions[0][5].answers[1]=`Deve ser transparente e seguro de utilizar`;
quizQuestions[0][5].answers[2]=`Deve parecer familiar e deve ser fácil de utilizar`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`O princípio "Acessível" da Experiência do Utilizador em Favo de Mel significa`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A opção 1 é o Princípio 6: Credível. A opção 3 é o Princípio 4: Localizável.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A opção 1 é o Princípio 6: Credível. A opção 3 é o Princípio 4: Localizável.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Deve sentir-se familiar e deve ser fácil de utilizar`;
quizQuestions[0][6].answers[1]=`Uma aplicação deve ser acessível a pessoas com deficiência`;
quizQuestions[0][6].answers[2]=`A informação tem de ser fácil de encontrar e de navegar`;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Se todos os 7 princípios da estrutura da experiência do utilizador em favo de mel forem cumpridos, o utilizador final irá:`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A estrutura User Experience Honeycomb foi criada para orientar a conceção da interface do utilizador. Os 7 princípios devem ser tidos em conta na conceção de uma interface de utilizador eficaz e são fundamentais para garantir uma experiência de aprendizagem eficaz para os formandos.`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A estrutura User Experience Honeycomb foi criada para orientar a conceção da interface do utilizador. Os 7 princípios devem ser tidos em conta na conceção de uma interface de utilizador eficaz e são fundamentais para garantir uma experiência de aprendizagem eficaz para os formandos.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Encontre valor e confiança na aplicação`;
quizQuestions[0][7].answers[1]=`Tenha uma amostra de um produto para vender`;
quizQuestions[0][7].answers[2]=`Tenha um produto que seja barato de utilizar`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Quantas etapas existem no processo de Design da Experiência do Utilizador?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os 5 passos do processo de design da experiência do utilizador são: Empatia, Definição, Ideação, Protótipo e Teste.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os 5 passos do processo de design da experiência do utilizador são: Empatia, Definição, Ideação, Protótipo e Teste.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`8`;
quizQuestions[0][8].answers[1]=`7`;
quizQuestions[0][8].answers[2]=`5`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`O que envolve a etapa "Empatia" no processo de design da Experiência do Utilizador? `;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A empatia é a primeira fase do processo de design da experiência do utilizador, em que tem de assumir e compreender os desafios que os utilizadores do seu produto enfrentam.  Isto significa colocar-se na pele dos utilizadores para compreender como se sentem quando utilizam o produto.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A empatia é a primeira fase do processo de design da experiência do utilizador, em que tem de assumir e compreender os desafios que os utilizadores do seu produto enfrentam.  Isto significa colocar-se na pele dos utilizadores para compreender como se sentem quando utilizam o produto.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Ter várias ideias sobre como resolver um problema específico que os formandos têm tendência a encontrar frequentemente`;
quizQuestions[0][9].answers[1]=`Obter feedback dos formandos para criar um produto melhor que satisfaça plenamente as suas necessidades e expectativas`;
quizQuestions[0][9].answers[2]=`Compreender o desafio dos utilizadores do seu produto e colocar-se na pele dos utilizadores para compreender como se sentem quando utilizam o produto`;
quizQuestions[0][9].key=3;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`O que é que envolve a etapa "Definir"? `;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A segunda etapa do processo de Design da Experiência do Utilizador é "Definir". Isto implica ordenar as questões identificadas no primeiro passo pelos seus níveis de importância e efetuar pesquisas para compreender por que razão estes desafios são importantes.`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A segunda etapa do processo de Design da Experiência do Utilizador é "Definir". Isto implica ordenar as questões identificadas no primeiro passo pelos seus níveis de importância e efetuar pesquisas para compreender por que razão estes desafios são importantes.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Esta etapa envolve a classificação das questões identificadas na fase de Empatia pelos seus níveis de importância e a realização de pesquisas para compreender porque é que estes desafios enfrentados são importantes`;
quizQuestions[0][10].answers[1]=`Envolve a definição dos elementos do produto que precisam de ser redesenhados para melhor satisfazer as necessidades dos utilizadores com base nos seus comentários anteriores`;
quizQuestions[0][10].answers[2]=`A etapa de definição consiste em selecionar a melhor ideia para resolver um problema comum que os formandos têm frequentemente`;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Com que frequência deve fazer pesquisas e testes de utilizadores num produto?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A investigação e os testes do utilizador são uma parte fundamental do trabalho do designer de UX e uma parte essencial do processo geral de design de UX. Para garantir que um produto continua a ser eficiente e eficaz, a investigação e os testes do utilizador devem ser efetuados com a maior regularidade possível.`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A investigação e os testes do utilizador são uma parte fundamental do trabalho do designer de UX e uma parte essencial do processo geral de design de UX. Para garantir que um produto continua a ser eficiente e eficaz, a investigação e os testes do utilizador devem ser efetuados com a maior regularidade possível.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Cinco vezes `;
quizQuestions[0][11].answers[1]=`Com a maior frequência possível`;
quizQuestions[0][11].answers[2]=`Uma vez`;
quizQuestions[0][11].key=2;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`O que é que a etapa "Idear" envolve?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Para garantir que o produto continua a ser eficiente e eficaz, repita este processo com a maior regularidade possível.`;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Para garantir que o produto continua a ser eficiente e eficaz, repita este processo com a maior regularidade possível.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Ordenar as questões identificadas por níveis de importância `;
quizQuestions[0][12].answers[1]=`Implica a geração do maior número possível de ideias`;
quizQuestions[0][12].answers[2]=`Coloque-se no lugar do utilizador`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Porque é que os designers UX testam o seu produto? `;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os testes são uma parte fundamental do trabalho do UX designer e uma parte essencial do processo geral de design UX. Os designers de UX testam porque isso lhes permite melhorar o produto original ou o design do sítio e ver se as alterações que fizeram durante a fase de "design" resistem ao escrutínio.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os testes são uma parte fundamental do trabalho do UX designer e uma parte essencial do processo geral de design UX. Os designers de UX testam porque isso lhes permite melhorar o produto original ou o design do sítio e ver se as alterações que fizeram durante a fase de "design" resistem ao escrutínio.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Esta etapa significa que os designers podem identificar melhor os futuros produtos que podem conceber para complementar o que está a ser testado`;
quizQuestions[0][13].answers[1]=`Isto assegura que pode ver quais as mudanças que precisam de ser feitas no seu produto`;
quizQuestions[0][13].answers[2]=`Isto permite-lhe ver se as alterações que fez num produto funcionam e funcionam corretamente`;
quizQuestions[0][13].key=3;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Porque é que a interatividade é tão importante?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A interatividade é uma forma de facilitar o envolvimento dos formandos com a sua disciplina. Ao criar os elementos interativos para a sua disciplina, inclua uma variedade de níveis diferentes para manter o conteúdo atualizado e interessante para os formandos.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A interatividade é uma forma de facilitar o envolvimento dos formandos com a sua disciplina. Ao criar os elementos interativos para a sua disciplina, inclua uma variedade de níveis diferentes para manter o conteúdo atualizado e interessante para os formandos.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Permite aos criadores colocarem-se na pele do utilizador`;
quizQuestions[0][14].answers[1]=`Torna mais fácil para os formandos envolverem-se com o seu conteúdo`;
quizQuestions[0][14].answers[2]=`Permite-lhe fazer alterações a um protótipo`;
quizQuestions[0][14].key=2;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`A que nível se encontra a aprendizagem baseada em jogos?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A aprendizagem baseada em jogos é o nível 4 de interatividade. `;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A aprendizagem baseada em jogos é o nível 4 de interatividade. `;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`4`;
quizQuestions[0][15].answers[1]=`3`;
quizQuestions[0][15].answers[2]=`7`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`Os seguintes softwares são de edição de vídeo, áudio e imagem`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Adobe Premiere, Final Cut Pro, Adobe Photoshop e GIMP são ferramentas de edição de vídeo e imagem. `;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Adobe Premiere, Final Cut Pro, Adobe Photoshop e GIMP são ferramentas de edição de vídeo e imagem. `;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Zoom, Skype e Instagram`;
quizQuestions[0][16].answers[1]=`Adobe Premiere, Final Cut Pro,
Adobe Photoshop e edição GIMP 
`;
quizQuestions[0][16].answers[2]=`Twitter, Microsoft Office, Microsoft Excel`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Há muitas etapas envolvidas no planeamento de qualquer meio de comunicação que crie. O primeiro passo é `;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O Storyboarding é uma ferramenta útil na fase de planeamento da produção de media. Ajuda os criadores a planear e a visualizar um vídeo quadro a quadro.`;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O Storyboarding é uma ferramenta útil na fase de planeamento da produção de media. Ajuda os criadores a planear e a visualizar um vídeo quadro a quadro.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Storyboarding`;
quizQuestions[0][17].answers[1]=`Edição`;
quizQuestions[0][17].answers[2]=`Escrever um guião`;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`O que é a aprendizagem baseada em cenários?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A aprendizagem baseada em cenários permite que os formandos se envolvam numa aprendizagem ativa, apresentando-lhes problemas que têm de ser resolvidos.  Facilita aos formandos o aperfeiçoamento das suas capacidades de tomada de decisão.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A aprendizagem baseada em cenários permite que os formandos se envolvam numa aprendizagem ativa, apresentando-lhes problemas que têm de ser resolvidos.  Facilita aos formandos o aperfeiçoamento das suas capacidades de tomada de decisão.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`A Aprendizagem Baseada em Cenários é quando o aluno recebe informação de um instrutor e absorve a informação de uma forma passiva`;
quizQuestions[0][18].answers[1]=`A aprendizagem baseada em cenários é quando os papéis são invertidos e o formador é ensinado pelo formando`;
quizQuestions[0][18].answers[2]=`A Aprendizagem Baseada em Cenários implica que os formandos se envolvam numa aprendizagem ativa, apresentando-lhes cenários e problemas que têm de ser resolvidos`;
quizQuestions[0][18].key=3;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`O primeiro passo na conceção de um cenário para a SBL deve ser:`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A opção 1 é, de facto, o terceiro passo que deve ser dado na construção de um cenário. A opção 2 é o quinto passo.`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A opção 1 é, de facto, o terceiro passo que deve ser dado na construção de um cenário. A opção 2 é o quinto passo.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Escolha uma situação para o seu cenário`;
quizQuestions[0][19].answers[1]=`Conceber o seu cenário`;
quizQuestions[0][19].answers[2]=`Identificar o seu público-alvo e compreender as suas necessidades`;
quizQuestions[0][19].key=3;

