const ChatBot = {
    baseURL: "https://quest-project.com/chatbot",
    // baseURL: "http://localhost/quest-dev/quest-bot",
    // imgDir: "chatbot/images/",
    imgDir: "lib/images/",
    // audioDir: "chatbot/audio/sfx/",
    audioDir: "lib/audio/sfx/",
    lang: "pt",
    botName: "Herbie",
    botDescription: "Chatbot do Quest",
    botSlogan: "Olá, em que posso ajudar?",
    appClassName: "app-wrapper",
    appBotIcon: "chat-bot-icon",
    showWelcome: true,
    botWelcomeMessage: `<b>Olá, sou o %nome%, o chatbot do Quest.</b><br/>Estou aqui para o ajudar a dominar o ID. <br/>Pode explorar os conceitos abaixo ou utilizar a barra de pesquisa para encontrar um conceito específico mais rapidamente. Pesquise apenas por palavras-chave, por exemplo, "Storyboard".`,

    // GPT CONFIG
    GPT_APIKEY: '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',
    GPT_APIURL: 'https://api.openai.com/v1/chat/completions',
    GPT_MODEL:'gpt-3.5-turbo',
    GPT_MAXTOKENS: 4000, // Model max: 4097
    GPT_TEMPERATURE: 0.8,

    // Don't touch
    primaryMenu: null,
    lastShownMenu: null,
    currentTopic: null,
    currentTopicName: null,
    currentSearch: null,

    sendMessageSound: null,
    receiveMessageSound: null,

    allDBData: null,

    translations: null,

    ShowBotIcon: function(){
        let html = `<div class="` + this.appBotIcon + `"><img src="` + this.imgDir + `bot-hello.gif" onclick="ChatBot.SetupLayout()"></div>`
        $("body").append(html)

        $("body").append("<audio src='" + this.audioDir + "bot-send.mp3' id='isqe-sendSound'></audio>")
        $("body").append("<audio src='" + this.audioDir + "user-receive.mp3' id='isqe-receiveSound'></audio>")

        let html2 = `<div id="chat-bot-popup"><div class="bot-img"><img src="` + this.imgDir + `bot.png"></div>
        <div class="bot-name"></div>
        <div class="bot-description"></div>
        <div class="bot-maximize"><i class="fa-regular fa-window-maximize"></i></div>
        <div class="bot-close"><i class="fa-solid fa-xmark"></i></div>
        </div>`
        $("body").append(html2)

        $("#chat-bot-popup").find(".bot-name").text(this.botName)
        $("#chat-bot-popup").find(".bot-description").text(this.botSlogan)


        $("#" + this.appClassName).append(html)

        ChatBot.GetPrimaryMenu()
    },

    SetupLayout: function(){
        $("body").append("<div id='"+ this.appClassName + "'></div>")
        let html = `<div class="app-header"><div class="bot bot-img"><img src="` + this.imgDir + `bot.png"></div><div class="bot bot-name"></div><div class="bot bot-description"></div><div class="bot bot-close"><i class="fa-solid fa-xmark"></i></div><div class="bot bot-minimize"><i class="fa-solid fa-minus"></i></div></div><div class="chat"></div><div class="app-footer"><textarea class="write-area" placeholder="${ChatBot.translations["search_bar_placeholder"]}" rows="1"></textarea><button class="search-icon"><i class="fa-solid fa-magnifying-glass"></i></button></div>`
        //let html = `<div class="app-header"><div class="bot bot-img"><img src="lib/images/bot.png"></div><div class="bot bot-name"></div></div><div class="chat"></div>`
        $("#" + this.appClassName).append(html)

        ChatBot.SetBotName()
        ChatBot.SetBotDescription()

        ChatBot.ShowWelcomeMessage()
        
        setTimeout(() => {
            ChatBot.ShowPrimaryMenu()
        }, 1000);

        // Register events

        $(".search-icon").click(function() {
            let message = $(".write-area").val()
            $(".write-area").val("")

            if(message != "")
                ChatBot.SearchGlossary(message)

            ChatBot.currentSearch = message
        })
        $(".bot-close").click(function(){
            ChatBot.CloseBot()
        })
        $(".bot-minimize").click(function(){
            ChatBot.MinimizeBot()
        })
        

        $(".write-area").on('keypress',function(e) {
            if(e.which == 13) {
                e.preventDefault()
                let message = $(".write-area").val()
                $(".write-area").val("")
                
                if(message != "")
                    ChatBot.SearchGlossary(message)

                ChatBot.currentSearch = message
            }
        })


    },

    SetBotName: function(){
        $(".bot.bot-name").text(this.botName)
    },

    SetBotDescription: function(){
        $(".bot.bot-description").text(this.botDescription)
    },

    ShowBotImage: function(){
        let html = `<img class="bot-thinking inactive" src="` + this.imgDir + `bot.png">`
        $(".chat").append(html)
    },

    ShowWelcomeMessage: function(){
        if(this.showWelcome){
            ChatBot.ShowBotImage()
            let welcomeMessage = this.botWelcomeMessage
            welcomeMessage = welcomeMessage.replace("%nome%", this.botName)
            ChatBot.BotSendMessage(welcomeMessage)
        }
    },

    HideBotIcons: function(){
        for(let i = 1 ; i < $('.bot-thinking.inactive').length ; i++){
            if(i > 1 && i < $('.bot-thinking.inactive').length){
                $('.bot-thinking.inactive')[i - 1].remove()
            }
        }
    },

    UserSendMessage: function(message){
        ChatBot.PlaySound("user")
        ChatBot.ScrollWindowToBottom()
        if(message != ""){
            let html = `<div class="bubble-quest bubble-quest-bot reply"><span class="bubble-quest-bot-content animated fade-in">` + message + `</span></div>`
            $(".chat").append(html)
            setTimeout(() => {
                $( ".bubble-quest-bot.reply" ).last().addClass("say")
            }, 100);
        }
    },

    BotSendMessage: function(message){
        ChatBot.PlaySound("bot")
        ChatBot.ScrollWindowToBottom()

        ChatBot.HideBotIcons()

        let currentTimeMillis = $.now();

        let html = `<div class="bubble-quest bubble-quest-bot say" data-time="${currentTimeMillis}"><span class="bubble-quest-bot-content animated fade-in">` + message + `</span></div>`
        $(".chat").append(html)
        // setTimeout(() => {
        //     $( ".bubble-quest-bot-content").last().addClass("").addClass("")
        // }, 250);
        ChatBot.ScrollWindowToBottom()
    },

    ShowTime: function(){
        let justNow = ChatBot.translations["just_now"]

        let html = `<div class="time">` + justNow + `</div>`
        $(".chat").append(html)
    },

    UpdateTime: function(){
        let currentTimeMillis = $.now();
        let currentDate = new Date(currentTimeMillis);
        $('.time').each(function(i, obj) {
            var oldTime = parseInt($(obj).prev().attr("data-time"))
            oldTime = new Date(oldTime)
            var difference = currentDate.getTime() - oldTime.getTime();
            var resultInMinutes = Math.round(difference / 60000);
            // console.log(resultInMinutes)
            if(resultInMinutes == 0){
                $(obj).text(ChatBot.translations["just_now"])
            }else if(resultInMinutes == 1){
                $(obj).text(ChatBot.translations["1_min_ago"].replace("%s", resultInMinutes))
            }else if(resultInMinutes > 1){
                $(obj).text(ChatBot.translations["min_ago"].replace("%s", resultInMinutes))
            }
        });
    },

    CloseBot: function() {
        $("#" + this.appClassName).remove()
    },

    MinimizeBot: function() {
        $("#chat-bot-popup").click(function(){
            $("#chat-bot-popup").fadeOut(350)
            $("#" + ChatBot.appClassName).removeClass("minimized")
            setTimeout(() => {
                $(".chat-bot-icon").show()
            }, 450);
        })

        $(".chat-bot-icon").hide()
        $("#" + this.appClassName).addClass("minimized")
        setTimeout(() => {
            $("#chat-bot-popup").fadeIn(350)
        }, 350);
    },

    ResetBot: function() {
        $("#" + this.appClassName).remove()
        ChatBot.SetupLayout()
    },

    PlaySound: function(type){
        switch (type) {
            case "bot":
                $("#isqe-sendSound")[0].play()
                break;
            case "user":
                $("#isqe-receiveSound")[0].play()
                break;
            default:
                break;
        }
    },

    GetPrimaryMenu: function(){
        fetch(ChatBot.baseURL + '/functions/api.php?action=getData')
        .then(response => response.json())
        .then(data => {
            // Filtrar as opções que não possuem parent_id
            const options = data.filter(option => !option.parent_id).sort((a, b) => a.id - b.id);

            // Criar um novo array com as posições seguidas
            const menu = options.reduce((acc, option, index) => {
              acc[index + 1] = option;
              return acc;
            }, {});
        
            this.primaryMenu = menu
          })
        .catch(error => console.error(error));        
    },

    ShowPrimaryMenu: function(showSearchBing){
        if(this.primaryMenu){
            if(showSearchBing){
                let optionHtml = ``
                optionHtml += "<ul class='bot bot-answer-list primary'>"
                optionHtml += `<li class="bot bot-answer" data-option="search"><b>Procurar na Web</b> "${showSearchBing}"</li>`;
                optionHtml += `<li class="bot bot-answer" data-option="chatgpt">Perguntar ao <b>ChatGPT</b></li>`;
                optionHtml += "<br/>"
                optionHtml += `<span class='span-option'>Saber sobre um dos conceitos abaixo:</span><br/><br/>`
                for (const [id, option] of Object.entries(this.primaryMenu)) {
                    optionHtml += `<li class="bot bot-answer" data-id="${option.id}" data-target="${option.target}" data-parent="${option.parent_id}" data-level="${option.level}">${option.text}</li>`;
                }
                optionHtml += "</ul>"
                ChatBot.BotSendMessage(optionHtml)
                ChatBot.ShowTime()

                $(".bot-answer-list").last().find("li").click(function() {
                    $(this).addClass("selected")

                    if($(this).attr("data-option") == "search"){
                        ChatBot.SearchBing(showSearchBing)
                    }else if($(this).attr("data-option") == "chatgpt"){
                        ChatBot.SearchGPT(showSearchBing)
                    }else{
                        $(this).parent().addClass("disabled")
                        let selectedId = $(this).attr("data-id")
                        let parentId = $(this).attr("data-parent")
                        let parentLevel = $(this).attr("data-level")
                        let answerTarget = $(this).attr("data-target")
                        let answerText = $(this).text()
                        ChatBot.UserSendMessage(answerText)
                        // ChatBot.AddDefaultOptions(origin, true)
                        ChatBot.ShowSummary(selectedId)
                        ChatBot.currentTopicName = answerText
                    }
                })
            }else{
                let optionHtml = `<span class='span-option'>${ChatBot.translations["select_topics_below"]}</span><br/><br/>`
                optionHtml += "<ul class='bot bot-answer-list primary'>"
                for (const [id, option] of Object.entries(this.primaryMenu)) {
                    optionHtml += `<li class="bot bot-answer" data-id="${option.id}" data-target="${option.target}" data-parent="${option.parent_id}" data-level="${option.level}">${option.text}</li>`;
                }
                optionHtml += "</ul>"
                ChatBot.BotSendMessage(optionHtml)
                ChatBot.ShowTime()

                $(".bot-answer-list").last().find("li").click(function() {
                    $(this).addClass("selected")
                    $(this).parent().addClass("disabled")
                    let selectedId = $(this).attr("data-id")
                    let parentId = $(this).attr("data-parent")
                    let parentLevel = $(this).attr("data-level")
                    let answerTarget = $(this).attr("data-target")
                    let answerText = $(this).text()
                    ChatBot.UserSendMessage(answerText)
                    // ChatBot.AddDefaultOptions(origin, true)
                    ChatBot.ShowSummary(selectedId)
                    ChatBot.currentTopicName = answerText
                })
            }
            
        }
    },


    ScrollWindowToBottom: function(){
        let chatWindow = $(".chat")
        chatWindow.scrollTop(chatWindow[0].scrollHeight);
    },

    ShowBotThinking: function(time){
        let botThinking = `
        <video loop autoplay class="bot-thinking">
            <source src="` + this.imgDir + `bot-thinking.webm" type="video/webm">
        </video>`

        $(".chat").append(botThinking)
        var video = $('.bot-thinking').last()[0]

        if(time === undefined)
            time = 5000
                
        setTimeout(() => {
    
            video.load()

            setTimeout(() => {
                ChatBot.ScrollWindowToBottom()
            }, 150);
        }, 500);

        if(time != "unlimited"){
            setTimeout(() => {
                let lastBotThinking = $(".bot-thinking").last()
                let html = `<img class="bot-thinking inactive" src="` + this.imgDir + `bot.png">`
                $(html).insertBefore(lastBotThinking)
                video.currentTime = 0
                video.pause()
                lastBotThinking.remove()
            }, time);
        }
    },

    ShowBotThinkingConfused: function(time, termToSearch){
        let botThinking = `
        <video loop autoplay class="bot-thinking-confused">
            <source src="` + this.imgDir + `bot-confused.webm" type="video/webm">
        </video>`

        if(time === undefined)
            time = 6000
                
        setTimeout(() => {
            $(".chat").append(botThinking)
            setTimeout(() => {
                ChatBot.ScrollWindowToBottom()
            }, 150);
        }, 500);

        setTimeout(() => {
            let lastBotThinking = $(".bot-thinking-confused").last()

            // Get the video and source elements
            var video = lastBotThinking[0];
            var source = lastBotThinking.find("source")[0];

            // Change the source of the video
            video.pause();
            // source.src = 'lib/images/bot-confused2.webm';
            // video.load(); // load the new source

            // // Play the video
            // video.play();
            ChatBot.BotSendMessage(ChatBot.translations["search_cant_find"])
            ChatBot.ShowPrimaryMenu(termToSearch)
        }, time);
    },

    StopBotThinking: function(){
        let lastBotThinking = $(".bot-thinking").last()
        let html = `<img class="bot-thinking inactive" src="` + this.imgDir + `bot.png">`
        $(html).insertBefore(lastBotThinking)

        // Get the video and source elements
        var video = lastBotThinking[0];
        var source = lastBotThinking.find("source")[0];

        video.currentTime = 0
        video.pause()
        lastBotThinking.remove()
    },
    
    // Custom

    AddDefaultOptions: function(origin, showBotThinking){
        let html
        if(showBotThinking){
            let timeout = 3500
            ChatBot.ShowBotThinking(timeout)
            setTimeout(() => {
                ChatBot.BotSendMessage(ChatBot.translations["lets_go"])
                setTimeout(() => {
                    html = `<span class='span-option'>${ChatBot.translations["select_option"]}</span><br/><br/>`
                    html += `<ul class="bot bot-answer-list" data-id="${origin.id}" data-parent="${origin.parent}" data-level="${origin.level}">`
                    html += `<li class="bot bot-answer" data-option="resumo">${ChatBot.translations["read_summary"]}</li>`
                    html += `<li class="bot bot-answer" data-option="saber-mais">${ChatBot.translations["learn_about"]}</li>`
                    html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                    html += "</ul>"
                    ChatBot.BotSendMessage(html)
                    SetupDefaultOptions()
                }, 1000);
            }, timeout);
        }else{
            ChatBot.BotSendMessage(ChatBot.translations["lets_go"])
            setTimeout(() => {
                html = `<span class='span-option'>${ChatBot.translations["select_option"]}</span><br/><br/>`
                html += `<ul class="bot bot-answer-list" data-id="${origin.id}" data-parent="${origin.parent}" data-level="${origin.level}">`
                html += `<li class="bot bot-answer" data-option="resumo">${ChatBot.translations["read_summary"]}</li>`
                html += `<li class="bot bot-answer" data-option="saber-mais">${ChatBot.translations["learn_about"]}</li>`
                html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                html += "</ul>"
                ChatBot.BotSendMessage(html)
                ChatBot.ShowTime()
                SetupDefaultOptions()
            }, 1000);
            
        }

        function SetupDefaultOptions(){
            ChatBot.lastShownMenu = html

            $(".bot-answer-list").last().find("li").click(function() {
                $(this).addClass("selected")
                $(this).parent().addClass("disabled")
                let option = $(this).attr("data-option")
                let answerText = $(this).text()
                let parentId = $(this).parent().attr("data-id")
                ChatBot.UserSendMessage(answerText)
                
                switch (option) {
                    case "resumo":
                        ChatBot.ShowSummary(parentId)
                        break;
                    case "saber-mais":
                        ChatBot.ShowSubThemes(parentId)
                        break;
                    case "voltar":
                        ChatBot.ShowLastShownMenu()
                        // ChatBot.ShowPrimaryMenu()
                        break;
                    default:
                        break;
                }
            })
        }
    },

    ShowSubThemes: function(parent_id){

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSubThemes&parent_id=' + parent_id)
        .then(response => response.json())
        .then(data => {
            ChatBot.ShowBotThinking(3500)
            setTimeout(() => {
                ChatBot.BotSendMessage(`${ChatBot.translations["lets_talk_about"]} <b>${ChatBot.currentTopicName}</b>!`)

                let optionHtml = `<span class='span-option'>${ChatBot.translations["delve_deeper"]} </span><br/><br/>`
                optionHtml += "<ul class='bot bot-answer-list'>"
                for (const [id, option] of Object.entries(data)) {
                    optionHtml += `<li class="bot bot-answer" data-id="${option.id}" data-option="answer" data-target="${option.target}" data-parent="${option.parent_id}" data-level="${option.level}">${option.text}</li>`;
                }
                optionHtml += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                optionHtml += "</ul>"

                setTimeout(() => {
                    ChatBot.BotSendMessage(optionHtml)
                    
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let optionid = $(this).attr("data-id")
                        let answerText = $(this).text()
                        ChatBot.UserSendMessage(answerText)
    
                        ChatBot.lastShownMenu = optionHtml

                        ChatBot.lastFunc = "ShowSubThemes"
                        ChatBot.lastId = parent_id

                        switch (option) {
                            case "answer":
                                ChatBot.currentTopicName = answerText
                                ChatBot.ShowSummary2(optionid)
                                break;
                            case "voltar":
                                ChatBot.currentTopicName = answerText
                                ChatBot.ShowLastShownMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, 1000);
                
            }, 3500);
          })
        .catch(error => console.error(error));
    },

    ShowSubThemes2: function(parent_id){
        let subTheme = ChatBot.currentTopicName

        ChatBot.ShowBotThinking(3500)

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSubThemes&parent_id=' + parent_id)
        .then(response => response.json())
        .then(data => {
            setTimeout(() => {
                ChatBot.BotSendMessage(`${ChatBot.translations["explore_theme"]} <b>${subTheme}</b>!`)
                ChatBot.currentTopic = parent_id
    
                let optionHtml = `<span class='span-option'>${ChatBot.translations["content_see"]} </span><br/><br/>`
                optionHtml += "<ul class='bot bot-answer-list'>"
                for (const [id, option] of Object.entries(data)) {
                    optionHtml += `<li class="bot bot-answer" data-id="${option.id}" data-option="answer" data-target="${option.target}" data-parent="${option.parent_id}" data-level="${option.level}">${option.text}</li>`;
                }
                optionHtml += `<li class="bot bot-answer goback" data-option="voltar">PREVIOUS</li>`
                optionHtml += "</ul>"

                setTimeout(() => {
                    ChatBot.BotSendMessage(optionHtml)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let optionId = $(this).attr("data-id")
                        let answerText = $(this).text()
                        ChatBot.UserSendMessage(answerText)
                        
                        ChatBot.currentTopicName = answerText
                        ChatBot.lastShownMenu = optionHtml

                        ChatBot.lastFunc = "ShowSubThemes2"
                        ChatBot.lastId = parent_id
        
                        switch (option) {
                            case "answer":
                                ChatBot.ShowSummary2(optionId)
                                ChatBot.currentTopic = optionId
                                break;
                            case "voltar":
                                ChatBot.ShowBotThinking(3500)
                                setTimeout(() => {
                                    ChatBot.ShowLastShownMenu()
                                    // ChatBot.ShowPrimaryMenu()
                                }, 3500);
                                break;
                            default:
                                break;
                        }
                    })
                }, 1000);
                
            }, 3500);
          })
        .catch(error => console.error(error));
    },

    ShowSubThemes3: function(parent_id){
        let subTheme = ChatBot.currentTopicName

        ChatBot.ShowBotThinking(3500)

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSubThemes&parent_id=' + parent_id)
        .then(response => response.json())
        .then(data => {
            setTimeout(() => {
                ChatBot.currentTopic = parent_id

                ChatBot.BotSendMessage(`${ChatBot.translations["consult_covered_concepts"]} <b>${subTheme}</b>!​`)
    
                let optionHtml = `<span class='span-option'>${ChatBot.translations["content_see"]}</span> <br/><br/>`
                optionHtml += "<ul class='bot bot-answer-list'>"
                for (const [id, option] of Object.entries(data)) {
                    optionHtml += `<li class="bot bot-answer" data-id="${option.id}" data-option="answer" data-target="${option.target}" data-parent="${option.parent_id}" data-level="${option.level}">${option.text}</li>`;
                }
                optionHtml += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                optionHtml += "</ul>"

                setTimeout(() => {
                    ChatBot.BotSendMessage(optionHtml)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let optionId = $(this).attr("data-id")
                        let answerText = $(this).text()
                        ChatBot.UserSendMessage(answerText)
    
                        ChatBot.currentTopicName = answerText
                        ChatBot.lastShownMenu = optionHtml

                        ChatBot.lastFunc = "ShowSubThemes3"
                        ChatBot.lastId = parent_id

                        switch (option) {
                            case "answer":
                                ChatBot.ShowSummary3(optionId)
                                break;
                            case "voltar":
                                ChatBot.ShowBotThinking(3500)
                                setTimeout(() => {
                                    ChatBot.ShowLastShownMenu()
                                    // ChatBot.ShowPrimaryMenu()
                                }, 3500);
                                break;
                            default:
                                break;
                        }
                    })
                }, 1000);
            }, 3500);
          })
        .catch(error => console.error(error));
    },

    ShowSubThemes4: function(parent_id){
        let subTheme = ChatBot.currentTopicName

        ChatBot.ShowBotThinking(3500)

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSubThemes&parent_id=' + parent_id)
        .then(response => response.json())
        .then(data => {
            setTimeout(() => {
                ChatBot.currentTopic = parent_id

                // ChatBot.BotSendMessage(`${ChatBot.translations["consult_covered_concepts"]} <b>"${subTheme}"</b>!​`)
                ChatBot.BotSendMessage(`${ChatBot.translations["testing_my_database"]} <br/><br/>${ChatBot.translations["look_concepts"]}​`)
    
                let optionHtml = `<span class='span-option'>${ChatBot.translations["which_concept"]}</span> <br/><br/>`
                optionHtml += "<ul class='bot bot-answer-list'>"
                for (const [id, option] of Object.entries(data)) {
                    optionHtml += `<li class="bot bot-answer" data-id="${option.id}" data-option="answer" data-target="${option.target}" data-parent="${option.parent_id}" data-level="${option.level}">${option.text}</li>`;
                }
                optionHtml += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                optionHtml += "</ul>"

                setTimeout(() => {
                    ChatBot.BotSendMessage(optionHtml)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let optionId = $(this).attr("data-id")
                        let answerText = $(this).text()
                        ChatBot.UserSendMessage(answerText)

                        ChatBot.currentSearch = answerText
                        ChatBot.currentTopicName = answerText
                        ChatBot.lastShownMenu = optionHtml

                        ChatBot.lastFunc = "ShowSubThemes4"
                        ChatBot.lastId = parent_id
        
                        switch (option) {
                            case "answer":
                                ChatBot.ShowSummary4(optionId)
                                break;
                            case "voltar":
                                ChatBot.ShowBotThinking(3500)
                                setTimeout(() => {
                                    ChatBot.ShowLastShownMenu()
                                    // ChatBot.ShowPrimaryMenu()
                                }, 3500);
                                break;
                            default:
                                break;
                        }
                    })
                }, 1000);
            }, 3500);
          })
        .catch(error => console.error(error));
    },

    ShowSummary: function(topic){
        ChatBot.currentTopic = topic

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSummary&id=' + topic)
        .then(response => response.json())
        .then(data => {
            if(data === null || data === "" || data === undefined){
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["not_found"])
                    let html = "Selecione uma opção: <br/><br/>"
                    html += `<ul class="bot bot-answer-list">`
                    html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                    html += "</ul>"
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()

                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let answerText = $(this).text()
                        let option = $(this).attr("data-option")
                        ChatBot.UserSendMessage(answerText)

                        ChatBot.lastFunc = "ShowSummary"
                        ChatBot.lastId = topic
            
                        switch (option) {
                            case "voltar":
                                ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }else{
                ChatBot.currentTopicName = data.text

                if(data.parent_id === null || data.parent_id === undefined || data.parent_id === "")
                    data.parent_id = 1

                    // let summary = `${ChatBot.translations["topic_summary"]} ` + "<b>" + data.text + ":</b><br/><br/>"
                let summary = `<b>` + data.text + `:</b><br/><br/>`
                summary += data.summary
                summary += "<br/><br/>"
                let html = `${ChatBot.translations["want_know_more"]}<br/>`
                html += `<ul class="bot bot-answer-list" data-parent="${data.parent_id}" data-level="${data.level}">`
                html += `<li class="bot bot-answer" data-option="consultar-temas">${ChatBot.translations["learn_about1"]}</li>`
                html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                html += "</ul>"
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["lets_go"])
                    ChatBot.BotSendMessage(summary)
                    ChatBot.BotSendMessage(html)


                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let answerText = $(this).text()
                        let parentLevel = $(this).parent().attr("data-level")
                        let parentId = $(this).parent().attr("data-parent")
                        ChatBot.UserSendMessage(answerText)

                        ChatBot.lastFunc = "ShowSummary"
                        ChatBot.lastId = 1
            
                        switch (option) {
                            case "consultar-temas":
                                ChatBot.ShowSubThemes(ChatBot.currentTopic)
                                break;
                            case "voltar":
                                ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }
          })
        .catch(error => console.error(error));
    },

    ShowSummary2: function(optionId){
        let subTheme = ChatBot.currentTopicName
        ChatBot.currentTopic = optionId

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSummary&id=' + optionId)
        .then(response => response.json())
        .then(data => {
            if(data === null || data === "" || data === undefined){
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["not_found"])
                    let html = `${ChatBot.translations["select_option"]} <br/><br/>`
                    html += `<ul class="bot bot-answer-list">`
                    html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                    html += "</ul>"
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let answerText = $(this).text()
                        let option = $(this).attr("data-option")
                        ChatBot.UserSendMessage(answerText)

                        ChatBot.lastShownMenu = html
            
                        switch (option) {
                            case "voltar":
                                ChatBot.ShowLastShownMenu()
                                // ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }else{
                let summary = "<b>" + subTheme + ":</b><br/><br/>"
                summary += data.summary
                summary += "<br/><br/>"
                let html = `${ChatBot.translations["satisfy_curiosity"]}<br/>`
                html += `<ul class="bot bot-answer-list" data-parent="${data.parent_id}" data-level="${data.level}">`
                html += `<li class="bot bot-answer" data-option="consultar-conceitos">${ChatBot.translations["covered_concepts"]}</li>`
                html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                html += "</ul>"
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["good_choice"])
                    ChatBot.BotSendMessage(summary)
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let answerText = $(this).text()
                        let parentLevel = $(this).parent().attr("data-level")
                        let parentId = $(this).parent().attr("data-parent")
                        ChatBot.UserSendMessage(answerText)

                        summary += html
                        ChatBot.lastShownMenu = summary

                        switch (option) {
                            case "consultar-conceitos":
                                fetch(ChatBot.baseURL + '/functions/api.php?action=hasChilds&id=' + ChatBot.currentTopic)
                                .then(response => response.json())
                                .then(linha => {
                                    if(linha.contador > 0){
                                        let level = parseInt(linha.level)
                                        switch (level) {
                                            case 3:
                                                ChatBot.ShowSubThemes3(ChatBot.currentTopic)
                                                break;
                                            case 4:
                                                ChatBot.ShowSubThemes4(ChatBot.currentTopic)
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                })
                                .catch(erro => console.error(erro));
                                break;
                            case "voltar":
                                ChatBot.ShowLastShownMenu()
                                // ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }
          })
        .catch(error => console.error(error));

    },

    ShowSummary3: function(optionId){
        let subTheme = ChatBot.currentTopicName

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSummary&id=' + optionId)
        .then(response => response.json())
        .then(data => {
            if(data === null || data === "" || data === undefined){
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["not_found"])
                    let html = `${ChatBot.translations["select_option"]} <br/><br/>`
                    html += `<ul class="bot bot-answer-list">`
                    html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                    html += "</ul>"
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let answerText = $(this).text()
                        let option = $(this).attr("data-option")
                        ChatBot.UserSendMessage(answerText)
            
                        switch (option) {
                            case "voltar":
                                ChatBot.ShowLastShownMenu()
                                // ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }else{

                let summary = "<b>" + subTheme + ":</b><br/><br/>"
                summary += data.summary
                summary += "<br/><br/>"
                let html = ChatBot.translations["helpful_information2"]
                html += `<ul class="bot bot-answer-list" data-parent="${data.parent_id}" data-level="${data.level}">`
                html += `<li class="bot bot-answer" data-option="answer">${ChatBot.translations["want_more_information2"]}</li>`
                html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["previous"]}</li>`
                html += "</ul>"
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["drive_content"])
                    ChatBot.BotSendMessage(summary)
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let answerText = $(this).text()
                        let parentLevel = $(this).parent().attr("data-level")
                        let parentId = $(this).parent().attr("data-parent")
                        ChatBot.UserSendMessage(answerText)

                        summary += html
                        ChatBot.lastShownMenu = summary
            
                        switch (option) {
                            case "answer":
                                ChatBot.ShowSubThemes4(optionId)
                                break;
                            case "reset":
                                // ChatBot.ShowPrimaryMenu()
                                ChatBot.ShowLastShownMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }
          })
        .catch(error => console.error(error));

    },

    ShowSummary4: function(optionId){
        let subTheme = ChatBot.currentTopicName

        fetch(ChatBot.baseURL + '/functions/api.php?action=getSummary&id=' + optionId)
        .then(response => response.json())
        .then(data => {
            if(data === null || data === "" || data === undefined){
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["not_found"])
                    let html = `${ChatBot.translations["select_option"]} <br/><br/>`
                    html += `<ul class="bot bot-answer-list">`
                    html += `<li class="bot bot-answer goback" data-option="voltar">${ChatBot.translations["previous"]}</li>`
                    html += "</ul>"
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let answerText = $(this).text()
                        let option = $(this).attr("data-option")
                        ChatBot.UserSendMessage(answerText)
            
                        switch (option) {
                            case "voltar":
                                ChatBot.ShowLastShownMenu()
                                // ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }else{

                let summary = "<b>" + subTheme + ":</b><br/><br/>"
                summary += data.summary
                summary += "<br/><br/>"
                let html = ChatBot.translations["helpful_information"]
                html += `<ul class="bot bot-answer-list" data-parent="${data.parent_id}" data-level="${data.level}">`
                html += `<li class="bot bot-answer" data-option="answer">${ChatBot.translations["want_more_information"]}</li>`
                html += `<li class="bot bot-answer" data-option="answer">${ChatBot.translations["dont_want_more_information"]}</li>`
                html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["previous"]}</li>`
                html += "</ul>"
                let time = 3000
                ChatBot.ShowBotThinking(time)
                setTimeout(() => {
                    ChatBot.BotSendMessage(ChatBot.translations["delve_concept"])
                    ChatBot.BotSendMessage(summary)
                    ChatBot.BotSendMessage(html)
                    ChatBot.ShowTime()
                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let answerText = $(this).text()
                        let parentLevel = $(this).parent().attr("data-level")
                        let parentId = $(this).parent().attr("data-parent")
                        ChatBot.UserSendMessage(answerText)

                        summary += html
                        ChatBot.lastShownMenu = summary
            
                        switch (option) {
                            case "answer":
                                ChatBot.FinalAnswer(optionId)
                                break;
                            case "reset":
                                ChatBot.ShowLastShownMenu()
                                // ChatBot.ShowPrimaryMenu()
                                break;
                            default:
                                break;
                        }
                    })
                }, time);
            }
          })
        .catch(error => console.error(error));

    },

    FinalAnswer: function(optionid){
        ChatBot.ShowBotThinking(3500)
        fetch(ChatBot.baseURL + '/functions/api.php?action=getOption&id=' + optionid)
        .then(response => response.json())
        .then(data => {
            let links = data.referencias
            setTimeout(() => {

                if(links != null && links.length > 0){
                    links = links.split(';');
                    let text = ChatBot.translations["final_know_more2"] + `<br/><br/>`
                    text += ChatBot.translations["final_know_more_goto"] + `<b>${data.caminho}</b>`
                    // text += `<br/><br/>${ChatBot.translations["final_or"]}`
                    text += `<br/><br/>${ChatBot.translations["final_click_links"]}`
                    let html = `<ul class="bot bot-answer-list">`

                    function truncate(str, n){
                        return (str.length > n) ? str.slice(0, n-1) + '&hellip;' : str;
                    };
                    
                    links.forEach(element => {
                        html += `<li class="bot bot-answer" data-option="answer" data-link='${element}'>${truncate(element, 30)}</li>`
                       
                    });
                    html += `<br/><br/>`
                    html += `<li class="bot bot-answer" data-option="search">Procurar na Web "${ChatBot.currentSearch}"</li>`
                    html += `<br/><br/>`
                    html += `<li class="bot bot-answer" data-option="chatgpt">Perguntar ao <b>ChatGPT</b></li>`
                    html += `<br/><br/>`
                    html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["final_back_home"]}</li>`
                    html += "</ul>"
                    text += html
        
                    ChatBot.BotSendMessage(text)

                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        // $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
                        let target = $(this).attr("data-link")
            
                        switch (option) {
                            case "answer":
                                window.open(target, '_blank')
                                break;
                            case "search":
                                ChatBot.SearchBing(ChatBot.currentSearch)
                                break;
                            case "chatgpt":
                                ChatBot.SearchGPT(ChatBot.currentSearch)
                                break;
                            case "reset":
                                ChatBot.ResetBot()
                                break;
                            default:
                                break;
                        }
                    })
                }else {
                    let text = ""
                    let html = ""
                    if(ChatBot.currentSearch){
                        text = ChatBot.translations["final_know_more2"]
                        text += `<br/><br/>` + ChatBot.translations["final_know_more_goto"] + `<b>${data.caminho}</b><br/><br/>`
                        text += "<ul class='bot bot-answer-list'>"
                        text += `<li class="bot bot-answer" data-option="search"><b>Procurar na Web</b> "${ChatBot.currentSearch}"</li>`;
                        text += `<li class="bot bot-answer" data-option="chatgpt">Perguntar ao <b>ChatGPT</b></li>`
                        html = "<br/>"
                        html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["final_back_home"]}</li>`
                        html += "</ul>"
                        text += html

                        ChatBot.BotSendMessage(text)
    
                        $(".bot-answer-list").last().find("li").click(function() {
                            $(this).addClass("selected")
                            $(this).parent().addClass("disabled")
                            let option = $(this).attr("data-option")
                
                            switch (option) {
                                case "search":
                                    ChatBot.SearchBing(ChatBot.currentSearch)
                                    break;
                                case "chatgpt":
                                    ChatBot.SearchGPT(ChatBot.currentSearch)
                                    break;
                                case "reset":
                                    ChatBot.ResetBot()
                                    break;
                                default:
                                    break;
                            }
                        })

                    }else{
                        text = ChatBot.translations["final_know_more"] + `<b>${data.caminho}</b>`
                        html = `<ul class="bot bot-answer-list">`
                        html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["final_back_home"]}</li>`
                        html += "</ul>"
                        text += html
    
                        ChatBot.BotSendMessage(text)
    
                        $(".bot-answer-list").last().find("li").click(function() {
                            $(this).addClass("selected")
                            $(this).parent().addClass("disabled")
                            let option = $(this).attr("data-option")
                
                            switch (option) {
                                case "reset":
                                    ChatBot.ResetBot()
                                    break;
                                default:
                                    break;
                            }
                        })
                    }
                }
                
                ChatBot.ShowTime()

            }, 3500)
        })
        .catch(error => console.error(error));
    },

    SearchGlossary: function(term){
        let upperTerm = term.toUpperCase()

        ChatBot.UserSendMessage(term)
        ChatBot.ScrollWindowToBottom()

        fetch(ChatBot.baseURL + '/functions/api.php?action=searchBD&term=' + upperTerm)
        .then(response => response.json())
        .then(lines => {
            if(lines.length == 1) {
                if(lines[0].IDOption){
                    ChatBot.ShowGlossary(0, true, lines[0].IDOption, lines[0].text)
                    setTimeout(() => {
                        ChatBot.ShowSearchBing(term)
                    }, 3000);
                } else{
                    ChatBot.ShowGlossary(lines[0].IDGlossary)
                } 
            } else{

                let expressions = upperTerm.split(' ').flat()
                let filterExpressions = []

                // se for uma frase
                if(expressions.length > 0){
                    expressions.forEach(element => {
                        // se tiver mais de 3 caracteres é considerado keyword
                        if(element.length > 3)
                            filterExpressions.push(element)
                    });
                }else{ // se não for uma frase (é uma palavra)
                    filterExpressions.push(element)
                }

                let phrases = []

                // Se encontrou mais que 1 expressão / possivel keyword, preenche o array de expressões
                if(filterExpressions.length > 0){
                    //Adicionar ao array de frases cada elemento que der match com a BD
                    filterExpressions.forEach(element => {
                        // console.log(element)
                        let filterBD = []
                        filterBD = ChatBot.allDBData.filter(phrase => phrase.text.includes(element))
                        filterBD.forEach(frase => {
                            phrases.push(frase)
                        })
                    })
                }

                if(phrases.length > 1){
                    ChatBot.ShowBotThinking()
                    setTimeout(() => {
                            let optionHtml = `<span class='span-option'>${ChatBot.translations["more_specific"]}</span> <br/><br/>${ChatBot.translations["select_option"]}<br/>`
                            optionHtml += "<ul class='bot bot-answer-list'>"
                            
                            for (const [id, option] of Object.entries(phrases)) {
                                optionHtml += `<li class="bot bot-answer" data-option="answer" data-idoption="${option.IDOption}" data-idglossary="${option.IDGlossary}">${option.text}</li>`;
                            }

                            optionHtml += `<li class="bot bot-answer" data-option="chatgpt">Perguntar ao <b>ChatGPT</b></li>`;

                            optionHtml += "</ul>"

                            ChatBot.BotSendMessage(optionHtml)
                            ChatBot.ShowTime()

                            $(".bot-answer-list").last().find("li").click(function() {
                                $(this).addClass("selected")
                                $(this).parent().addClass("disabled")
                                let option = $(this).attr("data-option")
                                let optionId = $(this).attr("data-idoption")
                                let glossaryId = $(this).attr("data-idglossary")
                                let answerText = $(this).text()
                    
                                switch (option) {
                                    case "answer":
                                        ChatBot.UserSendMessage(answerText)
                                        if(optionId)
                                            ChatBot.ShowGlossary(0, true, optionId, answerText)
                                        else
                                            ChatBot.ShowGlossary(glossaryId)
                                        break;
                                    case "chatgpt":
                                        ChatBot.SearchGPT(term)
                                        break;
                                    default:
                                        break;
                                }
                            })
                    }, 3500);
                }else{
                    if(phrases.length == 1) {
                        if(phrases[0].IDOption)
                            ChatBot.ShowGlossary(0, true, phrases[0].IDOption, phrases[0].text)
                        else
                            ChatBot.ShowGlossary(phrases[0].IDGlossary)
                    }else{
                        ChatBot.ShowBotThinkingConfused(6000, term)  
                    }
                }
            }
        })

        


        // fetch(ChatBot.baseURL + '/functions/api.php?action=searchBD&term=' + upperTerm)
        // .then(response => response.json())
        // .then(lines => {
        //         if(lines.length > 1){
        //             ChatBot.ShowBotThinking()
        //             setTimeout(() => {
        //                     let optionHtml = `<span class='span-option'>${ChatBot.translations["more_specific"]}</span> <br/><br/>`
        //                     optionHtml += "<ul class='bot bot-answer-list'>"
                            
        //                     for (const [id, option] of Object.entries(lines)) {
        //                         optionHtml += `<li class="bot bot-answer" data-option="answer" data-idoption="${option.IDOption}" data-idglossary="${option.IDGlossary}">${option.text}</li>`;
        //                     }
        //                     optionHtml += "</ul>"
        //                     ChatBot.BotSendMessage(optionHtml)
        //                     ChatBot.ShowTime()

        //                     $(".bot-answer-list").last().find("li").click(function() {
        //                         $(this).addClass("selected")
        //                         $(this).parent().addClass("disabled")
        //                         let option = $(this).attr("data-option")
        //                         let optionId = $(this).attr("data-idoption")
        //                         let glossaryId = $(this).attr("data-idglossary")
        //                         let answerText = $(this).text()
        //                         ChatBot.UserSendMessage(answerText)
                    
        //                         switch (option) {
        //                             case "answer":
        //                                 if(optionId)
        //                                     ChatBot.ShowGlossary(0, true, optionId, answerText)
        //                                 else
        //                                     ChatBot.ShowGlossary(glossaryId)

        //                                 break;
        //                             default:
        //                                 break;
        //                         }
        //                     })

        //             }, 3500);
        //         }else{
        //             if(lines.length == 1) {
        //                 if(lines[0].IDOption)
        //                     ChatBot.ShowGlossary(0, true, lines[0].IDOption, lines[0].text)
        //                 else
        //                     ChatBot.ShowGlossary(lines[0].IDGlossary)
        //             }else{
        //                 ChatBot.ShowBotThinkingConfused()  
        //                 setTimeout(() => {
        //                 //     // Função para calcular a distância de edição entre duas strings
        //                 //     function levenshteinDistance(a, b) {
    
        //                 //         if (a.length === 0) return b.length;
        //                 //         if (b.length === 0) return a.length;
                            
        //                 //         const matrix = [];
                            
        //                 //         // Inicializa a matriz
        //                 //         for (let i = 0; i <= b.length; i++) {
        //                 //         matrix[i] = [i];
        //                 //         }
                            
        //                 //         for (let j = 0; j <= a.length; j++) {
        //                 //         matrix[0][j] = j;
        //                 //         }
                            
        //                 //         // Calcula a distância de edição
        //                 //         for (let i = 1; i <= b.length; i++) {
        //                 //         for (let j = 1; j <= a.length; j++) {
        //                 //             if (b.charAt(i - 1) === a.charAt(j - 1)) {
        //                 //             matrix[i][j] = matrix[i - 1][j - 1];
        //                 //             } else {
        //                 //             matrix[i][j] = Math.min(
        //                 //                 matrix[i - 1][j - 1] + 1, // substituição
        //                 //                 matrix[i][j - 1] + 1, // inserção
        //                 //                 matrix[i - 1][j] + 1 // remoção
        //                 //             );
        //                 //             }
        //                 //         }
        //                 //         }
                            
        //                 //         return matrix[b.length][a.length];
        //                 //     }
                            
        //                 //     // Função para verificar se uma palavra está presente no dicionário
        //                 //     function checkWord(word, dictionary) {
        //                 //         if (dictionary.includes(word)) {
        //                 //         return true;
        //                 //         } else {
        //                 //         // Se a palavra não estiver no dicionário, tenta sugerir uma correção
        //                 //         const suggestions = [];
                            
        //                 //         dictionary.forEach((item) => {
        //                 //             const distance = levenshteinDistance(word, wordWithoutSpace);
        //                 //             if (distance <= 2) { // limite de distância para sugestão de correção
        //                 //                 suggestions.push(item);
        //                 //             }
        //                 //         });
                            
        //                 //         if (suggestions.length > 0) {
        //                 //             // return `Você quis dizer "${suggestions[0]}"?`;
        //                 //             return suggestions[0];
        //                 //         } else {
        //                 //             return 'Palavra não encontrada';
        //                 //         }
        //                 //         }
        //                 //     }
                            
        //                 //     fetch(ChatBot.baseURL + '/functions/api.php?action=searchBD')
        //                 //     .then(response => response.json())
        //                 //     .then(terms => {
    
        //                 //         let dictionary = new Array();
    
        //                 //         for (let idx = 0; idx < terms.length; idx++) {
        //                 //             const concept = terms[idx].conceito;
        //                 //             dictionary[idx] = concept;
        //                 //         }
    
        //                 //         let result = checkWord(term, dictionary)
        //                 //         if(result != "Palavra não encontrada")
        //                 //             console.log("Você quis dizer: " + result); // Você quis dizer "gato"?
        //                 //     })
        //                 //     .catch(erro => console.error(erro));
      
        //                 //     // let html = `Whoops! You messed up my algorithms. I can't find this concept.`
        //                 //     // ChatBot.BotSendMessage(html)
        //                 }, 5000);
        //             }
        //         }
        // })
        // .catch(error => console.error(error));

        
    },

    ShowGlossary: function(glossaryId, isAnOption, optionId, title){

        if(isAnOption){
            fetch(ChatBot.baseURL + '/functions/api.php?action=getSummary&id=' + parseInt(optionId))
            .then(response => response.json())
            .then(data => {
                // Capitalizar a primeira letra de todas as palavras
                // function ucwords(str,force){
                //     str=force ? str.toLowerCase() : str;  
                //     return str.replace(/(\b)([a-zA-Z])/g,
                //     function(firstLetter){
                //         return   firstLetter.toUpperCase();
                //     });
                // }

                // function checkWords(str){

                //     switch (str) {
                //         case "Foundations For Id 101":
                //             str = "Foundations for ID 101"
                //             break;
                //         case "Id Content Development":
                //             str = "ID Content Development"
                //             break;
                //         case "Id Evaluation":
                //             str = "ID Evaluation"
                //             break;
                //         case "Id Implementation":
                //             str = "ID Implementation"
                //             break;
                //         case "Identity Of An Instructional Designer​":
                //             str = "Identity of an Instructional Designer"
                //             break;
                //         case "Instructional Design As A Complex System​":
                //             str = "Instructional Design as a Complex System"
                //             break;
                //         case "Instructional Development (Id) Model And Principles​":
                //             str = "Instructional Development (ID) Model and Principles"
                //             break;
                //         case "Learning Theories And Instructional Design Theories":
                //             str = "Learning Theories and Instructional Design Theories"
                //             break;
                //         case "Video, Audio, And Image Editing":
                //             str = "Video, Audio, and Image Editing"
                //             break;
                //         case "User Experience And User Interface":
                //             str = "User Experience and User Interface"
                //             break;
                //         default:
                //             break;
                //     }

                //     return str
                // }

                // let head = ucwords(title, true)

                // head = checkWords(head)
                head = data.text

                let html = `<b>${head}:</b>`
                html += `<br/><br/>`
                html += data.summary
                setTimeout(() => {
                    ChatBot.BotSendMessage(html)
                }, 2000);
            })
            .catch(error => console.error(error));
        }else{
            fetch(ChatBot.baseURL + '/functions/api.php?action=searchGlossary&id=' + glossaryId)
            .then(response => response.json())
            .then(line => {
                let html = `<b>${line.conceito}:</b>`
                html += `<br/><br/>`
                html += line.definicao
                let html2 = `<ul class="bot bot-answer-list">`
                html2 += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["final_back_home"]}</li>`
                html2 += "</ul>"
                ChatBot.BotSendMessage(html)

                ChatBot.ShowSearchBing(line.conceito)

                setTimeout(() => {
                    ChatBot.BotSendMessage(html2)

                    $(".bot-answer-list").last().find("li").click(function() {
                        $(this).addClass("selected")
                        // $(this).parent().addClass("disabled")
                        let option = $(this).attr("data-option")
            
                        switch (option) {
                            case "reset":
                                ChatBot.ResetBot()
                                break;
                            default:
                                break;
                        }
                    })

                }, 2000);
            })
            .catch(error => console.error(error));
        }

        //Show final message
        if(isAnOption){
            fetch(ChatBot.baseURL + '/functions/api.php?action=getOption&id=' + parseInt(optionId))
            .then(response => response.json())
            .then(data => {
                let links = data.referencias
                setTimeout(() => {

                    if(links != null && links.length > 0){
                        links = links.split(';');
                        let text = ChatBot.translations["final_know_more"] + `<b>${data.caminho}</b>`
                        text += `<br/><br/>${ChatBot.translations["final_or"]}`
                        text += `<br/><br/>${ChatBot.translations["final_click_links"]}`
                        let html = `<ul class="bot bot-answer-list">`

                        function truncate(str, n){
                            return (str.length > n) ? str.slice(0, n-1) + '&hellip;' : str;
                        };
                        
                        links.forEach(element => {
                            html += `<li class="bot bot-answer" data-option="answer" data-link='${element}'>${truncate(element, 30)}</li>`
                        
                        });
                        html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["final_back_home"]}</li>`
                        html += "</ul>"
                        text += html
            
                        ChatBot.BotSendMessage(text)

                        $(".bot-answer-list").last().find("li").click(function() {
                            $(this).addClass("selected")
                            // $(this).parent().addClass("disabled")
                            let option = $(this).attr("data-option")
                            let target = $(this).attr("data-link")
                
                            switch (option) {
                                case "answer":
                                    window.open(target, '_blank')
                                    break;
                                case "reset":
                                    ChatBot.ResetBot()
                                    break;
                                default:
                                    break;
                            }
                        })
                    }else {
                        let text = ""
                        let html = `<ul class="bot bot-answer-list">`
                        html += `<li class="bot bot-answer goback" data-option="reset">${ChatBot.translations["final_back_home"]}</li>`
                        html += "</ul>"
                        if(data.caminho != null){
                            text = ChatBot.translations["final_know_more"] + `<b>${data.caminho}</b>`
                            text += html
                            ChatBot.BotSendMessage(text)
                        }else{
                            ChatBot.BotSendMessage(html)
                        }

                        $(".bot-answer-list").last().find("li").click(function() {
                            $(this).addClass("selected")
                            $(this).parent().addClass("disabled")
                            let option = $(this).attr("data-option")
                
                            switch (option) {
                                case "reset":
                                    ChatBot.ResetBot()
                                    break;
                                default:
                                    break;
                            }
                        })
                        
                    }
                    
                    ChatBot.ShowTime()

                }, 3500)
            })
            .catch(error => console.error(error));
        }   
    },

    // RequestToken: function(){

    //     let client_id = "970440824969-nff4een668n1c18p2i1nmc3tkqm9r12i.apps.googleusercontent.com"
    //     let client_secret = "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"

    //     fetch('https://accounts.google.com/o/oauth2/token', {
    //     method: 'POST',
    //     headers: {
    //         'Content-Type': 'application/x-www-form-urlencoded'
    //     },
    //     body: 'grant_type=client_credentials&client_id='+ client_id + '&client_secret='+ client_secret + '&scope=https://www.googleapis.com/auth/dialogflow'
    //     })
    //     .then(response => response.json())
    //     .then(data => console.log(data))
    //     .catch(error => console.error(error));


    // },

    // TestePost: function(){

    //     $.ajax({
    //         type: "POST",
    //         url: "https://dialogflow.googleapis.com/v2/projects/small-talk-ttsf/agent/sessions/123456789:detectIntent",
    //         contentType: "application/json; charset=utf-8",
    //         dataType: "json",
    //         headers: {
    //             "Authorization": "Bearer " + "AIzaSyBc0w9OOCBko3z7NF6uZqa4cXH4rj2O7nM",
    //         },
    //         data: JSON.stringify({ "query_input": {
    //                 "text": {
    //                 "text": "Olá!",
    //                 "language_code": "pt"
    //                 }
    //             }
    //         }),
    //         success: function(data) {
    //             console.log(data.queryResult.fulfillmentText)
    //         },
    //         error: function() {
    //             console.log("Internal Server Error");
    //         }
    //     })

    // }

    ShowLastShownMenu: function(){
        ChatBot.ResetBot()
    },

    ShowSearchBing: function(term){

        let html = `Se quiser saber mais sobre este conceito, pode pesquisar na Web:<br/><br/>`
        html += "<ul class='bot bot-answer-list'>"
        html += `<li class="bot bot-answer" data-option="search"><b>Pesquisar</b> "${term}"</li>`;
        html += "</ul>"
        
        ChatBot.BotSendMessage(html)

        $(".bot-answer-list").last().find("li").click(function() {
            $(this).addClass("selected")
            $(this).parent().addClass("disabled")
            let option = $(this).attr("data-option")

            switch (option) {
                case "search":
                    window.open('https://www.bing.com/search?q=' + term.replace(" ", "+"), '_blank');
                    break;
                default:
                    break;
            }
        })
    },

    SearchBing: function(term){
        window.open('https://www.bing.com/search?q=' + term.replace(" ", "+"), '_blank');
    },

    SearchGPT: function(prompt){

        setTimeout(() => {
            ChatBot.ShowBotThinking("unlimited")
        }, 250);

        const promptData = []
        
        promptData.push(        
            {
                role: "user",
                content: prompt
            }
        )

        const requestData = {
            model: ChatBot.GPT_MODEL,
            messages: promptData,
            max_tokens: ChatBot.GPT_MAXTOKENS,
            temperature: ChatBot.GPT_TEMPERATURE,
        };
        
        fetch(ChatBot.GPT_APIURL, {
            method: 'POST',
            headers: {
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${ChatBot.GPT_APIKEY}`,
            },
            body: JSON.stringify(requestData),
        })
        .then(response => response.json())
        .then(data => {

            ChatBot.StopBotThinking()

            console.log(data)

            let gptResponse = data.choices[0].message.content.replaceAll("\n","<br/>")

            // gptResponse.replace("\n", "<br />", "g")
            
            let html = `<div class='gpt-response-warning'><span class='gpt-response-label'><b>${ChatBot.translations["gpt_warning"]}</b><br/>
            "${ChatBot.translations["gpt_warning_text"]}"</span></div><br/>`
            html += gptResponse
            
            ChatBot.BotSendMessage(html)

            setTimeout(() => {
                ChatBot.ScrollWindowToBottom()
            }, 250);
        })
        .catch(error => {
            console.error('Error: ', error);
        });
    }
}

async function init() {
    try {
      const data = await $.ajax({
        url: ChatBot.baseURL + "/functions/api.php?action=initBot",
        method: 'GET'
      });
      // handle the response data here
      ChatBot.allDBData = data

      if(data.length > 0){
            // fetch('chatbot/config/translations.json')
            // // fetch('config/translations.json')
            // .then(response => response.json())
            // .then(translations => {
            //     ChatBot.translations = translations[ChatBot.lang]

            //     setTimeout(() => {
            //         ChatBot.ShowBotIcon()
            //     }, 1000);
            // })
            // .catch(error => console.error(error));


            ChatBot.translations = Translations[ChatBot.lang]

            setTimeout(() => {
                ChatBot.ShowBotIcon()
            }, 1000);

    
        setInterval(() => {
            ChatBot.UpdateTime()
        }, 30000)
      }
    } catch (error) {
      // handle any errors here
      console.error(error);
    }
  }

window.addEventListener('DOMContentLoaded', (event) => {
    init()
})

var Translations = {
    "pt": {
        "hello": "Olá",
        "goodbye": "Adeus",
        "reset": "REINICIAR",
        "search_bar_placeholder": "Indique o conceito que quer procurar.",
        "select_topics_below": "Sobre o que quer aprender?",
        "want_know_more": "Quer saber mais?",
        "lets_go": "Vamos a isso!",
        "select_option": "Selecione uma opção:",
        "read_summary": "LER RESUMO",
        "learn_about": "SABER MAIS",
        "learn_about1": "Sim, por favor. Quero aprender o máximo possível.",
        "previous": "Voltar ao início",
        "not_found": "Não encontrei nada sobre isso",
        "topic_summary": "Resumo do tópico",
        "lets_talk_about": "Ok! Vamos explorar",
        "delve_deeper": "Quer especializar-se em...",
        "explore_theme": "Boa escolha!",
        "content_see": "Que conteúdo gostaria de ver?",
        "covered_concepts": "Não, quero saber ainda mais!",
        "consult_covered_concepts": "Ok! Vamos falar sobre ",
        "which_concept": "Selecione um destes conceitos:",
        "satisfy_curiosity": "Satisfez a sua curiosidade?",
        "search_cant_find": "Ups! Algoritmo baralhado. Não consigo encontrar este conceito.",
        "good_choice": "Boa escolha!",
        "testing_my_database": "Ah, estou a ver! Está a testar o meu conhecimento. Adoro desafios!",
        "look_concepts": "Veja estes conceitos.",
        "delve_concept": "Vamos aprofundar este conceito.",
        "drive_content": "Vamos mergulhar neste tema.",
        "helpful_information": "Esta informação foi útil?",
        "helpful_information2": "Era esta a informação que procurava?",
        "want_more_information": "Sim, mas quero saber mais.",
        "want_more_information2": "Sim, mas quero saber mais.",
        "dont_want_more_information": "Não, não me podes mostrar mais?",
        "final_know_more": "Se quer saber mais sobre este conceito, visite a ",
        "final_know_more2": "Para saber mais sobre este conceito, pode:",
        "final_know_more_goto": "Consultar a ",
        "final_or": "ou",
        "final_click_links": "Consultar o(s) site(s) recomendado(s):",
        "final_back_home": "Voltar ao início",
        "just_now": "Agora mesmo",
        "1_min_ago": "Há %s minuto atrás",
        "min_ago": "Há %s minutos atrás",
        "more_specific": "Pode ser mais específico?",
        "gpt_warning": "Atenção",
        "gpt_warning_text": "Esta informação não é verificada. O ChatGPT pode produzir informações imprecisas sobre pessoas, lugares ou factos."
    },
    "en": {
        "hello": "Hello",
        "goodbye": "Goodbye",
        "reset": "RESET",
        "search_bar_placeholder": "Enter the concept you want to search",
        "select_topics_below": "What do you want to learn about?",
        "want_know_more": "Do you want to know more?",
        "lets_go": "Let's do it!",
        "select_option": "Select an option:",
        "read_summary": "READ SUMMARY",
        "learn_about1": "Yes, please. I want to get really smart",
        "learn_about": "LEARN ABOUT",
        "previous": "Back to main menu",
        "not_found": "I didn't find anything about it",
        "topic_summary": "Topic summary",
        "lets_talk_about": "OK! Let's explore",
        "delve_deeper": "You want to specialize in...",
        "explore_theme": "Good choice!",
        "content_see": "What content do you want to see?",
        "covered_concepts": "No, I want to know even more!",
        "consult_covered_concepts": "OK! Let's talk about ",
        "which_concept": "Select one of this concepts:",
        "satisfy_curiosity": "Did you satisfy your curiosity?",
        "search_cant_find": "Whoops! You messed up my algorithms. I can't find this concept.",
        "good_choice": "Good choice!",
        "testing_my_database": "Oh, I see! You are testing my knowledge. I love challenges!",
        "look_concepts": "Take a look at this concepts.",
        "delve_concept": "Let's go deep into this concept.",
        "drive_content": "Let's dive into this content.",
        "helpful_information": "Was this information helpful?",
        "helpful_information2": "Was this the information you were looking for?",
        "want_more_information": "Yes, but I want to know more",
        "want_more_information2": "Yes, but I want to go further",
        "dont_want_more_information": "No, don't you have more?",
        "final_know_more": "If you want to know more about this concept go to ",
        "final_know_more2": "If you want to know more about this concept you can:",
        "final_know_more_goto": "Go to ",
        "final_or": "or",
        "final_click_links": "Click on the following links:",
        "final_back_home": "Restart conversation",
        "just_now": "Just now",
        "1_min_ago": "%s minute ago",
        "min_ago": "%s minutes ago",
        "more_specific": "Can you be more specific?",
        "gpt_warning": "Attention",
        "gpt_warning_text": "This information is not verified. ChatGPT may produce inaccurate information about people, places, or facts."
    },
    "fi": {
        "hello": "Hei",
        "goodbye": "Hyvästi",
        "reset": "Nollaa",
        "search_bar_placeholder": "Syötä käsite, jota haluat etsiä",
        "select_topics_below": "Valitse jokin alla olevista aiheista:",
        "lets_go": "Tehdään se!",
        "select_option": "Valitse vaihtoehto:",
        "read_summary": "LUE TIIVISTELMÄ",
        "learn_about": "OTA TIETOJA",
        "previous": "EDELLINEN",
        "not_found": "En löytänyt siitä mitään",
        "topic_summary": "Aiheen yhteenveto",
        "lets_talk_about": "Asianmukaisesti! Puhutaan",
        "delve_deeper": "Mihin aiheeseen haluat syventää?",
        "explore_theme": "OK! Tutkitaanpa teemaa",
        "content_see": "Mitä sisältöä haluat nähdä?",
        "covered_concepts": "Tutustu käsitteisiin",
        "consult_covered_concepts": "Oikein hyvä! Katsotaanpa käsitteitä, joita käsitellään",
        "which_concept": "Mitä konseptia haluat kuulla?",
        "gpt_warning": "Huomio",
        "gpt_warning_text": "Näitä tietoja ei ole vahvistettu. ChatGPT voi tuottaa epätarkkoja tietoja ihmisistä, paikoista tai faktoista."
    }
}