/*!
 *      SCOBot
 *      Cybercussion
 *      Documentation @ https://github.com/cybercussion/SCOBot/wiki/SCORM-SCOBot-Documentation
 *
 *	List of Functions:
 *		SCORMSaveData( data )		Saves data to SCORM as string
 *		SCORMLoadData()			Loads data from SCORM as string
 *		SCORMSetGrade( raw, min, max ) 	Sets grade in SCORM
 */

// Prepare SCORM
var scorm = new SCOBotBase({ 
    debug: false,			// true or false
    time_type: 'GMT',			// UTC, GMT or ""
    exit_type: 'suspend',		// suspend, finish
    preferred_API : 'findAPI',		// findAPI, findSCORM12, findSCORM2004  ** new in 4.0.9 **
    success_status: 'passed',		// passed, failed, unknown
    completion_status: 'completed'	// completed, incomplete, not attempted, unknown
}),
SB    = new SCOBot({
    interaction_mode: 'state',		// state or journaled
    scaled_passing_score: '0.5',	// uses cmi.score.scaled to equate cmi.success_status
    completion_threshold: '0',		// uses cmi.progress_measure to equate cmi.completion_status
    base64                : false,	// Set to false if you manage suspend data or do not wish for it to be encoded (v4.0.3 option)
    happyEnding           : false,	// Set to false if you want to disable this method (v4.0.5)
    useJSONSuspendData    : false	// Set to false if you manage suspend data (v4.0.3 option)
});

// SCORM Ready
SCOBotUtil.addEvent(SB, 'load', function(e) {
    //playerLoad();
    loadData();
    return false;
});

// SCORM Byebye
SCOBotUtil.addEvent(SB, 'unload', function(e) {
    player.exit();						// Tell your SCO Player to wrap up
    //saveData( data );
    SB.commit();
    return false;
});

//SCORM Save
function SCORMSaveData( data ) {
    scorm.setvalue('cmi.suspend_data', data);
    SB.commit();
}

//SCORM Load Save
function SCORMLoadData() {
    return scorm.getvalue('cmi.suspend_data');
}

//SCORM Set Grade
function SCORMSetGrade( raw, min, max, viewed ) {
    scorm.setvalue('cmi.score.raw', raw);
    scorm.setvalue('cmi.score.min', min);
    scorm.setvalue('cmi.score.max', max);
    scorm.setvalue('cmi.progress_measure', viewed);

    SB.gradeIt();
    SB.commit();
    zork( 'You completed the course with grade ' + raw + '! This grade was saved to SCORM... and the course was set to ' + viewed );
}