// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];
//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();
totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);
var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;
var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "Lähetä", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade
    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",
    button_start: "Aloita",
    button_prev: "Edellinen",
    button_next: "Seuraava",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Lähetä",
    button_review: "Arvostelu",
    button_try_again: "Yritä uudelleen",
    button_finish: "Lähetä arvosana",
    button_help: "",
    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Tervetuloa arviointitoimintaan!</b></h2>
        <p>Tämä arviointitoiminta koostuu seuraavista osista<b><span class="quiz-total"></span> monivalintakysymykset</b> johon sinun on vastattava valitsemalla oikea vaihtoehto. Arviointitehtävän suorittaminen hyväksytysti edellyttää, että saat vähintään seuraavan arvosanan<b>${minimumGrade}%</b>.</p>
        <p>Sinulla on <b><span class="quiz-attempts"></span> yritystä</b> suorittamaan tämä tehtävä. Sinulla on<b>${minutesToComplete} minuuttia</b> jokaisessa yrityksessä suorittaa tietokilpailu. Sinun on klikattava "Lähetä arvosana" -painiketta tallentaaksesi sijoituksesi koulutusalustalle.</p>
        <p style="text-align: right"><b>Onnea matkaan!</b></p>
        `,
    message_end_generic_fail: `
            <h2 class="fail">Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</h2>
            <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
            <p>Yritä uudelleen.</p>
            <br><br>
            <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">ONNITTELUT!</h2>
            <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
            <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
            <p>Klikkaamalla "Lähetä arvosana" -painiketta aktiviteetti estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, klikkaa "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan).</p>
            <br><br>
            <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>
        `,
    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,
    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,
    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,
    message_end_fail: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Yritä uudelleen.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Sinulta on loppunut yritykset tehdä tämä arviointitehtävä.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Klikkaamalla "Lähetä arvosana" -painiketta aktiviteetti estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, klikkaa "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan).</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän arviointitehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Arvosanasi tallennettiin alustalle ja kohde merkittiin suoritetuksi.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Paras arvosanasi tähän mennessä oli <span class="quiz-best-grade"></span>%. Klikkaamalla "Lähetä arvosana" -painiketta toiminta estetään ja arvosanasi kirjataan alustalle ja kohde merkitään suoritetuksi. Jos haluat parantaa arvosanaa, käytä "Yritä uudelleen" -painiketta (paras arvosanasi kirjataan). Palaa alustalle napsauttamalla X-painiketta.</p>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Et läpäissyt tätä arviointitehtävää</h2>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Tässä yrityksessäsi et saanut vähimmäispistemäärää, joka vaaditaan arviointitehtävän suorittamiseen.</p>
        <p>Paras arvosanasi tähän mennessä oli <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Lähetä arvosana" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Yritä uudelleen" button (your best rating will be recorded).</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>Tässä yrityksessä arvosanasi oli<span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_best: `
        <h2 class="win">ONNITTELUT!</h2>
        <p>Olet suorittanut tämän tehtävän onnistuneesti.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Arvosanasi kirjattiin alustalle ja tehtävä merkittiin suoritetuksi.</p>
        <p>Palaa alustalle napsauttamalla X-painiketta.</p>
        <br><br>
        <p>Jäljellä olevat yritykset: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};
var quizQuestions = {};
quizQuestions[0] ={};
quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Mikä väite kuvailee parhaiten opetusratkaisua?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Opetusratkaisut kehitetään huomioiden opetusongelmat ja oppimistarpeet, opetettavat tiedot ja taidot, olemassa olevat oppimisympäristöt sekä oppijan personat. Ne tarjoavat opetuksen rakenteen, joka mahdollistaa oppimiskokemuksia oppijoille heidän saavuttaakseen oppimistavoitteet. Opetusratkaisuja kehitetään oppimismuotoilun suunnitelman mukaisesti erilaisten suunnitteluharkintojen avulla.`;
quizQuestions[0][0].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Opetusratkaisut kehitetään huomioiden opetusongelmat ja oppimistarpeet, opetettavat tiedot ja taidot, olemassa olevat oppimisympäristöt sekä oppijan personat. Ne tarjoavat opetuksen rakenteen, joka mahdollistaa oppimiskokemuksia oppijoille heidän saavuttaakseen oppimistavoitteet. Opetusratkaisuja kehitetään oppimismuotoilun suunnitelman mukaisesti erilaisten suunnitteluharkintojen avulla.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Instruktionaaliset ratkaisut kehitetään keskittyen vain opetettavaan tietoon ja taitoihin.`;
quizQuestions[0][0].answers[1]=`Opetusratkaisu tarjoaa yleisen opetuksen rakenteen, joka luo oppimiskokemuksen oppilaille tavoitteiden saavuttamiseksi.  `;
quizQuestions[0][0].answers[2]=`Opetusratkaisujen tulee olla mahdollisimman yksityiskohtaisia alusta lähtien, jotta niitä voidaan käyttää opetustuotteiden kehittämisessä.`;
quizQuestions[0][0].key=2;
quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Mitä tulisi sisällyttää tavoiteltuihin oppimistuloksiin?`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Oppimistavoitteiden tulee kuvastaa mitattavia kognitiivisia käyttäytymisiä opittavasta tiedosta ja taidoista sekä konteksteista, joissa niitä sovelletaan.`;
quizQuestions[0][1].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Oppimistavoitteiden tulee kuvastaa mitattavia kognitiivisia käyttäytymisiä opittavasta tiedosta ja taidoista sekä konteksteista, joissa niitä sovelletaan.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Odotetut mitattavat kognitiiviset toiminnot, kuvaus opittavasta tiedosta ja taidoista sekä soveltamisympäristö.`;
quizQuestions[0][1].answers[1]=`Tieto ja taidot, jotka opiskelijoiden tulisi hallita opetuksen päättymisen jälkeen.  `;
quizQuestions[0][1].answers[2]=`Odotettu suoritustaso tietylle oppimistehtävälle.`;
quizQuestions[0][1].key=1;
quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Mitkä ovat kuusi hierarkkista tasoa ajattelussa Bloomin koulutuksellisten tavoitteiden taksonomiassa?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Bloomin taksonomian kuusi hierarkkista ajattelun tasoa ovat: Muista, Ymmärrä, Sovella, Analysoi, Arvioi ja Luo.`;
quizQuestions[0][2].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Bloomin taksonomian kuusi hierarkkista ajattelun tasoa ovat: Muista, Ymmärrä, Sovella, Analysoi, Arvioi ja Luo.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Muista, Ymmärrä, Sovella, Analysoi, Arvioi, ja Luo.`;
quizQuestions[0][2].answers[1]=`Muista, Ymmärrä, Sovella, Analysoi, Yhdistä ja Luo.  `;
quizQuestions[0][2].answers[2]=`Muista, Sovella, Ymmärrä, Vertaa, Analysoi ja Luo.`;
quizQuestions[0][2].key=1;
quizQuestions[0][3] ={};
quizQuestions[0][3].question=`Miten oppijan persona-analyysi voi auttaa oppimissuunnittelussa?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Oppijan personaa hyödynnetään tunnistamaan oppimistarpeet ja viittaamaan tarvittavaan opetustukeen käyttäjäkeskeisessä opetuksessa.`;
quizQuestions[0][3].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Oppijan personaa hyödynnetään tunnistamaan oppimistarpeet ja viittaamaan tarvittavaan opetustukeen käyttäjäkeskeisessä opetuksessa.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Oppijapersonat tunnistavat keskeiset ongelmat opetushaasteiden takana.`;
quizQuestions[0][3].answers[1]=`Oppijaprofiilit ilmoittavat oppilaiden tarpeista, mikä viittaa tarvittavaan opetukselliseen tukeen.  `;
quizQuestions[0][3].answers[2]=`Oppijoiden personat ilmaisevat heidän oppimispreferenssinsä, jotka ohjaavat, miten opetus tulee suunnitella.`;
quizQuestions[0][3].key=2;
quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Mikä lausuma käyttäjäkeskeisen opetuksen kehittämisestä on virheellinen?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Jos oppijoista ei ole tietoa, oppimismuotoilijoiden tulee silti huomioida oppijan näkökulma suunnitellessaan opetusta oppimistavoitteiden pohjalta.`;
quizQuestions[0][4].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Jos oppijoista ei ole tietoa, oppimismuotoilijoiden tulee silti huomioida oppijan näkökulma suunnitellessaan opetusta oppimistavoitteiden pohjalta.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Oppimissuunnittelijat laativat opetussuunnitelman vain oppijoiden oppimispreferenssien mukaisesti.`;
quizQuestions[0][4].answers[1]=`Opetussuunnittelijoiden tulee käyttää oppijaprofiileja harkitessaan tarvittavaa opetustukea.`;
quizQuestions[0][4].answers[2]=`Oppimissuunnittelijat eivät voi suunnitella opetusta, jos oppijoiden persona-tietoja ei ole saatavilla.`;
quizQuestions[0][4].key=2;
quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Mikä lausuma oppimisympäristöistä on virheellinen?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Oppimismuotoilijoiden on huomioitava olemassa oleva oppimisympäristö, saatavilla olevat resurssit ja oppimistavoitteet kehittäessään uutta oppimisympäristöä.`;
quizQuestions[0][5].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Oppimismuotoilijoiden on huomioitava olemassa oleva oppimisympäristö, saatavilla olevat resurssit ja oppimistavoitteet kehittäessään uutta oppimisympäristöä.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Oppimisympäristö koostuu fyysisestä, kognitiivisesta ja psykologisesta ympäristöstä.`;
quizQuestions[0][5].answers[1]=`Opetussuunnittelijat voivat suunnitella ja kehittää mitä tahansa oppimisympäristöä, kunhan se palvelee opetuksellista tarkoitusta.  `;
quizQuestions[0][5].answers[2]=`Psykologiset ympäristöt ovat enemmän yhteydessä oppijoiden personoihin kuin fyysiset tai kognitiiviset ympäristöt.`;
quizQuestions[0][5].key=2;
quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Mikä lausuma opetusratkaisujen kehittämisestä on virheellinen?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Opetusratkaisun kehittäminen on jatkuva prosessi, joka sisältää opetuskontekstin iteratiivista analysointia.`;
quizQuestions[0][6].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Opetusratkaisun kehittäminen on jatkuva prosessi, joka sisältää opetuskontekstin iteratiivista analysointia.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`Instruktionaalisten ratkaisujen luominen on lineaarista prosessia, jossa valitaan opetus- ja arviointimenetelmiä oppimistavoitteiden pohjalta.`;
quizQuestions[0][6].answers[1]=`Opetusratkaisujen kehittäminen sisältää iteratiivisen analyysin opetuskonteksteista, joka ohjaa päätöksentekoa oppimismuotojen, opetusmenetelmien ja arviointimenetelmien valinnassa.  `;
quizQuestions[0][6].answers[2]=`Opetusratkaisujen kehittäminen alkaa aina opetuskontekstin analyysillä, jotta voidaan suunnitella käyttäjä-, ongelma- ja kontekstikeskeisiä ratkaisuja.`;
quizQuestions[0][6].key=1;
quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Jos tarvitset suunnitella koulutuksen verkko-oppimismuodossa, kuinka se vaikuttaa päätöksiisi muiden opetusratkaisun komponenttien osalta?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Joissain tapauksissa, kuten erityisten jalkapallotekniikoiden hallinnassa, oppimistavoitteita ei voida saavuttaa verkko-oppimisella.`;
quizQuestions[0][7].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Joissain tapauksissa, kuten erityisten jalkapallotekniikoiden hallinnassa, oppimistavoitteita ei voida saavuttaa verkko-oppimisella.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Opetusmenetelmät tulisi mukauttaa e-oppimisympäristöön käyttäen digitaalisia oppimismateriaaleja ja -työkaluja.`;
quizQuestions[0][7].answers[1]=`Oppimistavoitteiden ei tarvitse muuttua, koska kaikenlainen oppiminen voidaan siirtää verkko-oppimiseen.  `;
quizQuestions[0][7].answers[2]=`Arvioinnin on todennäköisesti keskityttävä tiedon deklaratiiviseen ja konseptuaaliseen ymmärtämiseen erityisten motoristen taitojen sijaan.`;
quizQuestions[0][7].key=2;
quizQuestions[0][8] ={};
quizQuestions[0][8].question=`Mikä on paras oppimismuoto arkkitehtuuripiirustusten oppimiseen?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Arkkitehtuuripiirustusten suunnittelussa vaaditaan itsenäistä oppimista, joka soveltuu hyvin verkko-oppimiseen. Se sisältää myös suunnittelua ja kommunikointia sidosryhmien kanssa, mikä on parempi oppia henkilökohtaisessa, ongelmalähtöisessä opetuksessa.`;
quizQuestions[0][8].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Arkkitehtuuripiirustusten suunnittelussa vaaditaan itsenäistä oppimista, joka soveltuu hyvin verkko-oppimiseen. Se sisältää myös suunnittelua ja kommunikointia sidosryhmien kanssa, mikä on parempi oppia henkilökohtaisessa, ongelmalähtöisessä opetuksessa.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Sekamuotoista oppimista.`;
quizQuestions[0][8].answers[1]=`Mobiilioppiminen.  `;
quizQuestions[0][8].answers[2]=`Kasvotusten tapahtuva oppiminen.`;
quizQuestions[0][8].key=1;
quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Mikä lausuma opetusmenetelmistä on oikea?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Opetusmenetelmien valinta perustuu oppimistavoitteen tyyppiin ja käytettävissä oleviin resursseihin.`;
quizQuestions[0][9].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Opetusmenetelmien valinta perustuu oppimistavoitteen tyyppiin ja käytettävissä oleviin resursseihin.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Valitsemme ja sopeutamme opetusmenetelmät ainoastaan opettajien pätevyyden ja käytettävissä olevan teknologian perusteella.`;
quizQuestions[0][9].answers[1]=`Valitsemme, sopeutamme ja integroimme opetusmenetelmät niiden tehokkuuden mukaan tukea tavoiteoppimista, mutta valintaan vaikuttavat myös saatavilla olevat teknologiset resurssit ja fyysinen ympäristö.  `;
quizQuestions[0][9].answers[2]=`Oppimissuunnittelijat valitsevat erilaisia opetusmenetelmiä oppimistavoitteiden mukaan ja luovat uuden oppimisympäristön niiden toteuttamiseksi.`;
quizQuestions[0][9].key=1;
quizQuestions[0][10] ={};
quizQuestions[0][10].question=`Mikä ei ole teknologian funktio opetusmenetelmien tukemisessa?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Jotkut oppimistavat, kuten havainto-moottoritaitojen harjoittelu, eivät ole mahdollisia verkko-oppimisella. Lähiopetuksella on myös erilainen psykologinen vaikutus kuin verkko-oppimisella.`;
quizQuestions[0][10].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Jotkut oppimistavat, kuten havainto-moottoritaitojen harjoittelu, eivät ole mahdollisia verkko-oppimisella. Lähiopetuksella on myös erilainen psykologinen vaikutus kuin verkko-oppimisella.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Teknologia voi tukea rikkaampien oppimiskokemusten tarjoamisessa ja oppimismotivaation parantamisessa.`;
quizQuestions[0][10].answers[1]=`Teknologia voi tukea kohdeoppimista tarjoamalla sosiaalisia vuorovaikutusmahdollisuuksia.  `;
quizQuestions[0][10].answers[2]=`Teknologia voi muuntaa kaikki kasvokkain tapahtuvan oppimisen toiminnot e-oppimiseksi.`;
quizQuestions[0][10].key=3;
quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Mitkä ovat arvioinnin roolit opetuksessa ja oppimisessa?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Arviointia voidaan käyttää tunnistamaan oppimisprosessi ja oppimistulokset, jotka voivat informoida opetuksen säätöä ja oppijoiden itsesäätelevää oppimista.`;
quizQuestions[0][11].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Arviointia voidaan käyttää tunnistamaan oppimisprosessi ja oppimistulokset, jotka voivat informoida opetuksen säätöä ja oppijoiden itsesäätelevää oppimista.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Arviointi voi informoida ja säädellä oppimis- ja opetusprosessia.`;
quizQuestions[0][11].answers[1]=`Arviointia voidaan käyttää tunnistamaan ja mittaamaan oppimistuloksia.  `;
quizQuestions[0][11].answers[2]=`Arviointi voi mitata oppimistuloksia ja säädellä oppimisprosessia.`;
quizQuestions[0][11].key=3;
quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Miksi oppimissuunnittelijat käyttävät formatiivista arviointia?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Oppimismuotoilijat käyttävät yleensä formatiivista arviointia osana oppimis- ja opetusaktiviteetteja tarjotakseen informatiivista palautetta oppijoille ja opettajille säädelläkseen oppimisprosessia. Mutta jokaisessa opetuksessa ei tarvitse olla formatiivista arviointia.`;
quizQuestions[0][12].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Oppimismuotoilijat käyttävät yleensä formatiivista arviointia osana oppimis- ja opetusaktiviteetteja tarjotakseen informatiivista palautetta oppijoille ja opettajille säädelläkseen oppimisprosessia. Mutta jokaisessa opetuksessa ei tarvitse olla formatiivista arviointia.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Formatiivista arviointia käytetään osana oppimisaktiviteetteja, jotta opiskelijat voisivat ymmärtää kurssin sisällön ja säädellä omaa oppimistaan.`;
quizQuestions[0][12].answers[1]=`Formatiivinen arviointi eliminoi tarpeen summatiiviselle arvioinnille, koska oppimistulokset mitataan oppimisprosessin aikana.  `;
quizQuestions[0][12].answers[2]=`Formatiivista arviointia voidaan käyttää seuraamaan oppimisprosessia ja opiskelijoiden edistymistä. Jokaisen oppimissuunnittelun tulisi sisältää formatiivinen arviointi.`;
quizQuestions[0][12].key=1;
quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Mitkä ovat opetusratkaisun keskeiset komponentit?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Opetusratkaisun tärkeitä komponentteja ovat oppimistavoitteet, oppimismuodot, opetusmenetelmät ja arviointimenetelmä.`;
quizQuestions[0][13].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Opetusratkaisun tärkeitä komponentteja ovat oppimistavoitteet, oppimismuodot, opetusmenetelmät ja arviointimenetelmä.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Motivaatiota lisäävät opetusstrategiat, opetusmenetelmät ja arviointivälineet.`;
quizQuestions[0][13].answers[1]=`Oppimistavoitteiden mukaiset oppimismuodot ja opetusmenetelmät.  `;
quizQuestions[0][13].answers[2]=`Oppimistavoitteet, oppimismuodot, opetusmenetelmät ja arviointivälineet.`;
quizQuestions[0][13].key=3;
quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Kuinka oppimissuunnittelijat kehittävät kulttuurisensitiivistä opetusta?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Oppimismuotoilijat kehittävät oppimateriaaleja ja -aktiviteetteja oppijoiden sosiaalis-kulttuuristen tapojen perusteella ja kehittävät kulttuurisensitiivisen oppimisyhteisön oppijoille erilaisista oppimistaustoista.`;
quizQuestions[0][14].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Oppimismuotoilijat kehittävät oppimateriaaleja ja -aktiviteetteja oppijoiden sosiaalis-kulttuuristen tapojen perusteella ja kehittävät kulttuurisensitiivisen oppimisyhteisön oppijoille erilaisista oppimistaustoista.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Oppimissuunnittelijat luovat oppimateriaaleja ja -aktiviteetteja ottaen huomioon oppijoiden sosio-kulttuuriset tavat.`;
quizQuestions[0][14].answers[1]=`Opetussuunnittelijoiden tulee suunnitella yhteisöpohjaista opetusta, joka mahdollistaa oppilaiden vuorovaikutuksen erilaisten taustojen omaavien ihmisten kanssa.  `;
quizQuestions[0][14].answers[2]=`Oppimissuunnittelijat kehittävät oppimateriaaleja ja aktiviteetteja ottaen huomioon oppijoiden sosio-kulttuuriset taustat, ja luovat kulttuurisensitiivisen oppimisyhteisön eri taustoista tuleville oppijoille.`;
quizQuestions[0][14].key=3;
quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Kuinka oppimissuunnittelijat sovittavat arvioinnin ja oppimistavoitteet yhteen?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Joskus arviointi keskittyy holistiseen tehtävään, joka on vaikea sisällyttää jokaiseen kognitiiviseen käyttäytymiseen ja oppimistavoitteissa esitettyyn oppimissisältöön.`;
quizQuestions[0][15].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Joskus arviointi keskittyy holistiseen tehtävään, joka on vaikea sisällyttää jokaiseen kognitiiviseen käyttäytymiseen ja oppimistavoitteissa esitettyyn oppimissisältöön.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Arvioinnin tulisi edellyttää oppijoiden kaikkien oppimistavoitteissa mainittujen kognitiivisten toimintojen osoittamista.`;
quizQuestions[0][15].answers[1]=`Arviointikriteerit määritellään sen perusteella, miten hyvin oppilaat pystyvät suorittamaan oppimistehtävät, kuten oppimistavoitteissa on määritelty.  `;
quizQuestions[0][15].answers[2]=`Arvioinnin tulisi kattaa kaikki oppimistavoitteissa mainitut tiedot ja taidot.`;
quizQuestions[0][15].key=2;
quizQuestions[0][16] ={};
quizQuestions[0][16].question=`Mikä on konstruktiivinen yhteensopivuus?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Konstruktiivinen linjakkuus on dynaaminen linjakkuus oppimistavoitteiden, opetusmenetelmien ja arvioinnin välillä.`;
quizQuestions[0][16].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Konstruktiivinen linjakkuus on dynaaminen linjakkuus oppimistavoitteiden, opetusmenetelmien ja arvioinnin välillä.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`Oppimismuotojen, opetusmenetelmien ja arvioinnin välinen yhteensovittaminen.`;
quizQuestions[0][16].answers[1]=`Yhtenevyys oppimistavoitteiden, opetusmenetelmien ja arvioinnin välillä.  `;
quizQuestions[0][16].answers[2]=`Oppimistavoitteiden, oppimismuotojen ja opetusmenetelmien välinen yhteensopivuus.`;
quizQuestions[0][16].key=2;
quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Mikä ei ole opetusratkaisun rooli oppimisobjektien suunnittelussa ja kehittämisessä?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Opetusratkaisu ei tarjoa yksityiskohtaista kuvausta oppimiskohteista.`;
quizQuestions[0][17].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Opetusratkaisu ei tarjoa yksityiskohtaista kuvausta oppimiskohteista.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Instruktionaaliset ratkaisut tarjoavat yksityiskohtaisia ohjeita siitä, kuinka oppimisobjektit tulisi kehittää kullakin oppimisreitillä, moduulilla ja toiminnolla.`;
quizQuestions[0][17].answers[1]=`Opetusratkaisut näyttävät menetelmät ja toimitustavat, jotka asettavat rajat oppimisobjektien kehittämiselle niin, että ne voidaan sijoittaa, käyttää ja käyttää uudelleen annetussa opetuskontekstissa.  `;
quizQuestions[0][17].answers[2]=`Opetusratkaisut määrittelevät keskeiset opetusmenetelmät ja arvioinnin suhteessa oppimissisältöön ja -aktiviteetteihin, jotka asettavat raamit oppimisobjekteille.`;
quizQuestions[0][17].key=1;
quizQuestions[0][18] ={};
quizQuestions[0][18].question=`Mitkä ovat oppimisobjektit?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Oppimiskohteet viittaavat oppimissisältömateriaaleihin, oppimisaktiviteettien tarjoamiin mahdollisuuksiin ja arviointivälineisiin perustuen yksittäiseen oppimistavoitteeseen.`;
quizQuestions[0][18].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Oppimiskohteet viittaavat oppimissisältömateriaaleihin, oppimisaktiviteettien tarjoamiin mahdollisuuksiin ja arviointivälineisiin perustuen yksittäiseen oppimistavoitteeseen.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Oppimisobjektit viittaavat oppimismateriaaleihin, jotka esittävät tavoitetiedon ja -taidot.`;
quizQuestions[0][18].answers[1]=`Oppimisobjektit tarkoittavat oppimismateriaaleja, oppimistoiminnan mahdollistajia ja arviointityökaluja, jotka pohjautuvat yksittäiseen oppimistavoitteeseen.  `;
quizQuestions[0][18].answers[2]=`Oppimisobjektit tarkoittavat materiaaleja, joita oppijat tarvitsevat tiettyjen oppimistehtävien suorittamiseen.`;
quizQuestions[0][18].key=2;
quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Mitkä opetusmenetelmät sisältävät yleisesti yhteisöllisen oppimisen?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Oikein! Vastauksesi on oikea.</b><br>Ongelmalähtöinen ja tutkiva oppiminen osallistavat oppijoita projekteihin, jotka edellyttävät monipuolista käsitteellistämistä, ryhmäkeskustelua ja yhteistyötä.`;
quizQuestions[0][19].feedback_wrong=`<b>Vastauksesi on väärä.</b><br>Ongelmalähtöinen ja tutkiva oppiminen osallistavat oppijoita projekteihin, jotka edellyttävät monipuolista käsitteellistämistä, ryhmäkeskustelua ja yhteistyötä.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Luennot ja projektipohjainen oppiminen.`;
quizQuestions[0][19].answers[1]=`Mikro-oppiminen ja simulaatiopohjainen oppiminen.`;
quizQuestions[0][19].answers[2]=`Ongelmaperustainen oppiminen ja tutkimusperustainen oppiminen.`;
quizQuestions[0][19].key=3;