/* 
 *      Functions for quiz creation and maintenance
 *
 */

/* global quizConfig, courseStatus */

var currentQuiz;
var currentQuizMode;
var ID;
var currentQuizNextDelay = true;
var currentQuizTryAgain = false;

//Check if quiz common variables exist
function quizMakeVariables() {
    if ( currentQuizTryAgain === false ) {
        currentQuizMode = 0;
    }
    
    if ( courseStatus.quiz_bank === undefined ) {
	courseStatus.quiz_bank = new Array;
    }
    if ( courseStatus.quiz_questions === undefined ) {
	courseStatus.quiz_questions = new Array;
    }
    if ( courseStatus.quiz_answers === undefined ) {
	courseStatus.quiz_answers = new Array;
    }
    
    
    if ( courseStatus.quiz_best_bank === undefined ) {
	courseStatus.quiz_best_bank = new Array;
    }
    if ( courseStatus.quiz_best_questions === undefined  ) {
	courseStatus.quiz_best_questions = new Array;
    }
    if ( courseStatus.quiz_best_answers === undefined ) {
	courseStatus.quiz_best_answers = new Array;
    }
    
    if ( courseStatus.quiz_last_bank === undefined ) {
	courseStatus.quiz_last_bank = new Array;
    }
    if ( courseStatus.quiz_last_questions === undefined  ) {
	courseStatus.quiz_last_questions = new Array;
    }
    if ( courseStatus.quiz_last_answers === undefined ) {
	courseStatus.quiz_last_answers = new Array;
    }
    
    if ( courseStatus.quiz_attempts === undefined ) {
	courseStatus.quiz_attempts = new Array;
    }
    if ( courseStatus.quiz_best_grade === undefined ) {
	courseStatus.quiz_best_grade = new Array;
    }
    if ( courseStatus.quiz_last_grade === undefined ) {
	courseStatus.quiz_last_grade = new Array;
    }
    
    if ( courseStatus.quiz_start_time === undefined ) {
	courseStatus.quiz_start_time = new Array;
    }
    
    if ( courseStatus.quiz_total_time === undefined ) {
	courseStatus.quiz_total_time = new Array;
    }
    if ( courseStatus.quiz_timeout === undefined ) {
	courseStatus.quiz_timeout = new Array;
    }
    
    if ( courseStatus.quiz_current_question === undefined ) {
	courseStatus.quiz_current_question = new Array;
    }
    
    if ( courseStatus.quiz_finished === undefined ) {
	courseStatus.quiz_finished = new Array;
    }
    if ( courseStatus.quiz_submit_grade === undefined ) {
	courseStatus.quiz_submit_grade = new Array;
    }
    if ( courseStatus.quiz_submit_grade_date === undefined ) {
	courseStatus.quiz_submit_grade_date = new Array;
    }
}
//Create quiz question bank
function quizBankCreate( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }//blah2
    
    zork( 'Creating quiz bank...');
    if ( courseStatus.quiz_finished[ID] !== 1 || currentQuizTryAgain === true ) {
        if ( courseStatus.quiz_bank[ID] === undefined ) {
            courseStatus.quiz_bank[ID] = [];
            zork( 'It didn\'t exist...');
        } /*else if ( quizConfig[ID].continue_attempt && currentQuizMode !== 1 ) {
            zork( 'It did exist but we want to keep it...');
        }*/ else {
            courseStatus.quiz_bank[ID] = [];
            zork( 'It did exist and now I\'m resetting it...');
        }

        if ( courseStatus.quiz_questions[ID] === undefined ) {	
            courseStatus.quiz_questions[ID] = [];
        } else {
            courseStatus.quiz_questions[ID] = [];
        }

        if ( courseStatus.quiz_answers[ID] === undefined ) {	
            courseStatus.quiz_answers[ID] = [];
        } else {
            courseStatus.quiz_answers[ID] = [];
        }
//        if ( courseStatus.quiz_current_question[ID] === null ||
//                courseStatus.quiz_current_question[ID] === undefined ) {
//            courseStatus.quiz_current_question[ID] = 0;
//        }
    } else {
        courseStatus.quiz_bank[ID] = courseStatus.quiz_last_bank[ID];
        courseStatus.quiz_questions[ID] = courseStatus.quiz_last_questions[ID];
        courseStatus.quiz_answers[ ID ] = courseStatus.quiz_last_answers[ ID ];
//        courseStatus.quiz_questions[ID] = [0,1,2,3];
    } /*else if ( courseStatus.quiz_finished[ID] === 1 ) {
        courseStatus.quiz_bank[ID] = courseStatus.quiz_best_bank[ID];
        courseStatus.quiz_questions[ID] = courseStatus.quiz_best_questions[ID];
        courseStatus.quiz_answers[ ID ] = courseStatus.quiz_best_answers[ ID ];
//        courseStatus.quiz_questions[ID] = [0,1,2,3];
    }*/
    
    
    var pools = quizConfig[ ID ].quiz_banks.length;
    if ( courseStatus.quiz_finished[ID] !== 1 || currentQuizTryAgain === true ) {
        if ( courseStatus.quiz_current_question[ID] >= 0 && currentQuizMode !== 1 ) { //blah
            
            zork('You left in the middle of something...');
            courseStatus.quiz_bank[ID] = courseStatus.quiz_last_bank[ID];
            courseStatus.quiz_questions[ID] = courseStatus.quiz_last_questions[ID];
            courseStatus.quiz_answers[ ID ] = courseStatus.quiz_last_answers[ ID ];
            quizControlsStart(ID);
        } else {
            //For each question bank pool
            zork( 'Creating question bank from ' + pools + ' question pools...');
            for ( i = 0; i < pools; i++ ) {
                zork('Loop ' + i + '!' );
                var size = quizConfig[ ID ].bank_questions[i];

                var poolSize = 0;

                for ( s = 0; s < 1000; s++ ) {
                    if ( quizQuestions[ quizConfig[ ID ].quiz_banks[i] ][s] !== undefined ) {
                        poolSize += 1;
                    } else {
                        break;
                    }
                }

                zork( 'We are going to take ' + size + ' questions from pool ' + i + ',a pool of ' + poolSize + ' questions...');

                var questions = new Array;

                var answers = new Array;

                for ( q = 0; q < poolSize ; q++ ){
                    questions.push( q );
                    answers.push( 0 );
                }
                if ( quizConfig[ ID ].shuffle === true ) {
                    questions = shuffle(questions);
                    zork( 'Shuffled questions to ' + questions + '!');
                } else if ( quizConfig[ ID ].shuffle === 'pool' ) {

                }
                zork( 'We have these ' + questions + ' questions and these  ' + answers + ' answers...');
                questions = questions.slice(0, size);
                answers = answers.slice(0, size);

                zork( 'We truncated the questions to ' + questions + '  and the answers to ' + answers + '...');

                //For each questions in poll
                for ( f = 0; f < size ; f++ ) {				
                    var poll = quizConfig[ID].quiz_banks[i];

                    //Set poll
                    courseStatus.quiz_bank[ID].push( poll );
                    courseStatus.quiz_questions[ID].push( questions.pop() );
//                    zork( 'i = ' + i + ' and f = ' + f );
                    zork( 'i = ' + i + ' and f = ' + f );
                    courseStatus.quiz_answers[ID].push( 'x' );
                }
//                courseStatus.quiz_questions[ ID ] = courseStatus.quiz_questions[ ID ].reverse();
                zork('Quiz banks for quiz ' + ID + ': ' + courseStatus.quiz_bank[ ID ] );
                zork('Quiz questions for quiz ' + ID + ': ' + courseStatus.quiz_questions[ ID ] );

            }
        }
    } else {
        courseStatus.quiz_bank[ ID ] = courseStatus.quiz_last_bank[ ID ];
        courseStatus.quiz_questions[ ID ] = courseStatus.quiz_last_questions[ ID ];
        courseStatus.quiz_answers[ ID ] = courseStatus.quiz_last_answers[ ID ];
    }
}

//Config all quiz variables
function quizCreate( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    
//    quizMakeVariables();

    if ( courseStatus.quiz_attempts[ ID ] === undefined ) {

	courseStatus.quiz_attempts[ ID ] = quizConfig[ ID ].attempts;
	
	//Quiz mode, 0 = normal, 1 = retry, 2 = review
        if ( currentQuizTryAgain === false ) {
            currentQuizMode = 0;
        }

	courseStatus.quiz_best_grade[ ID ] = 0;

	courseStatus.quiz_last_grade[ ID ] = 0;
	
	courseStatus.quiz_finished[ ID ] = 0;
    
    }
//    
//    if ( quizConfig[ ID ].shuffle === true || quizConfig[ ID ].shuffle === 'pool' ) {
//	courseStatus.quiz_answers[ ID ] = new Array;
//	quizBankCreate( ID );
//    }
    courseStatus.quiz_answers[ ID ] = new Array;
    quizBankCreate( ID );
}

//Build the quiz
function quizBuildHtml( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    $('.slide-current').empty();
    
    currentQuiz = ID;
    
    zork('Building Quiz ' + ID + '!');
    
    quizCreate( ID );
    
    var size = 0;

    var pools = quizConfig[ ID ].quiz_banks.length;
    
    //Count number of questions
    for ( i = 0; i < pools; i++ ) { 
	size += quizConfig[ ID ].bank_questions[i];
    }
    
    zork('This quiz has ' + size + ' questions!');
    
    //Create start screen
    $('#slide-'+ courseStatus.position).append(	
            '<div id="layer-0" class="layer layer-first layer-quiz quiz-start">' +
                '<div id="message-start-generic" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_generic +
                '</div></div>' +
                
                '<div id="message-start-terminated" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_terminated +
                '</div></div>' +
                
                '<div id="message-start-first" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_first +
                '</div></div>' +
                
                '<div id="message-start-pass" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_pass +
                '</div></div>' +
                
                '<div id="message-start-pass-no-attempts" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_pass_no_attempts +
                '</div></div>' +
                
                '<div id="message-start-fail" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_fail +
                '</div></div>' +
                
                '<div id="message-start-fail-no-attempts" class="quiz-message-start"><div class="quiz-flex">' +
                    quizConfig[ ID ].message_start_fail_no_attempts +
                '</div></div>' +
                
                '<div id="quiz-start-grade">' +
                    quizConfig[ ID ].label_grade +
                    '<span class="quiz-grade"></span>%'+
                '</div>' +

                '<div id="quiz-start-best-grade">' +
                    quizConfig[ ID ].label_best_grade +
                    '<span class="quiz-best-grade"></span>%'+
                '</div>' +

                '<div id="quiz-start-attempts">' +
                    quizConfig[ ID ].label_attempts +
                    '<span class="quiz-attempts"></span>'+
                '</div>' +
            '</div>'
            );
    //Create each question
    for ( q = 0; q < size; q++ ) { 
	var n = q + 1;
	
	var content = '';
	zork('Adding question ' +courseStatus.quiz_questions[ ID ][q]+ ' from pool ' + courseStatus.quiz_bank[ ID ][q] +'!');
//        console.log(q);
	content +=  '<div id="question-' + n + '" class="quiz-question-text">' +	//Add question
			quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].question +
		    '</div>';
	
	if ( quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].instruction !== false ) {
	    content +=  '<div id="instruction-' + n + '" class="quiz-question-instruction">' +	//Add instruction
			quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].instruction +
		    '</div>';
	}
	    
	//Add answers
	content += '<div class="quiz-answer-area">';
	var answers = quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].answers.length;
	
	for ( a = 0; a < answers; a++ ) {
	    var aAnswer = a + 1;
            var aOrder = '';
            if ( quizConfig[ ID ].shuffle_answers === true ) {
                aOrder = 'order-' + randomNumber(20);
            }
            
	    content +=	'<div id="quiz-answer-' + n + '-' + aAnswer + '" class="quiz-answer quiz-answer-' + n + ' quiz-answer-option-' + aAnswer + ' button-click ' + aOrder + '" onclick="quizAnswer( ' + ID + ', ' + q + ', ' + aAnswer + '); return false;"><span>' +
			    quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].answers[a] +
			'</span></div>';
	}
        if ( quizConfig[ ID ].feedback === true ) {
                content += '<div class="quiz-answer-feedback-right">'+quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].feedback_right+'</div>'+
                                '<div class="quiz-answer-feedback-wrong">'+quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].feedback_wrong+'</div>'
            }
	content += '</div>';
	
	if ( quizConfig[ ID ].help === true ) {
	    content +=	'<div id="help-' + q + '" class="quiz-help">' +
			    'Dica: '+
			    quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].help +
			'</div>';
	} else if ( quizConfig[ ID ].help === 'review' ) {
	    content +=	'<div id="help-' + q + '" class="quiz-help-review">' +
			    
			    quizQuestions[courseStatus.quiz_bank[ ID ][q]][courseStatus.quiz_questions[ ID ][q]].help +
			'</div>';
	}
	
	$('#slide-'+ courseStatus.position).append( 
	    '<div id="layer-' + n + '" class="layer layer-quiz quiz-question quiz-question-' + ID + '-' + q + '" ' +
		'data-quiz-id="' +  ID  + '" ' +
		'data-quiz-bank="' + courseStatus.quiz_bank[ ID ][q] + '" ' +
		'data-quiz-questions="' + courseStatus.quiz_questions[ ID ][q] + '"' +
		' style="display: none;"><div class="quiz-question-area">' +

	    content +

	    '</div></div>'
	);
	
    }
    
    var lastSlide = size + 1;
    
    //Create end screen
    $('#slide-'+ courseStatus.position).append(	

	'<div id="layer-' + lastSlide + '" class="layer layer-last layer-quiz quiz-end"' +
	    'data-quiz-questions="' + courseStatus.quiz_questions[ ID ][q] + '" ' +
	    'style="display: none;">'+
	    
	    '<div id="message-end-generic-fail" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_generic_fail +
	    '</div></div>' +
            
	    '<div id="message-end-generic-pass" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_generic_pass +
	    '</div></div>' +
            
	    '<div id="message-end-timeout-fail" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_fail +
	    '</div></div>' +
	    '<div id="message-end-timeout-fail-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_fail_no_attempts +
	    '</div></div>' +
	    
	    '<div id="message-end-timeout-fail-passed" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_fail_passed +
	    '</div></div>' +
	    '<div id="message-end-timeout-fail-passed-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_fail_passed_no_attempts +
	    '</div></div>' +
	    
	    '<div id="message-end-timeout-pass" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_pass +
	    '</div></div>' +
	    '<div id="message-end-timeout-pass-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_pass_no_attempts +
	    '</div></div>' +
	    
	    '<div id="message-end-timeout-pass-passed" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_pass_passed +
	    '</div></div>' +
            
	    '<div id="message-end-timeout-pass-passed-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_timeout_pass_passed_no_attempts +
	    '</div></div>' +
	    
	    '<div id="message-end-fail" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_fail +
	    '</div></div>' +
	    '<div id="message-end-fail-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_fail_no_attempts +
	    '</div></div>' +
            
	    '<div id="message-end-fail-passed" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_fail_passed +
	    '</div></div>' +
	    '<div id="message-end-fail-passed-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_fail_passed_no_attempts +
	    '</div></div>' +
	    
	    '<div id="message-end-pass" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_pass +
	    '</div></div>' +
	    '<div id="message-end-pass-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_pass_no_attempts +
	    '</div></div>' +
	    
	    '<div id="message-end-pass-passed" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_pass_passed +
	    '</div></div>' +
	    '<div id="message-end-pass-passed-no-attempts" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_pass_passed_no_attempts +
	    '</div></div>' +
        '<div id="message-end-best" class="quiz-message-end" style="display: none"><div class="quiz-flex">' +
		quizConfig[ ID ].message_end_best +
	    '</div></div>' +
'<img src="images/logos_eu_en.png" style="position: absolute; width: 820px; bottom: 0; left: 233px;">'+
	'</div>'
	);
    
    //Create controls
    $('#slide-'+ courseStatus.position).append(	
        '<div id="quiz-button-area">' +
            '<div id="quiz-start" class="quiz-button button-click" onclick="quizControlsStart( ' + ID + ' ); return false;">' +
                quizConfig[ ID ].button_start +
            '</div>' +

            '<div id="quiz-prev" class="quiz-button button-click" onclick="quizControlsPrevious( ' + ID + ' ); return false;" style="display: none;">' +
                quizConfig[ ID ].button_prev +
            '</div>' +

            '<div id="quiz-next" class="quiz-button button-click" onclick="quizControlsNext( ' + ID + ' ); return false;" style="display: none;">' +
                quizConfig[ ID ].button_next +
            '</div>' +

            '<div id="quiz-submit" class="quiz-button button-click" onclick="quizControlsSubmit( ' + ID + ' ); return false;" style="display: none;">' +
                quizConfig[ ID ].button_submit +
            '</div>' +

            '<div id="quiz-try-again" class="quiz-button button-click" onclick="quizControlsTryAgain( ' + ID + ' ); return false;" style="display: none;">' +
                quizConfig[ ID ].button_try_again +
            '</div>'+
	    '<div id="quiz-review" class="quiz-review quiz-button button-click" onclick="quizControlsReview( ' + ID + ' ); return false;" style="display: none;">' +
		quizConfig[ ID ].button_review +
	    '</div>'+
        '</div>'
    );
    
    var timeLimit = quizConfig[ID].maximum_time;
    if ( timeLimit > 0 ) {
        $('#slide-'+ courseStatus.position).append(	
            '<div id="quiz-counter"></div>'
        );
    }
    if ( quizConfig[ ID ].feedback === true ) {
	$('#slide-'+ courseStatus.position).append(	
	    '<div id="quiz-feedback" class="quiz-button button-click" onclick="quizControlsFeedback( ' + ID + ' ); return false;" style="display: none;">' +
		quizConfig[ ID ].button_feedback +
	    '</div>'
	);
    }
    
//    if ( quizConfig[ ID ].review || quizConfig[ ID ].review === 'submit' ) {
//	$('#slide-'+ courseStatus.position).append(
//	);
//    }
    
    if ( quizConfig[ ID ].submit_conditions === 'user' || quizConfig[ ID ].submit_conditions === 'best' ) {
	$('#slide-'+ courseStatus.position +' #quiz-button-area').append(
	    '<div id="quiz-finish" class="quiz-button button-click" onclick="quizControlsFinish( ' + ID + ' ); return false;" style="display: none;">' +
		quizConfig[ ID ].button_finish +
	    '</div>'
	);
    }
    
    //Create list
    if ( quizConfig[ ID ].list && quizConfig[ ID ].advance !== 'auto' ) {
        var list = '';
        
        list += '<div id="quiz-list" class="quiz-list quiz-list-size-'+size+'" style="display: none">';
            var buttonLockedClass = 'button-locked';
            if ( quizConfig[ID].advance === 'always' ) {
                buttonLockedClass = '';
            }
        //Add answer numbers
        for ( l = 0; l < size; l++ ) { 
            var n = l + 1;

            list += '<div id="quiz-list-' + n + '" class="quiz-list-item  '+buttonLockedClass+'" onclick="quizControlsListGoTo( ' + ID + ', ' + n + ', this ) ">' + n + '</div>';
        }
        list += '</div>';
        
        $('#slide-'+ courseStatus.position).append(
            list
        );
        
    }
    
    //Adding feedback screen
    if ( quizConfig[ ID ].feedback === true ) {
	var feedback =	'<div id="quiz-feedback-window" class="quiz-feedback">' +
			'<div id="quiz-feedback-message"></div>'+
			'<div id="quiz-feedback-next" class="quiz-button button-click" onclick="quizControlsFeedbackContinue( ' + ID + ' ); return false;" >' +
			    quizConfig[ ID ].button_feedback_continue +
			'</div>' +
			'</div>';
	$('#slide-'+ courseStatus.position).append(
	    feedback
	);
    }
    
    zork( 'Current quiz mode ' + currentQuizMode +'!');
    if ( currentQuizMode === 0 || courseStatus.quiz_finished[ ID ] === 1 ) { 
        if ( courseStatus.quiz_current_question[ID] > 0 &&
                courseStatus.quiz_current_question[ID] < layerTotal() ) {
            layerGoTo( courseStatus.quiz_current_question[ID] );
        } else {
            layer( 'first' );
        }
        if (  courseStatus.quiz_total_time[ID] > 0 ) {
//            quizCounterUpdate( ID );  
        } else {
//            quizCounterStart( ID );
        }
    } else {
//	layer( 1 ); //ASD
        layer( 'first' );
    }
    quizUpdateAnswers( ID );
    quizUpdateStartScreen( ID );
    quizUpdateEndScreen( ID );
    quizUpdateScreenInfo( ID );
    quizUpdateQuiz( ID );
}

//Quiz controls buttons

function quizControlsStart( ID ){
    if ( currentQuizNextDelay === true ) {
	currentQuizNextDelay = false;
        if ( courseStatus.quiz_current_question[ID] > 0 &&
                courseStatus.quiz_current_question[ID] <= layerTotal() ) {
            layerGoTo( courseStatus.quiz_current_question[ID] );
        } else {
            up();
        }
        courseStatus.quiz_timeout[ID] = 0;
        var timeLimit = quizConfig[ID].maximum_time;
        if ( timeLimit > 0 ) {
            if (  courseStatus.quiz_total_time[ID] > 0  ) {
                quizCounterUpdate( ID );  
            } else {
                quizCounterStart( ID );
            }
        }
        quizUpdateList( ID );
	    quizUpdateQuiz( ID );
        quizUpdateAnswers( ID );
        setTimeout( function() {
            currentQuizNextDelay = true;
            quizUpdateList( ID );
        }, 500);
    }
}
function quizControlsPrevious( ID ){
    if ( currentQuizNextDelay === true ) {
	currentQuizNextDelay = false;
        
	quizUpdateList( ID );
	down();
        if ( layerAfterFirst() ) {
            $( '#quiz-list' ).hide();
        };
        quizUpdateList( ID );
        quizUpdateQuiz( ID );
        quizUpdateAnswers( ID );
        $( '#quiz-next' ).show();
//	    $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});

        $('#next-button-blink').hide();
        $('#submit-button-blink').hide();
        setTimeout( function() {
            currentQuizNextDelay = true;
        }, 500);
    }
}
function quizControlsNext( ID ){
    if ( currentQuizNextDelay === true ) {
        currentQuizNextDelay = false;
            
        quizUpdateList( ID );
        up();
        if ( layerBeforeLast() ) {
            $( '#quiz-list' ).hide();
        };
        quizUpdateList( ID );
        quizUpdateQuiz( ID );
        quizUpdateAnswers( ID );
        $('#next-button-blink').hide();



        if( 
            $('#layer-'+ (courseStatus.quiz_current_question[0]+1)).find('.quiz-answer.selected').length ||
            ( !$('#layer-'+ (courseStatus.quiz_current_question[0]+1)).find('.quiz-answer.selected').length && currentQuizMode === 1 )
        ){

            if( 
                layerBeforeLast() && currentQuizMode !== 1
            ){

                $( '#quiz-next' ).hide();
                $( '#quiz-submit' ).show();

            } else {
                if( 
                    currentQuizMode === 1 && layerLast()
                ){ 
                    $( '#quiz-next' ).hide();
//                    $( '#quiz-next' ).css({'opacity':0,'pointer-events':'none'});
                }else{
                    $( '#quiz-next' ).show();
//                    $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});
                }

            }

        } else {

            if( currentQuizMode === 1 ){
                $( '#quiz-next' ).hide();
            } else {
                $( '#quiz-next' ).show();
            }

//            $( '#quiz-next' ).css({'opacity':0,'pointer-events':'none'});
        }

        setTimeout( function() {
            currentQuizNextDelay = true;
        }, 500);
    }
}
function quizControlsFeedback( ID ) {
    var question = layerCurrent() - 1;
    quizFeedbackAnswer( ID, question );
}
function quizControlsFeedbackContinue( ID ) {
    $( '#quiz-feedback-window' ).hide();
    $( '#quiz-feedback-next' ).hide();
    if ( layerInTheMiddle() && layerBeforeLast() === false ) {
	$( '#quiz-next' ).show();
//    $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});

    } else if ( layerInTheMiddle() && layerBeforeLast() ) {
	$( '#quiz-submit' ).show();
    console.log('aqui carla')
    }
    if ( layerCurrent() > 1 && layerLast() === false ) {
        $( '#quiz-prev' ).show();
    } 
}
function quizControlsSubmit( ID ){
    if ( currentQuizNextDelay === true ) {
	    currentQuizNextDelay = false;
        $('#quiz-next').hide();
        $( '#quiz-list' ).hide();
        quizUpdateList( ID );
        quizGrade( ID );
        quizUpdateQuiz( ID );
        layer( 'last' );
        currentQuizMode = 0;
        courseStatus.quiz_current_question[ID] = null;        
        courseStatus.quiz_start_time[ID] = null;
        quizCounterClear(ID);
        $('#next-button-blink').hide();
        $('#submit-button-blink').hide();
        setTimeout( function() {
            quizUpdateEndScreen( ID );
        }, 5);
        setTimeout( function() {
            currentQuizNextDelay = true;
        }, 500);
    }
    
}

function quizControlsTryAgain( ID ){
    quizTryAgain( ID );
}
function quizControlsReview( ID ){
    quizReview( ID );
}
function quizControlsFinish( ID ){
    quizFinish( ID );
}
function quizControlsListGoTo( ID, number, caller ) {
    if( !$( caller ).hasClass('button-locked') ){
            
        layer( number );
        quizUpdateList( ID );
        quizUpdateQuiz( ID );
        quizUpdateAnswers( ID );
        $('#next-button-blink').hide();
        $('#submit-button-blink').hide();

        // if( $('#layer-'+ number).find('.quiz-answer.selected').length ){
        //     if(layerBeforeLast() && currentQuizMode !== 1){
        //         $('#quiz-next').hide();
        //         $('#quiz-submit').show();
        //     } else {
        //         $('#quiz-next').show();
        //         $('#quiz-next').css({'opacity':1,'pointer-events':'all'});
        //     }
        // } else {
        //     $('#quiz-next').css({'opacity':0,'pointer-events':'none'});
        // }

        if( 
            $('#layer-'+ number).find('.quiz-answer.selected').length ||
            ( !$('#layer-'+ number).find('.quiz-answer.selected').length && currentQuizMode === 1 )
        ){

            if( 
                layerBeforeLast() && currentQuizMode !== 1
            ){

                $( '#quiz-next' ).hide();
                $( '#quiz-submit' ).show();

            } else {
                if( 
                    currentQuizMode === 1 && layerLast()
                ){ 
                    $( '#quiz-next' ).hide();
//                    $( '#quiz-next' ).css({'opacity':0,'pointer-events':'none'});
                }else{
                    $( '#quiz-next' ).show();
//                    $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});
                }

            }

        } else {

            if( currentQuizMode === 1 ){
                $( '#quiz-next' ).hide();
            } else {
                $( '#quiz-next' ).show();
            }

//            $( '#quiz-next' ).css({'opacity':0,'pointer-events':'none'});
        }
    }
}

function quizCounterStart( ID ) {
    var timeLimit = quizConfig[ID].maximum_time;
    if ( timeLimit > 0 ) {
        var d = new Date();
        courseStatus.quiz_start_time[ID] = parseInt( d.getTime() / 1000 );
        courseStatus.quiz_total_time[ID] = 0;
        zork('This quiz started at ' + d + '.');
        quizCounterUpdate( ID );
        if ( layerCurrent() === 0 ) {
            quizCounterClear( ID );
        }
    }
}

function quizCounterClear( ID ) {
    $('#quiz-counter').html('');
    $('#quiz-counter').removeClass('-visible');
    courseStatus.quiz_start_time[ID] = null;
}

var quizCounterSaveTime = 10; // Gravar de segurança de quantos em quantos segundos

// function quizCounterUpdate( ID ) {
//     var timeLimit = quizConfig[ID].maximum_time;

//     if ( timeLimit > 0 ) {
//         var startTime = courseStatus.quiz_start_time[ID];
//         if ( startTime === null || startTime === 'null' ) {
//             var d = new Date();
//             courseStatus.quiz_start_time[ID] = parseInt( d.getTime() / 1000 );
//             startTime = courseStatus.quiz_start_time[ID];
//         }
//         if ( startTime > 0 ) {
//             var quizTime = 0;

//             if ( quizConfig[ID].continuous_timing ) {
//                 var d = new Date();
//                 var currentTime = parseInt( d.getTime() / 1000 );
//                 quizTime = currentTime - startTime;
//             } else {
//                 quizTime = courseStatus.quiz_total_time[ID] + 1;
//             }

//             if ( quizTime > timeLimit ) {
//                 quizCounterTimeout( ID );
//             } else {
//                 courseStatus.quiz_total_time[ID] = quizTime;
//                 if ( quizTime % quizCounterSaveTime === 0 ) {
//                     zork( quizTime + ' seconds have passed since the start of this quiz.');
//                     courseSave();
//                 }

//                 var timeLeft = timeLimit - quizTime;
//                 if ( timeLeft < 3600 ) {
//                     timeLeft = convertMSminute( timeLeft*1000 );
//                 } else {
//                     timeLeft= convertMShour( timeLeft*1000 );
//                 }

//                 $('#quiz-counter').html(timeLeft);
//                 setTimeout( function() {
//                     if ( layerCurrent() > 0 ) {
//                         quizCounterUpdate( ID );
//                     } else {
//                         quizCounterClear( ID );
//                     }
//                 }, 1000);
//             }
//         }
//     }
// }

function quizCounterUpdate( ID ) {
    var startTime = courseStatus.quiz_start_time[ID];
    
    if ( startTime === null || startTime === 'null' ) {
        var d = new Date();
        courseStatus.quiz_start_time[ID] = parseInt( d.getTime() / 1000 );
        startTime = courseStatus.quiz_start_time[ID];
    }
    if ( startTime > 0 ) {
        var quizTime = 0;
        var timeLimit = quizConfig[ID].maximum_time;
        
        if ( quizConfig[ID].continuous_timing ) {
            var d = new Date();
            var currentTime = parseInt( d.getTime() / 1000 );
            quizTime = currentTime - startTime;
        } else {
            quizTime = courseStatus.quiz_total_time[ID] + 1;
        }
        
        if ( quizTime > timeLimit ) {
            quizCounterTimeout( ID );
        } else {
            courseStatus.quiz_total_time[ID] = quizTime;
            if ( quizTime % quizCounterSaveTime === 0 ) {
                zork( quizTime + ' seconds have passed since the start of this quiz.');
                courseSave();
            }
            
            var timeLeft = timeLimit - quizTime;
            if ( timeLeft < 3600 ) {
                timeLeft = convertMSminute( timeLeft*1000 );
            } else {
                timeLeft= convertMShour( timeLeft*1000 );
            }
            
            $('#quiz-counter').html(timeLeft);
            $('#quiz-counter').addClass('-visible');
            setTimeout( function() {
                if ( layerCurrent() > 0 && !layerLast() ) {
                    quizCounterUpdate( ID );
                } else {
                    quizCounterClear( ID );
                }
            }, 1000);
        }
    }
}

function quizCounterTimeout( ID ) {
    var timeLimit = quizConfig[ID].maximum_time;
    if ( timeLimit > 0 ) {
        layerGoTo( layerTotal() - 1);
        $('#message-end-timeout').show();
        courseStatus.quiz_timeout[ID] = 1;
        courseStatus.quiz_start_time[ID] = null;
        $('.quiz-button').hide();
        quizControlsSubmit(ID);
    }
}

function quizUpdateList( ID ) {
    var n = layerCurrent() + 1;
    var total = courseStatus.quiz_current_question + 1;
    for ( var t = 0; t < n; t++ ) {
        $( '#quiz-list-' + t ).removeClass( 'button-locked' );  
    }
        
//    $( '#quiz-list-' + layerCurrent() ).removeClass( 'button-locked' );  
//    $( '#quiz-list-' + n ).removeClass( 'button-locked' );   
}

// Choose an answer
function quizAnswer( ID, question, answer ) {

    var bankID = courseStatus.quiz_bank[ID][ question ];
    var questionID = courseStatus.quiz_questions[ID][ question ];
    
    if ( quizQuestions[ bankID ][ questionID ].type === 'single' ) {
	//zork('Single choice question!');
    } else if ( quizQuestions[ bankID ][ questionID ].type === 'multiple' ) {
	//zork('Multiple choice question!');
	var answered = '' + courseStatus.quiz_answers[ ID ][ question ];
	var answerString = '' + answer;
	
	if ( answered.length <= 0 || answered === 'x' ) {
	    zork('There wasn\'t an answer before!');
	    answered = '' + answer;
	} else {
	    zork('There was an answer before! It was ' + answered + '!');
	    if ( answered.includes( answerString ) ) {
		zork('You had already choosen ' + answerString + '!');
		answered = answered.replace( answerString, '');
	    } else {
		zork('Adding ' + answerString + ' to ' + answered + '!');
		answered += answerString;
	    }
	    
	    
	    if ( answered <= 0 ) {
		answered = 'x';
	    }
	    
	    answer = answered;
	}
    }
    courseStatus.quiz_answers[ ID ][ question ] = answer;
    zork( 'Answered ' + answer + ' to question ' + question + ' in quiz ' + ID + '.');
    quizUpdateAnswers( ID );
    $('#next-button-blink').show();
    $('#submit-button-blink').show();

    if( layerBeforeLast() ){
        $('#quiz-next').hide();

        $('#quiz-submit').show();
    } else {
        $('#quiz-next').show();
//        $('#quiz-next').css({'opacity':1,'pointer-events':'all'});
    }
}

// Update Answers
function quizUpdateAnswers( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    
    zork( 'Updating answers!');
    var answers = courseStatus.quiz_answers[ ID ].length;
    $( '.quiz-answer' ).removeClass( 'selected' );
    
    for( i = 0; i < answers; i++) {
	var bankID = courseStatus.quiz_bank[ID][ i ];
	var questionID = courseStatus.quiz_questions[ID][ i ];
	var n = i + 1;

	if ( quizQuestions[ bankID ][ questionID ].type === 'single' ) {
	    //zork('Single choice question!');
	    var answer = courseStatus.quiz_answers[ ID ][i];
	    $( '#quiz-answer-' + n + '-' + answer ).addClass( 'selected ');
            if ( answer !== 'x' ) {
                $( '#quiz-list-' + n ).addClass( 'answered ');  
            }
	    zork( 'Selecting answer ' + answer + ' for question ' + i +'!');
	} else if ( quizQuestions[ bankID ][ questionID ].type === 'multiple' ) {
	    //zork('Multiple choice question!');
	    var options = '' + courseStatus.quiz_answers[ ID ][i];
	    var numberOfOptions = options.length;
	    for ( f = 0; f < numberOfOptions; f++ ) {
		var answer = options[f];
		$( '#quiz-answer-' + n + '-' + answer ).addClass( 'selected ');
		zork( 'Selecting answer ' + answer + ' for question ' + i +'!');
	    }
	}
	
    }
    
    courseStatus.quiz_last_bank[ID] = courseStatus.quiz_bank[ID];
    courseStatus.quiz_last_questions[ID] = courseStatus.quiz_questions[ID];
    courseStatus.quiz_last_answers[ ID ] = courseStatus.quiz_answers[ ID ];
    
    setTimeout( function() {
	if ( quizConfig[ ID ].advance === 'answer' ) {
	    if ( layerInTheMiddle() && layerBeforeLast() === false && layerFirst() === false ) {

		if ( currentQuizMode === 0 ) {
		    if ( quizConfig[ ID ].feedback === true ) {//This is what's bugging at the start
			    $( '#quiz-feedback' ).show();
		    } else {
			    //$( '#quiz-next' ).show();
                if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
		    }
		} else {

		    $( '#quiz-next' ).show();
//            $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});

            if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
		}
	    } else if ( layerInTheMiddle() && layerBeforeLast() ) {
		if ( currentQuizMode === 0 ) {
		    if ( quizConfig[ ID ].feedback === true ) {
			$( '#quiz-feedback' ).show();
		    } else {

            if( !$('#layer-'+ courseStatus.quiz_current_question[0]).find('.quiz-answer.selected').length ){
                $( '#quiz-submit' ).show();
            }

            if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
		    }
		} else {

		    $( '#quiz-next' ).show();
                    if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
		}
	    }
	} else if ( quizConfig[ ID ].advance === 'auto' ) {
	    if ( layerInTheMiddle() && layerBeforeLast() === false ) {
		    quizControlsNext( ID );
	    } else if ( layerBeforeLast() ) {
		    quizControlsSubmit( ID ); 
	    }
	} else if ( quizConfig[ ID ].advance === 'always' ) {
            if ( layerInTheMiddle() && layerBeforeLast() === false ) {
		$( '#quiz-next' ).show();
//        $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});

		if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
	    } else if ( layerBeforeLast() ) {
                if ( currentQuizMode === 0 ) {
                    $( '#quiz-submit' ).show();
                    console.log('aqui fred')

                    if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
                } else {
                    $( '#quiz-next' ).show();
                    $( '#quiz-prev' ).show();
                }
	    }
        }
    }, 5);
}

function quizFeedbackAnswer( ID, question ) {
    var bank = courseStatus.quiz_bank[ ID ][question];
    var bankQuestion = courseStatus.quiz_questions[ ID ][question];
    var questionNumber = question + 1;
    var key = quizQuestions[bank][bankQuestion].key;
    var correct = false;
    
    zork('Showing feedback for question ' + questionNumber + ' (bank: ' + ID + ', question ' + question + ')!');
    
    $( '#quiz-next' ).hide();
    $( '#quiz-prev' ).hide();
    $( '#quiz-feedback' ).hide();
    
    zork('Removing click from question ' + questionNumber + ' answers!');
    $( '.quiz-answer-' + questionNumber ).prop( 'onclick', null  );
    $( '.quiz-answer-' + questionNumber ).removeClass( 'button-click' );
    
    zork('Coloring question ' + questionNumber + ' answers!');
    $( '.quiz-answer-' + questionNumber ).addClass( 'wrong' );
    
    if ( quizQuestions[bank][bankQuestion].type === 'single' ) {
	$( '#quiz-answer-' + questionNumber + '-' + key ).addClass( 'correct' );
	$( '#quiz-answer-' + questionNumber + '-' + key ).removeClass( 'wrong' );

	if ( $( '#quiz-answer-' + questionNumber + '-' + key + '.correct' ).hasClass( 'selected' ) ) {
	    zork( 'Question ' + questionNumber + ' (single) is CORRECT!' );
	    $( '#quiz-list-' + questionNumber ).addClass( 'correct' );
	    correct = true;
	    
	} else {
	    zork( 'Question ' + questionNumber + ' (single) is WRONG!' );
	    $( '#quiz-list-' + questionNumber ).addClass( 'wrong' );
	}

    } else if ( quizQuestions[bank][bankQuestion].type === 'multiple' ) {
	var keySize = key.length;
	var ruined = 0;

	for ( f = 0; f < keySize; f++ ) {
	    var answerKey = key[f];
	    $( '#quiz-answer-' + questionNumber + '-' + answerKey ).addClass( 'correct' );
	    $( '#quiz-answer-' + questionNumber + '-' + answerKey ).removeClass( 'wrong' );
	    if( !$( '#quiz-answer-' + questionNumber + '-' + answerKey ).hasClass('selected') ) {
		ruined += 1;
	    }
	}
	
	if ( $('.quiz-answer-' + questionNumber + '.wrong').hasClass('selected') ||
		ruined > 0 ) {
	    zork( 'Question ' + questionNumber + ' (multiple) is WRONG!' );
	    $( '#quiz-list-' + questionNumber ).addClass( 'wrong' );
	} else {
	    zork( 'Question ' + questionNumber + ' (multiple) is CORRECT!' );
	    $( '#quiz-list-' + questionNumber ).addClass( 'correct' );	
	    correct = true;
	}

    }
    $( '#quiz-feedback-window' ).removeClass( 'quiz-feedback-window-wrong' );
    $( '#quiz-feedback-window' ).removeClass( 'quiz-feedback-window-right' );
    var feedbackData = '';
    if ( correct === true ) {
	if ( quizQuestions[bank][question].feedback_right === false ) {
	    feedbackData = quizConfig[ ID ].message_feedback_standard_right;
	} else {
	    feedbackData = quizQuestions[bank][bankQuestion].feedback_right;
	}
	
	$( '#quiz-feedback-window' ).addClass( 'quiz-feedback-window-right' );
    } else {
	if ( quizQuestions[bank][question].feedback_wrong === false ) {
	    feedbackData = quizConfig[ ID ].message_feedback_standard_wrong;
	} else {
	    feedbackData = quizQuestions[bank][bankQuestion].feedback_wrong;
	}
	$( '#quiz-feedback-window' ).addClass( 'quiz-feedback-window-wrong' );
    }
    
    $( '#quiz-feedback-message' ).html( feedbackData );
	
    $( '#quiz-feedback-window' ).show();
    $( '#quiz-feedback-next' ).hide();
    
}

function quizUpdateQuiz( ID ) {
    if ( ID === undefined ) {
	    ID = currentQuiz;
    }
    
    zork('Hiding EVERYTHING!');
    $( '#quiz-start' ).hide();
    $( '#quiz-try-again' ).hide();
    $( '#quiz-review' ).hide();
    console.log('esconder aqui')
    $( '#quiz-finish' ).hide();
    //$( '#quiz-next' ).hide();
    $( '#quiz-prev' ).hide();
    $( '#quiz-feedback' ).hide();
    $( '#quiz-submit' ).hide();
    
    var grade = quizGradeToSubmit( ID );
    
    setTimeout( function() {
        if ( layerFirst() ) {
    //	    if ( courseStatus.quiz_attempts[ ID ] > 0 && currentQuizMode === 0 || courseStatus.quiz_attempts[ ID ] === -1 && currentQuizMode === 0 ) {
    ////		$( '#quiz-start' ).show();
    //                if ( courseStatus.quiz_finished[ ID ] === 1 ) {
    //                    if ( quizConfig[ ID ].submit_try_again_allow === true ) {
    //                        $( '#quiz-start' ).show();
    //                    }
    //                    if ( quizConfig[ ID ].review !== false ) {
    //                        $( '#quiz-review' ).removeClass('end');
    //                        $( '#quiz-review' ).show();
    //                    }
    //                } else {
    //                    $( '#quiz-start' ).show();
    //                }
    //	    }
    //            if ( courseStatus.quiz_finished[ ID ] === 1 ) {
    //                if ( quizConfig[ ID ].review !== false ) {
    //                    $( '#quiz-review' ).removeClass('end');
    //                    $( '#quiz-review' ).show();
    //                }
    //            }
    //	    if ( quizConfig[ ID ].submit_conditions === 'user' && grade >= quizConfig[ ID ].minimum_grade && currentQuizMode === 0 && courseStatus.quiz_finished[ ID ] === 0 || 
    //                quizConfig[ ID ].submit_conditions === 'best' && grade >= quizConfig[ ID ].minimum_grade && currentQuizMode === 0 && courseStatus.quiz_finished[ ID ] === 0) {
    //		$( '#quiz-finish' ).show();
    //	    }
                $( '#quiz-start' ).show();
        } else if ( layerLast() ) {









            if ( quizConfig[ ID ].submit_conditions === 'user' && grade >= quizConfig[ ID ].minimum_grade && courseStatus.quiz_finished[ ID ] === 0 && grade < 100
                        || quizConfig[ ID ].submit_conditions === 'best' && grade >= quizConfig[ ID ].minimum_grade && grade < 100 && courseStatus.quiz_finished[ ID ] === 0
                        ) {
            $('#quiz-finish').show();
                console.log('1 aqui?')
                } else if ( quizConfig[ ID ].submit_conditions === 'best' && grade === 100 && courseStatus.quiz_finished[ ID ] === 0 
                        || quizConfig[ ID ].submit_conditions === 'best' && grade >= quizConfig[ ID ].minimum_grade && courseStatus.quiz_attempts[ ID ] === 0 && courseStatus.quiz_finished[ ID ] === 0  
                        || quizConfig[ ID ].submit_conditions === 'user' && grade >= quizConfig[ ID ].minimum_grade && courseStatus.quiz_attempts[ ID ] === 0 && courseStatus.quiz_finished[ ID ] === 0 
                        || quizConfig[ ID ].submit_conditions === 'user' && grade === 100 && courseStatus.quiz_finished[ ID ] === 0 
                        ) { 
    //                alert('DING');
                console.log('2 aqui?')
            courseStatus.quiz_attempts[ ID ] = 0;
                    quizFinish( ID );
            } else if ( quizConfig[ ID ].submit_conditions === 'attempts' && courseStatus.quiz_attempts[ ID ] === 0 && courseStatus.quiz_finished[ ID ] === 0 ) {
                console.log('3 aqui?')
                quizFinish( ID );
            } else if ( quizConfig[ ID ].submit_conditions === 'pass' && grade >= quizConfig[ ID ].minimum_grade && courseStatus.quiz_finished[ ID ] === 0 ) {
                console.log('4 aqui?')
            
                quizFinish( ID );
            } else if ( courseStatus.quiz_attempts[ ID ] === 0 ) {
                console.log('5 aqui?')

                    quizFinish( ID );
                }
            
            if ( courseStatus.quiz_attempts[ ID ] > 0 || quizConfig[ ID ].attempts === -1) {
                    if ( courseStatus.quiz_finished[ ID ] === 1 ) {
                        if ( quizConfig[ ID ].submit_try_again_allow === true ) {
                            $( '#quiz-try-again' ).show();
                        }
                    } else {
                        $( '#quiz-try-again' ).show();
                    }
            }
            if ( quizConfig[ ID ].review === true ) {
                    $( '#quiz-review' ).addClass('end');
                    $( '#quiz-review' ).show();
            } else if ( quizConfig[ ID ].review === 'pass' && grade >= quizConfig[ ID ].minimum_grade ) {
                
                    $( '#quiz-review' ).addClass('end');
                    $( '#quiz-review' ).show();
            } else if ( quizConfig[ ID ].review === 'submit' && courseStatus.quiz_finished[ ID ] === 1 ) {
                    $( '#quiz-review' ).addClass('end');
                    $( '#quiz-review' ).show();
            }
            if ( grade === 100 && courseStatus.quiz_finished[ ID ] === 0 || courseStatus.quiz_attempts[ ID ] === 0  ) {
                    quizFinish( ID );
            }
    //            $( '#quiz-review' ).show();
    //            $( '#quiz-try-again' ).show();

        } else if ( layerBeforeLast() ) {
            //$( '#quiz-submit' ).show();
            if ( currentQuizMode === 0 ) {
            if ( quizConfig[ ID ].feedback === true ) {
                $( '#quiz-feedback' ).show();
            } else {
                //$( '#quiz-submit' ).show();
            }
            } else {
            //$( '#quiz-next' ).show();
            }
        }
        var q = layerCurrent() - 1;
        if ( layerInTheMiddle() && layerBeforeLast() === false && quizConfig[ ID ].advance === 'always' || 
            layerInTheMiddle() && layerBeforeLast() === false && courseStatus.quiz_answers[ ID ][q] > -1) {
            if ( currentQuizMode === 0 ) {
            if ( quizConfig[ ID ].feedback === true ) {
                $( '#quiz-feedback' ).show();
            } /*else {
                $( '#quiz-submit' ).show();
            }*/
            } else {
            $( '#quiz-next' ).show();
//            $( '#quiz-next' ).css({'opacity':1,'pointer-events':'all'});
            if ( layerCurrent() > 1 ) { $( '#quiz-prev' ).show();} 
            }
        }
        if ( layerInTheMiddle() ) {
            $( '#quiz-list' ).show();
            var a = layerCurrent();
            $( '.quiz-list-item' ).removeClass( 'active' );
            $( '#quiz-list-' + a ).addClass( 'active' );
        } else {
            $( '#quiz-list' ).hide();
        }
        
        quizCorrectAnswer( ID );
            courseStatus.quiz_current_question[ID] = layerCurrent();
        $( '.llwindow-quiz' ).show();
        $( '#llwindow-data-quiz-name' ).text( quizConfig[ID].name );
        $( '#llwindow-data-quiz' ).text( ID );
        $( '#llwindow-data-last' ).text( courseStatus.quiz_last_grade[ID] );
        $( '#llwindow-data-best' ).text( courseStatus.quiz_best_grade[ID] );
        $( '#llwindow-data-attempts' ).text( courseStatus.quiz_attempts[ID] );
    },
    10);
    

}

function quizCorrectAnswer( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    
    if ( layerInTheMiddle() ) {
	var questionNumber = layerCurrent() - 1;
	var bank = courseStatus.quiz_bank[ ID ][ questionNumber ];
	var question = courseStatus.quiz_questions[ ID ][ questionNumber ];
	var key = quizQuestions[bank][question].key;
	
    if(adminMode) console.log('%cA RESPOSTA CERTA É A ' + key, 'background-color:black;color:white;font-size:30px;padding:5px;' )
	zork( 'PSST! The correct answer to question ' + questionNumber + ' is ' + key +'!');
	
	$( '#llwindow-data-bank' ).text( bank );
	$( '#llwindow-data-question' ).text( question );
	$( '#llwindow-data-answer' ).text( key );

    }
}

function quizUpdateEndScreen( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    
    var grade;
    
    grade = courseStatus.quiz_last_grade[ ID ];
    gradeToSubmit = quizGradeToSubmit(ID);
    
//    var attempts = courseStatus.quiz_attempts[ ID ];
    var pass = quizConfig[ ID ].minimum_grade;
    $('.quiz-message-end').hide();
    
    if ( layerLast() ) { 
        courseStatus.quiz_start_time[ID] = null;
        
        var passed = '';        
//        if ( courseStatus.quiz_finished[ID] === 1 ) {
        if ( gradeToSubmit >= pass ) {
            passed = '-passed';
        }
        
        var passTest = '-fail';
        if ( grade >= pass  ) {
            passTest = '-pass';
            if ( justPassed ) {passed = '';}
        }
        
        var attempts = '';
        if ( courseStatus.quiz_attempts[ID] === 0 ) {
            attempts = '-no-attempts';
	}
        
        var timeout = '';
        if ( courseStatus.quiz_timeout[ID] === 1 ) {
            timeout = '-timeout';
        }

        let best = '';

        if(grade === 100){
            best = '-best'
            passTest='';
            attempts = '';
        }
        
        $('#message-end-generic'+passTest).show();
        $('#message-end'+timeout+passTest+passed+attempts+best).show();
        zork('Showing end layer: #message-end'+timeout+passTest+passed+attempts+best );
    }
    
    quizUpdateScreenInfo( ID );
}

function quizUpdateStartScreen( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    
    var grade = quizGradeToSubmit( ID );
    
    var attempts = courseStatus.quiz_attempts[ ID ];
    var pass = quizConfig[ ID ].minimum_grade;
    
    zork('Updating start screen...');
    $('.quiz-message-start').hide();
    $( '#message-start-terminated' ).hide();
    $( '#message-start-first' ).hide();
    $( '#message-start-pass' ).hide();
    $( '#message-start-pass-no-attempts' ).hide();
    $( '#message-start-fail' ).hide();
    $( '#message-start-fail-no-attempts' ).hide();
    
    if ( attempts === quizConfig[ ID ].attempts ){
	$( '#message-start-first' ).show();
        $('#quiz-start-grade').hide();
        $('#quiz-start-best-grade').hide();
        $('#quiz-start-attempts').hide();

	zork('FIRST!');
    } else { 
        $('#quiz-start-grade').show();
        $('#quiz-start-best-grade').show();
        $('#quiz-start-attempts').show();
        if ( courseStatus.quiz_finished[ ID ] === 1 ) {
            $( '#message-start-terminated' ).show();
        } else {
            if ( grade <= 100 && grade >= pass ) {
                if ( attempts > 0 || attempts === -1 ) {
                    $( '#message-start-pass' ).show();
                    zork('Passed with attempts left...');
                } else if ( attempts === 0 ) {
                    $( '#message-start-pass-no-attempts' ).show();
                    zork('Passed with no attempts left...');
                }
            } else if ( grade < pass  ) {
                if ( attempts > 0 || attempts === -1 ) {
                    $( '#message-start-fail' ).show();
                    zork('Failed with attempts left...');
                } else if ( attempts === 0 ) {
                    $( '#message-start-fail-no-attempts' ).show();
                    zork('Failed with no attempts left...');
                }
            }
        }
    }
    $( '#message-start-generic' ).show();
    
    quizUpdateScreenInfo( ID );
}

function quizUpdateScreenInfo( ID ) {
    if ( ID === undefined ) {
	    ID = currentQuiz;
    }
    
    var best = courseStatus.quiz_best_grade[ ID ];
    var grade = courseStatus.grade;
    var lastGrade = courseStatus.quiz_last_grade[ ID ]; 
    var attempts = courseStatus.quiz_attempts[ ID ];
    var pass = quizConfig[ ID ].minimum_grade;
    var submit = /*grade =*/ quizGradeToSubmit( ID );
    var date = courseStatus.quiz_submit_grade_date;
    
    $('.quiz-total').html(totalQuestions[ID]);
    $('.js-totalPlural').html(totalQuestions[ID] > 1 ? 'ões' : 'ão')
    $( '.quiz-best-grade' ).html( best );
    $( '.quiz-grade' ).html( grade );
    $( '.quiz-last-grade' ).html( lastGrade );
    $( '.quiz-attempts' ).html( attempts );
    $('.js-attemptsPlural').html(courseStatus.quiz_attempts[ID] !== 1 ? 's':'');
    $( '.quiz-pass' ).html( pass ); 
    $( '.quiz-final-grade' ).html( submit ); 
    $( '.quiz-end-date').html( date ); 
}

function quizClearAnswers( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    
    var answers = courseStatus.quiz_answers[ ID ].length;
    
    for ( i = 0; i < answers; i++ ) {
	courseStatus.quiz_answers[ ID ][ i ] = -1;
    }
    
    quizUpdateAnswers( ID );
}

function quizTryAgain( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    currentQuizTryAgain = true;
    
    currentQuizMode = 1;
    courseStatus.quiz_current_question[ ID ] = null;
    quizBuildHtml( ID );
    
    currentQuizMode = 0;
    courseStatus.quiz_total_time[ID] = 0;
//    quizCounterStart( ID );
//    quizControlsStart( ID );
}

function quizReview( ID, target ) {
    if ( target === undefined ) target = 'all';
    
    if ( ID === undefined ) {
	    ID = currentQuiz;
    }
    
    currentQuizMode = 1;
    
    zork( 'Updating answers for review!');
    var answers = courseStatus.quiz_answers[ ID ].length;
    
    $( '.quiz-answer' ).removeClass( 'button-click' );
    $( '.quiz-answer' ).prop( 'onclick', null  );
    $( '.quiz-answer' ).addClass( 'wrong' );
    $( '.quiz-list-item' ).addClass( 'wrong' );
    
    if ( quizConfig[ ID ].help = 'review' ) {
	$( '.quiz-help-review' ).addClass( 'quiz-help' );
	$( '.quiz-help' ).removeClass( 'quiz-help-review' );
    }
    if ( quizConfig[ID].review_type === 'best' ) {
        courseStatus.quiz_bank[ ID ] = courseStatus.quiz_best_bank[ ID ];
        courseStatus.quiz_questions[ ID ] = courseStatus.quiz_best_questions[ ID ];
        courseStatus.quiz_answers[ ID ] = courseStatus.quiz_best_answers[ ID ];
    } else if ( quizConfig[ID].review_type === 'last' ) {
        courseStatus.quiz_bank[ ID ] = courseStatus.quiz_last_bank[ ID ];
        courseStatus.quiz_questions[ ID ] = courseStatus.quiz_last_questions[ ID ];
        courseStatus.quiz_answers[ ID ] = courseStatus.quiz_last_answers[ ID ];
    }
    for( i = 0; i < answers; i++) { //Check each answer
	var n = i + 1;
	var bank = courseStatus.quiz_bank[ ID ][i];
	var question = courseStatus.quiz_questions[ ID ][i];
        var answered = [];

        
	var key = quizQuestions[bank][question].key;
        
	
                
        
	zork( 'Checking answer ' + n + '!' );
	if ( quizQuestions[bank][question].type === 'single' ) {
	    $( '#quiz-answer-' + n + '-' + key ).addClass( 'correct' );
	    $( '#quiz-answer-' + n + '-' + key ).removeClass( 'wrong' );
	    
	    if ( $( '#quiz-answer-' + n + '-' + key + '.correct' ).hasClass( 'selected' ) ) {
		zork( 'Question ' + n + ' (single) is CORRECT!' );
		$( '#quiz-list-' + n ).addClass( 'correct' );
		$( '#quiz-list-' + n ).removeClass( 'wrong' );
	    } else {
		zork( 'Question ' + n + ' (single) is WRONG!' );
	    }
	    
	} else if ( quizQuestions[bank][question].type === 'multiple' ) {
	    var keySize = key.length;
	    var ruined = 0;
	    
	    for ( f = 0; f < keySize; f++ ) {
		var answerKey = key[f];
		$( '#quiz-answer-' + n + '-' + answerKey ).addClass( 'correct' );
		$( '#quiz-answer-' + n + '-' + answerKey ).removeClass( 'wrong' );
		if( !$( '#quiz-answer-' + n + '-' + answerKey ).hasClass('selected') ) {
		    ruined += 1;
		}
	    }
	    if ( quizConfig[ ID ].multiple_choice_grade === 'some' ) {
		
	    } else if ( quizConfig[ ID ].multiple_choice_grade === 'all' ) {
		
		if ( $('.quiz-answer-' + n + '.wrong').hasClass('selected') ||
			ruined > 0 ) {
		    zork( 'Question ' + n + ' (multiple) is WRONG!' );
		} else {
		    zork( 'Question ' + n + ' (multiple) is CORRECT!' );
		    $( '#quiz-list-' + n ).addClass( 'correct' );
		    $( '#quiz-list-' + n ).removeClass( 'wrong' );
		}
	    }

	}

    }
    $('.quiz-question-instruction').hide();
    layer( 1 );
    setTimeout( function() {
        quizUpdateQuiz( ID );
        quizUpdateAnswers( ID );
    }, 5);
}

function quizFinish( ID ) {
    if ( courseStatus.quiz_finished[ ID ] !== 1 ) {
    //    var grade = quizGradeToSubmit( ID );
        console.log('%cCURSO CONCLUIDO!','background-color:yellow;color:blue;font-size:30px;')
        var grade = courseStatus.quiz_last_grade[ ID ];
        quizSubmit( ID );
       if ( courseStatus.quiz_attempts[ ID ] > 0 ) {
    	courseStatus.quiz_attempts[ ID ] = 0;
       }
        courseStatus.quiz_finished[ ID ] = 1;
        
    //    if ( courseStatus.quiz_attempts[ ID ] === 0 && quizConfig[ ID ].unlock === 'attempts' ) {
    //	slideComplete();
    //    }
    //    if ( quizConfig[ ID ].unlock === 'pass' && grade >= quizConfig[ ID ].minimum_grade ) {
    //	slideComplete();
    //    }  
        quizUpdateQuiz( ID );
        quizUpdateEndScreen( ID );
    }
}


// Get quiz grade in %
function quizGradeToSubmit( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
//    quizGrade( ID );
    var grade;
    if ( quizConfig[ ID ].best_grade === true ) {
	grade = courseStatus.quiz_best_grade[ ID ];
    } else {
	grade = courseStatus.quiz_last_grade[ ID ];
    }
    return grade;
}
function quizGrade( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
        
    zork( 'Calculating grade for quiz ' + ID +'...');
    
    var totalQuestions = courseStatus.quiz_answers[ ID ].length;
    
    var correctAnswers = 0;
    
    for ( i = 0; i < totalQuestions; i++ ) {
        var bank = courseStatus.quiz_bank[ ID ][ i ];
        var question = courseStatus.quiz_questions[ ID ][ i ];
        var answer = courseStatus.quiz_answers[ ID ][ i ];
        var key = quizQuestions[bank][question].key;
        var type = quizQuestions[bank][question].type;
        
        zork( 'Checking if question ' + question + ' key (' + key + ') and it\'s answer (' + answer + ') are equal...');
        var rightWrong = 'incorrect';
        if ( type === 'single' ) {
            zork('Single choice question!');
            console.log({key,answer})
            if ( key === answer ) {
                correctAnswers += 1;
                rightWrong = 'correct';
                zork('They are! And this answer is worth 1!');
            } else {
                zork('They aren\'t...');
            }
        } else if ( type === 'multiple' ) {
            zork('Multiple choice question!');
            var answerSize = answer.length;
            var keySize = key.length;
            var valuePerItem = 100 / keySize;
            var answerValue = 0;
            var ruined = 0;
            
            for ( f = 0; f < answerSize; f++ ) {
            if ( answerSize <= keySize ) {
                zork( 'Checking ' + answer + ' includes ' + key[f] + '...' );
                if ( answer.includes( key[f] ) ) {
                answerValue += valuePerItem;
                zork('It does!');
                } else {
                ruined += 1;
                zork('It doesn\'t!');
                }
            } else {
                ruined = answerSize - keySize;
                zork('Too many locks for so little keys...');
            }
            }
            zork('You choose ' + ruined + ' unecessary questions...');
            
            if ( answerValue >= 100 - quizConfig[ ID ].multiple_choice_forgiveness &&
            answerValue <= 100 + quizConfig[ ID ].multiple_choice_forgiveness ){
            answerValue = 100;
            }
            
            if ( quizConfig[ ID ].multiple_choice_grade === 'some' ) {
            /*answerValue = ( Math.round( answerValue / 10 ) ) / 10;
            correctAnswers += answerValue;
            zork('This answer is worth ' + answerValue + '!');*/
            } else if ( quizConfig[ ID ].multiple_choice_grade === 'all' ) {
            if ( ruined > 0) {
                answerValue = 0;
                zork('You chose WRONG! And for that you must die!!!');
            }
            if ( answerValue === 100 ) {
                correctAnswers += 1;
                zork('They are equal! And this answer is worth 1!');
            } else {
                zork('They aren\'t equal...');
            }
            }
        }	
            

        var questionText = quizQuestions[bank][question].question;
        var answerText = quizQuestions[bank][question].answers[answer];
        courseInteraction(i, 'Pergunta de teste', questionText, answerText, rightWrong, rightWrong, i +'_0');
    }
    zork( 'You answered correctly to ' + correctAnswers + ' questions in a total of ' + totalQuestions + '.');
    console.log(correctAnswers)
    
    var grade = correctAnswers * 100 / totalQuestions;
    
    var decimals = quizConfig[ ID ].grade_round_decimal;
    
    if ( decimals > 0 ) {
        decimals = Math.pow(10, decimals);
    } else {
        decimals = 1;
    }
    
    if ( quizConfig[ ID ].grade_round === true ) {
        grade = Math.round( grade * decimals) / decimals;
    } else if ( quizConfig[ ID ].grade_round === 'down' ) {
        grade = Math.floor( grade * decimals) / decimals;
    } else if ( quizConfig[ ID ].grade_round === 'up' ) {
        grade = Math.ceil( grade * decimals) / decimals;
    }
    
    courseStatus.quiz_last_grade[ ID ] = grade;
    
    if ( grade >= courseStatus.quiz_best_grade[ ID ] ) {
	courseStatus.quiz_best_grade[ ID ] = grade;
        
	courseStatus.quiz_best_bank[ ID ] = courseStatus.quiz_bank[ ID ];
        zork('Saving best bank ' + courseStatus.quiz_bank[ ID ] );
        courseStatus.quiz_best_questions[ ID ] = courseStatus.quiz_questions[ ID ];
        zork('Saving best questions ' + courseStatus.quiz_questions[ ID ] );
        courseStatus.quiz_best_answers[ ID ] = courseStatus.quiz_answers[ ID ];
        zork('Saving best answers ' + courseStatus.quiz_answers[ ID ] );
    }
    
    zork( 'Your grade for quiz ' + ID + ' is... ' + grade + '%!');
    
    if ( courseStatus.quiz_attempts[ ID ] > 0 && currentQuizMode === 0 ) {
	courseStatus.quiz_attempts[ ID ] = courseStatus.quiz_attempts[ ID ] - 1;
	zork( 'You still have ' + courseStatus.quiz_attempts + ' attempts!');
    } else if ( courseStatus.quiz_attempts[ ID ] === -1 ) {
	zork( 'You have unlimited attempts. That is almost like cheating...');
    } else {
	zork( 'You don\'t have any more attempts...');
    }
    $( '#llwindow-data-attempts' ).text( courseStatus.quiz_attempts[ID] );
    
    quizUpdateQuiz( ID );
    courseSave();
}

function quizResetQuiz( ID ) {
    if ( ID === undefined ) {
	ID = currentQuiz;
    }
    courseStatus.quiz_last_grade[ID] = 0;
    courseStatus.quiz_best_grade[ID] = 0;
    courseStatus.quiz_finished[ID] = 0;
    courseStatus.quiz_attempts[ID] = quizConfig[ID].attempts;
}
var justPassed = false;
function quizSubmit( ID ) {
    if ( quizConfig[ ID ].submit_conditions !== false &&
            courseStatus.quiz_finished[ID] === 0 ) {
        justPassed = true;
	courseStatus.grade = quizGradeToSubmit(ID);
        courseStatus.quiz_submit_grade[ID] = quizGradeToSubmit(ID);
        if ( courseStatus.quiz_submit_grade[ID] === 'undefined' ) {
            justPassed
        }
        var date = new Date();
        var month = date.getMonth() + 1;
        var year = date.getYear() + 1900;
        var dateLong = '' + date.getHours() + 'h'+ date.getMinutes() + ' ' + date.getDate() +'/' + month + '/' + year;
        dateLong = date.getDate() +'/' + month + '/' + year;
        courseStatus.quiz_submit_grade_date = dateLong;
	courseStatus.completed = 1;
	courseGrade();
    }
}
