// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`How many types of ID evaluation are there?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>There are 3 types of ID evaluation: Formative,  Summative and Confirmative. `;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>There are 3 types of ID evaluation: Formative,  Summative and Confirmative. `;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`3`;
quizQuestions[0][0].answers[1]=`6`;
quizQuestions[0][0].answers[2]=`2`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Who is involved in formative design evaluation? `;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>Both instructional designers and learners are involved in the process alongside subject matter experts and instructors.`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>Both instructional designers and learners are involved in the process alongside subject matter experts and instructors.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Instructional designers and expert groups`;
quizQuestions[0][1].answers[1]=`Instructional designers, subject matter experts, learners, and instructors`;
quizQuestions[0][1].answers[2]=`Learners and students`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`When is formative design evaluation carried out? `;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>Summative evaluation is carried out at the end of the process and confirmative evaluation is carried out continually.`;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>Summative evaluation is carried out at the end of the process and confirmative evaluation is carried out continually.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`It is carried out before the design process`;
quizQuestions[0][2].answers[1]=`It is carried out during the design process`;
quizQuestions[0][2].answers[2]=`It is carried out after the design process`;
quizQuestions[0][2].key=2;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`What is the purpose of Summative design evaluation?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>Summative evaluation is conducted at the end of the design process to determine if the instruction product achieves the intended outcomes.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>Summative evaluation is conducted at the end of the design process to determine if the instruction product achieves the intended outcomes.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`To evaluate instruction and/or instructional materials at the beginning of the design process`;
quizQuestions[0][3].answers[1]=`To evaluate instruction and/or instructional materials throughout the design process`;
quizQuestions[0][3].answers[2]=`To evaluate instruction and/or instructional materials after 
they have been finalised`;
quizQuestions[0][3].key=3;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Who carries out summative design evaluation? `;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct. </b><br>The purpose of a summative evaluation is to evaluate instruction and/or instructional materials after they have been finalized.`;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>The purpose of a summative evaluation is to evaluate instruction and/or instructional materials after they have been finalized.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`External evaluators`;
quizQuestions[0][4].answers[1]=`Learners `;
quizQuestions[0][4].answers[2]=`Instructional designers`;
quizQuestions[0][4].key=1;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`When is Summative design evaluation carried out?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>External evaluators for decision makers often conduct or participate in summative evaluation.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>External evaluators for decision makers often conduct or participate in summative evaluation.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Before`;
quizQuestions[0][5].answers[1]=`Continually`;
quizQuestions[0][5].answers[2]=`After`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`Why is confirmative evaluation conducted?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>Confirmative evaluation goes beyond the scope of formative and summative evaluation and looks at whether the long-term effect of instruction is what the instructional designer hoped to achieve.`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>Confirmative evaluation goes beyond the scope of formative and summative evaluation and looks at whether the long-term effect of instruction is what the instructional designer hoped to achieve.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`To provide feedback to inform the design process`;
quizQuestions[0][6].answers[1]=`To evaluate instructional materials after they have been finalised`;
quizQuestions[0][6].answers[2]=`To determine the lasting effect of the instruction`;
quizQuestions[0][6].key=3;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`When should confirmative evaluation be carried out?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>Confirmative evaluation should be conducted on a continual basis.`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>Confirmative evaluation should be conducted on a continual basis.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Confirmative evaluation should be conducted on a regular basis
`;
quizQuestions[0][7].answers[1]=`Confirmative evaluation should be conducted at the end of the design process`;
quizQuestions[0][7].answers[2]=`Confirmative evaluation should be conducted during the design process`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`What is the best way to ensure that quality assurance is met?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>Assuring quality across your course is best done by implementing quality assurance standards to be met from the beginning of the instructional design process. This means that the quality of the materials produced is considered from the very beginning, ensuring they are of the highest standard.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>Assuring quality across your course is best done by implementing quality assurance standards to be met from the beginning of the instructional design process. This means that the quality of the materials produced is considered from the very beginning, ensuring they are of the highest standard.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`By letting it happen naturally throughout the instructional design process`;
quizQuestions[0][8].answers[1]=`By implementing it from the beginning of the instructional design process`;
quizQuestions[0][8].answers[2]=`By implementing it at the end of the instructional design process`;
quizQuestions[0][8].key=1;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`How many criteria are there to test your instructional design content?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>There are 3 quality assurance criteria: Effectiveness, Efficiency and Engagement.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>There are 3 quality assurance criteria: Effectiveness, Efficiency and Engagement.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`3`;
quizQuestions[0][9].answers[1]=`5`;
quizQuestions[0][9].answers[2]=`2`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`What does effectiveness in the 3 Es of Quality Assurance mean?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>Effectiveness means that the objectives and desired outcomes have been met. It can be accounted for throughout the design process by pilot testing and continuous assessment.`;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>Effectiveness means that the objectives and desired outcomes have been met. It can be accounted for throughout the design process by pilot testing and continuous assessment.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`This means that the objectives and desired outcomes have been met`;
quizQuestions[0][10].answers[1]=`This means that the designs have been created within time, budget and other constraints`;
quizQuestions[0][10].answers[2]=`This means that learners have engaged with the instructional design process`;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`How is efficiency measured in quality assurance?`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>Efficiency is measured in terms of designs being created with time, budget and other constraints.
It can be accounted for throughout the process by continuously testing throughout the design and development stages by timing learners' participation.`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>Efficiency is measured in terms of designs being created with time, budget and other constraints.
It can be accounted for throughout the process by continuously testing throughout the design and development stages by timing learners' participation.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Efficiency is measured in terms of the level of quality of the outcomes of the course/content`;
quizQuestions[0][11].answers[1]=`Efficiency is measured in terms of how quickly the instructional design process is completed`;
quizQuestions[0][11].answers[2]=`Efficiency is measured in terms of designs being created within time, budget and other constraints`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`How can engagement be tested in quality assurance?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>It is important to ensure that learners have the opportunity to contribute and engage in active learning throughout each step of testing the ID content.`;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>It is important to ensure that learners have the opportunity to contribute and engage in active learning throughout each step of testing the ID content.`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`It can be tested by timing learners' participation`;
quizQuestions[0][12].answers[1]=`It can be tested by ensuring there are opportunities for learner contribution, active learning, and learner involvement throughout each step of the process`;
quizQuestions[0][12].answers[2]=`It can be tested during the piloting phase`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`What are Key Performance Indicators?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>Key Performance Indicators or KPIs as they are often called are quantifiable measures that are used to evaluate the performance of a particular objective over time.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>Key Performance Indicators or KPIs as they are often called are quantifiable measures that are used to evaluate the performance of a particular objective over time.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`They are quantifiable measures that are used to evaluate the performance of a particular objective over time`;
quizQuestions[0][13].answers[1]=`They are goals that are specific, measurable, achievable, realistic, and timely`;
quizQuestions[0][13].answers[2]=`They allow time limited goals`;
quizQuestions[0][13].key=1;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`What is external validation?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>External validation is an important tool when assessing the instructional design process. This stage involves getting the opinion of an instructional designer external to the project in order to test the materials you have designed.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>External validation is an important tool when assessing the instructional design process. This stage involves getting the opinion of an instructional designer external to the project in order to test the materials you have designed.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`It assists with providing feedback to inform the piloting process`;
quizQuestions[0][14].answers[1]=`It is the process of having an external instructional designer test the materials you have designed
`;
quizQuestions[0][14].answers[2]=`It is the process of having someone within the company test the materials you have designed`;
quizQuestions[0][14].key=2;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Why is pilot testing educational material useful?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>Pilot testing can help in the early identification of flaws in your educational material. Piloting your educational material is a great way to get fresh eyes on the material before it goes live to the wider group of learners. `;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>Pilot testing can help in the early identification of flaws in your educational material. Piloting your educational material is a great way to get fresh eyes on the material before it goes live to the wider group of learners. `;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`It helps ID instructors brainstorm ideas for educational learning materials`;
quizQuestions[0][15].answers[1]=`It is useful to make changes after the educational material has been used by a wide group of learners`;
quizQuestions[0][15].answers[2]=`Piloting educational material allows you to highlight any potential flaws or issues in your materials before it goes to a wider group of learners`;
quizQuestions[0][15].key=3;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`What is a pilot group? `;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>A pilot group is a group of individuals who test material before it is released to the general target audience. It is important that the pilot group has similar demographics to the intended target audience.`;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>A pilot group is a group of individuals who test material before it is released to the general target audience. It is important that the pilot group has similar demographics to the intended target audience.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`It is a group of individuals who come up with the concept of your materials`;
quizQuestions[0][16].answers[1]=`It is a group of individuals who test material before it is released to the general target audience`;
quizQuestions[0][16].answers[2]=`It is a group of individuals who are the target of your materials`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`How many steps are in a pilot test?
`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>A pilot step has 5 steps: Planning, Preparation, Testing, Evaluation and Deployment.`;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>A pilot step has 5 steps: Planning, Preparation, Testing, Evaluation and Deployment.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`6`;
quizQuestions[0][17].answers[1]=`5`;
quizQuestions[0][17].answers[2]=`7`;
quizQuestions[0][17].key=2;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`The third step in pilot testing is?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>After the preparation stage is complete, testing can begin. Testing is completed by a selected group of end-users who test the materials as the target audience would.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>After the preparation stage is complete, testing can begin. Testing is completed by a selected group of end-users who test the materials as the target audience would.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Testing`;
quizQuestions[0][18].answers[1]=`Evaluation`;
quizQuestions[0][18].answers[2]=`Deployment`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`What is in an evaluation plan? `;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b><br>Once testing is completed, the end-users then evaluate the materials. They create a report and send any issues to the designers who fix any issues to prepare the materials for deployment.`;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b><br>Once testing is completed, the end-users then evaluate the materials. They create a report and send any issues to the designers who fix any issues to prepare the materials for deployment.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`It contains information from the piloting phase`;
quizQuestions[0][19].answers[1]=`It contains an overview of the objectives of the material, collected data for the instruction characterization, and a list of the evaluation instruments used`;
quizQuestions[0][19].answers[2]=`It contains an overview of the initial brainstorming of ideas for the materials`;
quizQuestions[0][19].key=2;

