// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Iniciar",
    button_prev: "Anterior",
    button_next: "Seguinte",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submeter",
    button_review: "Rever",
    button_try_again: "Tentar Novamente",
    button_finish: "Submeter Nota",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Bem-vindo ao teste de avaliação!</b></h2>
        <p>Este teste de avaliação consiste em <b><span class="quiz-total"></span> perguntas de escolha múltipla</b> às quais deve responder selecionando a opção correta. Para concluir com êxito o teste de avaliação, deve obter uma classificação igual ou superior a <b>${minimumGrade}%</b>.</p>
        <p>Tem <b><span class="quiz-attempts"></span> tentativas</b> para completar este teste. Dispõe de <b>${minutesToComplete} minutos</b> em cada tentativa para completar o teste. Deve clicar no botão "Enviar nota" para guardar a sua classificação na plataforma de formação.</p>
        <p style="text-align: right"><b>Boa sorte!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</h2>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
            <p>Tente novamente.</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">PARABÉNS!</h2>
            <p>Concluiu com êxito este teste de avaliação.</p>
            <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
            <br><br>
            <p>Tentativas restantes: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Tente novamente.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
            <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>Esgotou as tentativas para realizar este teste de avaliação.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor nota será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Concluiu com êxito este teste de avaliação.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi guardada na Plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>

        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>

        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Ao clicar no botão "Submeter nota", o teste será bloqueado, a sua nota será registada na Plataforma e o item marcado como concluído. Se quiser melhorar a classificação, utilize o botão "Tentar novamente" (a sua melhor classificação será registada). Clique no botão X para regressar à plataforma.</p>

        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">Não concluiu este teste de avaliação com sucesso</h2>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Nesta tentativa, não conseguiu obter a nota mínima para concluir com êxito o teste de avaliação.</p>
        <p>A sua melhor nota até agora foi <span class="quiz-best-grade"></span>%. Esta nota foi automaticamente registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste  de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>Ao clicar no botão "Enviar nota", o teste será bloqueado, a sua melhor classificação de <span class="quiz-best-grade"></span>% será registada na plataforma e o item será marcado como concluído. Se quiser melhorar a sua nota, clique no botão "Tentar novamente" (a sua melhor classificação será registada).</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Nesta tentativa, a sua nota foi <span class="quiz-last-grade"></span>%.</p>
        <p>A sua melhor nota de <span class="quiz-best-grade"></span>% foi registada na plataforma e o item foi marcado como concluído.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">PARABÉNS!</h2>
        <p>Este teste de avaliação foi concluído com êxito.</p>
        <p>Atingiu a classificação máxima de <span class="quiz-last-grade"></span>%.</p>
        <p>A sua nota foi registada na plataforma e o item foi marcado como concluído.</p>
        <p>Clique no botão X para regressar à plataforma.</p>
        <br><br>
        <p>Tentativas restantes: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Que regulamento europeu relativo à segurança dos dados orienta a experiência de aprendizagem?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Os princípios devem orientar a experiência de aprendizagem de acordo com o Regulamento Geral sobre a Proteção de Dados (RGPD) da União Europeia.`;
quizQuestions[0][0].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Os princípios devem orientar a experiência de aprendizagem de acordo com o Regulamento Geral sobre a Proteção de Dados (RGPD) da União Europeia.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Regulamento Geral sobre a Proteção de Dados (RGPD)`;
quizQuestions[0][0].answers[1]=`Regulamento específico sobre a proteção de dados (REPD)`;
quizQuestions[0][0].answers[2]=`Proteção de dados europeia (PDE)`;
quizQuestions[0][0].key=1;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`Refira três boas práticas de segurança de dados`;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Por várias razões, é importante utilizar firewalls internas e externas, ter uma política bem definida e exigir cópias de segurança dos dados. Estas medidas podem ajudar a proteger os dados e sistemas sensíveis contra o acesso não autorizado, a adulteração ou outras ameaças à segurança.`;
quizQuestions[0][1].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Por várias razões, é importante utilizar firewalls internas e externas, ter uma política bem definida e exigir cópias de segurança dos dados. Estas medidas podem ajudar a proteger os dados e sistemas sensíveis contra o acesso não autorizado, a adulteração ou outras ameaças à segurança.`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Implemente palavras-passe únicas;
 Utilize encriptação para todos os dados sensíveis;
 Faça regularmente cópias de segurança dos dados`;
quizQuestions[0][1].answers[1]=`Utilize firewalls internas e externas;
 tenha uma política bem definida;
 exija cópias de segurança dos dados`;
quizQuestions[0][1].answers[2]=`Implemente controlos de acesso para restringir o acesso;
 monitorize e audite regularmente as redes e os sistemas;
 assegure-se de que todo o software e sistemas são mantidos atualizados`;
quizQuestions[0][1].key=2;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`Qual é o principal objetivo de um storyboard numa experiência de aprendizagem?`;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O principal objetivo de um storyboard é planear visualmente uma narrativa de vídeo, incluindo as sequências, as composições de cada uma e qualquer áudio que possa ser incluído.`;
quizQuestions[0][2].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O principal objetivo de um storyboard é planear visualmente uma narrativa de vídeo, incluindo as sequências, as composições de cada uma e qualquer áudio que possa ser incluído.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Um storyboard funciona como uma peça autónoma de conteúdo`;
quizQuestions[0][2].answers[1]=`Para servir de versão final e aperfeiçoada da experiência de aprendizagem`;
quizQuestions[0][2].answers[2]=`Crie uma história ou um contexto que envolva os formandos, de acordo com a abordagem pedagógica`;
quizQuestions[0][2].key=3;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`O que é um storyboard?`;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Um storyboard é um documento que descreve o conteúdo de um curso em linha, dividindo-o em diapositivos ou ecrãs individuais. Isto permite aos criadores de cursos planear o seu material de uma forma estruturada e organizada e fazer alterações e revisões antes do início da produção. O storyboard também pode ajudá-los a comunicar a sua visão ao resto da equipa, incluindo os formadores e os designers.`;
quizQuestions[0][3].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Um storyboard é um documento que descreve o conteúdo de um curso em linha, dividindo-o em diapositivos ou ecrãs individuais. Isto permite aos criadores de cursos planear o seu material de uma forma estruturada e organizada e fazer alterações e revisões antes do início da produção. O storyboard também pode ajudá-los a comunicar a sua visão ao resto da equipa, incluindo os formadores e os designers.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Um storyboard é um documento que decompõe o material do curso em linha diapositivo por diapositivo ou ecrã por ecrã`;
quizQuestions[0][3].answers[1]=`Um storyboard é uma versão acabada e polida do curso material`;
quizQuestions[0][3].answers[2]=`Um storyboard é uma ferramenta para organizar dados ou informações`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Qual é o principal objetivo de um storyboard em geral?`;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Um storyboard delineia a estrutura e a apresentação de um resultado, fornecendo às partes interessadas uma antevisão do aspeto do curso. Isto permite que estas pessoas vejam como o resultado final será organizado e apresentado, e que deem feedback e sugestões antes do início da produção.`;
quizQuestions[0][4].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Um storyboard delineia a estrutura e a apresentação de um resultado, fornecendo às partes interessadas uma antevisão do aspeto do curso. Isto permite que estas pessoas vejam como o resultado final será organizado e apresentado, e que deem feedback e sugestões antes do início da produção.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`O objetivo de um storyboard é ocultar a estrutura e a apresentação do curso às partes interessadas e aos especialistas na matéria`;
quizQuestions[0][4].answers[1]=`O objetivo de um storyboard é fornecer às partes interessadas e aos especialistas na matéria uma espreitadela à estrutura e apresentação do curso`;
quizQuestions[0][4].answers[2]=`O principal objetivo de um storyboard é fornecer uma apresentação final dos conteúdos de um curso`;
quizQuestions[0][4].key=2;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Que tipos de storyboard existem?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Correto! A sua resposta está certa.</b><br> Existem duas categorias principais de storyboards: storyboards de e-learning escritos e storyboards de e-learning gráficos.`;
quizQuestions[0][5].feedback_wrong=`<b>A sua resposta está incorreta.</b><br> Existem duas categorias principais de storyboards: storyboards de e-learning escritos e storyboards de e-learning gráficos.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`Storyboards interativos, animados e verbais`;
quizQuestions[0][5].answers[1]=`Storyboards tradicionais e modernos`;
quizQuestions[0][5].answers[2]=`Storyboards de e-learning escritos e storyboards de e-learning gráficos`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`O que é um storyboard escrito?`;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O storyboard e-learning escrito é um documento que descreve o conteúdo de um curso em linha, dividindo-o em diapositivos ou ecrãs individuais. 
Isto permite aos criadores de cursos planear o seu material de uma forma estruturada e organizada, e fazer alterações e revisões antes do início da produção.`;
quizQuestions[0][6].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O storyboard e-learning escrito é um documento que descreve o conteúdo de um curso em linha, dividindo-o em diapositivos ou ecrãs individuais. 
Isto permite aos criadores de cursos planear o seu material de uma forma estruturada e organizada, e fazer alterações e revisões antes do início da produção.`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`O storyboard e-learning escrito é um documento que enumera o material da disciplina, diapositivo por diapositivo ou ecrã por ecrã`;
quizQuestions[0][6].answers[1]=`Um storyboard escrito é uma versão finalizada de um conteúdo`;
quizQuestions[0][6].answers[2]=`Um storyboard escrito é uma ferramenta de organização de dados e de planeamento`;
quizQuestions[0][6].key=1;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`Qual é a principal vantagem de utilizar um storyboard escrito?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A principal vantagem da utilização de um storyboard escrito é que permite planear o seu material de uma forma estruturada e organizada. Um storyboard escrito pode incluir um esboço detalhado, dividindo-o em slides ou ecrãs individuais.`;
quizQuestions[0][7].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A principal vantagem da utilização de um storyboard escrito é que permite planear o seu material de uma forma estruturada e organizada. Um storyboard escrito pode incluir um esboço detalhado, dividindo-o em slides ou ecrãs individuais.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Os storyboards escritos são rápidos de criar`;
quizQuestions[0][7].answers[1]=`Os guiões escritos ajudam o ID a concentrar-se no material do curso e não na estética audiovisual do curso`;
quizQuestions[0][7].answers[2]=`Os storyboards escritos permitem ter uma perspetiva completa dos materiais`;
quizQuestions[0][7].key=2;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`O que é um storyboard visual?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O storyboard visual de e-learning é um tipo de storyboard que se concentra tanto no design como no conteúdo do conteúdo. Este tipo de storyboard combina elementos de um storyboard escrito, que descreve o material e a estrutura do curso, com um protótipo visual, que mostra o aspeto e a sensação do conteúdo.`;
quizQuestions[0][8].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O storyboard visual de e-learning é um tipo de storyboard que se concentra tanto no design como no conteúdo do conteúdo. Este tipo de storyboard combina elementos de um storyboard escrito, que descreve o material e a estrutura do curso, com um protótipo visual, que mostra o aspeto e a sensação do conteúdo.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`Uma ferramenta para aumentar o valor estético visual de uma apresentação`;
quizQuestions[0][8].answers[1]=`Uma ferramenta para criar animações ou efeitos especiais`;
quizQuestions[0][8].answers[2]=`O storyboard visual e-learning concentra-se tanto na conceção do curso como no seu conteúdo. Um storyboard visual e-learning combina um storyboard escrito e um protótipo visual`;
quizQuestions[0][8].key=3;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`Quais são as duas estratégias mais comuns para determinar os objetivos de aprendizagem?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O mapeamento de ações é um método para identificar as ações ou comportamentos específicos que os alunos devem ser capazes de realizar para alcançar os resultados de aprendizagem desejados. Isto envolve a identificação dos indicadores chave de desempenho que serão utilizados para medir o sucesso, e a conceção do conteúdo e das atividades do curso para apoiar o desenvolvimento destas competências. A construção convencional de cursos envolve começar com os resultados de aprendizagem desejados e trabalhar de trás para a frente para conceber o conteúdo e as atividades do curso.`;
quizQuestions[0][9].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O mapeamento de ações é um método para identificar as ações ou comportamentos específicos que os alunos devem ser capazes de realizar para alcançar os resultados de aprendizagem desejados. Isto envolve a identificação dos indicadores chave de desempenho que serão utilizados para medir o sucesso, e a conceção do conteúdo e das atividades do curso para apoiar o desenvolvimento destas competências. A construção convencional de cursos envolve começar com os resultados de aprendizagem desejados e trabalhar de trás para a frente para conceber o conteúdo e as atividades do curso.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Mapeamento de ações e criação de cursos convencionais`;
quizQuestions[0][9].answers[1]=`Esboço e avaliação comparativa`;
quizQuestions[0][9].answers[2]=`Brainstorming e análise de fatores`;
quizQuestions[0][9].key=1;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`O que é um mapa de ação?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O mapa de ação especifica as ações ou comportamentos específicos que a audiência deve adotar para atingir um determinado objetivo. Isto pode incluir coisas como completar uma tarefa, tomar uma decisão ou atingir um determinado nível de proficiência.`;
quizQuestions[0][10].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O mapa de ação especifica as ações ou comportamentos específicos que a audiência deve adotar para atingir um determinado objetivo. Isto pode incluir coisas como completar uma tarefa, tomar uma decisão ou atingir um determinado nível de proficiência.`;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Uma ferramenta para gerar ideias`;
quizQuestions[0][10].answers[1]=`O mapa de ação especifica os passos que o público deve dar para atingir um determinado objetivo`;
quizQuestions[0][10].answers[2]=`Uma apresentação visual de um resultado específico`;
quizQuestions[0][10].key=2;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Quais são os elementos que compõem um storyboard? `;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Texto, imagens, áudio, animações e notas de programação são todos elementos importantes para um storyboard, porque ajudam a planear e a visualizar o conteúdo e a estrutura.`;
quizQuestions[0][11].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Texto, imagens, áudio, animações e notas de programação são todos elementos importantes para um storyboard, porque ajudam a planear e a visualizar o conteúdo e a estrutura.`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`Imagens ou animações bem trabalhadas, guiões detalhados e efeitos ou tecnologias complexas ou especializadas`;
quizQuestions[0][11].answers[1]=`Gravações áudio finais e música`;
quizQuestions[0][11].answers[2]=`Texto, imagens, áudio, animações, notas de programação`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`Qual é o nome do texto que aparece em cada diapositivo para o público?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A resposta correta é "On-screen-text" (OST).`;
quizQuestions[0][12].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A resposta correta é "On-screen-text" (OST).`;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Texto no ecrã (OST)`;
quizQuestions[0][12].answers[1]=`Texto do ecrã`;
quizQuestions[0][12].answers[2]=`Conteúdo verbal no ecrã`;
quizQuestions[0][12].key=1;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`Refira algumas preocupações que o ID deve ter quando utiliza locução`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>É importante incluir a transcrição e o nome do ficheiro de áudio para cada diapositivo quando se utiliza locução, pois ajuda a garantir que o áudio está devidamente alinhado com o conteúdo visual. 
Ajuda a garantir que o áudio está corretamente alinhado com os elementos visuais do diapositivo.`;
quizQuestions[0][13].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>É importante incluir a transcrição e o nome do ficheiro de áudio para cada diapositivo quando se utiliza locução, pois ajuda a garantir que o áudio está devidamente alinhado com o conteúdo visual. 
Ajuda a garantir que o áudio está corretamente alinhado com os elementos visuais do diapositivo.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`Atenção ao tom de voz`;
quizQuestions[0][13].answers[1]=`Deve incluir a transcrição e o nome do ficheiro áudio de cada diapositivo`;
quizQuestions[0][13].answers[2]=`Dicção correta`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`Quais são os domínios abrangidos pelo design da experiência do utilizador (UX)?`;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>O design de interação, o design de interface, o design visual, a gestão de conteúdos, a usabilidade e a arquitetura da informação são importantes para o design de UX porque ajudam a criar experiências digitais fáceis de utilizar e envolventes.`;
quizQuestions[0][14].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>O design de interação, o design de interface, o design visual, a gestão de conteúdos, a usabilidade e a arquitetura da informação são importantes para o design de UX porque ajudam a criar experiências digitais fáceis de utilizar e envolventes.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Desenvolvimento de software, engenharia de redes e marketing digital`;
quizQuestions[0][14].answers[1]=`Análise de dados e cibersegurança`;
quizQuestions[0][14].answers[2]=`Design de interação, design de interface, design visual, gestão de conteúdos, usabilidade e arquitetura da informação`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`Como é que os utilizadores interagem com um produto?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A interface do utilizador (IU) é a parte de um produto ou serviço que permite aos utilizadores interagir com ele. Pode incluir elementos como botões, menus e outros controlos que permitem aos utilizadores introduzir comandos e dados, bem como os elementos visuais e sonoros que fornecem feedback e orientação aos utilizadores.`;
quizQuestions[0][15].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A interface do utilizador (IU) é a parte de um produto ou serviço que permite aos utilizadores interagir com ele. Pode incluir elementos como botões, menus e outros controlos que permitem aos utilizadores introduzir comandos e dados, bem como os elementos visuais e sonoros que fornecem feedback e orientação aos utilizadores.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Através da sua interface de utilizador (IU)`;
quizQuestions[0][15].answers[1]=`Com um teclado e um rato`;
quizQuestions[0][15].answers[2]=`Com um controlo remoto`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`O que é que a UX abrange?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A experiência do utilizador abrange toda a interação que os utilizadores têm com um produto. Isto inclui não só a interface do utilizador (IU), que é a parte de um produto que permite aos utilizadores interagir com ele, mas também os outros elementos que contribuem para a experiência do utilizador.`;
quizQuestions[0][16].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A experiência do utilizador abrange toda a interação que os utilizadores têm com um produto. Isto inclui não só a interface do utilizador (IU), que é a parte de um produto que permite aos utilizadores interagir com ele, mas também os outros elementos que contribuem para a experiência do utilizador.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`A estética de um produto`;
quizQuestions[0][16].answers[1]=`A interação completa que os utilizadores têm com um produto`;
quizQuestions[0][16].answers[2]=`Recolha e análise de dados`;
quizQuestions[0][16].key=2;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Quais são algumas das heurísticas a ter em conta na produção de conteúdos de e-learning?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>A visibilidade do estado do sistema, a correspondência entre o sistema e o mundo real e o controlo e liberdade do utilizador são todos importantes para o e-learning, pois ajudam a criar experiências de aprendizagem fáceis e eficazes.`;
quizQuestions[0][17].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>A visibilidade do estado do sistema, a correspondência entre o sistema e o mundo real e o controlo e liberdade do utilizador são todos importantes para o e-learning, pois ajudam a criar experiências de aprendizagem fáceis e eficazes.`;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`Conteúdo fácil de digerir;
 interatividade`;
quizQuestions[0][17].answers[1]=`Estética apelativa e animação complexa`;
quizQuestions[0][17].answers[2]=`Visibilidade do estado do sistema;
 Correspondência entre o sistema e o mundo real;
 Controlo e liberdade do utilizador`;
quizQuestions[0][17].key=3;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`Como é que as mensagens de erro devem ser apresentadas?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>As mensagens de erro devem ser sempre expressas em linguagem simples (sem códigos), indicar com precisão o problema e sugerir uma solução de forma construtiva.`;
quizQuestions[0][18].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>As mensagens de erro devem ser sempre expressas em linguagem simples (sem códigos), indicar com precisão o problema e sugerir uma solução de forma construtiva.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=`Em linguagem simples (sem códigos), indique com precisão o problema e sugira uma solução de forma construtiva`;
quizQuestions[0][18].answers[1]=`Utilize código detalhado`;
quizQuestions[0][18].answers[2]=`Com um ruído sonoro forte`;
quizQuestions[0][18].key=1;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`Como melhorar o feedback dos erros dos utilizadores?`;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Correto! A sua resposta está certa.</b><br>Oferecer uma "saída" claramente assinalada para sair de um estado indesejado, e o apoio ao desfazer e refazer, pode ajudar a criar experiências de experiências de aprendizagem.`;
quizQuestions[0][19].feedback_wrong=`<b>A sua resposta está incorreta.</b><br>Oferecer uma "saída" claramente assinalada para sair de um estado indesejado, e o apoio ao desfazer e refazer, pode ajudar a criar experiências de experiências de aprendizagem.`;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`Com um fluxo constante de informações sobre o erro`;
quizQuestions[0][19].answers[1]=`Ofereça uma "saída" claramente marcada para deixar o estado indesejado e suporte para desfazer e refazer`;
quizQuestions[0][19].answers[2]=`Com instruções técnicas pormenorizadas sobre o erro`;
quizQuestions[0][19].key=2;

