// Config for quizzes
var quizBanks = new Array();
quizBanks[0] = [0];

//quizBanks[0] = [0];
var bankQuestions = new Array();
bankQuestions[0] = [10];
//bankQuestions[0] = [1];
//bankQuestions[0] = [1,1,1,1,1,1,1,1,1,1];
//bankQuestions[0] = [21,30,33,32,29,22,19];
var totalQuestions = new Array();

totalQuestions[0] = bankQuestions[0].reduce(function (acc, val) {
  return acc + val;
}, 0);

var minutesToComplete = 40;
var minimumGrade = 60;
var maximumAttempts = 3;

var quizConfig = {
  0: {
    name: "Teste avaliação", //Name of quiz
    quiz_banks: quizBanks[0], //Which quiz banks to use
    bank_questions: bankQuestions[0], //How many questions to use from each bank
    attempts: maximumAttempts, //How many attempts
    //        attempts: 3,			//How many attempts
    minimum_grade: minimumGrade, //Minimum grade, in %
    maximum_time: minutesToComplete * 60, //Maximum quiz time, in seconds
    //        maximum_time: 180, //Maximum quiz time, in seconds
    continuous_timing: false, //Should the counter count only session time (false), or time since quiz start (true)
    continue_attempt: true,
    multiple_choice_grade: "all", //How should we grade multiple choice answers? When 'all' are selected, partial grade when 'some' are selected?
    multiple_choice_forgiveness: 2, //How much percentage points should we forgive in a multiple choice questions?
    shuffle: true, //Shuffle questions for each attempt, false, true, or pool
    shuffle_answers: false,
    //	shuffle: false,			//Shuffle questions for each attempt, false, true, or pool
    //        shuffle_answers: false,
    feedback: true, //Allow for imediate feedback
    review: "submit", //Allow the user to review the quiz always (true) on positive ('pass') or on 'submit'
    review_type: "last", //On review, review the 'last' attempt, or the 'best' attempt? (only for unshuffled)
    help: false, //Allow for a help button, true, false or on review
    advance: "answer", //The user can jump to the next question 'always', 'answer' or after selecting an answer ('auto')
    list: true, //Shows a list of total answers
    best_grade: true, //Submit only the best grade
    lock_grade: "best", //Lock quiz after 'pass', or 'best' or false
    grade_round: true, // Round the grade, false, true, 'down', 'up'.
    grade_round_decimal: 0, //Number of decimal places
    unlock: "pass", //Unlock next content on 'pass' or 'attempts', or false
    submit_conditions: "user", //Quiz submission and course completion, false (doesn't submit), 'attempts' (on attempts = 0), 'best', 'pass' (on first positive grade) or 'user' (when user presses finish button)
    submit_grade: "best", //Grade to submit, 'best' or 'last'
    submit_try_again_allow: false, //Allow user to do the quiz AFTER they've submitted their grade

    label_grade: "Última classificação<br/>",
    label_best_grade: "Melhor classificação<br/>",
    label_attempts: "Tentativa<br/>",

    button_start: "Start",
    button_prev: "Previous",
    button_next: "Next",
    button_feedback: "",
    button_feedback_continue: "",
    button_submit: "Submit",
    button_review: "Review",
    button_try_again: "Try again",
    button_finish: "Submit Grade",
    button_help: "",

    message_feedback_standard_right: "",
    message_feedback_standard_wrong: "",
    message_start_terminated: ``,
    message_start_first: ``,
    message_start_pass: ``,
    message_start_fail: ``,
    message_start_pass_no_attempts: ``,
    message_start_fail_no_attempts: ``,
    message_start_generic: `
        <h2><b>Welcome to the assessment activity!</b></h2>
        <p>This assessment activity consists of <b><span class="quiz-total"></span> multiple choice questions</b> which you must answer by selecting the correct option. To successfully complete the assessment activity, you must obtain a rating equal to or greater than <b>${minimumGrade}%</b>.</p>
        <p>You have <b><span class="quiz-attempts"></span> attempts</b> to complete this activity. You have <b>${minutesToComplete} minutes</b> in each attempt to complete the quiz. You must click on the "Submit Grade" button to save your ranking on the Training Platform.</p>
        <p style="text-align: right"><b>Good luck!</b></p>
        `,

    message_end_generic_fail: `
            <h2 class="fail">In this attempt your grade was <span class="quiz-last-grade"></span>%.</h2>
            <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
            <p>Try again.</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,
    message_end_generic_pass: `
            <h2 class="win">CONGRATULATIONS!</h2>
            <p>You have successfully completed this assessment activity.</p>
            <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
            <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
            <br><br>
            <p>Remaining attempts: <span class="quiz-attempts"></span></p>
        `,

    message_end_timeout_fail: ``,
    message_end_timeout_fail_no_attempts: ``,

    message_end_timeout_fail_passed: ``,
    message_end_timeout_fail_passed_no_attempts: ``,
    message_end_timeout_pass: ``,
    message_end_timeout_pass_no_attempts: ``,

    message_end_timeout_pass_passed: ``,
    message_end_timeout_pass_passed_no_attempts: ``,

    message_end_fail: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Try again.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>You have run out of attempts to do this assessment activity.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best grade will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this assessment activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was saved on the Platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_fail_passed: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>

        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>

        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. By clicking on the "Submit grade" button, the activity will be blocked and your grade will be recorded on the Platform and the item marked as completed. If you want to improve the rating use the "Try again" button (your best rating will be recorded). Click on the X button to return to the platform.</p>

        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_fail_passed_no_attempts: `
        <h2 class="fail">You failed this assessment activity</h2>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>In this attempt you failed to obtain the minimum grade to successfully complete the assessment activity.</p>
        <p>Your best grade so far was <span class="quiz-best-grade"></span>%. This grade was automatically recorded on the Platform and the item was marked as completed.</p>
        <p>Click the X button to return to the platform.</p>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_pass_passed: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>By clicking on the "Submit grade" button, the activity will be blocked and your best rating up to the moment of <span class="quiz-best-grade"></span>% will be recorded on the Platform and the item marked as completed. If you want to improve your grade click on the "Try again" button (your best rating will be recorded).</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_pass_passed_no_attempts: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>In this attempt your grade was <span class="quiz-last-grade"></span>%.</p>
        <p>Your best grade of <span class="quiz-best-grade"></span>% was recorded on the platform and the item was marked as completed.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,

    message_end_best: `
        <h2 class="win">CONGRATULATIONS!</h2>
        <p>You have successfully completed this activity.</p>
        <p>You have reached the maximum grade of <span class="quiz-last-grade"></span>%.</p>
        <p>Your grade was recorded on the platform and the item was marked as completed.</p>
        <p>Click on the X button to return to the platform.</p>
        <br><br>
        <p>Remaining attempts: <span class="quiz-attempts"></span></p>`,
    message_end_best_no_attempts: ``,
  },
};

var quizQuestions = {};

quizQuestions[0] ={};

quizQuestions[0][0] ={};
quizQuestions[0][0].question=`Which three people competences a Project Manager (PM) needs to have?`;
quizQuestions[0][0].type='single';
quizQuestions[0][0].instruction='';
quizQuestions[0][0].help='';
quizQuestions[0][0].feedback_right=`<b>Right! Your answer is correct. </b><br>Option 1 and Option 2 refers to the Perspective Competences and not People Competences.`;
quizQuestions[0][0].feedback_wrong=`<b>Your answer is incorrect.</b><br>Option 1 and Option 2 refers to the Perspective Competences and not People Competences.`;
quizQuestions[0][0].answers = new Array;
quizQuestions[0][0].answers[0]=`Governance, Structures and Processes`;
quizQuestions[0][0].answers[1]=`Leadership, Teamwork and Negotiation`;
quizQuestions[0][0].answers[2]=`Compliance, Standards and Regulations`;
quizQuestions[0][0].key=2;

quizQuestions[0][1] ={};
quizQuestions[0][1].question=`What is the inspiration for our Project Management Methodology? `;
quizQuestions[0][1].type='single';
quizQuestions[0][1].instruction='';
quizQuestions[0][1].help='';
quizQuestions[0][1].feedback_right=`<b>Right! Your answer is correct. </b><br>PM² (pronounced “P-M squared”) is a project management methodology developed and endorsed by the European Commission (EC).`;
quizQuestions[0][1].feedback_wrong=`<b>Your answer is incorrect.</b><br>PM² (pronounced “P-M squared”) is a project management methodology developed and endorsed by the European Commission (EC).`;
quizQuestions[0][1].answers = new Array;
quizQuestions[0][1].answers[0]=`Agile`;
quizQuestions[0][1].answers[1]=`Lean project management`;
quizQuestions[0][1].answers[2]=`PM² Methodology`;
quizQuestions[0][1].key=3;

quizQuestions[0][2] ={};
quizQuestions[0][2].question=`What are the main phases of a Project Lifecycle?   `;
quizQuestions[0][2].type='single';
quizQuestions[0][2].instruction='';
quizQuestions[0][2].help='';
quizQuestions[0][2].feedback_right=`<b>Right! Your answer is correct. </b><br>A Project Lifecycle always has 4 phases. The project lifecycle starts with the Project Initiation Request and ends once the Closing Phase activities are completed, and the client performs the final acceptance.`;
quizQuestions[0][2].feedback_wrong=`<b>Your answer is incorrect.</b><br>A Project Lifecycle always has 4 phases. The project lifecycle starts with the Project Initiation Request and ends once the Closing Phase activities are completed, and the client performs the final acceptance.`;
quizQuestions[0][2].answers = new Array;
quizQuestions[0][2].answers[0]=`Planning, Executing and Closing`;
quizQuestions[0][2].answers[1]=`Initiating, Executing, Closing, Monitor & Control`;
quizQuestions[0][2].answers[2]=`Executing, Initiating, Monitor & Control`;
quizQuestions[0][2].key=2;

quizQuestions[0][3] ={};
quizQuestions[0][3].question=`The Project Lifecycle consists of what activities? `;
quizQuestions[0][3].type='single';
quizQuestions[0][3].instruction='';
quizQuestions[0][3].help='';
quizQuestions[0][3].feedback_right=`<b>Right! Your answer is correct. </b><br>The focus of a project shifts from initiating and planning activities in the beginning to executing, monitoring, and controlling activities in the middle and acceptance, transitioning, and closing activities at the end.`;
quizQuestions[0][3].feedback_wrong=`<b>Your answer is incorrect.</b><br>The focus of a project shifts from initiating and planning activities in the beginning to executing, monitoring, and controlling activities in the middle and acceptance, transitioning, and closing activities at the end.`;
quizQuestions[0][3].answers = new Array;
quizQuestions[0][3].answers[0]=`Creating the Project Initiation Request, developing the Work Plan, coordinating the project, documenting lessons learned for future projects and execute all management processes`;
quizQuestions[0][3].answers[1]=`Producing the project deliverables, starting the Project-end review meeting and managing the project implementation`;
quizQuestions[0][3].answers[2]=`Running the planning kick-off meeting, coordinating the project and resources`;
quizQuestions[0][3].key=1;

quizQuestions[0][4] ={};
quizQuestions[0][4].question=`Does the Project Scope need to be closed right from the beginning of the project? `;
quizQuestions[0][4].type='single';
quizQuestions[0][4].instruction='';
quizQuestions[0][4].help='';
quizQuestions[0][4].feedback_right=`<b>Right! Your answer is correct. </b><br>It is primordial that the scope of the project is closed right from the beginning of the project. This way you can avoid working on deliverables that are inadequately defined or planned, because this can result in the delivery of outputs with poor quality. This is a common and costly mistake.`;
quizQuestions[0][4].feedback_wrong=`<b>Your answer is incorrect.</b><br>It is primordial that the scope of the project is closed right from the beginning of the project. This way you can avoid working on deliverables that are inadequately defined or planned, because this can result in the delivery of outputs with poor quality. This is a common and costly mistake.`;
quizQuestions[0][4].answers = new Array;
quizQuestions[0][4].answers[0]=`Yes, the client(s) need(s) to know what he wants ASAP`;
quizQuestions[0][4].answers[1]=`No, you can wait until the closing phase of the project`;
quizQuestions[0][4].answers[2]=`Yes, in order to avoid budget slips`;
quizQuestions[0][4].key=3;

quizQuestions[0][5] ={};
quizQuestions[0][5].question=`Which one of the statements is true?`;
quizQuestions[0][5].type='single';
quizQuestions[0][5].instruction='';
quizQuestions[0][5].help='';
quizQuestions[0][5].feedback_right=`<b>Right! Your answer is correct. </b><br>A Project Charter needs to present high-level needs and features, where the client reviews and approves them (or not) so the project can formally move to the planning phase.`;
quizQuestions[0][5].feedback_wrong=`<b>Your answer is incorrect.</b><br>A Project Charter needs to present high-level needs and features, where the client reviews and approves them (or not) so the project can formally move to the planning phase.`;
quizQuestions[0][5].answers = new Array;
quizQuestions[0][5].answers[0]=`The Project Charter doesn't need to be re-submitted if the project’s scope has changed and/or updated`;
quizQuestions[0][5].answers[1]=`A Project Charter should present detailed requirements, disregarding high-level needs and features`;
quizQuestions[0][5].answers[2]=`A Project Charter should be brief, avoiding present detailed requirements and taking in consideration all input from the client`;
quizQuestions[0][5].key=3;

quizQuestions[0][6] ={};
quizQuestions[0][6].question=`As an ID Project Manager, how can you use a Decison Log? `;
quizQuestions[0][6].type='single';
quizQuestions[0][6].instruction='';
quizQuestions[0][6].help='';
quizQuestions[0][6].feedback_right=`<b>Right! Your answer is correct. </b><br>You can use a Decision Log whenever there’s a decision made in the project. Include any decision that has an impact on the project, because it’s a way to communicate with the client and a way for them to support the decision.
`;
quizQuestions[0][6].feedback_wrong=`<b>Your answer is incorrect.</b><br>You can use a Decision Log whenever there’s a decision made in the project. Include any decision that has an impact on the project, because it’s a way to communicate with the client and a way for them to support the decision.
`;
quizQuestions[0][6].answers = new Array;
quizQuestions[0][6].answers[0]=`You can use a Decision Log only where there’s scheduled meetings regarding the project`;
quizQuestions[0][6].answers[1]=`You can use a Decision Log whenever there’s a decision made in the project. Include any decision that has an impact on the project`;
quizQuestions[0][6].answers[2]=`You can use a Decision Log whenever there’s a decision that you don't need to share with the stakeholders`;
quizQuestions[0][6].key=2;

quizQuestions[0][7] ={};
quizQuestions[0][7].question=`What are some of the advantages of a good Time Management approach?`;
quizQuestions[0][7].type='single';
quizQuestions[0][7].instruction='';
quizQuestions[0][7].help='';
quizQuestions[0][7].feedback_right=`<b>Right! Your answer is correct. </b><br>A good Time Management approach can lead to improved efficiency and productivity, less stress, and more success in the development of projects.`;
quizQuestions[0][7].feedback_wrong=`<b>Your answer is incorrect.</b><br>A good Time Management approach can lead to improved efficiency and productivity, less stress, and more success in the development of projects.`;
quizQuestions[0][7].answers = new Array;
quizQuestions[0][7].answers[0]=`Stress Relief and consequently more ability to achieve goals`;
quizQuestions[0][7].answers[1]=`A Poor Work flow and consequentely Poor Quality of Work`;
quizQuestions[0][7].answers[2]=`More Ability to achieve goals and consequentely loss of control`;
quizQuestions[0][7].key=1;

quizQuestions[0][8] ={};
quizQuestions[0][8].question=`As an ID Project Manager how can you use your time more effectively?`;
quizQuestions[0][8].type='single';
quizQuestions[0][8].instruction='';
quizQuestions[0][8].help='';
quizQuestions[0][8].feedback_right=`<b>Right! Your answer is correct. </b><br>A Project Manager can make the most of his/her time by setting goals that are achievable, prioritizing tasks based on time and urgency. Also by setting time constraints for completing tasks, because this helps the PM to be more focused and efficient, planning and taking breaks between tasks.`;
quizQuestions[0][8].feedback_wrong=`<b>Your answer is incorrect.</b><br>A Project Manager can make the most of his/her time by setting goals that are achievable, prioritizing tasks based on time and urgency. Also by setting time constraints for completing tasks, because this helps the PM to be more focused and efficient, planning and taking breaks between tasks.`;
quizQuestions[0][8].answers = new Array;
quizQuestions[0][8].answers[0]=`By setting goals correctly, a time limit to carry out a task, prioritizing wisely, planning ahead and taking a break between tasks`;
quizQuestions[0][8].answers[1]=`By not delegating tasks and being anxious about deadlines`;
quizQuestions[0][8].answers[2]=`By completing tasks at the last minute`;
quizQuestions[0][8].key=1;

quizQuestions[0][9] ={};
quizQuestions[0][9].question=`What you consider to be examples of Time Management Tools?`;
quizQuestions[0][9].type='single';
quizQuestions[0][9].instruction='';
quizQuestions[0][9].help='';
quizQuestions[0][9].feedback_right=`<b>Right! Your answer is correct. </b><br>Project Scheduling & Gantt Charts are two of the tools you can use in Time Management, identifying dependencies between tasks and giving the PM a visual representation of the project.`;
quizQuestions[0][9].feedback_wrong=`<b>Your answer is incorrect.</b><br>Project Scheduling & Gantt Charts are two of the tools you can use in Time Management, identifying dependencies between tasks and giving the PM a visual representation of the project.`;
quizQuestions[0][9].answers = new Array;
quizQuestions[0][9].answers[0]=`Project Iniation Request & Decision Log`;
quizQuestions[0][9].answers[1]=`Project – End Report & Risk Log`;
quizQuestions[0][9].answers[2]=`Project Scheduling & Gantt Charts `;
quizQuestions[0][9].key=3;

quizQuestions[0][10] ={};
quizQuestions[0][10].question=`What's the diference between Project Planning and Project Scheduling?`;
quizQuestions[0][10].type='single';
quizQuestions[0][10].instruction='';
quizQuestions[0][10].help='';
quizQuestions[0][10].feedback_right=`<b>Right! Your answer is correct. </b><br>Project Planning refers to the Planning Phase, which involves selecting the appropriate policies, project methodologies and procedures.
Project Scheduling refers to the Executing Phase, where the PM needs to convert the plans, scope, and cost into an operational timeline of the project. `;
quizQuestions[0][10].feedback_wrong=`<b>Your answer is incorrect.</b><br>Project Planning refers to the Planning Phase, which involves selecting the appropriate policies, project methodologies and procedures.
Project Scheduling refers to the Executing Phase, where the PM needs to convert the plans, scope, and cost into an operational timeline of the project. `;
quizQuestions[0][10].answers = new Array;
quizQuestions[0][10].answers[0]=`Project Planning involves selecting the appropriate policies, project methodologies and procedures required to deliver the project on time.
Project Scheduling converts the plans, scope, and cost into an operational timeline of the project`;
quizQuestions[0][10].answers[1]=`Project Planning converts the plans, scope, and cost into an operational timeline of the project.
Project Scheduling involves selecting the appropriate policies, project methodologies and procedures required to deliver the project on time`;
quizQuestions[0][10].answers[2]=`Project Planning converts the plans, scope, and cost into an operational timeline of the project.
Project Scheduling involves selecting the appropriate risks, project methodologies and procedures required to deliver the project after the estimated time`;
quizQuestions[0][10].key=1;

quizQuestions[0][11] ={};
quizQuestions[0][11].question=`Name some of the rewards for achieving goals and milestones that you can give to your team members:`;
quizQuestions[0][11].type='single';
quizQuestions[0][11].instruction='';
quizQuestions[0][11].help='';
quizQuestions[0][11].feedback_right=`<b>Right! Your answer is correct. </b><br>People are motivated in different ways, so there are several ways for you to give the recognition your team members deserve. You can do this by using informal and/or formal rewards, like casual dress Fridays or other fun activities (informal rewards) or special bonuses (formal rewards).`;
quizQuestions[0][11].feedback_wrong=`<b>Your answer is incorrect.</b><br>People are motivated in different ways, so there are several ways for you to give the recognition your team members deserve. You can do this by using informal and/or formal rewards, like casual dress Fridays or other fun activities (informal rewards) or special bonuses (formal rewards).`;
quizQuestions[0][11].answers = new Array;
quizQuestions[0][11].answers[0]=`They don't need recognition or rewards, they are only doing their job`;
quizQuestions[0][11].answers[1]=`Buying something very special and personal for your team member`;
quizQuestions[0][11].answers[2]=`Casual-dress Fridays, Special bonuses and others`;
quizQuestions[0][11].key=3;

quizQuestions[0][12] ={};
quizQuestions[0][12].question=`What are the techniques you can use in Cost Management?`;
quizQuestions[0][12].type='single';
quizQuestions[0][12].instruction='';
quizQuestions[0][12].help='';
quizQuestions[0][12].feedback_right=`<b>Right! Your answer is correct. </b><br>To achieve the project goals along with their detailed effort/cost estimates, their schedule and resulting project duration and resource requirements need to be aligned. `;
quizQuestions[0][12].feedback_wrong=`<b>Your answer is incorrect.</b><br>To achieve the project goals along with their detailed effort/cost estimates, their schedule and resulting project duration and resource requirements need to be aligned. `;
quizQuestions[0][12].answers = new Array;
quizQuestions[0][12].answers[0]=`Cost Estimation, Meeting minutes and Resource Planning`;
quizQuestions[0][12].answers[1]=`Cost Estimation, Cost Budgeting, Cost Control and Resource Planning`;
quizQuestions[0][12].answers[2]=`Cost Estimation, Cost Budgeting, Gantt Chart`;
quizQuestions[0][12].key=2;

quizQuestions[0][13] ={};
quizQuestions[0][13].question=`During Cost Management, when it is possible to establish budgets, standards and a monitoring system?`;
quizQuestions[0][13].type='single';
quizQuestions[0][13].instruction='';
quizQuestions[0][13].help='';
quizQuestions[0][13].feedback_right=`<b>Right! Your answer is correct. </b><br>Cost Budgeting its only possible when the budget is approved by the client, at the beginning of the project.`;
quizQuestions[0][13].feedback_wrong=`<b>Your answer is incorrect.</b><br>Cost Budgeting its only possible when the budget is approved by the client, at the beginning of the project.`;
quizQuestions[0][13].answers = new Array;
quizQuestions[0][13].answers[0]=`This process it's possible once the budget is approved by the team members, at the beginning of the project`;
quizQuestions[0][13].answers[1]=`This process is only possible once the budget is approved by the client, at the beginning of the project`;
quizQuestions[0][13].answers[2]=`This process is only possible once the budget is approved by the client, at the closing of the project`;
quizQuestions[0][13].key=2;

quizQuestions[0][14] ={};
quizQuestions[0][14].question=`What are the Human Resources Management Steps? `;
quizQuestions[0][14].type='single';
quizQuestions[0][14].instruction='';
quizQuestions[0][14].help='';
quizQuestions[0][14].feedback_right=`<b>Right! Your answer is correct. </b><br>Human Resource Management (HRM) consists of the practice of recruiting, hiring, deploying, and managing an organization's employees, reporting it to the unit coordinator.`;
quizQuestions[0][14].feedback_wrong=`<b>Your answer is incorrect.</b><br>Human Resource Management (HRM) consists of the practice of recruiting, hiring, deploying, and managing an organization's employees, reporting it to the unit coordinator.`;
quizQuestions[0][14].answers = new Array;
quizQuestions[0][14].answers[0]=`Recruitment, Reward, Criticise`;
quizQuestions[0][14].answers[1]=`Recruitment, Reward, Training and Planning`;
quizQuestions[0][14].answers[2]=`Building the team, Reward, Training, Value, Planning & Coaching`;
quizQuestions[0][14].key=3;

quizQuestions[0][15] ={};
quizQuestions[0][15].question=`As an ID Project Manager how can you support the company strategy for employee retention?`;
quizQuestions[0][15].type='single';
quizQuestions[0][15].instruction='';
quizQuestions[0][15].help='';
quizQuestions[0][15].feedback_right=`<b>Right! Your answer is correct. </b><br>As a Project Manager you should always support your team. Make time for a team meeting, as well as one-on-one conversations, so you can know how to best assist them.`;
quizQuestions[0][15].feedback_wrong=`<b>Your answer is incorrect.</b><br>As a Project Manager you should always support your team. Make time for a team meeting, as well as one-on-one conversations, so you can know how to best assist them.`;
quizQuestions[0][15].answers = new Array;
quizQuestions[0][15].answers[0]=`Support your team members along the way! Be their best motivator and prioritize Work-Life Balance`;
quizQuestions[0][15].answers[1]=`Not invest in schedule flexibility of your team members`;
quizQuestions[0][15].answers[2]=`Prioritize your own needs`;
quizQuestions[0][15].key=1;

quizQuestions[0][16] ={};
quizQuestions[0][16].question=`During the Communication Management, how can you improve cross-cultural communication?`;
quizQuestions[0][16].type='single';
quizQuestions[0][16].instruction='';
quizQuestions[0][16].help='';
quizQuestions[0][16].feedback_right=`<b>Right! Your answer is correct. </b><br>You will have different approaches to reaching different people. Take into consideration cultural and individual differences when selecting your style of communication and also your means to reach them. The PM needs to maintain etiquette at all times, respecting the culture and/or communication gap between them.`;
quizQuestions[0][16].feedback_wrong=`<b>Your answer is incorrect.</b><br>You will have different approaches to reaching different people. Take into consideration cultural and individual differences when selecting your style of communication and also your means to reach them. The PM needs to maintain etiquette at all times, respecting the culture and/or communication gap between them.`;
quizQuestions[0][16].answers = new Array;
quizQuestions[0][16].answers[0]=`By using slang, speaking faster and behaving unprofessionally`;
quizQuestions[0][16].answers[1]=`By kepping things simple, creating a team communication agreement and use a lot of unappropriated sense of humour`;
quizQuestions[0][16].answers[2]=`By maintaining etiquette practicing active listening and be aware of the generation gap`;
quizQuestions[0][16].key=3;

quizQuestions[0][17] ={};
quizQuestions[0][17].question=`Why is essential to have written comunication, especially with the client?`;
quizQuestions[0][17].type='single';
quizQuestions[0][17].instruction='';
quizQuestions[0][17].help='';
quizQuestions[0][17].feedback_right=`<b>Right! Your answer is correct. </b><br>In order to ensure all the decisions are approved within the Project, the PM needs to have proof regarding them. `;
quizQuestions[0][17].feedback_wrong=`<b>Your answer is incorrect.</b><br>In order to ensure all the decisions are approved within the Project, the PM needs to have proof regarding them. `;
quizQuestions[0][17].answers = new Array;
quizQuestions[0][17].answers[0]=`The communication with the client should be written, so you can have proof/written record, in case of need or divergences in the project`;
quizQuestions[0][17].answers[1]=`The communication with the client doesn't need to be written, because there is a tacit agreement between the Project Manager and the Client`;
quizQuestions[0][17].answers[2]=`The communication with the client must be written, because the Project Manager is going to send emails to him`;
quizQuestions[0][17].key=1;

quizQuestions[0][18] ={};
quizQuestions[0][18].question=`What are the possible Risk Response Stategies?`;
quizQuestions[0][18].type='single';
quizQuestions[0][18].instruction='';
quizQuestions[0][18].help='';
quizQuestions[0][18].feedback_right=`<b>Right! Your answer is correct. </b><br>Mitigate, Avoid, Reduce and Transfer a risk, are the risk response strategies. These strategies are referred in the Step 3 Risk Response Development in the Risk Management Process Description.`;
quizQuestions[0][18].feedback_wrong=`<b>Your answer is incorrect.</b><br>Mitigate, Avoid, Reduce and Transfer a risk, are the risk response strategies. These strategies are referred in the Step 3 Risk Response Development in the Risk Management Process Description.`;
quizQuestions[0][18].answers = new Array;
quizQuestions[0][18].answers[0]=` Avoid, Reduce and Transfer a risk `;
quizQuestions[0][18].answers[1]=`Mitigate, Avoid, Reduce and Transfer a risk`;
quizQuestions[0][18].answers[2]=`Create, Avoid, Reduce and Transfer a risk`;
quizQuestions[0][18].key=2;

quizQuestions[0][19] ={};
quizQuestions[0][19].question=`As an ID Project Manager should you consider the environmental impacts of the project? `;
quizQuestions[0][19].type='single';
quizQuestions[0][19].instruction='';
quizQuestions[0][19].help='';
quizQuestions[0][19].feedback_right=`<b>Right! Your answer is correct. </b><br>Saving resources translates into saving money and more importantly, preserving the resources for future generations. The ID project manager needs to think green by creating a plan to minimize the environmental impacts of the project. `;
quizQuestions[0][19].feedback_wrong=`<b>Your answer is incorrect.</b><br>Saving resources translates into saving money and more importantly, preserving the resources for future generations. The ID project manager needs to think green by creating a plan to minimize the environmental impacts of the project. `;
quizQuestions[0][19].answers = new Array;
quizQuestions[0][19].answers[0]=`As an ID project a manager, I don't need to worry about that`;
quizQuestions[0][19].answers[1]=`As an ID project manager, I only care about the profit`;
quizQuestions[0][19].answers[2]=`As an ID project manager I need to truly think green for the effective and efficienty of the project, promoting sustainability for future generations`;
quizQuestions[0][19].key=3;
